/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retailinmotion.details;

import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.FileReferenceWriteBack;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight_;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<RetailInMotionDataImportLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> locations;
    private TitledItem<DateChooser> requiredDate;
    private FileChooserPanel file;

    public ConfigurationDetailsPanel(RowEditor<RetailInMotionDataImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(LocationConverter.class)), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.requiredDate = new TitledItem<DateChooser>(new DateChooser(), Words.DELIVERY, TitledItem.TitledItemOrientation.NORTH);
        this.requiredDate.setProgress(1.0f);
        this.file = new FileChooserPanel(false);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean lsgfc = CompanyUtil.isLSGFC((SystemSettingsComplete)settings);
        if (lsgfc) {
            this.file.setFileType("xlsx");
        } else {
            this.file.setFileType("csv");
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.requiredDate);
        this.addToView(this.file);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.requiredDate);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.file);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            RetailInMotionDataImportLight dto = (RetailInMotionDataImportLight)node.getValue();
            dto.setLocation((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().refreshPossibleValues(NodeToolkit.getAffixList(LocationComplete.class));
            this.locations.getElement().setNode(node.getChildNamed(RetailInMotionDataImportLight_.location));
        }
        if (node.getChildNamed(RetailInMotionDataImportLight_.deliveryDate).getValue() == null) {
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(System.currentTimeMillis());
            c.add(6, 1);
            node.getChildNamed(RetailInMotionDataImportLight_.deliveryDate).setValue((Object)new Date(c.getTimeInMillis()), 0L);
        }
        this.requiredDate.getElement().setNode(node.getChildNamed(RetailInMotionDataImportLight_.deliveryDate));
        this.file.setNode(node.getChildNamed(RetailInMotionDataImportLight_.sheet));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        java.util.Date selectedDate = this.requiredDate.getElement().getSelectedDate();
        this.requiredDate.getElement().getNode().setValue((Object)new Date(selectedDate.getTime()), 0L);
        PegasusFileComplete gr = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(RetailInMotionDataImportLight_.sheet).getValue();
        if (gr != null && gr.getLocalFile() != null) {
            FileCommitter c = new FileCommitter(gr.getLocalFile());
            c.setWriteBackAlgorithm(new FileReferenceWriteBack(){

                @Override
                public void writeBack(PegasusFileComplete reference) {
                    ConfigurationDetailsPanel.this.editor.getModel().getNode().getChildNamed(RetailInMotionDataImportLight_.sheet).setValue((Object)reference, 0L);
                    ((RetailInMotionDataImportLight)ConfigurationDetailsPanel.this.editor.getModel().getNode().getValue()).setSheet(reference);
                }
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.requiredDate.kill();
        this.requiredDate = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        this.file.kill();
        this.file = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.requiredDate.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        this.file.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.requiredDate.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.requiredDate.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.requiredDate.setSize((int)ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getWidth(), (int)ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getHeight());
            int cy = ConfigurationDetailsPanel.this.requiredDate.getY() + ConfigurationDetailsPanel.this.requiredDate.getHeight();
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                ConfigurationDetailsPanel.this.locations.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.requiredDate.getY() + ConfigurationDetailsPanel.this.requiredDate.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
                ConfigurationDetailsPanel.this.locations.setSize(200, (int)ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight());
                cy = ConfigurationDetailsPanel.this.locations.getY() + ConfigurationDetailsPanel.this.locations.getHeight();
            }
            ConfigurationDetailsPanel.this.file.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, cy + ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.file.setSize(400, (int)ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = ConfigurationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                lh += (int)ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight();
                lh += ConfigurationDetailsPanel.this.verticalBorder;
            }
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getHeight());
            lh += ConfigurationDetailsPanel.this.verticalBorder;
            lh = (int)((double)lh + ConfigurationDetailsPanel.this.file.getPreferredSize().getHeight());
            return new Dimension(0, lh += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

