/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.safetystock;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.safetystock.SafetyStockServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockArticleComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockReference;
import ch.icit.pegasus.server.core.dtos.search.SafetyStockSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class SafetyStockModuleDataHandler
extends DefaultDataHandler<SafetyStockLight, SafetyStockComplete> {
    public SafetyStockModuleDataHandler(long id, ScreenTableView<SafetyStockLight, SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN> tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<SafetyStockLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SafetyStockComplete d = (SafetyStockComplete)node.getValue(SafetyStockComplete.class);
                SafetyStockComplete dto = (SafetyStockComplete)((SafetyStockServiceManager)ServiceManagerRegistry.getService(SafetyStockServiceManager.class)).updateSafetyStock(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SafetyStockComplete> createEmptyNode() {
        SafetyStockComplete d = new SafetyStockComplete();
        d.setCalculationPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<SafetyStockComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                SafetyStockComplete dto = (SafetyStockComplete)node.getValue(SafetyStockComplete.class);
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                SafetyStockComplete nDto = (SafetyStockComplete)((SafetyStockServiceManager)ServiceManagerRegistry.getService(SafetyStockServiceManager.class)).createSafetyStock(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SafetyStockModuleDataHandler.this.setCurrentLoadMaximum(3);
                SafetyStockModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                SafetyStockModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                SafetyStockModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSafetyStockStates();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SafetyStockModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SafetyStockComplete> resetData(Node<SafetyStockComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SafetyStockLight acc = (SafetyStockLight)node.getValue(SafetyStockLight.class);
                SafetyStockComplete nacc = (SafetyStockComplete)((SafetyStockServiceManager)ServiceManagerRegistry.getService(SafetyStockServiceManager.class)).getSafetyStock((SafetyStockReference)acc).getValue();
                for (SafetyStockArticleComplete article : nacc.getArticles()) {
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(article.getArticle().getId())).getValue();
                    INodeCreator.getDefaultImpl().getNode4DTO((Object)artC, false, false);
                }
                node.removeExistingValues();
                node.setValue((Object)nacc, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<SafetyStockComplete> getCommittingClass() {
        return SafetyStockComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<SafetyStockLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

