/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.safetystock.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockArticleComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ArticlesDetailsPanel
extends TableDetailsPanel<SafetyStockLight> {
    private static final long serialVersionUID = 1L;

    public ArticlesDetailsPanel(RowEditor<SafetyStockLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ARTICLES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", 120, Integer.MAX_VALUE, 120));
        int iw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("Max Daily Usage", "", (Class)String.class, null, "", iw));
        columns.add(new TableColumnInfo("Average Daily Usage", "", (Class)String.class, null, "", iw));
        columns.add(new TableColumnInfo("Max Delivery Days", "", (Class)String.class, null, "", 75));
        columns.add(new TableColumnInfo("Average Delivery Days", "", (Class)String.class, null, "", 75));
        int dw = DateChooser.getPreferredWidth(this, false);
        columns.add(new TableColumnInfo("Max Usage Date", "", (Class)String.class, null, "", dw));
        columns.add(new TableColumnInfo("Max Delivery Days Date", "", (Class)String.class, null, "", dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setUseAccessRight(true);
        table.setDontUseScrollBar(15);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(SafetyStockComplete_.articles));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private TextLabel article;
        private RDInputComboBox maxDailyUsage;
        private RDInputComboBox averageDailyUsage;
        private RDTextField maxDeliveryDays;
        private RDTextField averageDeliveryDays;
        private TextLabel maxUsageDate;
        private TextLabel maxDeliveryDaysDate;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(SafetyStockArticleComplete_.article).getValue(BasicArticleComplete.class);
            ViewNode un = new ViewNode("");
            if (artC != null) {
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)new Timestamp(System.currentTimeMillis()), (TransactionType)TransactionType.PURCHASE, (UserComplete)ArticlesDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticlesDetailsPanel.this.settings);
                for (UnitComplete u : units) {
                    un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
                }
            }
            this.article = new TextLabel(m.getNode().getChildNamed(SafetyStockArticleComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.maxDailyUsage = new RDInputComboBox(ArticlesDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.maxDailyUsage.setOverrideName(SafetyStockComplete_.articles);
            this.maxDailyUsage.setNode(m.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.maxDailyUsageInMainStore, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.maxDailyUsageInMainStore, QuantityComplete_.unit}));
            this.maxDailyUsage.setPossibleUnits((Node)un);
            this.averageDailyUsage = new RDInputComboBox(ArticlesDetailsPanel.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.averageDailyUsage.setOverrideName(SafetyStockComplete_.articles);
            this.averageDailyUsage.setNode(m.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.averageDailyUsageInMainStore, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.averageDailyUsageInMainStore, QuantityComplete_.unit}));
            this.averageDailyUsage.setPossibleUnits((Node)un);
            this.maxDeliveryDays = new RDTextField(ArticlesDetailsPanel.this.provider, TextFieldType.LONG);
            this.maxDeliveryDays.setOverrideName(SafetyStockComplete_.articles);
            this.maxDeliveryDays.setNode(m.getNode().getChildNamed(SafetyStockArticleComplete_.maxDeliveryDays));
            this.averageDeliveryDays = new RDTextField(ArticlesDetailsPanel.this.provider, TextFieldType.LONG);
            this.averageDeliveryDays.setOverrideName(SafetyStockComplete_.articles);
            this.averageDeliveryDays.setNode(m.getNode().getChildNamed(SafetyStockArticleComplete_.averageDeliveryDays));
            this.maxUsageDate = new TextLabel(m.getNode().getChildNamed(SafetyStockArticleComplete_.maxUsageDate), ConverterRegistry.getConverter(DateConverter.class));
            this.maxDeliveryDaysDate = new TextLabel(m.getNode().getChildNamed(SafetyStockArticleComplete_.maxDeliveryDaysDate), ConverterRegistry.getConverter(DateConverter.class));
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.maxDailyUsage);
            this.add(this.averageDailyUsage);
            this.add(this.maxDeliveryDays);
            this.add(this.averageDeliveryDays);
            this.add(this.maxUsageDate);
            this.add(this.maxDeliveryDaysDate);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new DtoField[]{SafetyStockArticleComplete_.article, BasicArticleLight_.number}).getValue();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.maxDailyUsage);
            CheckedListAdder.addToList(focusList, this.averageDailyUsage);
            CheckedListAdder.addToList(focusList, this.maxDeliveryDays);
            CheckedListAdder.addToList(focusList, this.averageDeliveryDays);
            return focusList;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.maxDailyUsage.kill();
            this.averageDailyUsage.kill();
            this.maxDeliveryDays.kill();
            this.averageDeliveryDays.kill();
            this.maxUsageDate.kill();
            this.maxDeliveryDaysDate.kill();
            this.article = null;
            this.maxDailyUsage = null;
            this.averageDailyUsage = null;
            this.maxDeliveryDays = null;
            this.averageDeliveryDays = null;
            this.maxUsageDate = null;
            this.maxDeliveryDaysDate = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(1);
                TableRowImpl.this.maxDailyUsage.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.maxDailyUsage.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.maxDailyUsage.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.maxDailyUsage.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(2);
                TableRowImpl.this.averageDailyUsage.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.averageDailyUsage.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.averageDailyUsage.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.averageDailyUsage.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(3);
                TableRowImpl.this.maxDeliveryDays.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.maxDeliveryDays.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.maxDeliveryDays.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.maxDeliveryDays.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(4);
                TableRowImpl.this.averageDeliveryDays.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.averageDeliveryDays.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.averageDeliveryDays.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.averageDeliveryDays.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(5);
                TableRowImpl.this.maxUsageDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.maxUsageDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.maxUsageDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.maxUsageDate.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(6);
                TableRowImpl.this.maxDeliveryDaysDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.maxDeliveryDaysDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.maxDeliveryDaysDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.maxDeliveryDaysDate.getPreferredSize().getHeight());
            }
        }
    }
}

