/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sageimport.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ImportDetailsPanel
extends DefaultDetailsPanel<SageImportLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private FileChooserPanel fileChooser;
    private TitledItem<TextField> name;
    private TitledPeriodEditor periodEditor;

    public ImportDetailsPanel(RowEditor<SageImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.IMPORT);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        this.fileChooser = new FileChooserPanel((Node<PegasusFileComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new PegasusFileComplete(), false, false));
        this.fileChooser.setFileType("xlsx");
        this.name = new TitledItem<TextField>(new TextField(), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.periodEditor = new TitledPeriodEditor(null, true, provider);
        this.periodEditor.getEndDateChooser().setOverrideName(SageImportLight_.period);
        this.periodEditor.getStartDateChooser().setOverrideName(SageImportLight_.period);
        this.addToView(this.fileChooser);
        this.addToView(this.name);
        this.addToView(this.periodEditor);
    }

    @Override
    public void setNode(Node<?> node) {
        this.fileChooser.setNode(node.getChildNamed(SageImportLight_.importedFile));
        this.name.getElement().setNode(node.getChildNamed(SageImportLight_.name));
        this.periodEditor.setNode((Node<PeriodComplete>)node.getChildNamed(SageImportLight_.period));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.fileChooser);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.fileChooser.kill();
        this.fileChooser = null;
        this.name.kill();
        this.name = null;
        this.periodEditor.kill();
        this.periodEditor = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.fileChooser.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.periodEditor.setEnabled(isEnabled);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return this.fileChooser.commitFile();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.fileChooser.getNode().getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCEL_FILE_TO_IMPORT_IS_SELECTED));
        } else if (((PegasusFileComplete)this.fileChooser.getNode().getValue()).getLocalFile() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCEL_FILE_TO_IMPORT_IS_SELECTED));
        }
        return validationObjects;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.setNode(node);
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
        super.errorOccurred(exception);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ImportDetailsPanel.this.fileChooser.setLocation(10, 10);
            ImportDetailsPanel.this.fileChooser.setSize(350, (int)ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            ImportDetailsPanel.this.name.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.fileChooser.getY() + ImportDetailsPanel.this.fileChooser.getHeight() + ImportDetailsPanel.this.inner_verticalBorder);
            ImportDetailsPanel.this.name.setSize(350, (int)ImportDetailsPanel.this.name.getPreferredSize().getHeight());
            ImportDetailsPanel.this.periodEditor.setLocation(10, ImportDetailsPanel.this.name.getY() + ImportDetailsPanel.this.name.getHeight() + ImportDetailsPanel.this.inner_verticalBorder);
            ImportDetailsPanel.this.periodEditor.setSize(ImportDetailsPanel.this.periodEditor.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            h += ImportDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.name.getPreferredSize().getHeight());
            h += ImportDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            return new Dimension(0, h += ImportDetailsPanel.this.verticalBorder);
        }
    }
}

