/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sageimport.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ALocalizedDeletableDTO_;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete_;
import ch.icit.pegasus.server.core.dtos.sage.SageImportComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight;
import ch.icit.pegasus.server.core.dtos.sage.SageImportLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<SageImportLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<TextLabel> importDate;
    private TitledItem<TextLabel> importUser;
    private TitledItem<RDTextField> name;
    private TitledPeriodEditor periodEditor;
    private TitledItem<RDMultiLocationComboBox> location;

    public SpecificationDetailsPanel(RowEditor<SageImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
        }
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.importDate = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.importUser = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.USER, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.periodEditor = new TitledPeriodEditor(null, true, provider);
        this.periodEditor.getEndDateChooser().setOverrideName(SageImportLight_.period);
        this.periodEditor.getStartDateChooser().setOverrideName(SageImportLight_.period);
        this.number.getElement().setReadOnlyTextField(true);
        this.importDate.getElement().setReadOnlyTextField(true);
        this.importUser.getElement().setReadOnlyTextField(true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.location);
        }
        this.addToView(this.importDate);
        this.addToView(this.importUser);
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.periodEditor);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue() == null || this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue().equals(""))) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.location.getElement().isWritable() && this.location.getElement().getNode().getChildCount() < 1) {
            this.location.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.location);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.kill();
        }
        this.importDate.kill();
        this.importUser.kill();
        this.number.kill();
        this.name.kill();
        this.periodEditor.kill();
        this.location = null;
        this.importDate = null;
        this.importUser = null;
        this.name = null;
        this.number = null;
        this.periodEditor = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.setEnabled(isEnabled);
        }
        this.importDate.setEnabled(isEnabled);
        this.importUser.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.periodEditor.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            SageImportComplete dto = (SageImportComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ALocalizedDeletableDTO_.eligibleLocations));
        }
        this.number.getElement().setNode(node.getChildNamed(SageImportLight_.number));
        this.importDate.getElement().setNode(node.getChildNamed(SageImportLight_.importDate));
        this.importUser.getElement().setNode(node.getChildNamed(SageImportLight_.importUser));
        this.periodEditor.setNode((Node<PeriodComplete>)node.getChildNamed(SageImportLight_.period));
        this.name.getElement().setNode(node.getChildNamed(SageImportLight_.name));
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(120, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            int cx = SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.location.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.location.setSize(180, (int)SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
                cx = SpecificationDetailsPanel.this.location.getX() + SpecificationDetailsPanel.this.location.getWidth();
            }
            SpecificationDetailsPanel.this.importDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.importDate.setSize(SpecificationDetailsPanel.this.importDate.getPreferredSize());
            SpecificationDetailsPanel.this.importUser.setLocation(SpecificationDetailsPanel.this.importDate.getX() + SpecificationDetailsPanel.this.importDate.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.importDate.getY());
            SpecificationDetailsPanel.this.importUser.setSize(SpecificationDetailsPanel.this.importUser.getPreferredSize());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.importDate.getY() + SpecificationDetailsPanel.this.importDate.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(350, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.periodEditor.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.periodEditor.setSize(SpecificationDetailsPanel.this.periodEditor.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.importDate.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

