/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sob.details;

import ch.icit.pegasus.client.converter.GalleyEquipmentConverter3;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EquipmentSpecificationDetailsPanel
extends TableDetailsPanel<FlightLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TextButton resetSeals;
    private TextLabel generatedReserve;

    public EquipmentSpecificationDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.SEALED_DOORS);
        this.resetSeals = new TextButton(Words.CLEAR_SEALS);
        this.resetSeals.addButtonListener(this);
        this.generatedReserve = new TextLabel(Words.RESERVE_SEALS);
        this.addToView(this.resetSeals);
        this.addToView(this.generatedReserve);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.EQUIPMENT, null, null, null, "", 140, 140, 140));
        columns.add(new TableColumnInfo(Words.DOOR, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.GALLEY, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.INBOUND, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.CREW_CHANGE, null, null, null, "", 80, 80, 80));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.34);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.33);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        return p;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        Node fss = NodeToolkit.getAffixNamed((String)"SealedEQs");
        fss.getChildNamed(DtoFieldConstants.additionalSeals).removeExistingValues();
        fss.getChildNamed(DtoFieldConstants.additionalSeals).removeAllChilds();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            i.resetSeals();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.resetSeals.setEnabled(isEnabled);
        this.generatedReserve.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        if (n != null) {
            n.getChildNamed(DtoFieldConstants.additionalSeals).removeNodeListener((NodeListener)this);
        }
        this.resetSeals.kill();
        this.resetSeals = null;
        this.generatedReserve.kill();
        this.generatedReserve = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        Node n = NodeToolkit.getAffixNamed((String)"SealedEQs");
        ListNode tableNode = new ListNode();
        if (n != null) {
            List<ViewNode> children = this.generateNode(n.getChildNamed(FlightSealsComplete_.equipments));
            for (ViewNode c : children) {
                tableNode.addChild((Node)c, 0L);
            }
            n.getChildNamed(DtoFieldConstants.additionalSeals).addNodeListener((NodeListener)this);
            this.valueChanged(n.getChildNamed(DtoFieldConstants.additionalSeals));
        }
        this.table.getModel().setNode((Node)tableNode);
    }

    private List<ViewNode> generateNode(Node<?> equipmentList) {
        ArrayList<ViewNode> nodes2add = new ArrayList<ViewNode>();
        Iterator it = equipmentList.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.setName(DtoFieldConstants.EQ);
            int i = 0;
            while (((EquipmentSealsComplete)n.getValue()).getEquipment().getEquipmentType().getNumberOfSeals() > i) {
                ViewNode v = new ViewNode(DtoFieldConstants.DOOR.getFieldName());
                v.addChild(n, 0L);
                ViewNode dno = new ViewNode(DtoFieldConstants.DOOR_NO.getFieldName());
                dno.setValue((Object)("" + ++i), 0L);
                v.addChild((Node)dno, 0L);
                String id = Words.REAR;
                if (i % 2 == 0) {
                    id = Words.FRONT;
                }
                v.addChild((Node)this.getSealConfig(DtoFieldConstants.CONFIG_INBOUND.getFieldName(), SealTypeE.INBOUND, ((EquipmentSealsComplete)n.getValue()).getSeals(), id, i, null), 0L);
                v.addChild((Node)this.getSealConfig(DtoFieldConstants.CONFIG_OUTBOUND.getFieldName(), SealTypeE.OUTBOUND, ((EquipmentSealsComplete)n.getValue()).getSeals(), id, i, null), 0L);
                v.addChild((Node)this.getSealConfig(DtoFieldConstants.CONFIG_CREW_CHANGE.getFieldName(), SealTypeE.CREW_CHANGE, ((EquipmentSealsComplete)n.getValue()).getSeals(), id, i, null), 0L);
                n.addChild((Node)v, 0L);
                nodes2add.add(v);
            }
        }
        return nodes2add;
    }

    private ViewNode getSealConfig(String name, SealTypeE sealType, Map<SealTypeE, List<SealComplete>> map, String identifier, int door, ColorComplete sealColor) {
        ViewNode configInbound = new ViewNode(name);
        ViewNode color = new ViewNode(DtoFieldConstants.SEAL_COLOR.getFieldName());
        configInbound.addChild((Node)color, 0L);
        ViewNode sealNo = new ViewNode(DtoFieldConstants.SEAL_NO.getFieldName());
        configInbound.addChild((Node)sealNo, 0L);
        ViewNode type = new ViewNode(DtoFieldConstants.SEAL_TYPE.getFieldName());
        configInbound.addChild((Node)type, 0L);
        ViewNode doorNode = new ViewNode(DtoFieldConstants.SEAL_DOOR.getFieldName());
        configInbound.addChild((Node)doorNode, 0L);
        ViewNode sealId = new ViewNode(DtoFieldConstants.SEAL_IDENTIFIER.getFieldName());
        configInbound.addChild((Node)sealId, 0L);
        boolean found = false;
        List<SealComplete> seals = map.get(sealType);
        if (seals != null) {
            for (SealComplete s : seals) {
                if (!s.getType().equals((Object)sealType) || !s.getIdentifier().equals(identifier)) continue;
                found = true;
                sealNo.setValue((Object)s.getPredefinedNumber(), 0L);
                type.setValue((Object)s.getType(), 0L);
                color.setValue((Object)s.getColor(), 0L);
                doorNode.setValue((Object)s.getSequenceNumber(), 0L);
                sealId.setValue((Object)s.getIdentifier(), 0L);
            }
        }
        if (!found) {
            sealNo.setValue((Object)-1, 0L);
            type.setValue((Object)sealType, 0L);
            doorNode.setValue((Object)door, 0L);
            sealId.setValue((Object)identifier, 0L);
            color.setValue((Object)sealColor, 0L);
        }
        return configInbound;
    }

    public void applySeals(SealTypeE sealType, int sealStartNo, ColorComplete sealColor) {
        int currentNo = sealStartNo;
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            i.applySeal(sealType, currentNo, sealColor);
            ++currentNo;
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.generatedReserve.setLocation(this.horizontalBorder, (int)((double)parent.getHeight() - ((double)(2 * this.verticalBorder) + this.resetSeals.getPreferredSize().getHeight() + this.generatedReserve.getPreferredSize().getHeight())));
        this.generatedReserve.setSize(parent.getWidth() - 2 * this.horizontalBorder, (int)this.generatedReserve.getPreferredSize().getHeight());
        this.resetSeals.setLocation(this.horizontalBorder, (int)((double)parent.getHeight() - ((double)this.verticalBorder + this.resetSeals.getPreferredSize().getHeight())));
        this.resetSeals.setSize(this.resetSeals.getPreferredSize());
        this.table.setLocation(2, 2);
        this.table.setSize(parent.getWidth() - 4, parent.getHeight() - (parent.getHeight() - this.generatedReserve.getY()));
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 250);
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(DtoFieldConstants.ADDITIONAL_SEALS.getFieldName())) {
            List rs = (List)node.getValue();
            String t = Words.RESERVE_SEALS + " " + rs.size();
            if (!rs.isEmpty()) {
                int startNo = Integer.MAX_VALUE;
                int endNo = 0;
                ColorComplete color = null;
                for (SealComplete s : rs) {
                    color = s.getColor();
                    if (s.getPredefinedNumber() > endNo) {
                        endNo = s.getPredefinedNumber();
                    }
                    if (s.getPredefinedNumber() >= startNo) continue;
                    startNo = s.getPredefinedNumber();
                }
                t = t + " (" + WordsToolkit.toLowerCase((String)Words.FROM) + " " + startNo + " - " + endNo + ")" + (color != null ? " " + WordsToolkit.toLowerCase((String)Words.IN) + " " + color.getName() : "");
            }
            this.generatedReserve.setText(t);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel eq;
        private TextLabel door;
        private TextLabel galley;
        private TextField inbound;
        private TextField outbound;
        private TextField crewChange;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.eq = new TextLabel(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.EQ, EquipmentSealsComplete_.equipment}), ConverterRegistry.getConverter(GalleyEquipmentConverter3.class));
            this.door = new TextLabel(this.model.getNode().getChildNamed(DtoFieldConstants.DOOR_NO));
            this.galley = new TextLabel(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.EQ, EquipmentSealsComplete_.equipment, GalleyEquipmentLight_.containingGalley, GalleyEquipmentSetLight_.galleyCode}));
            this.inbound = new NumberTextField(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_INBOUND, DtoFieldConstants.SEAL_NO}), TextFieldType.INT);
            this.outbound = new NumberTextField(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_OUTBOUND, DtoFieldConstants.SEAL_NO}), TextFieldType.INT);
            this.crewChange = new NumberTextField(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_CREW_CHANGE, DtoFieldConstants.SEAL_NO}), TextFieldType.INT);
            this.setLayout(new Layout());
            this.add(this.eq);
            this.add(this.door);
            this.add(this.galley);
            this.add(this.inbound);
            this.add(this.outbound);
            this.add(this.crewChange);
        }

        public void applySeal(SealTypeE sealType, int sealNo, ColorComplete sealColor) {
            switch (sealType) {
                case CREW_CHANGE: {
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_CREW_CHANGE, DtoFieldConstants.SEAL_NO}).setValue((Object)sealNo, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_CREW_CHANGE, DtoFieldConstants.SEAL_COLOR}).setValue((Object)sealColor, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_CREW_CHANGE, DtoFieldConstants.SEAL_TYPE}).setValue((Object)sealType, 0L);
                    break;
                }
                case INBOUND: {
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_INBOUND, DtoFieldConstants.SEAL_NO}).setValue((Object)sealNo, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_INBOUND, DtoFieldConstants.SEAL_COLOR}).setValue((Object)sealColor, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_INBOUND, DtoFieldConstants.SEAL_TYPE}).setValue((Object)sealType, 0L);
                    break;
                }
                case OUTBOUND: {
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_OUTBOUND, DtoFieldConstants.SEAL_NO}).setValue((Object)sealNo, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_OUTBOUND, DtoFieldConstants.SEAL_COLOR}).setValue((Object)sealColor, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_OUTBOUND, DtoFieldConstants.SEAL_TYPE}).setValue((Object)sealType, 0L);
                    break;
                }
                case RESERVE: {
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_RESERVE1, DtoFieldConstants.SEAL_NO}).setValue((Object)sealNo, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_RESERVE1, DtoFieldConstants.SEAL_COLOR}).setValue((Object)sealColor, 0L);
                    this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.CONFIG_RESERVE1, DtoFieldConstants.SEAL_TYPE}).setValue((Object)sealType, 0L);
                    break;
                }
            }
        }

        public void resetSeals() {
            Map v = ((EquipmentSealsComplete)this.model.getNode().getChildNamed(DtoFieldConstants.EQ).getValue()).getSeals();
            for (SealTypeE e : v.keySet()) {
                List l = (List)v.get(e);
                for (SealComplete s : l) {
                    s.setPredefinedNumber(Integer.valueOf(-1));
                }
            }
            this.inbound.setText("-1");
            this.outbound.setText("-1");
            this.crewChange.setText("-1");
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.inbound.getFocusComponents();
            CheckedListAdder.addToList(focusList, this.outbound);
            CheckedListAdder.addToList(focusList, this.crewChange);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.EQ, EquipmentSealsComplete_.equipment, GalleyEquipmentLight_.positionCode}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.EQ, EquipmentSealsComplete_.equipment, GalleyEquipmentLight_.containingGalley, GalleyEquipmentSetLight_.galleyCode}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.eq.setEnabled(isEnabled);
            this.door.setEnabled(isEnabled);
            this.galley.setEnabled(isEnabled);
            this.inbound.setEnabled(isEnabled);
            this.outbound.setEnabled(isEnabled);
            this.crewChange.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.eq.kill();
            this.eq = null;
            this.door.kill();
            this.door = null;
            this.galley.kill();
            this.galley = null;
            this.inbound.kill();
            this.inbound = null;
            this.outbound.kill();
            this.outbound = null;
            this.crewChange.kill();
            this.crewChange = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.eq.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.eq.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.eq.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.eq.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.door.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.door.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.door.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.door.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.galley.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.galley.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.galley.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.galley.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.inbound.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.inbound.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.inbound.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.inbound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.outbound.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.outbound.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.outbound.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.outbound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.crewChange.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.crewChange.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.crewChange.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.crewChange.getPreferredSize().getHeight());
            }
        }
    }
}

