/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.allergens.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.UserSignConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight_;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewEntryComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class AllergenDetails
extends TableDetailsPanel<AllergenSpotCheckReviewLight> {
    private static final long serialVersionUID = 1L;

    public AllergenDetails(RowEditor<AllergenSpotCheckReviewLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.DETAILED_VIEW);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(AllergenSpotCheckReviewComplete_.entries));
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(AllergenSpotCheckReviewComplete_.entries));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        return rets;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.0, Words.DATE, TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.25, Words.SUPPLIER, 180));
        headers.add(new TableColumnInfo(0.25, Words.ARTICLE, 180));
        headers.add(new TableColumnInfo(0.0, Words.ALLERGEN_SPOT_CHECK, TableColumnInfo.checkColumnWith + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.25, Words.COMMENT, 100));
        headers.add(new TableColumnInfo(0.0, Words.USER, TableColumnInfo.userColumnWidth + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.25, Words.REVIEW_COMMENT, 100));
        headers.add(new TableColumnInfo(0.0, Words.REVIEWED, 75));
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel supplier;
        private TextLabel article;
        private CheckBoxRO allergenSpotCheck;
        private TextLabel comment;
        private TextLabel user;
        private TextField reviewComment;
        private CheckBox approved;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            Node entry = m.getNode();
            Node position = m.getNode().getChildNamed(AllergenSpotCheckReviewEntryComplete_.position);
            Node order = m.getNode().getChildNamed(new DtoField[]{AllergenSpotCheckReviewEntryComplete_.position, PurchaseOrderPositionLight_.order});
            this.date = new TextLabel(order.getChildNamed(PurchaseOrderComplete_.deliveryDate), ConverterRegistry.getConverter(DateConverter.class));
            this.supplier = new TextLabel(order.getChildNamed(PurchaseOrderComplete_.supplier), ConverterRegistry.getConverter(SupplierConverter.class));
            this.article = new TextLabel(position.getChildNamed(PurchaseOrderPositionLight_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.allergenSpotCheck = new CheckBoxRO((Node<Boolean>)position.getChildNamed(PurchaseOrderPositionLight_.allergenStatus));
            this.comment = new TextLabel(position.getChildNamed(PurchaseOrderPositionLight_.allergenCheckComment), ConverterRegistry.getConverter(StringConverter.class));
            this.user = new TextLabel(position.getChildNamed(PurchaseOrderPositionLight_.allergenCheckUser), ConverterRegistry.getConverter(UserSignConverter.class));
            this.reviewComment = new TextField(entry.getChildNamed(AllergenSpotCheckReviewEntryComplete_.comment));
            this.approved = new CheckBox((Node<Boolean>)entry.getChildNamed(AllergenSpotCheckReviewEntryComplete_.reviewed));
            this.setLayout(new Layout());
            this.add(this.date);
            this.add(this.supplier);
            this.add(this.article);
            this.add(this.allergenSpotCheck);
            this.add(this.comment);
            this.add(this.user);
            this.add(this.reviewComment);
            this.add(this.approved);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.reviewComment);
            CheckedListAdder.addToList(focusList, this.approved);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.date.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.supplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.supplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplier.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.allergenSpotCheck.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.allergenSpotCheck.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.allergenSpotCheck.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.allergenSpotCheck.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(6);
                TableRowImpl.this.reviewComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reviewComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reviewComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.reviewComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(7);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.approved.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approved.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approved.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.approved.getPreferredSize().getHeight());
            }
        }
    }
}

