/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.ccp0102.details;

import ch.icit.pegasus.client.converter.CCP0102MeasurementConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CCP0102SpotCheckAccess;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewEntryComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<CCP0102SpotCheckReviewLight> {
    private TitledDateTimePeriodChooser periodEditor;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> creationUser;
    private TitledItem<TextLabel> creationDate;
    private TitledItem<TextLabel> reviewUser;
    private TitledItem<TextLabel> reviewDate;
    private TitledItem<Component> measurement;
    private TextButton checkAll;

    public SpecificationDetailsPanel(RowEditor<CCP0102SpotCheckReviewLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.periodEditor = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.timestampPeriod));
        this.periodEditor.getStartTimeChooser().addDateTimeChooserListener((source, timestamp) -> this.updateSearchPeriod());
        this.periodEditor.getEndTimeChooser().addDateTimeChooserListener((source, timestamp) -> this.updateSearchPeriod());
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.creationUser = new TitledItem<TextLabel>(new TextLabel(editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.creationUser), ConverterRegistry.getConverter(UserConverter.class)), Words.CREATION_USER, TitledItem.TitledItemOrientation.NORTH);
        this.creationDate = new TitledItem<TextLabel>(new TextLabel(editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.creationDate), ConverterRegistry.getConverter(DateConverter.class)), Words.CREATION_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.reviewUser = new TitledItem<TextLabel>(new TextLabel(editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.reviewUser), ConverterRegistry.getConverter(UserConverter.class)), Words.REVIEW_USER, TitledItem.TitledItemOrientation.NORTH);
        this.reviewDate = new TitledItem<TextLabel>(new TextLabel(editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.reviewedDate), ConverterRegistry.getConverter(DateConverter.class)), Words.REVIEW_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.checkAll = new TextButton("Check All");
        this.checkAll.addButtonListener((source, x, y) -> this.checkAllItems());
        this.measurement = editor.getModel().isAddRow() ? new TitledItem<SearchTextField2<CCP0102MeasurementLight>>(SearchTextField2Factory.getMeasurementSearchField(true, null), "Measurement", TitledItem.TitledItemOrientation.NORTH) : new TitledItem<TextLabel>(new TextLabel(ConverterRegistry.getConverter(CCP0102MeasurementConverter.class)), "Measurement", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.periodEditor);
        this.addToView(this.name);
        this.addToView(this.checkAll);
        this.addToView(this.creationDate);
        this.addToView(this.creationUser);
        this.addToView(this.reviewDate);
        this.addToView(this.reviewUser);
        this.addToView(this.measurement);
    }

    private void updateSearchPeriod() {
        if (this.editor.getModel().isAddRow()) {
            Object[] a = new Object[]{new PeriodComplete(new Date(this.periodEditor.getTimePeriod().getStartTime().getTime()), new Date(this.periodEditor.getTimePeriod().getEndTime().getTime())), true};
            ((SearchTextField2)this.measurement.getElement()).setAdditionalSearchField(a);
        }
    }

    private void checkAllItems() {
        Iterator it = this.node.getChildNamed(CCP0102SpotCheckReviewComplete_.entries).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            node.getChildNamed(CCP0102SpotCheckReviewEntryComplete_.reviewed).setValue((Object)true, 0L);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.checkAll.setEnabled(isEnabled && this.provider.isWritable(CCP0102SpotCheckAccess.CHECK_ALL));
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.periodEditor.setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.timestampPeriod));
        this.name.getElement().setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.name));
        this.creationDate.getElement().setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.creationDate));
        this.creationUser.getElement().setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.creationUser));
        this.reviewDate.getElement().setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.reviewedDate));
        this.reviewUser.getElement().setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.reviewUser));
        if (this.editor.getModel().isAddRow()) {
            ((SearchTextField2)this.measurement.getElement()).setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.measurement));
        } else {
            ((TextLabel)this.measurement.getElement()).setNode(node.getChildNamed(CCP0102SpotCheckReviewComplete_.measurement));
        }
        this.updateSearchPeriod();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().getNode().getChildNamed(CCP0102SpotCheckReviewComplete_.measurement).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Measurement must be set"));
            if (this.measurement.getElement() instanceof Validatable) {
                ((Validatable)((Object)this.measurement.getElement())).setInvalid();
            }
        } else if (this.measurement.getElement() instanceof Validatable) {
            ((Validatable)((Object)this.measurement.getElement())).setValid();
        }
        return validationObjects;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.measurement);
        CheckedListAdder.addToList(focusList, this.checkAll);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.measurement.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(300, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.periodEditor.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.periodEditor.setSize(SpecificationDetailsPanel.this.periodEditor.getPreferredSize());
            SpecificationDetailsPanel.this.creationUser.setLocation(SpecificationDetailsPanel.this.periodEditor.getX() + SpecificationDetailsPanel.this.periodEditor.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.creationUser.setSize(250, (int)SpecificationDetailsPanel.this.creationUser.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.creationDate.setLocation(SpecificationDetailsPanel.this.creationUser.getX(), SpecificationDetailsPanel.this.creationUser.getY() + SpecificationDetailsPanel.this.creationUser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.creationDate.setSize(250, (int)SpecificationDetailsPanel.this.creationDate.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.reviewUser.setLocation(SpecificationDetailsPanel.this.creationUser.getX() + SpecificationDetailsPanel.this.creationUser.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.reviewUser.setSize(250, (int)SpecificationDetailsPanel.this.reviewUser.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.reviewDate.setLocation(SpecificationDetailsPanel.this.reviewUser.getX(), SpecificationDetailsPanel.this.reviewUser.getY() + SpecificationDetailsPanel.this.reviewUser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.reviewDate.setSize(250, (int)SpecificationDetailsPanel.this.reviewDate.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.measurement.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.periodEditor.getY() + SpecificationDetailsPanel.this.periodEditor.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.measurement.setSize(300, (int)SpecificationDetailsPanel.this.measurement.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.checkAll.setLocation((int)((double)parent.getWidth() - ((double)SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.checkAll.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)SpecificationDetailsPanel.this.verticalBorder + SpecificationDetailsPanel.this.checkAll.getPreferredSize().getHeight())));
            SpecificationDetailsPanel.this.checkAll.setSize(SpecificationDetailsPanel.this.checkAll.getPreferredSize());
        }
    }
}

