/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.halal;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SpotCheckServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewEntryComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class HalalSpotCheckModuleDataHandler
extends DefaultDataHandler<HalalSpotCheckReviewLight, HalalSpotCheckReviewComplete> {
    public HalalSpotCheckModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HalalSpotCheckReviewLight group = (HalalSpotCheckReviewLight)node.getValue(HalalSpotCheckReviewLight.class);
                HalalSpotCheckReviewComplete ngroup = (HalalSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getHalalSpotCheck(group).getValue();
                for (HalalSpotCheckReviewEntryComplete entry : ngroup.getEntries()) {
                    BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(entry.getPosition().getArticle().getId())).getValue();
                    entry.getPosition().setArticle((BasicArticleLight)basicArticle);
                }
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<HalalSpotCheckReviewLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HalalSpotCheckReviewComplete g = (HalalSpotCheckReviewComplete)node.getValue(HalalSpotCheckReviewComplete.class);
                HalalSpotCheckReviewComplete gn = (HalalSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).updateHalalSpotCheck(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<HalalSpotCheckReviewComplete> createEmptyNode() {
        HalalSpotCheckReviewComplete r = new HalalSpotCheckReviewComplete();
        r.setCreationDate(new Timestamp(System.currentTimeMillis()));
        r.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        r.setTimestampPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
    }

    @Override
    public void createNewData(final Node<HalalSpotCheckReviewComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HalalSpotCheckReviewComplete g = (HalalSpotCheckReviewComplete)node.getValue(HalalSpotCheckReviewComplete.class);
                HalalSpotCheckReviewComplete gn = (HalalSpotCheckReviewComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).createHalalSpotCheck(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HalalSpotCheckModuleDataHandler.this.setCurrentLoadMaximum(0);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return HalalSpotCheckModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<HalalSpotCheckReviewComplete> resetData(Node<HalalSpotCheckReviewComplete> node) {
        HalalSpotCheckReviewComplete n = new HalalSpotCheckReviewComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<HalalSpotCheckReviewComplete> getCommittingClass() {
        return HalalSpotCheckReviewComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<HalalSpotCheckReviewLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

