/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.knifetacking;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.KnifeTrackingServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckReviewReference;
import ch.icit.pegasus.server.core.i18n.Words;

public class KnifeTrackingSpotCheckModuleDataHandler
extends DefaultDataHandler<KnifeSpotCheckReviewLight, KnifeSpotCheckReviewComplete> {
    public KnifeTrackingSpotCheckModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KnifeSpotCheckReviewLight group = (KnifeSpotCheckReviewLight)node.getValue(KnifeSpotCheckReviewLight.class);
                KnifeSpotCheckReviewComplete ngroup = (KnifeSpotCheckReviewComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).getSpotCheck(new KnifeSpotCheckReviewReference(group.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<KnifeSpotCheckReviewLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(KnifeSpotCheckReviewComplete.class);
                KnifeSpotCheckReviewComplete g = (KnifeSpotCheckReviewComplete)node.getValue(KnifeSpotCheckReviewComplete.class);
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                KnifeSpotCheckReviewComplete gn = (KnifeSpotCheckReviewComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).updateSpotCheck(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<KnifeSpotCheckReviewComplete> createEmptyNode() {
        return null;
    }

    @Override
    public void createNewData(final Node<KnifeSpotCheckReviewComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KnifeTrackingSpotCheckModuleDataHandler.this.setCurrentLoadMaximum(2);
                StaticEnumServiceManager.getAllKnifeStates();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return KnifeTrackingSpotCheckModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<KnifeSpotCheckReviewComplete> resetData(Node<KnifeSpotCheckReviewComplete> node) {
        return null;
    }

    @Override
    public Class<KnifeSpotCheckReviewComplete> getCommittingClass() {
        return KnifeSpotCheckReviewComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<KnifeSpotCheckReviewLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

