/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock.details.utils;

import ch.icit.pegasus.client.gui.modules.stock.details.StockContentDetailsPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.PrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreArticleContentSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.report.ArticleLabelsOnStockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreArticleContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ArticleLabelsPopup
extends PrintPopupInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<StoreLight> store;
    protected TitledItem<TextLabel> title;
    protected HorizontalSeparator sep1;
    private TitledItem<RadioButton> all;
    private TitledItem<RadioButton> filtered;
    private TitledItem<RadioButton> screen;
    private TitledItem<RadioButtonBox> styleSheets;
    private TitledItem<CheckBox> calculateNeededLabels;
    private TitledItem<TextField> numberOfLabels;
    private TitledItem<CheckBox> includeBarCode;
    private TitledItem<TextField> startPosition;
    private StockContentDetailsPanel para;
    private UserComplete currentUser;

    public ArticleLabelsPopup(Node store, UserComplete currentUser, StockContentDetailsPanel para) {
        super(true);
        this.currentUser = currentUser;
        this.store = store;
        this.para = para;
        this.createComponents();
    }

    protected void createComponents() {
        this.title = new TitledItem<TextLabel>(new TextLabel(((StoreLight)this.store.getValue()).getCode()), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.add(this.title);
        this.add(this.sep1);
        this.all = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_ALL, TitledItem.TitledItemOrientation.EAST);
        this.filtered = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_FILTERED, TitledItem.TitledItemOrientation.EAST);
        this.screen = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_SHOWN, TitledItem.TitledItemOrientation.EAST);
        this.styleSheets = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Sheet", TitledItem.TitledItemOrientation.NORTH);
        this.calculateNeededLabels = new TitledItem<CheckBox>(new CheckBox(), Words.CALCULATE_NEEDED_LABELS_AUTOMATICALLY, TitledItem.TitledItemOrientation.EAST);
        this.numberOfLabels = new TitledItem<TextField>(new TextField(), Words.NUMBER_OF_LABELS_PER_CHARGE, TitledItem.TitledItemOrientation.EAST);
        this.numberOfLabels.getElement().setText("15");
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.startPosition = new TitledItem<TextField>(new TextField(), Words.START_POSITION, TitledItem.TitledItemOrientation.EAST);
        this.startPosition.getElement().setText("1");
        this.includeBarCode.setEnabled(true);
        this.startPosition.setEnabled(true);
        this.calculateNeededLabels.getElement().addButtonListener(this);
        this.calculateNeededLabels.getElement().setChecked(true);
        this.filtered.getElement().setChecked(true);
        this.includeBarCode.getElement().setChecked(true);
        this.setLayout(new Layout());
        this.add(this.all);
        this.add(this.screen);
        this.add(this.filtered);
        this.add(this.calculateNeededLabels);
        this.add(this.numberOfLabels);
        this.add(this.includeBarCode);
        this.add(this.startPosition);
        this.add(this.styleSheets);
        this.intiTypes();
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.screen != null) {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.screen.getFocusComponents());
            a.addAll(this.filtered.getFocusComponents());
            a.addAll(this.all.getFocusComponents());
            CheckedListAdder.addToList(a, this.styleSheets);
            a.addAll(this.calculateNeededLabels.getFocusComponents());
            a.addAll(this.numberOfLabels.getFocusComponents());
            a.addAll(this.startPosition.getFocusComponents());
            return a;
        }
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        this.screen.setVisible(false);
        this.filtered.setVisible(false);
        this.all.setVisible(false);
        this.calculateNeededLabels.setVisible(false);
        this.numberOfLabels.setVisible(false);
        this.includeBarCode.setVisible(false);
        this.startPosition.setVisible(false);
        this.styleSheets.setVisible(false);
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                int start;
                QuantityComplete q;
                StoreArticleContentSearchConfiguration searchConfig = null;
                if (((RadioButton)ArticleLabelsPopup.this.screen.getElement()).isChecked()) {
                    searchConfig = ArticleLabelsPopup.this.para.getSearchConfig(true);
                } else if (((RadioButton)ArticleLabelsPopup.this.filtered.getElement()).isChecked()) {
                    searchConfig = ArticleLabelsPopup.this.para.getSearchConfig(true);
                    searchConfig.setPageNumber(0);
                    searchConfig.setNumResults(Integer.MAX_VALUE);
                } else if (((RadioButton)ArticleLabelsPopup.this.all.getElement()).isChecked()) {
                    StoreArticleContentSearchConfiguration tempSearch = ArticleLabelsPopup.this.para.getSearchConfig(true);
                    searchConfig = new StoreArticleContentSearchConfiguration();
                    searchConfig.setPageNumber(0);
                    searchConfig.setStore(tempSearch.getStore());
                    searchConfig.setNumResults(Integer.MAX_VALUE);
                }
                BasicArticleSearchConfiguration newSearch = ((StoreArticleContentSearchAlgorithm)SearchAlgorithmRegistry.getSearchAlgorithm(StoreArticleContentSearchAlgorithm.class)).convertToBasicArticleSearchConfiguration(searchConfig);
                HashMap<Object, QuantityComplete> quantity = new HashMap<Object, QuantityComplete>();
                SearchResult r = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreArticleContent(newSearch);
                Object r2 = null;
                for (Object sac : r.getResults()) {
                    q = (QuantityComplete)quantity.get(sac.getArticle());
                    if (q != null) continue;
                    QuantityComplete totalQuantityInStoreUnit = UnitConversionToolkit.getTotalQuantityInStoreUnit((StoreArticleContentComplete)sac);
                    quantity.put(sac.getArticle(), totalQuantityInStoreUnit);
                }
                if (r2 != null) {
                    for (Object sac : r2.getResults()) {
                        q = (QuantityComplete)quantity.get(sac);
                        if (q != null) continue;
                        quantity.put(sac, new QuantityComplete(Double.valueOf(0.0), sac.getFloatStoreUnit()));
                    }
                }
                HashMap<BasicArticleReference, QuantityComplete> articles = new HashMap<BasicArticleReference, QuantityComplete>();
                for (BasicArticleLight artL : quantity.keySet()) {
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                    QuantityComplete p = (QuantityComplete)quantity.get(artL);
                    if (p == null) {
                        p = new QuantityComplete();
                    }
                    if (p.getQuantity() == null) {
                        p.setQuantity(Double.valueOf(0.0));
                    }
                    if (p.getUnit() == null) {
                        p.setUnit(artC.getFloatStoreUnit());
                    }
                    articles.put(new BasicArticleReference(artL.getId()), p);
                }
                ArticleLabelsOnStockReportConfiguration conf = new ArticleLabelsOnStockReportConfiguration();
                conf.setStore(ArticleLabelsPopup.this.para.getSearchConfig(true).getStore());
                conf.setArticles(articles);
                DefaultScrollablePrintPopup2.ReportSelection selectedButton = (DefaultScrollablePrintPopup2.ReportSelection)((RadioButtonBox)ArticleLabelsPopup.this.styleSheets.getElement()).getSelectedButton();
                conf.setStylesheet(selectedButton.getUserObject());
                try {
                    start = Integer.valueOf(((TextField)ArticleLabelsPopup.this.startPosition.getElement()).getText());
                }
                catch (NumberFormatException e) {
                    start = 1;
                }
                conf.setStartPosition(start);
                conf.setIncludeBarCode(((CheckBox)ArticleLabelsPopup.this.includeBarCode.getElement()).isChecked());
                if (((CheckBox)ArticleLabelsPopup.this.calculateNeededLabels.getElement()).isChecked()) {
                    conf.setCalculateNeededLabels(true);
                } else {
                    int amount;
                    try {
                        amount = Integer.valueOf(((TextField)ArticleLabelsPopup.this.numberOfLabels.getElement()).getText());
                    }
                    catch (NumberFormatException e) {
                        amount = 1;
                    }
                    conf.setNumberOfLabels(amount);
                }
                PegasusFileComplete file = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabelsForArticlesOnStock(conf).getValue();
                if (file != null && file.getLocalFile() == null) {
                    File f = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                        public void statusChanged(File file, FileTransferState state) {
                        }

                        public void exceptionOccurred(Exception exception) {
                            InnerPopupFactory.showErrorDialog(exception, (Component)ArticleLabelsPopup.this);
                        }
                    }});
                    Desktop.getDesktop().open(f);
                }
                ArticleLabelsPopup.this.errorMSG = null;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleLabelsPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFULLY_EXPORTED;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORTING;
    }

    private void intiTypes() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List reportFileCompletes = ArticleLabelsPopup.this.loadTypes();
                ViewNode node = new ViewNode("");
                node.setValue((Object)reportFileCompletes, 0L);
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (ArticleLabelsPopup.this.styleSheets != null) {
                            List reports = (List)node.getValue();
                            for (ReportFileComplete r : reports) {
                                DefaultScrollablePrintPopup2.ReportSelection f = new DefaultScrollablePrintPopup2.ReportSelection(r);
                                ((RadioButtonBox)ArticleLabelsPopup.this.styleSheets.getElement()).addBox(new TitledItem<DefaultScrollablePrintPopup2.ReportSelection>(f, r.getDescription(), TitledItem.TitledItemOrientation.EAST), f);
                            }
                            if (((RadioButtonBox)ArticleLabelsPopup.this.styleSheets.getElement()).getAnyButton() != null) {
                                ((RadioButtonBox)ArticleLabelsPopup.this.styleSheets.getElement()).getAnyButton().setChecked(true);
                            }
                        }
                        if (ArticleLabelsPopup.this.popup != null) {
                            ArticleLabelsPopup.this.popup.enablePreviewButton(true);
                            ArticleLabelsPopup.this.popup.enableBackgroundButton(true);
                            ArticleLabelsPopup.this.popup.enableCancelButton(true);
                            ArticleLabelsPopup.this.popup.enableOKButton(true);
                        }
                        ArticleLabelsPopup.this.revalidate();
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private List<ReportFileComplete> loadTypes() throws ClientGetFromServerException {
        ReportTypeE reportType = ReportTypeE.ARTICLE_STORE_INFO_SHEET;
        if (reportType != null) {
            SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(reportType);
            List results = r.getResults();
            Collections.sort(results, Ordering.natural().onResultOf((Function)new Function<ReportFileComplete, String>(){

                public String apply(ReportFileComplete input) {
                    return input.getDescription();
                }
            }));
            List reportConfig = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportConfiguration(reportType).getList();
            if (reportConfig != null) {
                block5: for (ReportConfigurationComplete rc : reportConfig) {
                    switch (rc.getType()) {
                        case HIDE_DEFAULT: {
                            Iterator it;
                            if (!rc.getShowDefault().booleanValue()) {
                                it = results.iterator();
                                while (it.hasNext()) {
                                    if (((ReportFileComplete)it.next()).getId() != null) continue;
                                    it.remove();
                                }
                            }
                            if (!rc.getHideReport().booleanValue()) break;
                            it = results.iterator();
                            while (it.hasNext()) {
                                ReportFileComplete report = (ReportFileComplete)it.next();
                                if (!report.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            continue block5;
                        }
                        case MAX_LABEL_ENTRIES: {
                            break;
                        }
                        case REPLACE_IN_LOCATION: {
                            Iterator it = results.iterator();
                            LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                            if (rc.getShowReport().booleanValue() || !location.equals((Object)rc.getLocation())) break;
                            while (it.hasNext()) {
                                ReportFileComplete rfc = (ReportFileComplete)it.next();
                                if (!rfc.getDescription().equals(rc.getOriginReportName())) continue;
                                it.remove();
                            }
                            break;
                        }
                    }
                }
            }
            return results;
        }
        return new ArrayList<ReportFileComplete>();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.calculateNeededLabels.getElement()) {
            this.numberOfLabels.setEnabled(!this.calculateNeededLabels.getElement().isChecked());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(280, 250);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ArticleLabelsPopup.this.layoutInheritedComponents(parent);
            ArticleLabelsPopup.this.title.setLocation(ArticleLabelsPopup.this.border, y);
            ArticleLabelsPopup.this.title.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.title.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.sep1.setLocation(0, ArticleLabelsPopup.this.title.getY() + ArticleLabelsPopup.this.title.getHeight() + ArticleLabelsPopup.this.border);
            ArticleLabelsPopup.this.sep1.setSize(parent.getWidth(), 1);
            y = ArticleLabelsPopup.this.sep1.getY() + ArticleLabelsPopup.this.sep1.getHeight();
            ArticleLabelsPopup.this.screen.setLocation(ArticleLabelsPopup.this.border, y += ArticleLabelsPopup.this.border);
            ArticleLabelsPopup.this.screen.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.screen.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.filtered.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.screen.getY() + ArticleLabelsPopup.this.screen.getHeight() + ArticleLabelsPopup.this.border / 2);
            ArticleLabelsPopup.this.filtered.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.filtered.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.all.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.filtered.getY() + ArticleLabelsPopup.this.filtered.getHeight() + ArticleLabelsPopup.this.border / 2);
            ArticleLabelsPopup.this.all.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.all.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.styleSheets.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.all.getY() + ArticleLabelsPopup.this.all.getHeight() + ArticleLabelsPopup.this.border);
            ArticleLabelsPopup.this.styleSheets.setSize(ArticleLabelsPopup.this.styleSheets.getPreferredSize());
            ArticleLabelsPopup.this.calculateNeededLabels.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.styleSheets.getY() + ArticleLabelsPopup.this.styleSheets.getHeight() + ArticleLabelsPopup.this.border);
            ArticleLabelsPopup.this.calculateNeededLabels.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.calculateNeededLabels.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.numberOfLabels.setLocation(ArticleLabelsPopup.this.border * 2, ArticleLabelsPopup.this.calculateNeededLabels.getY() + ArticleLabelsPopup.this.calculateNeededLabels.getHeight() + ArticleLabelsPopup.this.border / 2);
            ArticleLabelsPopup.this.numberOfLabels.setSize(parent.getWidth() - 3 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.numberOfLabels.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.includeBarCode.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.numberOfLabels.getY() + ArticleLabelsPopup.this.numberOfLabels.getHeight() + ArticleLabelsPopup.this.border / 2);
            ArticleLabelsPopup.this.includeBarCode.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.includeBarCode.getPreferredSize().getHeight());
            ArticleLabelsPopup.this.startPosition.setLocation(ArticleLabelsPopup.this.border, ArticleLabelsPopup.this.includeBarCode.getY() + ArticleLabelsPopup.this.includeBarCode.getHeight() + ArticleLabelsPopup.this.border / 2);
            ArticleLabelsPopup.this.startPosition.setSize(parent.getWidth() - 2 * ArticleLabelsPopup.this.border, (int)ArticleLabelsPopup.this.startPosition.getPreferredSize().getHeight());
        }
    }
}

