/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalutationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.supply.OrderTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StowingListModuleDataHandler
extends DefaultDataHandler<StowingListTemplateReference, StowingListTemplateComplete> {
    private static Map<StowingListTemplateVariantLight, ModificationStateE> stateMap = new HashMap<StowingListTemplateVariantLight, ModificationStateE>();

    public StowingListModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, final ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Stowing List");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node dlNode;
                StowingListTemplateComplete stw = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                StowingListTemplateComplete nstw = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplateComplete(new StowingListTemplateReference(stw.getId())).getValue();
                HashSet<StowingListTemplateReference> stowingIds = new HashSet<StowingListTemplateReference>();
                HashSet<FlightScheduleReference> flightScheduleIds = new HashSet<FlightScheduleReference>();
                for (StowingListConfigurationComplete config : nstw.getStowingListConfigs()) {
                    if (config.getStowingList() == null && config.getStowingListId() != null) {
                        stowingIds.add(new StowingListTemplateReference(config.getStowingListId()));
                    }
                    if (config.getFlightSchedule() != null || config.getFlightScheduleId() == null) continue;
                    flightScheduleIds.add(new FlightScheduleReference(config.getFlightScheduleId()));
                }
                if (!stowingIds.isEmpty()) {
                    boolean onlyActive = false;
                    ListWrapper templates = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplatesComplete(new ListWrapper(new ArrayList(stowingIds)), onlyActive);
                    HashMap<Long, StowingListTemplateComplete> stowingIndex = new HashMap<Long, StowingListTemplateComplete>();
                    for (StowingListTemplateComplete templateComplete : templates.getList()) {
                        stowingIndex.put(templateComplete.getId(), templateComplete);
                    }
                    for (StowingListConfigurationComplete config : nstw.getStowingListConfigs()) {
                        if (config.getStowingList() != null || config.getStowingListId() == null) continue;
                        config.setStowingList((StowingListTemplateComplete)stowingIndex.get(config.getStowingListId()));
                    }
                }
                if (!flightScheduleIds.isEmpty()) {
                    boolean onlyActive = false;
                    ListWrapper flightSchedules = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSchedules(new ListWrapper(new ArrayList(flightScheduleIds)), onlyActive);
                    Iterator scheduleIndex = new HashMap<Long, FlightScheduleComplete>();
                    for (FlightScheduleComplete scheduleComplete : flightSchedules.getList()) {
                        scheduleIndex.put(scheduleComplete.getId(), scheduleComplete);
                    }
                    for (StowingListConfigurationComplete config : nstw.getStowingListConfigs()) {
                        if (config.getFlightSchedule() != null || config.getFlightScheduleId() == null) continue;
                        config.setFlightSchedule((FlightScheduleLight)scheduleIndex.get(config.getFlightScheduleId()));
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)nstw, 0L);
                node.updateNode();
                List l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(nstw.getVariants())).getList();
                StowingListModuleDataHandler.this.showMessage(progressListener, "Check Leg Sync State");
                boolean synced = true;
                for (StowingListTemplateVariantLight variant : l) {
                    if (!LegToolkit.areLegsSynced((StowingListTemplateComplete)nstw, (StowingListTemplateVariantLight)variant)) {
                        synced = false;
                        LegToolkit.syncLegs((StowingListTemplateComplete)nstw, (StowingListTemplateVariantLight)variant, (boolean)false);
                        StowingListModuleDataHandler.ensureMealPlanForWS(variant);
                    }
                    StowingListModuleDataHandler.ensureMealPlanForWS(variant);
                }
                nstw.getVariants().clear();
                nstw.getVariants().addAll(l);
                if (!synced) {
                    StowingListModuleDataHandler.this.showMessage(progressListener, "Update Leg Sync State");
                    nstw = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateTemplate(nstw).getValue();
                    l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(nstw.getVariants())).getList();
                    for (StowingListTemplateVariantLight variant : l) {
                        StowingListModuleDataHandler.ensureMealPlanForWS(variant);
                    }
                    nstw.getVariants().clear();
                    nstw.getVariants().addAll(l);
                }
                StowingListTemplateVariantLight pvc = nstw.getCurrentVariant();
                StowingListModuleDataHandler.ensureMealPlanForWS(pvc);
                if (stateMap.get(pvc) != null) {
                    stateMap.remove(pvc);
                }
                stateMap.put(pvc, pvc.getState());
                node.disableEvents();
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).disableEvents();
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).removeExistingValues();
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).removeChildsPermanent();
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).setValue((Object)pvc, 0L);
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).updateNode();
                node.getChildNamed(StowingListTemplateComplete_.currentVariant).enableEvents();
                node.getChildNamed(StowingListTemplateComplete_.variants).disableEvents();
                node.getChildNamed(StowingListTemplateComplete_.variants).removeExistingValues();
                node.getChildNamed(StowingListTemplateComplete_.variants).setValue((Object)l, 0L);
                node.getChildNamed(StowingListTemplateComplete_.variants).updateNode();
                node.getChildNamed(StowingListTemplateComplete_.variants).enableEvents();
                node.enableEvents();
                ArrayList referencedLegs = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getUsedLegs((StowingListTemplateReference)nstw).getList();
                if (referencedLegs == null) {
                    referencedLegs = new ArrayList();
                }
                if ((dlNode = NodeToolkit.getAffixNamed((String)"referencedLegs")) == null) {
                    dlNode = INodeCreator.getDefaultImpl().createNodes(referencedLegs, true);
                    if (dlNode == null) {
                        dlNode = new ListNode();
                    }
                    dlNode.setName("referencedLegs");
                    NodeToolkit.addAffix((Node)dlNode);
                }
                dlNode.removeExistingValues();
                dlNode.setValue(referencedLegs, 0L);
                for (StowingListConfigurationComplete config : nstw.getStowingListConfigs()) {
                    if (config.getStowingList() == null && config.getStowingListId() != null) {
                        StowingListTemplateComplete stwT = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplateComplete(new StowingListTemplateReference(config.getStowingListId())).getValue();
                        config.setStowingList(stwT);
                    }
                    if (config.getFlightSchedule() != null || config.getFlightScheduleId() == null) continue;
                    FlightScheduleComplete flightSchedule = (FlightScheduleComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSchedule(new FlightScheduleReference(config.getFlightScheduleId())).getValue();
                    config.setFlightSchedule((FlightScheduleLight)flightSchedule);
                }
                List galleyNames = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getGalleys(new StowingListTemplateVariantReference(pvc.getId())).getList();
                Node galleyNodes = INodeCreator.getDefaultImpl().createNodes(galleyNames, false, false);
                galleyNodes.setName("usedGalleys");
                NodeToolkit.addAffix((Node)galleyNodes);
                node.removeExistingValues();
                node.setValue((Object)nstw, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return false;
    }

    public static void ensureMealPlanForWS(StowingListTemplateVariantLight pvc) throws ClientServerCallException {
        if (pvc.getMealplan() != null && pvc.getMealplan().getMealplan() == null && pvc.getMealplan().getMealPlanId() != null) {
            MealPlanLight ml = (MealPlanLight)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlanLight(new MealPlanReference(pvc.getMealplan().getMealPlanId())).getValue();
            pvc.getMealplan().setMealplan(ml);
            XmlCache.getXmlCache().put(ml.getId(), (Object)ml);
        }
    }

    public boolean reloadVariant(final Node<StowingListTemplateVariantReference> aNode, final RemoteLoader listener, final ProgressListener pListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListModuleDataHandler.this.showMessage(pListener, Words.LOAD_DATA);
                Node newNode = aNode;
                StowingListTemplateVariantReference pr = (StowingListTemplateVariantReference)aNode.getValue(StowingListTemplateVariantReference.class);
                if (pr.getId() != null) {
                    StowingListTemplateVariantLight pc = (StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariantLight(new StowingListTemplateVariantReference(pr.getId())).getValue();
                    StowingListModuleDataHandler.ensureMealPlanForWS(pc);
                    List galleyNames = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getGalleys(new StowingListTemplateVariantReference(pr.getId())).getList();
                    Node galleyNodes = INodeCreator.getDefaultImpl().createNodes(galleyNames, false, false);
                    galleyNodes.setName("usedGalleys");
                    NodeToolkit.addAffix((Node)galleyNodes);
                    stateMap.remove(pc);
                    stateMap.put(pc, pc.getState());
                    aNode.removeExistingValues();
                    aNode.setValue((Object)pc, 0L);
                }
                return aNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<StowingListTemplateReference> node, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListModuleDataHandler.this.showMessage(l, Words.SAVE_DATA);
                StowingListTemplateComplete dto = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                Boolean copyChanges = false;
                if (node.getChildNamed(DtoFieldConstants.copyChanges) != null) {
                    copyChanges = (Boolean)node.getChildNamed(DtoFieldConstants.copyChanges).getValue();
                }
                Node newNode = node;
                ArrayList<StowingListTemplateVariantLight> completeDto = new ArrayList<StowingListTemplateVariantLight>();
                ArrayList lightDto = new ArrayList();
                ArrayList<Object> allVariants = new ArrayList<Object>();
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Iterator it = node.getChildNamed(StowingListTemplateComplete_.variants).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.getChildNamed(StowingListTemplateVariantLight_.base).setValue((Object)dto, 0L);
                    if (n.getValue(StowingListTemplateVariantLight.class) != null) {
                        StowingListTemplateVariantLight vc = (StowingListTemplateVariantLight)n.getValue(StowingListTemplateVariantLight.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        n.commitThis(StowingListTemplateVariantLight.class);
                        StowingListTemplateVariantLight c = (StowingListTemplateVariantLight)n.getValue(StowingListTemplateVariantLight.class);
                        ArrayList<ALegComplete> legs2Remove = new ArrayList<ALegComplete>();
                        if (c.getMealplan() != null) {
                            for (ALegComplete l22 : c.getMealplan().getLegMapping().keySet()) {
                                ILegComplete vl = (ILegComplete)c.getMealplan().getLegMapping().get(l22);
                                if (c.getLegs().contains(vl)) continue;
                                legs2Remove.add(l22);
                            }
                            for (ALegComplete l22 : legs2Remove) {
                                c.getMealplan().getLegMapping().remove(l22);
                            }
                            if (c.getMealplan() != null) {
                                c.getMealplan().setStowingList(c);
                            }
                        }
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        c.setBase(dto);
                        completeDto.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    allVariants.add((StowingListTemplateVariantReference)n.getValue());
                }
                Hashtable<Class<StowingListTemplateVariantReference>, Class<StowingListTemplateVariantLight>> t = new Hashtable<Class<StowingListTemplateVariantReference>, Class<StowingListTemplateVariantLight>>();
                t.put(StowingListTemplateVariantReference.class, StowingListTemplateVariantLight.class);
                node.commit(StowingListTemplateComplete.class, t);
                dto = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                for (Object leg : dto.getLegs()) {
                    leg.setStowingList(dto);
                }
                StowingListTemplateComplete l3 = dto;
                l3.setVariants(allVariants);
                if (!completeDto.isEmpty()) {
                    dto.setCurrentVariant((StowingListTemplateVariantLight)completeDto.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                for (StowingListTemplateVariantReference variant : dto.getVariants()) {
                    if (!(variant instanceof StowingListTemplateVariantLight)) continue;
                    StowingListTemplateVariantLight light = (StowingListTemplateVariantLight)variant;
                    if (light.getMealplan() != null && light.getMealplan().getMealplan() == null) {
                        light.setMealplan(null);
                    }
                    if (LegToolkit.areLegsSynced((StowingListTemplateComplete)l3, (StowingListTemplateVariantLight)light)) continue;
                    LegToolkit.syncLegs((StowingListTemplateComplete)l3, (StowingListTemplateVariantLight)light, (boolean)false);
                }
                StowingListTemplateComplete newDTO = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateTemplate(dto).getValue();
                if (newDTO == null) {
                    newDTO = dto;
                    Iterator it2 = newDTO.getVariants().iterator();
                    while (it2.hasNext()) {
                        StowingListTemplateVariantReference r = (StowingListTemplateVariantReference)it2.next();
                        if (r.getId() != null) continue;
                        it2.remove();
                    }
                }
                if (newDTO.getCurrentVariant() == null && newDTO.getVariants() != null && newDTO.getVariants().size() > 0) {
                    newDTO.setCurrentVariant((StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariant((StowingListTemplateVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    newNode.getChildNamed(ProductComplete_.variants).removeAllChilds();
                    newNode.removeExistingValues();
                    newNode.setValue((Object)newDTO, 0L);
                    newNode.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<StowingListTemplateComplete> node, final RemoteLoader model, boolean sameNode, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListTemplateComplete dto = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                Node nn = node;
                ArrayList<StowingListTemplateVariantComplete> cl = new ArrayList<StowingListTemplateVariantComplete>();
                ArrayList<StowingListTemplateVariantLight> ll = new ArrayList<StowingListTemplateVariantLight>();
                Iterator it = node.getChildNamed(StowingListTemplateComplete_.variants).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(StowingListTemplateVariantComplete.class) != null) {
                        StowingListTemplateVariantComplete c = (StowingListTemplateVariantComplete)n.getValue(StowingListTemplateVariantComplete.class);
                        if (c.getState() == null) {
                            c.setState(ModificationStateE.DRAFT);
                        }
                        if (c.getMealplan() != null && c.getMealplan().getMealplan() == null) {
                            c.setMealplan(null);
                        }
                        n.setValue((Object)c, 0L);
                        n.updateNode();
                        c.setBase(dto);
                        cl.add(c);
                        continue;
                    }
                    if (n.getValue(StowingListTemplateVariantLight.class) == null) continue;
                    StowingListTemplateVariantLight l = (StowingListTemplateVariantLight)n.getValue(StowingListTemplateVariantLight.class);
                    if (l.getState() == null) {
                        l.setState(ModificationStateE.DRAFT);
                    }
                    if (l.getState() == null) {
                        l.setState(ModificationStateE.DRAFT);
                    }
                    if (l.getMealplan() != null && l.getMealplan().getMealplan() == null) {
                        l.setMealplan(null);
                    }
                    l.setBase(dto);
                    ll.add(l);
                }
                Hashtable<Class<StowingListTemplateVariantLight>, Class<StowingListTemplateVariantComplete>> t = new Hashtable<Class<StowingListTemplateVariantLight>, Class<StowingListTemplateVariantComplete>>();
                t.put(StowingListTemplateVariantLight.class, StowingListTemplateVariantComplete.class);
                node.commit(StowingListTemplateComplete.class, t);
                PeriodComplete pTime = dto.getPeriod();
                for (StowingListTemplateVariantLight l : ll) {
                    if (l.getMealplan() == null || l.getMealplan().getMealplan() != null) continue;
                    l.setMealplan(null);
                }
                StowingListModuleDataHandler.this.ensurePeriodMatching(pTime, cl, ll);
                if (!ll.isEmpty()) {
                    dto.setCurrentVariant((StowingListTemplateVariantLight)ll.get(0));
                } else if (!cl.isEmpty()) {
                    dto.setCurrentVariant((StowingListTemplateVariantLight)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                dto = (StowingListTemplateComplete)node.getValue(StowingListTemplateComplete.class);
                for (StowingListTemplateLegComplete leg : dto.getLegs()) {
                    leg.setStowingList(dto);
                }
                for (StowingListTemplateVariantReference r : dto.getVariants()) {
                    if (!(r instanceof StowingListTemplateVariantLight)) continue;
                    ((StowingListTemplateVariantLight)r).setBase(dto);
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                LegToolkit.syncLegs((StowingListTemplateComplete)dto, (StowingListTemplateVariantLight)dto.getCurrentVariant(), (boolean)false);
                StowingListTemplateComplete newDTO = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).createTemplate(dto).getValue();
                Iterator it2 = newDTO.getVariants().iterator();
                while (it2.hasNext()) {
                    StowingListTemplateVariantReference r = (StowingListTemplateVariantReference)it2.next();
                    if (r.getId() != null) continue;
                    it2.remove();
                }
                List l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(newDTO.getVariants())).getList();
                StowingListModuleDataHandler.this.showMessage(progressListener, "Check Leg Sync State");
                boolean synced = true;
                for (StowingListTemplateVariantLight variant : l) {
                    if (LegToolkit.areLegsSynced((StowingListTemplateComplete)newDTO, (StowingListTemplateVariantLight)variant)) continue;
                    synced = false;
                    LegToolkit.syncLegs((StowingListTemplateComplete)newDTO, (StowingListTemplateVariantLight)variant, (boolean)false);
                }
                if (!synced) {
                    StowingListModuleDataHandler.this.showMessage(progressListener, "Update Leg Sync State");
                    newDTO.getVariants().clear();
                    for (StowingListTemplateVariantLight variant : l) {
                        newDTO.getVariants().add(variant);
                    }
                    newDTO = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateTemplate(newDTO).getValue();
                    l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(newDTO.getVariants())).getList();
                }
                if (newDTO.getCurrentVariant() == null) {
                    newDTO.setCurrentVariant((StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariant((StowingListTemplateVariantReference)newDTO.getVariants().get(0)).getValue());
                }
                if (newDTO != null) {
                    Node n = node;
                    node.getChildNamed(StowingListTemplateComplete_.variants).removeAllChilds();
                    node.removeExistingValues();
                    node.setValue((Object)newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensurePeriodMatching(PeriodComplete pTime, List<StowingListTemplateVariantComplete> cl, List<StowingListTemplateVariantLight> ll) {
        ArrayList<StowingListTemplateVariantLight> productive = new ArrayList<StowingListTemplateVariantLight>();
        for (StowingListTemplateVariantComplete variantComplete : cl) {
            productive.add((StowingListTemplateVariantLight)variantComplete);
        }
        for (StowingListTemplateVariantLight variantLight : ll) {
            productive.add(variantLight);
        }
        this.sortProductList(pTime, productive);
    }

    private void sortProductList(PeriodComplete pTime, List<StowingListTemplateVariantLight> l) {
        if (l.size() == 1) {
            StowingListTemplateVariantLight variantLight = l.get(0);
            variantLight.getValidityPeriod().setStartDate(new Date(pTime.getStartDate().getTime()));
            variantLight.getValidityPeriod().setEndDate(new Date(pTime.getEndDate().getTime()));
        }
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListModuleDataHandler.this.setCurrentLoadMaximum(14);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SalutationComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderTypeComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxMealTypeComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightLevelComplete.class);
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrolleyScanSettingsCached();
                StowingListModuleDataHandler.this.showNextMessage(progressListener);
                ((EdelweissServiceManager)ServiceManagerRegistry.getService(EdelweissServiceManager.class)).getSettingsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return StowingListModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StowingListTemplateComplete> resetData(Node<StowingListTemplateComplete> node) {
        StowingListTemplateComplete p = new StowingListTemplateComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setPeriod(new PeriodComplete());
        Date d = new Date(System.currentTimeMillis());
        Date d2 = new Date(System.currentTimeMillis());
        p.getPeriod().setStartDate(d);
        p.getPeriod().setEndDate(d2);
        StowingListTemplateVariantComplete variant = new StowingListTemplateVariantComplete();
        variant.setValidityPeriod(new PeriodComplete(d, d2));
        p.getVariants().add(variant);
        p.setCurrentVariant((StowingListTemplateVariantLight)variant);
        node.setValue((Object)p, System.currentTimeMillis());
        node.updateNode();
        return node;
    }

    @Override
    public Node<StowingListTemplateComplete> createEmptyNode() {
        StowingListTemplateComplete p = new StowingListTemplateComplete();
        p.setPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        StowingListTemplateVariantComplete variant = new StowingListTemplateVariantComplete();
        variant.setClientOId(Long.valueOf(ADTO.getNextId()));
        variant.setValidityPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), CalendarUtil.getInfinityDate()));
        variant.setState(ModificationStateE.DRAFT);
        variant.setBase(p);
        p.getVariants().add(variant);
        p.setCurrentVariant((StowingListTemplateVariantLight)variant);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        n.getChildNamed(StowingListTemplateComplete_.variants);
        return n;
    }

    @Override
    public Class<StowingListTemplateComplete> getCommittingClass() {
        return StowingListTemplateComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<StowingListTemplateReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

