/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.inserts.LegMappingPopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowingListToFlightScheduleConfigurationDetailsPanel
extends StateDependantTableDetailsPanel<StowingListTemplateComplete> {
    private static final Logger log = LoggerFactory.getLogger(StowingListToFlightScheduleConfigurationDetailsPanel.class);
    private static final long serialVersionUID = 1L;

    public StowingListToFlightScheduleConfigurationDetailsPanel(RowEditor<StowingListTemplateComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.STOWING_LIST_FLIGHT_SCHEDULE_MAPPING);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.CUST, null, null, null, "", TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.INBOUND, null, null, null, "", 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.PERIOD, null, null, null, "", TableColumnInfo.periodColumnWidth + 2 * this.table.getCellPadding()));
        int tw = ConfigButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setSortable(true);
        table.setSortedColumn(4);
        table.setSortDirection(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return StowingListTemplateVariantLight_.state;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            List<ScreenValidationObject> a = i.validateLegs();
            if (a == null) continue;
            o.addAll(a);
        }
        return o;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (node != null) {
            this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.stowingListConfigs));
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel customer;
        private TextLabel inbound;
        private TextLabel outbound;
        private TextLabel period;
        private ConfigButton editMapping;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.customer = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.customer, CustomerLight_.code}), ConverterRegistry.getConverter(StringConverter.class));
            this.inbound = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.inboundCode}), ConverterRegistry.getConverter(StringConverter.class));
            this.outbound = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.outboundCode}), ConverterRegistry.getConverter(StringConverter.class));
            this.period = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.period}), ConverterRegistry.getConverter(PeriodConverter.class));
            this.editMapping = new ConfigButton();
            this.editMapping.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.customer);
            this.add(this.number);
            this.add(this.inbound);
            this.add(this.outbound);
            this.add(this.period);
            this.add(this.editMapping);
        }

        public List<ScreenValidationObject> validateLegs() {
            Node mapping;
            Node destinationLegs;
            Node sourceLeg = this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs});
            List a = LegToolkit.validateLegsMapping((Node)sourceLeg, (Node)(destinationLegs = this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, StowingListTemplateVariantLight_.legs})), (Node)(mapping = this.model.getNode().getChildNamed(StowingListConfigurationComplete_.legMapping)), (boolean)true, (String)"(Stw - FS) ");
            if (a != null && !a.isEmpty()) {
                this.editMapping.setInvalid();
            } else {
                this.editMapping.setValid();
            }
            return a;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.editMapping);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.number}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.customer, CustomerLight_.code}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.outboundCode}).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.inboundCode}).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.period, PeriodComplete_.startDate}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isDraft = true;
            if (StowingListToFlightScheduleConfigurationDetailsPanel.this.node != null) {
                try {
                    isDraft = StowingListToFlightScheduleConfigurationDetailsPanel.this.node.getChildNamed(StowingListTemplateVariantLight_.state).getValue() != ModificationStateE.ACCEPTED;
                }
                catch (Exception e) {
                    log.error("Error while set Enable", (Throwable)e);
                }
            }
            boolean b = isEnabled && isDraft;
            super.setEnabled(b);
            this.number.setEnabled(b);
            this.customer.setEnabled(b);
            this.inbound.setEnabled(b);
            this.outbound.setEnabled(b);
            this.period.setEnabled(b);
            this.editMapping.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.number.kill();
            this.customer.kill();
            this.inbound.kill();
            this.outbound.kill();
            this.period.kill();
            this.editMapping.kill();
            this.number = null;
            this.customer = null;
            this.inbound = null;
            this.outbound = null;
            this.period = null;
            this.editMapping = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.DEFINE_MEAL_PLAN_LEG_MAPPING);
            ArrayList<Node<ALegComplete>> sourceLeg = new ArrayList<Node<ALegComplete>>();
            this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}).commit();
            Iterator it = this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                sourceLeg.add(n);
            }
            this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.legs}).commit();
            popUp.setView(new LegMappingPopupInsert(sourceLeg, MappingTable2D.createList(this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.flightSchedule, FlightScheduleLight_.legs})), (Node<Map<ALegComplete, ALegComplete>>)this.model.getNode().getChildNamed(StowingListConfigurationComplete_.legMapping), "Leg (from Stowing List)", "is replaced by Leg (from Flight Schedule)", false));
            popUp.showPopUp(x, y, 500, 200, null, source);
            popUp.getView().setEnabled(this.isEnabled());
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.outbound.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.outbound.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.outbound.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.outbound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.inbound.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.inbound.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.inbound.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.inbound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.editMapping.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editMapping.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editMapping.setSize(TableRowImpl.this.editMapping.getPreferredSize());
            }
        }
    }
}

