/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist.details.utils;

import ch.icit.pegasus.client.converter.MealPlanConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.stowinglist.details.utils.LoadingGroupMappingConverter;
import ch.icit.pegasus.client.gui.modules.stowinglist.details.utils.MealPlanSwitchNodeFilter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.LegMappingTable;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MealPlanSwitchPopup
extends ScrollablePrintPopupInsert
implements SearchTextField2Listener {
    static Logger log = LoggerFactory.getLogger(MealPlanSwitchPopup.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> mealPlanToSwitch;
    private TitledItem<SearchTextField2> newMealPlan;
    private HorizontalSeparator sep1;
    private LegMappingTable legMapping;
    private Node<?> newMealPlanNode;
    private Node<List<CateringServiceScheduleComplete>> currentScheds;
    private Node<List<CateringServiceScheduleComplete>> newScheds;
    private TitledItem<MappingTable2D<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMapping;
    private Node<MealPlanConfigurationComplete> currentMealPlan;
    protected List<ALoadingGroupComplete> usedGroups;
    private TextButton validateButton;

    public MealPlanSwitchPopup(Node<MealPlanConfigurationComplete> currentMealPlan) {
        this.currentMealPlan = currentMealPlan;
        this.getViewContainer().setLayout(new Layout());
        this.mealPlanToSwitch = new TitledItem<TextLabel>(new TextLabel(currentMealPlan.getChildNamed(MealPlanConfigurationComplete_.mealplan), ConverterRegistry.getConverter(MealPlanConverter.class)), "Meal Plan to switch", TitledItem.TitledItemOrientation.NORTH);
        this.newMealPlan = new TitledItem<SearchTextField2<MealPlanLight>>(SearchTextField2Factory.getMealplanSearchField(false, new DTOProxyNode()), "New Meal Plan", TitledItem.TitledItemOrientation.NORTH);
        this.newMealPlan.getElement().addSearchTextFieldListener(this);
        this.sep1 = new HorizontalSeparator();
        this.serviceMapping = new TitledItem<1>(new MappingTable2D<ALoadingGroupComplete, ALoadingGroupComplete>(LoadingGroupMappingConverter.class, LoadingGroupMappingConverter.class, "Loading Group (from old MP)", "is replaced by (from new MP)", null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void findSelection(Node<ALoadingGroupComplete> currentNode, String text, List<Node<ALoadingGroupComplete>> mappingList, TextLabel currentCombo, List<Node<ALoadingGroupComplete>> sources) {
                ALoadingGroupComplete currentGroup = (ALoadingGroupComplete)currentNode.getValue();
                CateringServiceScheduleVariantComplete currentService = (CateringServiceScheduleVariantComplete)currentNode.getParent().getParent().getParent().getParent().getParent().getValue();
                Node<ALoadingGroupComplete> secondChoice = null;
                Node<ALoadingGroupComplete> thirdChoice = null;
                int match = -1;
                for (Node<ALoadingGroupComplete> n : mappingList) {
                    match = MealPlanSwitchPopup.this.getBestMatch(n, currentService.getBase(), currentGroup);
                    if (match == -1) continue;
                    if (match == 0) {
                        currentCombo.setNode((Node)n);
                        return;
                    }
                    if (match == 1) {
                        secondChoice = n;
                        continue;
                    }
                    if (match != 2) continue;
                    thirdChoice = n;
                }
                match = secondChoice != null ? 1 : (thirdChoice != null ? 2 : -1);
                boolean hasBetterMatch = false;
                if (secondChoice != null) {
                    hasBetterMatch = MealPlanSwitchPopup.this.hasBetterMatch(secondChoice, match, sources);
                } else if (thirdChoice != null) {
                    hasBetterMatch = MealPlanSwitchPopup.this.hasBetterMatch(thirdChoice, match, sources);
                }
                if (!hasBetterMatch) {
                    if (secondChoice != null) {
                        currentCombo.setNode((Node)secondChoice);
                    } else if (thirdChoice != null) {
                        currentCombo.setNode((Node)thirdChoice);
                    }
                } else {
                    log.debug("found a better choice " + ((ALoadingGroupComplete)currentNode.getValue()).getName());
                }
            }
        }, "Stowage Mapping", TitledItem.TitledItemOrientation.NORTH);
        Node n = new Node();
        this.legMapping = new LegMappingTable(null, null, (Node<Map<ALegComplete, ALegComplete>>)n, "Leg (from old MP)", "is replaced by (from new MP)");
        this.serviceMapping.getElement().setNodeFilter(new MealPlanSwitchNodeFilter(this.legMapping));
        this.validateButton = new TextButton("Validate");
        this.validateButton.addButtonListener(new ButtonListener(){

            @Override
            public void buttonPressed(Button source, int x, int y) {
                MealPlanSwitchPopup.this.validateOnline();
            }
        });
        this.getViewContainer().add(this.mealPlanToSwitch);
        this.getViewContainer().add(this.newMealPlan);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.serviceMapping);
        this.getViewContainer().add(this.legMapping);
        this.getViewContainer().add(this.validateButton);
    }

    private void validateOnline() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                Map mt = ((MappingTable2D)MealPlanSwitchPopup.this.serviceMapping.getElement()).getInvertedMappingTable();
                Map lm = MealPlanSwitchPopup.this.legMapping.getInverseMappingTable2();
                StowingListTemplateVariantLight stw = (StowingListTemplateVariantLight)MealPlanSwitchPopup.this.currentMealPlan.getParent().getValue(StowingListTemplateVariantLight.class);
                MealPlanLight mp = (MealPlanLight)((SearchTextField2)MealPlanSwitchPopup.this.newMealPlan.getElement()).getNode().getValue();
                if (stw == null) {
                    throw new ClientServerCallException("No Stowing List selected, please reopen Switch Dialog");
                }
                if (mp == null) {
                    throw new ClientServerCallException("No Meal Plan selected, please selected a Meal Plan");
                }
                List warnings = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).validateMealPlanMapping(stw, mp, new MapWrapper(lm), new MapWrapper(mt)).getList();
                ViewNode n = new ViewNode("");
                n.setValue((Object)warnings, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node.getValue() instanceof List) {
                            List values = (List)node.getValue();
                            if (values.isEmpty()) {
                                InnerPopupFactory.showMessageDialog("Mapping ok", MealPlanSwitchPopup.this);
                            } else {
                                ArrayList<ScreenValidationObject> vo = new ArrayList<ScreenValidationObject>();
                                for (String value : values) {
                                    vo.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, value));
                                }
                                InnerPopupFactory.showErrorDialog(vo, "Mapping not valid", (Component)MealPlanSwitchPopup.this);
                            }
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Mapping not valid", (Component)MealPlanSwitchPopup.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public int getBestMatch(Node<ALoadingGroupComplete> n, CateringServiceScheduleComplete currentService, ALoadingGroupComplete currentGroup) {
        ILegComplete leg2;
        Node service = n.getParent().getParent().getParent().getParent().getParent();
        CateringServiceScheduleVariantComplete s = (CateringServiceScheduleVariantComplete)service.getValue(CateringServiceScheduleVariantComplete.class);
        ALoadingGroupComplete newGroup = (ALoadingGroupComplete)n.getValue();
        ILegComplete leg = !s.getLegs().isEmpty() ? (ILegComplete)s.getLegs().get(0) : null;
        ILegComplete iLegComplete = leg2 = !currentService.getLegs().isEmpty() ? (ILegComplete)currentService.getLegs().get(0) : null;
        if (currentGroup.getName().equals(newGroup.getName()) && s.getCabinClass().equals((Object)currentService.getCabinClass()) && s.getType().equals((Object)currentService.getType())) {
            Integer i2;
            Integer i1;
            if (leg != null && leg2 != null && (i1 = leg.getNumber()).equals(i2 = leg2.getNumber())) {
                return 0;
            }
        } else if (currentGroup.getName().equals(newGroup.getName()) && s.getCabinClass().equals((Object)currentService.getCabinClass()) && leg != null && leg2 != null) {
            Integer i2;
            Integer i1 = leg.getNumber();
            if (i1.equals(i2 = leg2.getNumber())) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public boolean hasBetterMatch(Node<ALoadingGroupComplete> currentChoice, int currentMatch, List<Node<ALoadingGroupComplete>> sources) {
        ALoadingGroupComplete currentGroup = (ALoadingGroupComplete)currentChoice.getValue();
        CateringServiceScheduleComplete currentService = (CateringServiceScheduleComplete)currentChoice.getParent().getParent().getParent().getParent().getParent().getValue(CateringServiceScheduleComplete.class);
        if (currentService == null) {
            currentService = ((CateringServiceScheduleVariantComplete)currentChoice.getParent().getParent().getParent().getParent().getParent().getValue(CateringServiceScheduleVariantComplete.class)).getBase();
        }
        for (Node<ALoadingGroupComplete> n : sources) {
            int match;
            if (((ALoadingGroupComplete)n.getValue()).equals(currentChoice.getValue()) || (match = this.getBestMatch(n, currentService, currentGroup)) >= currentMatch || match == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.mealPlanToSwitch != null) {
            this.mealPlanToSwitch.setEnabled(isEnabled);
            this.newMealPlan.setEnabled(isEnabled);
            this.sep1.setEnabled(isEnabled);
            this.legMapping.setEnabled(isEnabled);
            this.serviceMapping.setEnabled(isEnabled);
            this.validateButton.setEnabled(isEnabled);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Map<ALoadingGroupComplete, ALoadingGroupComplete> mt = this.serviceMapping.getElement().getInvertedMappingTable();
        Map<ALegComplete, ALegComplete> lm = this.legMapping.getInverseMappingTable();
        ArrayList<Object> sourceGroup = new ArrayList<Object>();
        ArrayList<Object> targetGroup = new ArrayList<Object>();
        if (this.newMealPlanNode != null) {
            Node group;
            Node part;
            Iterator it3;
            Node rotation;
            Iterator it2;
            Node service;
            Node n;
            Iterator it = this.currentMealPlan.getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.mealplan, MealPlanLight_.legs}).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                sourceGroup.add(n.getValue());
            }
            it = this.newMealPlanNode.getChildNamed(MealPlanLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                targetGroup.add(n.getValue());
            }
            List c = LegToolkit.validateLegMapping(lm, sourceGroup, targetGroup, (boolean)true);
            a.addAll(c);
            ArrayList<ALoadingGroupComplete> sourceGroups = new ArrayList<ALoadingGroupComplete>();
            ArrayList<ALoadingGroupComplete> targetGroups = new ArrayList<ALoadingGroupComplete>();
            it = this.currentScheds.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
                if (!it2.hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    if (sourceGroups.contains(group.getValue())) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Source Loading Group: " + MealPlanToolkit.createServiceGroupString(((ALoadingGroupComplete)group.getValue()).getContainingService().getCabinClass(), (ALegComplete)((ALoadingGroupComplete)group.getValue()).getContainingService().getLegs().get(0), ((ALoadingGroupComplete)group.getValue()).getContainingService().getType())));
                    }
                    sourceGroups.add((ALoadingGroupComplete)group.getValue());
                }
            }
            it = this.newScheds.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
                if (!it2.hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    if (targetGroups.contains(group.getValue())) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Target Loading Group: " + MealPlanToolkit.createServiceGroupString(((ALoadingGroupComplete)group.getValue()).getContainingService().getCabinClass(), (ALegComplete)((ALoadingGroupComplete)group.getValue()).getContainingService().getLegs().get(0), ((ALoadingGroupComplete)group.getValue()).getContainingService().getType())));
                    }
                    targetGroups.add((ALoadingGroupComplete)group.getValue());
                }
            }
            List<ScreenValidationObject> b = MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, true, this.usedGroups);
            a.addAll(b);
        } else {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Destination Meal Plan selected"));
        }
        MealPlanLight mp = (MealPlanLight)this.newMealPlan.getElement().getNode().getValue();
        if (mp == null) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Select a Meal Plan to switch first"));
        }
        return a;
    }

    private void createMappingTable(Node<?> currentNode) {
        Node group;
        Node part;
        Iterator it3;
        Node rotation;
        Iterator it2;
        Node service;
        Node n;
        ArrayList<Node<ALegComplete>> sourceGroup = new ArrayList<Node<ALegComplete>>();
        ArrayList<Node<ALegComplete>> targetGroup = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.currentMealPlan.getChildNamed(new DtoField[]{MealPlanConfigurationComplete_.mealplan, MealPlanLight_.legs}).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            sourceGroup.add(n);
        }
        if (currentNode != null && currentNode.getChildNamed(StowingListTemplateVariantLight_.legs) != null) {
            it = currentNode.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                targetGroup.add(n);
            }
        }
        ArrayList sourceGroup2 = new ArrayList();
        ArrayList targetGroup2 = new ArrayList();
        it = this.currentScheds.getFailSafeChildIterator();
        while (it.hasNext()) {
            service = (Node)it.next();
            if (((CateringServiceScheduleComplete)service.getValue(CateringServiceScheduleComplete.class)).getIsDeleted().booleanValue() || !(it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator()).hasNext()) continue;
            rotation = (Node)it2.next();
            it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
            while (it3.hasNext()) {
                part = (Node)it3.next();
                group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                if (group == null || this.usedGroups == null || !this.usedGroups.contains(group.getValue())) continue;
                sourceGroup2.add(group);
            }
        }
        if (this.newScheds != null) {
            it = this.newScheds.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                if (((CateringServiceScheduleComplete)service.getValue(CateringServiceScheduleComplete.class)).getIsDeleted().booleanValue() || !(it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator()).hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    if (group == null) continue;
                    targetGroup2.add(group);
                }
            }
        }
        if (this.legMapping != null) {
            this.legMapping.setData(sourceGroup, targetGroup);
            this.legMapping.startDownload();
        }
        if (this.serviceMapping != null) {
            this.serviceMapping.getElement().setData(sourceGroup2, targetGroup2);
            this.serviceMapping.getElement().startDownload();
        }
    }

    public void newValueSelected(SearchTextField2 source, final Node n) {
        this.setEnabled(false);
        this.ensureAnimation("Load Meal Plan");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (MealPlanSwitchPopup.this.currentScheds == null || MealPlanSwitchPopup.this.usedGroups == null) {
                    ArrayList<ALoadingGroupComplete> groups = new ArrayList<ALoadingGroupComplete>();
                    MealPlanLight oldMealPlan = (MealPlanLight)MealPlanSwitchPopup.this.currentMealPlan.getChildNamed(MealPlanConfigurationComplete_.mealplan).getValue();
                    MealPlanComplete oldMealPlanC = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(oldMealPlan.getId())).getValue();
                    List scheds = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(oldMealPlan.getId())).getList();
                    MealPlanSwitchPopup.this.currentScheds = INodeCreator.getDefaultImpl().createNodes(scheds, false);
                    List oldServices = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedServices((MealPlanReference)oldMealPlan).getList();
                    ArrayList refs = new ArrayList();
                    for (CateringServiceScheduleComplete c : scheds) {
                        if (c.getIsDeleted().booleanValue() || !oldServices.contains(c)) continue;
                        try {
                            StowingListTemplateVariantReference sl = new StowingListTemplateVariantReference(((MealPlanConfigurationComplete)MealPlanSwitchPopup.this.currentMealPlan.getValue()).getStowingList().getId());
                            List oldUsedLoadingGroups = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedLoadingGroups(sl, c);
                            refs.addAll(oldUsedLoadingGroups);
                            for (LoadingGroupTemplateComplete g : c.getLoadingGroups()) {
                                if (!oldUsedLoadingGroups.contains(g)) continue;
                                groups.add((ALoadingGroupComplete)g);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    MealPlanSwitchPopup.this.currentMealPlan.getChildNamed(MealPlanConfigurationComplete_.mealplan).removeExistingValues(MealPlanLight.class);
                    MealPlanSwitchPopup.this.currentMealPlan.getChildNamed(MealPlanConfigurationComplete_.mealplan).setValue((Object)oldMealPlanC, 0L);
                    MealPlanSwitchPopup.this.usedGroups = groups;
                }
                MealPlanLight l = (MealPlanLight)n.getValue(MealPlanLight.class);
                MealPlanComplete newMealPlan = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(l.getId())).getValue();
                List nScheds = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(l.getId())).getList();
                MealPlanSwitchPopup.this.newScheds = INodeCreator.getDefaultImpl().createNodes(nScheds, false);
                n.removeExistingValues();
                n.setValue((Object)newMealPlan, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        MealPlanSwitchPopup.this.newMealPlanNode = node;
                        MealPlanSwitchPopup.this.createMappingTable(node);
                        MealPlanSwitchPopup.this.removeAnimation(false);
                        MealPlanSwitchPopup.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        MealPlanSwitchPopup.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
        this.mealPlanToSwitch.setVisible(false);
        this.newMealPlan.setVisible(false);
        this.legMapping.setVisible(false);
        this.serviceMapping.setVisible(false);
        this.sep1.setVisible(false);
        this.validateButton.setVisible(false);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.newMealPlan);
        CheckedListAdder.addToList(a, this.legMapping);
        CheckedListAdder.addToList(a, this.serviceMapping);
        CheckedListAdder.addToList(a, this.validateButton);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[0];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean b = false;
        if (this.legMapping != null) {
            b = this.legMapping.isInnerComponent(c);
        }
        if (!b && this.serviceMapping != null) {
            b = this.serviceMapping.getElement().isInnerComponent(c);
        }
        return b;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.mealPlanToSwitch.kill();
        this.newMealPlan.kill();
        this.legMapping.kill();
        this.serviceMapping.kill();
        this.validateButton.kill();
        this.mealPlanToSwitch = null;
        this.newMealPlan = null;
        this.legMapping = null;
        this.serviceMapping = null;
        this.validateButton = null;
    }

    @Override
    protected String getProgressText() {
        return "Switch Meal Plan";
    }

    @Override
    protected String getFinishedText() {
        return "Meal Plan switched";
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Map mt = ((MappingTable2D)MealPlanSwitchPopup.this.serviceMapping.getElement()).getInvertedMappingTable();
                Map lm = MealPlanSwitchPopup.this.legMapping.getInverseMappingTable2();
                StowingListTemplateVariantLight stw = (StowingListTemplateVariantLight)MealPlanSwitchPopup.this.currentMealPlan.getParent().getValue(StowingListTemplateVariantLight.class);
                MealPlanLight mp = (MealPlanLight)((SearchTextField2)MealPlanSwitchPopup.this.newMealPlan.getElement()).getNode().getValue();
                if (stw == null) {
                    throw new ClientServerCallException("No Stowing List selected, please reopen Switch Dialog");
                }
                if (mp == null) {
                    throw new ClientServerCallException("No Meal Plan selected, please selected a Meal Plan");
                }
                MealPlanConfigurationComplete nStw = (MealPlanConfigurationComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).replaceMealPlan((StowingListTemplateVariantReference)stw, (MealPlanReference)mp, new MapWrapper(lm), new MapWrapper(mt)).getValue();
                if (nStw == null) {
                    ViewNode r = new ViewNode("Error");
                    r.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to switch Meal Plan"), 0L);
                    return r;
                }
                MealPlanSwitchPopup.this.currentMealPlan.removeExistingValues();
                MealPlanSwitchPopup.this.currentMealPlan.setValue((Object)nStw, 0L);
                MealPlanSwitchPopup.this.currentMealPlan.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MealPlanSwitchPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = MealPlanSwitchPopup.this.border;
            h = (int)((double)h + MealPlanSwitchPopup.this.mealPlanToSwitch.getPreferredSize().getHeight());
            h += MealPlanSwitchPopup.this.border;
            h = (int)((double)h + MealPlanSwitchPopup.this.newMealPlan.getPreferredSize().getHeight());
            h += MealPlanSwitchPopup.this.border / 2;
            h = (int)((double)h + MealPlanSwitchPopup.this.sep1.getPreferredSize().getHeight());
            h += MealPlanSwitchPopup.this.border / 2;
            h = (int)((double)h + MealPlanSwitchPopup.this.legMapping.getPreferredSize().getHeight());
            h += MealPlanSwitchPopup.this.border;
            h = (int)((double)h + MealPlanSwitchPopup.this.serviceMapping.getPreferredSize().getHeight());
            h += MealPlanSwitchPopup.this.border;
            h = (int)((double)h + MealPlanSwitchPopup.this.validateButton.getPreferredSize().getHeight());
            return new Dimension(0, h += MealPlanSwitchPopup.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            MealPlanSwitchPopup.this.layoutInheritedComponents(parent);
            MealPlanSwitchPopup.this.mealPlanToSwitch.setLocation(MealPlanSwitchPopup.this.border, MealPlanSwitchPopup.this.border);
            MealPlanSwitchPopup.this.mealPlanToSwitch.setSize(parent.getWidth() - 2 * MealPlanSwitchPopup.this.border, (int)MealPlanSwitchPopup.this.mealPlanToSwitch.getPreferredSize().getHeight());
            MealPlanSwitchPopup.this.newMealPlan.setLocation(MealPlanSwitchPopup.this.border, MealPlanSwitchPopup.this.mealPlanToSwitch.getY() + MealPlanSwitchPopup.this.mealPlanToSwitch.getHeight() + MealPlanSwitchPopup.this.border);
            MealPlanSwitchPopup.this.newMealPlan.setSize(parent.getWidth() - 2 * MealPlanSwitchPopup.this.border, (int)MealPlanSwitchPopup.this.newMealPlan.getPreferredSize().getHeight());
            MealPlanSwitchPopup.this.sep1.setLocation(0, MealPlanSwitchPopup.this.newMealPlan.getY() + MealPlanSwitchPopup.this.newMealPlan.getHeight() + MealPlanSwitchPopup.this.border / 2);
            MealPlanSwitchPopup.this.sep1.setSize(parent.getWidth(), (int)MealPlanSwitchPopup.this.sep1.getPreferredSize().getHeight());
            MealPlanSwitchPopup.this.legMapping.setLocation(MealPlanSwitchPopup.this.border, MealPlanSwitchPopup.this.sep1.getY() + MealPlanSwitchPopup.this.sep1.getHeight() + MealPlanSwitchPopup.this.border / 2);
            MealPlanSwitchPopup.this.legMapping.setSize(parent.getWidth() - 2 * MealPlanSwitchPopup.this.border, (int)MealPlanSwitchPopup.this.legMapping.getPreferredSize().getHeight());
            MealPlanSwitchPopup.this.serviceMapping.setLocation(MealPlanSwitchPopup.this.border, MealPlanSwitchPopup.this.legMapping.getY() + MealPlanSwitchPopup.this.legMapping.getHeight() + MealPlanSwitchPopup.this.border);
            MealPlanSwitchPopup.this.serviceMapping.setSize(parent.getWidth() - 2 * MealPlanSwitchPopup.this.border, (int)((double)parent.getHeight() - ((double)(MealPlanSwitchPopup.this.serviceMapping.getY() + MealPlanSwitchPopup.this.border) + MealPlanSwitchPopup.this.validateButton.getPreferredSize().getHeight() + (double)MealPlanSwitchPopup.this.border)));
            MealPlanSwitchPopup.this.validateButton.setLocation(MealPlanSwitchPopup.this.border, MealPlanSwitchPopup.this.serviceMapping.getY() + MealPlanSwitchPopup.this.serviceMapping.getHeight() + MealPlanSwitchPopup.this.border);
            MealPlanSwitchPopup.this.validateButton.setSize(MealPlanSwitchPopup.this.validateButton.getPreferredSize());
        }
    }
}

