/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.ContactLocationConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.SingleArticleCategoryConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.supplier.SupplierModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.supplier.details.CommentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.supplier.details.ContactDetailsPanel;
import ch.icit.pegasus.client.gui.modules.supplier.details.ContactsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.supplier.details.OrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.supplier.details.PaymentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.supplier.details.SpecDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.SupplierSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SupplierAccess;
import ch.icit.pegasus.server.core.dtos.search.SupplierSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SupplierModule
extends ScreenTableView<SupplierLight, SupplierSearchConfiguration.SUPPLIER_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "number_filter";
    private static final String FILTER_LOCATION = "location_filter";
    private static final String FILTER_PRODUCT_GROUP = "product_group_filter";
    private static final String FITLER_KNOWN_SUPPLIER = "known_supplier";
    private boolean allLoaded = false;
    private String searchCriteria1 = null;
    private String searchCriteria2 = null;
    private ArticleCategoryLight searchCriteria3 = null;
    private Boolean knownSupplier = null;
    private ComboBox locations;
    private ComboBox productGroups;

    public SupplierModule() {
        super(SupplierLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.locations.kill();
        this.productGroups.kill();
        this.locations = null;
        this.productGroups = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return SupplierAccess.MODULE_SUPPLIER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", SupplierSearchConfiguration.SUPPLIER_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.locations = new ComboBox();
        this.productGroups = new ComboBox();
        this.locations.addItem(Words.ALL);
        this.filterChain.addSearchField(FILTER_NAME, Words.NUMBER_OR_NAME, "");
        SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (!Boolean.TRUE.equals(settingsComplete.getCompany().getSolarCompanyType())) {
            this.filterChain.addSelectionComboBox(this.locations, FILTER_LOCATION, Words.COUNTRY, Words.ALL);
            this.filterChain.addSelectionComboBox(this.productGroups, FILTER_PRODUCT_GROUP, Words.ARTICLE_CATEGORY, Words.ALL);
            ComboBox knownSupplierCombo = ComboBoxFactory.getYesNoComboBox(true);
            this.filterChain.addSelectionComboBox(knownSupplierCombo, FITLER_KNOWN_SUPPLIER, Words.KNOWN_SUPPLIER, Words.AL);
        } else {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addResetButton();
    }

    protected void fillComboBox(Node<?> node) {
        Node<?> n = node;
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node sup = (Node)it.next();
            String v = ((SupplierLight)sup.getValue()).getHeadQuarters().getCountry();
            boolean found = false;
            for (int i = 0; i < this.locations.getItemCount(); ++i) {
                String t = (String)this.locations.getItemAt(i);
                if (!t.toLowerCase().equals(v.toLowerCase())) continue;
                found = true;
            }
            if (found || v.equals("")) continue;
            this.locations.addItem(v);
        }
        this.productGroups.setViewConverter(ConverterRegistry.getConverter(SingleArticleCategoryConverter.class));
        this.productGroups.refreshPossibleValues(NodeToolkit.getAffixList(ArticleCategoryComplete.class));
        this.productGroups.addItem(Words.ALL);
        this.productGroups.setSelectedItem(Words.ALL);
    }

    @Override
    public ASearchConfiguration<SupplierLight, SupplierSearchConfiguration.SUPPLIER_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria3 = null;
            this.knownSupplier = null;
        } else if (name == FILTER_NAME) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_LOCATION) {
            this.searchCriteria2 = (String)value;
            if (Words.ALL.equals(this.searchCriteria2)) {
                this.searchCriteria2 = null;
            }
        } else if (name == FILTER_PRODUCT_GROUP) {
            this.searchCriteria3 = value instanceof Node ? (ArticleCategoryLight)((Node)value).getValue() : null;
        } else if (name == FITLER_KNOWN_SUPPLIER) {
            this.knownSupplier = Words.ALL.equals(value) ? null : (Words.YES.equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        SupplierSearchConfiguration c = new SupplierSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setArticleCategory((ArticleCategoryReference)this.searchCriteria3);
        c.setCountry(this.searchCriteria2);
        c.setKnownSupplier(this.knownSupplier);
        String v = this.searchCriteria1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                c.setNumber(a);
                c.setName(null);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(v);
            }
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (!this.allLoaded) {
            this.fillComboBox(node);
            this.allLoaded = true;
        }
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<SupplierLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(SupplierSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<SupplierLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<SupplierLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<SupplierLight> rowEditor = new MessageProvidedRowEditor<SupplierLight>(model, "Continue anyway?");
            rowEditor.orderErrors(true);
            RDProvider p = this.createProvider(model.isAddRow());
            SpecDetailsPanel d1 = new SpecDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            PaymentDetailsPanel d2 = new PaymentDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            OrderDetailsPanel d22 = new OrderDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            ContactsDetailsPanel d3 = new ContactsDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            ContactDetailsPanel d4 = new ContactDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            CommentDetailsPanel d5 = new CommentDetailsPanel((RowEditor<SupplierLight>)rowEditor, p);
            d3.getTable().setDetailsFocusView(d4);
            d3.getTable().getModel().addTableSelectionListener(d4);
            CombinedDetailsParagraph ccdp = new CombinedDetailsParagraph();
            ccdp.add((Component)d1, new TableLayoutConstraint(0, 0, 0.0, 1.0));
            ccdp.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            ccdp.add((Component)d22, new TableLayoutConstraint(2, 0, 0.5, 1.0));
            CombinedDetailsParagraph ccdp2 = new CombinedDetailsParagraph();
            ccdp2.add((Component)d3, new TableLayoutConstraint(0, 0, 0.0, 1.0));
            ccdp2.add((Component)d4, new TableLayoutConstraint(1, 0, 1.0, 1.0));
            rowEditor.add(ccdp, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.add(ccdp2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.add(d5, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d22);
            rowEditor.addToFocusQueue(d3);
            rowEditor.addToFocusQueue(d4);
            rowEditor.addToFocusQueue(d5);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new SupplierModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        info.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)SupplierSearchConfiguration.SUPPLIER_COLUMN.NUMBER, SupplierLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        if (!Boolean.TRUE.equals(settingsComplete.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.KNOWN_SUPPLIER, "", (Class)BooleanConverter.class, (Enum<?>)SupplierSearchConfiguration.SUPPLIER_COLUMN.KNOWN_SUPPLIER, SupplierLight_.knownSupplier, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
            info.add(new TableColumnInfo(Words.CUSTOMS_RELEVANT, "", BooleanConverter.class, null, SupplierLight_.customsRelevant, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        }
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)SupplierSearchConfiguration.SUPPLIER_COLUMN.NAME, SupplierLight_.name, 100, Integer.MAX_VALUE, 100));
        if (!Boolean.TRUE.equals(settingsComplete.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.COUNTRY, "", (Class)ContactLocationConverter.class, (Enum<?>)SupplierSearchConfiguration.SUPPLIER_COLUMN.COUNTRY, SupplierLight_.headQuarters, 100, Integer.MAX_VALUE, 100));
        }
        return info;
    }
}

