/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalutationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SupplierCertificationTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.VendorTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.supply.OrderTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierDeliveryCostTypeE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.util.List;

public class SupplierModuleDataHandler
extends DefaultDataHandler<SupplierReference, SupplierComplete> {
    public SupplierModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<SupplierReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(SupplierComplete.class);
                SupplierComplete dto = (SupplierComplete)node.getValue(SupplierComplete.class);
                SupplierComplete nDto = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateSupplier((SupplierLight)dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<SupplierComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(SupplierComplete.class);
                SupplierComplete dto = (SupplierComplete)node.getValue(SupplierComplete.class);
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                SupplierComplete nDto = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createSupplier(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SupplierModuleDataHandler.this.setCurrentLoadMaximum(13);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SalutationComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderTypeComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SupplierCertificationTypeComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderDeliveryWindowComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(VendorTypeComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSupplierDeliveryCostTypes();
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                SupplierModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HolidayPlanTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SupplierModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SupplierComplete> resetData(Node<SupplierComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, "Refresh Supplier");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SupplierLight sup = (SupplierLight)node.getValue(SupplierLight.class);
                SupplierComplete d = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier((SupplierReference)sup).getValue();
                if (d.getBillingContact() != null && !d.getContacts().contains(d.getBillingContact())) {
                    d.getContacts().add(d.getBillingContact());
                }
                if (d.getHeadQuarters() != null && !d.getContacts().contains(d.getHeadQuarters())) {
                    d.getContacts().add(d.getHeadQuarters());
                }
                if (d.getOrderContact() != null && !d.getContacts().contains(d.getOrderContact())) {
                    d.getContacts().add(d.getOrderContact());
                }
                node.removeExistingValues();
                node.setValue((Object)d, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<SupplierComplete> createEmptyNode() {
        SupplierComplete newSupplier = new SupplierComplete();
        newSupplier.setClientOId(Long.valueOf(ADTO.getNextId()));
        newSupplier.setDeliverDutyFree(Boolean.valueOf(false));
        newSupplier.setCostType(SupplierDeliveryCostTypeE.NONE);
        newSupplier.setOverrideApprovalTime(Boolean.valueOf(false));
        newSupplier.setIgnoreApprovalProcess(Boolean.valueOf(false));
        newSupplier.setApprovalTime(DateUtil.getSQLTime((int)18, (int)0, (int)0));
        ContactComplete hq = new ContactComplete();
        newSupplier.setHeadQuarters(hq);
        hq.setCity("");
        hq.setCountry("");
        hq.setEmail("");
        hq.setFax("");
        hq.setFirstName("Headquarters");
        hq.setFunction("Main");
        hq.setLastName("");
        hq.setMobile("");
        hq.setProvince("");
        hq.setSitaCode("");
        hq.setStation("");
        hq.setStreet("");
        hq.setStreetNumber("");
        hq.setTel("");
        hq.setTitle("");
        hq.setZipCode("");
        if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (settings != null) {
                newSupplier.setPaymentCurrency(settings.getCurrency());
            }
            if (CompanyUtil.isLSGFC((SystemSettingsComplete)settings)) {
                for (VendorTypeComplete vendorTypeComplete : (List)NodeToolkit.getAffixList(VendorTypeComplete.class).getValue()) {
                    if (!vendorTypeComplete.getCode().equals("Only PO")) continue;
                    newSupplier.setVendorType(vendorTypeComplete);
                }
            }
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newSupplier, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<SupplierComplete> getCommittingClass() {
        return SupplierComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<SupplierReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

