/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CommentDetailsPanel
extends DefaultDetailsPanel<SupplierLight> {
    private static final long serialVersionUID = 1L;
    private RDTextArea textArea;

    public CommentDetailsPanel(RowEditor<SupplierLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.COMMENT);
        this.setCustomLayouter(new Layout());
        this.textArea = new RDTextArea(provider);
        this.addToView(this.textArea);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.textArea.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.textArea.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.textArea.kill();
        this.textArea = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.textArea);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.textArea.setNode(node.getChildNamed(SupplierComplete_.comment));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 150);
        }

        @Override
        public void layoutContainer(Container parent) {
            CommentDetailsPanel.this.textArea.setLocation(CommentDetailsPanel.this.horizontalBorder, CommentDetailsPanel.this.verticalBorder);
            CommentDetailsPanel.this.textArea.setSize(parent.getWidth() - 2 * CommentDetailsPanel.this.horizontalBorder, parent.getHeight() - 2 * CommentDetailsPanel.this.verticalBorder);
        }
    }
}

