/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.template.purchaseorder.details;

import ch.icit.pegasus.client.comparators.DefaultIntegerTableRowComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.template.purchaseorder.details.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplatePositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class OrderPositionDetailsPanel<T extends IDTO>
extends TableDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private SupplierLight supplier;
    private ConfigurationDetailsPanel confPanel;

    public OrderPositionDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.POSITIONS);
    }

    public boolean isDeletable() {
        return this.provider.isDeletable(PurchaseOrderTemplateComplete_.positions);
    }

    public boolean canBeOrdered() {
        return this.provider.isOrderChangable(PurchaseOrderTemplateComplete_.positions);
    }

    public boolean allUnitsAllowed() {
        return false;
    }

    public abstract boolean isWithoutAmount();

    public abstract boolean isWithPosition();

    public void setConfigurationPanel(ConfigurationDetailsPanel panel) {
        this.confPanel = panel;
    }

    public void cleanTable() {
        Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.table.getModel().getNode().removeChild(n, System.currentTimeMillis());
        }
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public void enableAdd(SupplierLight supplier) {
        this.supplier = supplier;
        this.table.setUseAddButton(true);
        this.table.setEnabled(this.table.isEnabled());
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 30, 30, 30));
        if (this.isWithoutAmount()) {
            int th = 2 * this.table.getCellPadding() + InputComboBox.getPreferredWidth(this.table, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            columns.add(new TableColumnInfo(Words.QTY, null, null, null, "", th, th, th));
        }
        if (this.isWithPosition()) {
            columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 300, 300, 300));
        }
        int tw = 3 * this.table.getCellPadding() + 1 * this.table.getInnerCellPadding() + 3 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        int i = 2;
        if (this.isWithoutAmount()) {
            ((TableColumnInfo)columns.get(i)).setxExpand(0.0);
            ++i;
        }
        if (this.isWithPosition()) {
            ((TableColumnInfo)columns.get(i)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(++i)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(i)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setComparator(ComparatorRegistry.getComparator(DefaultIntegerTableRowComparator.class));
        table.setRequestFocusOnAdd(true);
        table.setUseAddButton(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        if (!this.isWithPosition() && this.confPanel != null && !this.confPanel.isSupplierSet()) {
            InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please select a Supplier first")}), null, (Component)source);
            return;
        }
        this.buttonPressed();
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber(OrderTemplatePositionComplete_.sequence, 0);
        this.table.updateOrder();
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model, this.canBeOrdered(), this.isDeletable());
        p.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (node.getChildNamed(PurchaseOrderTemplateComplete_.supplier) != null) {
            this.supplier = (SupplierLight)node.getChildNamed(PurchaseOrderTemplateComplete_.supplier).getValue();
        }
        this.table.getModel().setNode(node.getChildNamed(OrderTemplateComplete_.positions));
    }

    protected void buttonPressed() {
        OrderTemplatePositionComplete p = new OrderTemplatePositionComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setSequence(Integer.valueOf(this.table.getRowCount()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                List<ScreenValidationObject> a = pp.validateRow();
                validationObjects.addAll(a);
            }
        }
        return validationObjects;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private InputComboBox amount;
        private ArticleProductInfoButton infoButton;
        private RDSearchTextField2 article;
        private StorePositionSearchBox storeSearch;

        public TableRowImpl(Table2RowModel m, boolean canBeSorted, boolean isDeletable) {
            super(m, canBeSorted, isDeletable);
            this.setLayout(new InnerLayout());
            this.setSortAttributeName(OrderTemplatePositionComplete_.sequence);
            this.setStartEndOffset(0, 1);
            this.no = new TextLabel(m.getNode().getChildNamed(OrderTemplatePositionComplete_.sequence), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            this.article = new RDSearchTextField2(OrderPositionDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.ARTICLE);
            this.article.setNode(m.getNode().getChildNamed(OrderTemplatePositionComplete_.article));
            this.article.addSearchTextFieldListener(this);
            if (OrderPositionDetailsPanel.this.isWithoutAmount()) {
                OrderTemplatePositionComplete p = (OrderTemplatePositionComplete)m.getNode().getValue();
                if (p.getAmount() == null) {
                    p.setAmount(new StoreQuantityComplete());
                }
                this.amount = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
                this.add(this.amount);
            }
            int i = 20735;
            if (!OrderPositionDetailsPanel.this.isWithPosition()) {
                i *= 196707;
            }
            this.infoButton = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(OrderTemplatePositionComplete_.article), (Node<Date>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false), i);
            if (OrderPositionDetailsPanel.this.supplier != null) {
                Object[] o = new Object[]{OrderPositionDetailsPanel.this.supplier};
                this.article.setAdditionalSearchField(o);
            }
            if (OrderPositionDetailsPanel.this.isWithPosition()) {
                this.storeSearch = new StorePositionSearchBox(true, OrderPositionDetailsPanel.this.provider);
                this.storeSearch.setOverrideName(OrderTemplatePositionComplete_.receivingStorePosition.getFieldName());
                this.storeSearch.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(OrderTemplatePositionComplete_.receivingStorePosition));
                this.add(this.storeSearch);
            }
            if (OrderPositionDetailsPanel.this.isWithoutAmount()) {
                this.updateBasicArticle();
            }
            this.add(this.no);
            this.add(this.article);
            this.add(this.infoButton);
        }

        private void updateSelectableUnits() {
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(OrderTemplatePositionComplete_.article).getValue(BasicArticleComplete.class);
            if (artC != null) {
                if (this.model.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.amount}).getValue() == null) {
                    this.model.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.amount}).setValue((Object)0, 0L);
                }
                if (this.model.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.unit}).getValue() == null) {
                    this.model.getNode().getChildNamed(new DtoField[]{OrderTemplatePositionComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)artC.getMainStoreUnit(), 0L);
                }
                List list = UnitConversionToolkit.getPossibleUnits((BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()), (boolean)OrderPositionDetailsPanel.this.allUnitsAllowed(), (SystemSettingsComplete)OrderPositionDetailsPanel.this.settings);
                this.amount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
            }
            this.setEnabled(this.isEnabled());
            OrderPositionDetailsPanel.this.fireFocusCycleChanged(this);
        }

        private void updateBasicArticle() {
            BasicArticleLight artL = (BasicArticleLight)this.model.getNode().getChildNamed(OrderTemplatePositionComplete_.article).getValue(BasicArticleLight.class);
            if (artL != null) {
                if (this.model.getNode().getChildNamed(OrderTemplatePositionComplete_.article).getValue(BasicArticleComplete.class) == null) {
                    new BasicArticleLoader((BasicArticleReference)artL, new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (OrderPositionDetailsPanel.this.isWithoutAmount()) {
                                TableRowImpl.this.updateSelectableUnits();
                            }
                            TableRowImpl.this.setEnabled(TableRowImpl.this.isEnabled());
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TableRowImpl.this);
                        }
                    }, this.model.getNode().getChildNamed(OrderTemplatePositionComplete_.article), this);
                } else {
                    if (OrderPositionDetailsPanel.this.isWithoutAmount()) {
                        this.updateSelectableUnits();
                    }
                    this.setEnabled(this.isEnabled());
                }
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            this.article.requestFocusInWindowNow();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.article.setEnabled(isEnabled);
            boolean articleSelected = isEnabled && this.article.isItemSelected();
            this.no.setEnabled(isEnabled);
            if (this.amount != null) {
                this.amount.setEnabled(articleSelected);
            }
            if (this.storeSearch != null) {
                this.storeSearch.setEnabled(articleSelected);
            }
            this.infoButton.setEnabled(articleSelected);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> b;
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.article);
            CheckedListAdder.addToList(focusList, this.amount);
            if (this.storeSearch != null) {
                focusList.addAll(this.storeSearch.getFocusComponents());
            }
            if ((b = super.getFocusComponents()) != null) {
                focusList.addAll(b);
            }
            return focusList;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.article.kill();
            this.infoButton.kill();
            if (this.amount != null) {
                this.amount.kill();
            }
            this.no = null;
            this.article = null;
            this.infoButton = null;
            this.amount = null;
            if (this.storeSearch != null) {
                this.storeSearch.kill();
            }
            this.storeSearch = null;
        }

        @Override
        public Object getSortableObject() {
            return super.getSortableObject();
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.article.getNode().getValue() == null || this.article.getNode().getValue().equals("")) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ARTICLE_IS_SET));
            }
            if (this.storeSearch != null && this.storeSearch.getNode().getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STORE_IS_SET));
            }
            return validationObjects;
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            this.updateBasicArticle();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = 0;
                int currentX = 0;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                int i = 2;
                if (TableRowImpl.this.amount != null) {
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(i);
                    TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                    currentX += w;
                    ++i;
                }
                if (TableRowImpl.this.storeSearch != null) {
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(i);
                    ++i;
                    TableRowImpl.this.storeSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storeSearch.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.storeSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storeSearch.getPreferredSize().getHeight());
                    currentX += w;
                }
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

