/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.ImportDetailsPanel;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.ImportedInvoicesDetailsPanel;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.ResolveDetailsPanel;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.TWMSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ThreeWayMatchAccess;
import ch.icit.pegasus.server.core.dtos.search.ThreeWayMatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ThreeWayMatchModule
extends ScreenTableView<ThreeWayMatchLight, ThreeWayMatchSearchConfiguration.TWM_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_SEARCH_FIELD = "name or number";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_PERIOD = "period";
    private String searchCriteria1 = null;
    private TWMModificationStateE searchCriteria2 = null;
    private PeriodComplete searchCriteria3 = null;
    private TitledPeriodEditor periodChooser;

    public ThreeWayMatchModule() {
        super(ThreeWayMatchLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodChooser.kill();
        this.periodChooser = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ThreeWayMatchAccess.MODULE_THREE_WAY_MATCH;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ThreeWayMatchSearchConfiguration.TWM_COLUMN.NO.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_SEARCH_FIELD, Words.NUMBER_OR_NAME, "");
        ComboBox states = ComboBoxFactory.getThreeWayMatchStateComboBox(true);
        this.filterChain.addSelectionComboBox(states, 100, FILTER_STATE, Words.STATE, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodChooser.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<ThreeWayMatchLight, ThreeWayMatchSearchConfiguration.TWM_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria3 = null;
        } else if (name == FILTER_SEARCH_FIELD) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_STATE) {
            if (value == null || value instanceof String) {
                this.searchCriteria2 = null;
            } else if (value instanceof TWMModificationStateE) {
                this.searchCriteria2 = (TWMModificationStateE)value;
            }
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria3 = per;
        }
        ThreeWayMatchSearchConfiguration c = new ThreeWayMatchSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        if (this.searchCriteria1 != null) {
            try {
                int no = Integer.valueOf(this.searchCriteria1);
                c.setNumber(Integer.valueOf(no));
                c.setName(null);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(this.searchCriteria1);
            }
        }
        c.setState(this.searchCriteria2);
        c.setPeriod(this.searchCriteria3);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<ThreeWayMatchLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(TWMSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<ThreeWayMatchLight> model) {
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<ThreeWayMatchLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<ThreeWayMatchLight> rowEditor = new MessageProvidedRowEditor<ThreeWayMatchLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<ThreeWayMatchLight>)rowEditor, p);
            ImportDetailsPanel d2 = new ImportDetailsPanel((RowEditor<ThreeWayMatchLight>)rowEditor, p);
            CombinedDetailsParagraph d3 = new CombinedDetailsParagraph();
            d3.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            d3.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            ImportedInvoicesDetailsPanel d4 = new ImportedInvoicesDetailsPanel((RowEditor<ThreeWayMatchLight>)rowEditor, p);
            ResolveDetailsPanel d5 = new ResolveDetailsPanel((RowEditor<ThreeWayMatchLight>)rowEditor, p);
            d4.getTable().getModel().addTableSelectionListener(d5.getMatchingPanel());
            rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.3));
            rowEditor.add(d4, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.3));
            rowEditor.add(d5, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.4));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d4);
            rowEditor.addToFocusQueue(d5);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ThreeWayMatchModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)ThreeWayMatchSearchConfiguration.TWM_COLUMN.NO, ThreeWayMatchLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo("", "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)ThreeWayMatchSearchConfiguration.TWM_COLUMN.STATE, ThreeWayMatchLight_.state, TableColumnInfo.state3, TableColumnInfo.state3, TableColumnInfo.state3));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)ThreeWayMatchSearchConfiguration.TWM_COLUMN.NAME, ThreeWayMatchLight_.name, 100, Integer.MAX_VALUE, 100));
        info.add(new TableColumnInfo(Words.TWM_PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)ThreeWayMatchSearchConfiguration.TWM_COLUMN.PERIOD, ThreeWayMatchLight_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        info.add(new TableColumnInfo(Words.PURCHASE_BOUNDS, "", (Class)DateConverter.class, (Enum<?>)ThreeWayMatchSearchConfiguration.TWM_COLUMN.PERIOD, DtoFieldConstants.TWM_START_END_BOUNDS, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        return info;
    }
}

