/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch;

import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMOrderComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ThreeWayMatchModuleDataHandler
extends DefaultDataHandler<ThreeWayMatchReference, ThreeWayMatchComplete> {
    public ThreeWayMatchModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<ThreeWayMatchReference> node, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchModuleDataHandler.this.showMessage(l, "Load validation data");
                ThreeWayMatchComplete d = (ThreeWayMatchComplete)node.getValue(ThreeWayMatchComplete.class);
                PeriodComplete p = new PeriodComplete(d.getOrderSearchStartDate(), d.getOrderSearchEndDate());
                d.setOrderSearchStartDate(p.getStartDate());
                d.setOrderSearchEndDate(p.getEndDate());
                ThreeWayMatchToolkit.updateSupplierVolume(d);
                ThreeWayMatchComplete old = (ThreeWayMatchComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).getThreeWayMatchComplete((ThreeWayMatchReference)d).getValue();
                List allOrders = ThreeWayMatchModuleDataHandler.this.getAllAffectedOrders(old);
                ThreeWayMatchModuleDataHandler.this.validateOrderReviewState(d, l, allOrders);
                ThreeWayMatchModuleDataHandler.this.showMessage(l, "Save data");
                ThreeWayMatchComplete dto = (ThreeWayMatchComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).updateThreeWayMatch(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    private List<PurchaseOrderReference> getAllAffectedOrders(ThreeWayMatchComplete match) {
        ArrayList<PurchaseOrderReference> orders = new ArrayList<PurchaseOrderReference>();
        for (TWMSupplierComplete i : match.getSuppliers()) {
            for (TWMEntryComplete e : i.getEntries()) {
                for (TWMOrderComplete o : e.getOrders()) {
                    orders.add(new PurchaseOrderReference(o.getOrder().getId()));
                }
            }
        }
        return orders;
    }

    private void validateOrderReviewState(ThreeWayMatchComplete match, ProgressListener l, List<PurchaseOrderReference> allOldOrders) throws ClientSaveOnServerException {
        this.showMessage(l, "Update Order Review States");
        ArrayList<PurchaseOrderReference> approvedOrders = new ArrayList<PurchaseOrderReference>();
        ArrayList<PurchaseOrderReference> notApprovedOrders = new ArrayList<PurchaseOrderReference>();
        ArrayList<PurchaseOrderReference> noCheckedOrders = new ArrayList<PurchaseOrderReference>();
        for (TWMSupplierComplete i : match.getSuppliers()) {
            for (TWMEntryComplete e : i.getEntries()) {
                boolean isChecked;
                boolean bl = isChecked = i.getState() == TWMSupplierStateE.COMPLETED || e.getInvoice().getAcceptAnyway() != false;
                if (isChecked) {
                    if (e.getInvoice().getState() != TWMInvoiceStateE.ACCEPT) {
                        e.getInvoice().setState(TWMInvoiceStateE.ACCEPT);
                    }
                } else if (e.getInvoice().getState() == TWMInvoiceStateE.ACCEPT) {
                    isChecked = true;
                }
                for (TWMOrderComplete o : e.getOrders()) {
                    if (isChecked) {
                        o.getOrder().setReviewState(OrderReviewStateE.APPROVED);
                        approvedOrders.add(new PurchaseOrderReference(o.getOrder().getId()));
                    } else {
                        o.getOrder().setReviewState(OrderReviewStateE.NOT_APPROVED);
                        notApprovedOrders.add(new PurchaseOrderReference(o.getOrder().getId()));
                    }
                    allOldOrders.remove(o.getOrder());
                }
            }
        }
        noCheckedOrders.addAll(allOldOrders);
        ((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).updateOrderStates(new ListWrapper(approvedOrders), new ListWrapper(notApprovedOrders), new ListWrapper(noCheckedOrders));
    }

    @Override
    public Node<ThreeWayMatchComplete> createEmptyNode() {
        ThreeWayMatchComplete d = new ThreeWayMatchComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        d.setPeriod(p);
        d.setOrderSearchStartDate(new Date(p.getStartDate().getTime()));
        d.setOrderSearchEndDate(new Date(p.getEndDate().getTime()));
        d.setPurchaseStartBounds(new Timestamp(p.getStartDate().getTime()));
        d.setPurchaseEndBounds(new Timestamp(p.getEndDate().getTime()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<ThreeWayMatchComplete> node, final RemoteLoader model, boolean sameNode, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchComplete d = (ThreeWayMatchComplete)node.getValue(ThreeWayMatchComplete.class);
                PeriodComplete p = new PeriodComplete(d.getOrderSearchStartDate(), d.getOrderSearchEndDate());
                d.setOrderSearchStartDate(p.getStartDate());
                d.setOrderSearchEndDate(p.getEndDate());
                PegasusFileComplete r = d.getUploadedFile();
                r.setCategory(FileCategoryE.IMPORT);
                PegasusFileComplete nr = FileTransferUtil.upload((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[0]);
                d.setUploadedFile(nr);
                List allOrders = ThreeWayMatchModuleDataHandler.this.getAllAffectedOrders(d);
                ThreeWayMatchModuleDataHandler.this.validateOrderReviewState(d, l, allOrders);
                ThreeWayMatchModuleDataHandler.this.showMessage(l, Words.SAVE_DATA);
                if (d.getEligibleLocations().isEmpty()) {
                    d.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ThreeWayMatchComplete dto = (ThreeWayMatchComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).createThreeWayMatch(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchModuleDataHandler.this.setCurrentLoadMaximum(10);
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getThreeWayStates();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getOrderStates();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllOrderPricingStates();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllTWMInvoiceStates();
                ThreeWayMatchModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllTWMInvoiceReviewStates();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ThreeWayMatchModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Three Way Match");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchLight twm = (ThreeWayMatchLight)node.getValue(ThreeWayMatchLight.class);
                ThreeWayMatchComplete comp = (ThreeWayMatchComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).getThreeWayMatchComplete(new ThreeWayMatchReference(twm.getId())).getValue();
                if (comp.getOrderSearchStartDate() == null) {
                    comp.setOrderSearchStartDate(comp.getPeriod().getStartDate());
                }
                if (comp.getOrderSearchEndDate() == null) {
                    comp.setOrderSearchEndDate(comp.getPeriod().getEndDate());
                }
                ThreeWayMatchToolkit.updateTWMStates(comp);
                node.removeExistingValues();
                node.setValue((Object)comp, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<ThreeWayMatchComplete> resetData(Node<ThreeWayMatchComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Class<ThreeWayMatchComplete> getCommittingClass() {
        return ThreeWayMatchComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ThreeWayMatchReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

