/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPricingStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.SupplierSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMOrderComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMOrderComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ThreeWayMatchToolkit {
    public static List<TWMSupplierComplete> createSupplierMapping(List<TWMInvoiceImportComplete> invoices, SystemSettingsComplete settings) {
        HashMap<SupplierLight, TWMSupplierComplete> twmSupplierMap = new HashMap<SupplierLight, TWMSupplierComplete>();
        HashMap<String, SupplierLight> supplierMapping = new HashMap<String, SupplierLight>();
        for (TWMInvoiceImportComplete invoice : invoices) {
            SupplierLight supplier = null;
            if (!Boolean.TRUE.equals(settings.getAllowThreeWayMatchOnlyBySapNumber()) && (supplier = (SupplierLight)supplierMapping.get(invoice.getDescription())) == null) {
                supplier = (SupplierLight)supplierMapping.get(invoice.getName());
            }
            if (supplier == null) {
                supplier = (SupplierLight)supplierMapping.get(invoice.getSapSupplier());
            }
            if (supplier == null && (supplier = ThreeWayMatchToolkit.readSupplierByInvoiceReference(invoice.getSapSupplier())) != null) {
                supplierMapping.put(invoice.getSapSupplier(), supplier);
            }
            if (!Boolean.TRUE.equals(settings.getAllowThreeWayMatchOnlyBySapNumber())) {
                if (supplier == null && (supplier = ThreeWayMatchToolkit.readSupplierByName(invoice.getDescription())) != null) {
                    supplierMapping.put(invoice.getDescription(), supplier);
                }
                if (supplier == null && (supplier = ThreeWayMatchToolkit.readSupplierByName(invoice.getName())) != null) {
                    supplierMapping.put(invoice.getName(), supplier);
                }
            }
            if (supplier != null) {
                TWMSupplierComplete twmSupplier = (TWMSupplierComplete)twmSupplierMap.get(supplier);
                if (twmSupplier == null) {
                    twmSupplier = new TWMSupplierComplete();
                    twmSupplier.setSupplier(supplier);
                    twmSupplier.setClientOId(Long.valueOf(ADTO.getNextId()));
                    twmSupplier.setState(TWMSupplierStateE.FAILED);
                    twmSupplierMap.put(supplier, twmSupplier);
                }
                if (invoice.getState() == TWMInvoiceStateE.CANCELLED) continue;
                TWMEntryComplete e = ThreeWayMatchToolkit.createNewTWMEntry(supplier, invoice);
                twmSupplier.addEntry(e);
                invoice.setState(TWMInvoiceStateE.NO_ORDER);
                continue;
            }
            if (invoice.getState() == TWMInvoiceStateE.CANCELLED) continue;
            invoice.setState(TWMInvoiceStateE.NO_SUPPLIER_MATCHED);
        }
        ArrayList<TWMSupplierComplete> r = new ArrayList<TWMSupplierComplete>();
        r.addAll(twmSupplierMap.values());
        return r;
    }

    public static void updateSupplierVolume(ThreeWayMatchComplete match) {
        for (TWMSupplierComplete supplier : match.getSuppliers()) {
            ThreeWayMatchToolkit.updateSupplierVolume(supplier);
        }
    }

    public static void updateSupplierVolume(TWMSupplierComplete supplier) {
        PriceComplete volume = new PriceComplete(supplier.getSupplier().getPaymentCurrency(), Double.valueOf(0.0));
        for (TWMEntryComplete entry : supplier.getEntries()) {
            if (entry.getInvoice().getPrice().getPrice() == null) continue;
            volume.setPrice(Double.valueOf(volume.getPrice() + entry.getInvoice().getPrice().getPrice()));
        }
        supplier.setVolume(volume);
    }

    public static TWMEntryComplete createNewTWMEntry(SupplierLight supplier, TWMInvoiceImportComplete invoice) {
        TWMEntryComplete e = new TWMEntryComplete();
        e.setClientOId(Long.valueOf(ADTO.getNextId()));
        e.setInvoice(invoice);
        e.setDif(new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(0.0)));
        e.setSum(new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(0.0)));
        return e;
    }

    private static SupplierLight readSupplierByInvoiceReference(String sapSupplier) {
        if (sapSupplier == null || sapSupplier.trim().isEmpty()) {
            return null;
        }
        SupplierLight supplier = null;
        SupplierSearchConfiguration ss = new SupplierSearchConfiguration();
        ss.setInvoiceReferenceNumber(sapSupplier);
        ss.setSortColumn((Enum)SupplierSearchConfiguration.SUPPLIER_COLUMN.NUMBER);
        try {
            SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ss);
            if (!result.getResults().isEmpty()) {
                supplier = (SupplierLight)result.getResults().get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supplier;
    }

    private static SupplierLight readSupplierByName(String t) {
        if (t == null || t.trim().isEmpty()) {
            return null;
        }
        SupplierLight supplier = null;
        SupplierSearchConfiguration ss = new SupplierSearchConfiguration();
        ss.setName(t);
        ss.setSortColumn((Enum)SupplierSearchConfiguration.SUPPLIER_COLUMN.NUMBER);
        try {
            SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ss);
            supplier = (SupplierLight)result.getSingleResult();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supplier;
    }

    public static void resolveOrderNumbers(List<TWMSupplierComplete> suppliers, PeriodComplete period) {
        for (TWMSupplierComplete supplier : suppliers) {
            ThreeWayMatchToolkit.processSupplierEntry(supplier, period);
        }
    }

    public static void processSupplierEntry(TWMSupplierComplete supplier, PeriodComplete period) {
        PurchaseOrderSearchConfiguration ps = new PurchaseOrderSearchConfiguration();
        ps.setSortColumn((Enum)PurchaseOrderSearchConfiguration.PURCHASE_ORDER_COLUMN.NUMBER);
        ps.setSupplier(supplier.getSupplier());
        ps.setPeriod(period);
        for (TWMEntryComplete entry : supplier.getEntries()) {
            ThreeWayMatchToolkit.processEntry(entry.getInvoice().getName(), ps, entry);
            ThreeWayMatchToolkit.processEntry(entry.getInvoice().getDescription(), ps, entry);
        }
    }

    private static void processEntry(String code, PurchaseOrderSearchConfiguration ps, TWMEntryComplete entry) {
        String[] splits;
        if (entry.getInvoice().getState() == TWMInvoiceStateE.CANCELLED) {
            return;
        }
        for (String split : splits = code.split(" ")) {
            try {
                int orderNumber = Integer.valueOf(split);
                ps.setNumber(Integer.valueOf(orderNumber));
                SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ps);
                if (result.getResults().isEmpty()) {
                    ps.setNumber(null);
                    ps.setNumResults(Integer.MAX_VALUE);
                    result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ps);
                    String ot = "" + orderNumber;
                    boolean found = false;
                    Iterator it = result.getResults().iterator();
                    while (it.hasNext() && !found) {
                        PurchaseOrderLight o = (PurchaseOrderLight)it.next();
                        String t = "" + o.getNumber();
                        if (!t.endsWith(ot)) continue;
                        ThreeWayMatchToolkit.tryToInsertEntry(entry, o);
                    }
                    continue;
                }
                PurchaseOrderLight order = (PurchaseOrderLight)result.getSingleResult();
                ThreeWayMatchToolkit.tryToInsertEntry(entry, order);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entry.getOrders().isEmpty()) {
            entry.getInvoice().setState(TWMInvoiceStateE.NO_ORDER);
        } else {
            entry.getInvoice().setState(TWMInvoiceStateE.VALUE_DIFFERENCE);
        }
    }

    private static void tryToInsertEntry(TWMEntryComplete entry, PurchaseOrderLight order) {
        boolean alreadyInserted = false;
        for (TWMOrderComplete o : entry.getOrders()) {
            if (!o.getOrder().equals((Object)order)) continue;
            alreadyInserted = true;
        }
        if (!alreadyInserted) {
            TWMOrderComplete oEntry = new TWMOrderComplete();
            oEntry.setClientOId(Long.valueOf(ADTO.getNextId()));
            oEntry.setOrder(order);
            if (order.getRealCost() == null) {
                order.setRealCost(new PriceComplete(order.getSupplier().getPaymentCurrency(), Double.valueOf(0.0)));
            }
            PriceComplete usedPrice = new PriceComplete(order.getRealCost());
            if (order.getRealCost().getPrice() >= entry.getInvoice().getPrice().getPrice()) {
                usedPrice.setPrice(entry.getInvoice().getPrice().getPrice());
            } else {
                usedPrice.setPrice(order.getRealCost().getPrice());
            }
            oEntry.setPrice(usedPrice);
            entry.getOrders().add(oEntry);
        }
    }

    public static void updateImportedInvoiceState(Node<ThreeWayMatchComplete> match, Node<TWMInvoiceImportComplete> invoice, boolean recursive, boolean isSilent, NodeListener listener) {
        Node<TWMSupplierComplete> supplier = ThreeWayMatchToolkit.getSupplier4Invoice(match, invoice);
        if (supplier != null) {
            ThreeWayMatchToolkit.updateTWMSupplier(supplier, recursive, isSilent, listener);
        }
    }

    public static Node<TWMEntryComplete> getEntryForInvoice(Node<TWMSupplierComplete> supplier, Node<TWMInvoiceImportComplete> invoice) {
        Iterator it = supplier.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node e = (Node)it.next();
            if (!((TWMInvoiceImportComplete)e.getChildNamed(TWMEntryComplete_.invoice).getValue()).equals(invoice.getValue())) continue;
            return e;
        }
        return null;
    }

    public static void updateTWMSupplier(Node<TWMSupplierComplete> supplier, boolean recursive, boolean isSilent, NodeListener listener) {
        Iterator it = supplier.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
        boolean foundInvalid = false;
        while (it.hasNext()) {
            Node e = (Node)it.next();
            if (recursive) {
                ThreeWayMatchToolkit.updateTWMEntry((Node<TWMEntryComplete>)e, isSilent, listener);
            }
            if (e.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).getValue() == TWMInvoiceStateE.ACCEPT) continue;
            foundInvalid = true;
        }
        if (isSilent) {
            if (foundInvalid) {
                supplier.getChildNamed(TWMSupplierComplete_.state).setValueSilent((Object)TWMSupplierStateE.FAILED, true, 0L, new NodeListener[]{listener});
            } else {
                supplier.getChildNamed(TWMSupplierComplete_.state).setValueSilent((Object)TWMSupplierStateE.COMPLETED, true, 0L, new NodeListener[]{listener});
            }
        } else if (foundInvalid) {
            supplier.getChildNamed(TWMSupplierComplete_.state).setValue((Object)TWMSupplierStateE.FAILED, 0L);
        } else {
            supplier.getChildNamed(TWMSupplierComplete_.state).setValue((Object)TWMSupplierStateE.COMPLETED, 0L);
        }
    }

    public static void updateTWMEntry(Node<TWMEntryComplete> entry, boolean isSilent, NodeListener listener) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Node invoiceState = entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state});
        TWMInvoiceStateE oldState = (TWMInvoiceStateE)invoiceState.getValue();
        TWMInvoiceStateE newState = null;
        if (oldState == TWMInvoiceStateE.CANCELLED) {
            entry.getChildNamed(TWMEntryComplete_.orders).removeAllChilds();
            if (isSilent) {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.price}).setValueSilent((Object)0.0, false, 0L, new NodeListener[]{listener});
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.price}).setValueSilent((Object)0.0, false, 0L, new NodeListener[]{listener});
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).setValueSilent((Object)false, false, 0L, new NodeListener[]{listener});
            } else {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.price}).setValue((Object)0.0, 0L);
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.price}).setValue((Object)0.0, 0L);
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).setValue((Object)false, 0L);
            }
        } else {
            CurrencyVariantAccessorImpl accessor = new CurrencyVariantAccessorImpl();
            double sum = 0.0;
            Iterator it = entry.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node o = (Node)it.next();
                try {
                    CurrencyComplete targetCur = ((TWMSupplierComplete)o.getParent().getParent().getParent().getParent().getValue()).getVolume().getCurrency();
                    CurrencyComplete currentCur = (CurrencyComplete)o.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).getValue();
                    if (targetCur == null) {
                        targetCur = currentCur;
                    }
                    Object d = o.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).getValue();
                    CurrencyVariantComplete tCv = (CurrencyVariantComplete)accessor.loadData(targetCur, new Timestamp(((TWMOrderComplete)o.getValue()).getOrder().getOrderDate().getTime()));
                    CurrencyVariantComplete cCv = (CurrencyVariantComplete)accessor.loadData(currentCur, new Timestamp(((TWMOrderComplete)o.getValue()).getOrder().getOrderDate().getTime()));
                    if (d == null) continue;
                    Double dd = (Double)d;
                    if (!tCv.getBase().equals((Object)cCv.getBase())) {
                        dd = dd * cCv.getExchangeRate();
                        dd = dd / tCv.getExchangeRate();
                    }
                    sum += dd.doubleValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (isSilent) {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.price}).setValueSilent((Object)sum, false, 0L, new NodeListener[]{listener});
            } else {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.price}).setValue((Object)sum, 0L);
            }
            double dif = ((TWMEntryComplete)entry.getValue()).getInvoice().getPrice().getPrice() - sum;
            if (isSilent) {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.price}).setValueSilent((Object)dif, false, 0L, new NodeListener[]{listener});
            } else {
                entry.getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.price}).setValue((Object)dif, 0L);
            }
            double tresh = (Double)entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.price, PriceComplete_.price}).getValue() * (settings.getOrderReviewSumTreshold() / 100.0);
            Boolean checkAnyway = (Boolean)entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).getValue();
            if (!checkAnyway.booleanValue()) {
                checkAnyway = (Boolean)entry.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).getValue();
            }
            if (checkAnyway.booleanValue() || Math.abs(dif) <= tresh) {
                newState = TWMInvoiceStateE.ACCEPT;
                invoiceState.setValue((Object)TWMInvoiceStateE.ACCEPT, 0L);
                it = entry.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node o = (Node)it.next();
                    o.getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.orderPricingState}).setValue((Object)OrderPricingStateE.CHECKED, 0L);
                }
            } else if (entry.getChildNamed(TWMEntryComplete_.orders).getChildCount() == 0) {
                newState = TWMInvoiceStateE.NO_ORDER;
                invoiceState.setValue((Object)TWMInvoiceStateE.NO_ORDER, 0L);
            } else {
                newState = TWMInvoiceStateE.VALUE_DIFFERENCE;
                invoiceState.setValue((Object)TWMInvoiceStateE.VALUE_DIFFERENCE, 0L);
            }
            if (oldState != newState) {
                ThreeWayMatchToolkit.updateTWMEntry(entry, isSilent, listener);
            }
        }
    }

    public static Node<TWMSupplierComplete> getSupplier4Invoice(Node<ThreeWayMatchComplete> match, Node<TWMInvoiceImportComplete> invoice) {
        Iterator it = match.getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node su = (Node)it.next();
            Iterator it2 = su.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node entry = (Node)it2.next();
                if (!((TWMInvoiceImportComplete)invoice.getValue()).equals(entry.getChildNamed(TWMEntryComplete_.invoice).getValue())) continue;
                return su;
            }
        }
        return null;
    }

    public static Node<TWMSupplierComplete> getSupplier4Supplier(Node<ThreeWayMatchComplete> match, Node<SupplierLight> supplier) {
        Iterator it = match.getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node su = (Node)it.next();
            if (!((SupplierLight)su.getChildNamed(TWMSupplierComplete_.supplier).getValue()).equals(supplier.getValue())) continue;
            return su;
        }
        return null;
    }

    public static PriceComplete getRealCostSum(Node<TWMSupplierComplete> node) {
        Iterator it = node.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
        double p = 0.0;
        HashSet<PurchaseOrderLight> orders = new HashSet<PurchaseOrderLight>();
        CurrencyVariantAccessorImpl accessor = new CurrencyVariantAccessorImpl();
        while (it.hasNext()) {
            Node i = (Node)it.next();
            Iterator it2 = i.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node o = (Node)it2.next();
                if (orders.contains(o.getChildNamed(TWMOrderComplete_.order).getValue())) continue;
                PurchaseOrderLight order = (PurchaseOrderLight)o.getChildNamed(TWMOrderComplete_.order).getValue();
                orders.add(order);
                CurrencyComplete targetCur = ((TWMSupplierComplete)node.getValue()).getVolume().getCurrency();
                CurrencyComplete currentCur = ((TWMSupplierComplete)node.getValue()).getSupplier().getPaymentCurrency();
                if (targetCur == null) {
                    targetCur = currentCur;
                }
                Object d = o.getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.realCost, PriceComplete_.price}).getValue();
                try {
                    CurrencyVariantComplete tCv = (CurrencyVariantComplete)accessor.loadData(targetCur, new Timestamp(order.getOrderDate().getTime()));
                    CurrencyVariantComplete cCv = (CurrencyVariantComplete)accessor.loadData(currentCur, new Timestamp(order.getOrderDate().getTime()));
                    if (d == null) continue;
                    Double dd = (Double)d;
                    if (!tCv.getBase().equals((Object)cCv.getBase())) {
                        dd = dd * cCv.getExchangeRate();
                        dd = dd / tCv.getExchangeRate();
                    }
                    p += dd.doubleValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (node.getValue() != null && ((TWMSupplierComplete)node.getValue()).getVolume() != null) {
            return new PriceComplete(((TWMSupplierComplete)node.getValue()).getVolume().getCurrency(), Double.valueOf(p));
        }
        return new PriceComplete(((PriceComplete)node.getChildNamed(TWMSupplierComplete_.volume).getValue()).getCurrency(), Double.valueOf(p));
    }

    public static PriceComplete getInvoicedSum(Node<TWMSupplierComplete> node) {
        Iterator it = node.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
        double p = 0.0;
        while (it.hasNext()) {
            Node i = (Node)it.next();
            Object o = i.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.price, PriceComplete_.price}).getValue();
            if (o == null) continue;
            p += ((Double)o).doubleValue();
        }
        CurrencyComplete currency = node != null && node.getValue() != null ? (((TWMSupplierComplete)node.getValue()).getVolume() != null ? ((TWMSupplierComplete)node.getValue()).getVolume().getCurrency() : ((TWMSupplierComplete)node.getValue()).getSupplier().getPaymentCurrency()) : ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency();
        return new PriceComplete(currency, Double.valueOf(p));
    }

    public static String getOrderInfoText(Node<ThreeWayMatchComplete> match, Node<PurchaseOrderLight> node) {
        Node<TWMSupplierComplete> supplier = ThreeWayMatchToolkit.getSupplier4Supplier(match, (Node<SupplierLight>)node.getChildNamed(PurchaseOrderLight_.supplier));
        String t = "<b>Order " + ((PurchaseOrderLight)node.getValue(PurchaseOrderLight.class)).getNumber() + "</b>";
        t = t + "<br/>";
        PriceComplete d = ThreeWayMatchToolkit.getRemainingCosts(supplier, (PurchaseOrderLight)node.getValue(PurchaseOrderLight.class));
        PriceConverter2 pc = (PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class);
        t = t + "Remaining Cost: " + pc.convert(d, null, new Object[0]);
        return t;
    }

    private static PriceComplete getRemainingCosts(Node<TWMSupplierComplete> supplier, PurchaseOrderLight value) {
        double rc = value.getRealCost().getPrice();
        double mc = 0.0;
        if (supplier != null && supplier.getChildNamed(TWMSupplierComplete_.entries) != null) {
            Iterator it = supplier.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node e = (Node)it.next();
                Iterator it2 = e.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node o = (Node)it2.next();
                    if (!((TWMOrderComplete)o.getValue()).getOrder().equals((Object)value)) continue;
                    mc += ((Double)o.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).getValue(Double.class)).doubleValue();
                }
            }
        }
        return new PriceComplete(value.getRealCost().getCurrency(), Double.valueOf(rc - mc));
    }

    public static void ensurePurchaseOrderRemainingCost(Node<ThreeWayMatchComplete> match, Node<PurchaseOrderLight> node, boolean isAttached, Component comp) {
        Node rc1 = node.getChildNamed(DtoFieldConstants.remainingCost);
        if (rc1 == null) {
            rc1 = new ViewNode(DtoFieldConstants.remainingCost.getFieldName());
            node.addChild(rc1, 0L);
        }
        Node rc = rc1;
        ThreeWayMatchToolkit.calculateCosts(match, node, isAttached, rc);
    }

    private static void calculateCosts(Node<ThreeWayMatchComplete> match, Node<PurchaseOrderLight> node, boolean isAttached, Node rc) {
        Node<TWMSupplierComplete> supplier = ThreeWayMatchToolkit.getSupplier4Supplier(match, (Node<SupplierLight>)node.getChildNamed(PurchaseOrderLight_.supplier));
        PriceComplete price = null;
        price = isAttached ? ThreeWayMatchToolkit.getRemainingCosts(supplier, (PurchaseOrderLight)node.getValue()) : new PriceComplete(((PurchaseOrderLight)node.getValue()).getRealCost());
        rc.removeExistingValues();
        rc.setValue((Object)price, 0L);
        rc.updateNode();
    }

    public static PeriodComplete createPeriod(Node<ThreeWayMatchComplete> node) {
        Date s = (Date)node.getChildNamed(ThreeWayMatchComplete_.orderSearchStartDate).getValue();
        Date e = (Date)node.getChildNamed(ThreeWayMatchComplete_.orderSearchEndDate).getValue();
        Date us = new Date(s.getTime());
        Date ue = new Date(e.getTime());
        return new PeriodComplete(us, ue);
    }

    public static String getInvoiceText(TWMInvoiceImportComplete value) {
        if (value == null) {
            return "";
        }
        String t = "<b>Invoice " + value.getDocumentNumber() + "</b><br/>";
        t = t + "<ul>";
        DateConverter c = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
        t = t + "<li>Name: " + value.getName() + "</li>";
        t = t + "<li>Description: " + value.getDescription() + "</li>";
        t = t + "<li>Reference: " + value.getReference() + "</li>";
        t = t + "<li>Invoice Date: " + c.convert((Object)value.getDocumentDate(), null, new Object[0]) + "</li>";
        t = t + "<li>" + Words.NET + " Date: " + c.convert((Object)value.getNettoDate(), null, new Object[0]) + "</li>";
        t = t + "<li>Accept Anyway: ";
        if (value.getLog().getUpdateUser() != null) {
            t = t + "by " + value.getLog().getUpdateUser().getUserName();
            t = t + " at " + ((DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class)).convert((Object)value.getLog().getUpdated(), null, new Object[0]);
            t = t + "</li>";
        } else {
            t = t + "Invoice is not accepted anyway</li>";
        }
        t = t + "</ul>";
        return t;
    }

    public static void updateTWMStates(ThreeWayMatchComplete comp) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        double f = settings.getOrderReviewSumTreshold();
        if (f != 0.0) {
            f /= 100.0;
        }
        for (TWMSupplierComplete s : comp.getSuppliers()) {
            boolean supplierApproved = true;
            for (TWMEntryComplete e : s.getEntries()) {
                boolean approved = true;
                double totalCost = 0.0;
                for (TWMOrderComplete o : e.getOrders()) {
                    double upperBound = o.getOrder().getRealCost().getPrice() * (1.0 + f);
                    double lowerBound = o.getOrder().getRealCost().getPrice() * (1.0 - f);
                    if (o.getPrice().getPrice() >= lowerBound && o.getPrice().getPrice() <= upperBound) {
                        o.getOrder().setReviewState(OrderReviewStateE.APPROVED);
                    } else {
                        approved = false;
                    }
                    totalCost += o.getPrice().getPrice().doubleValue();
                }
                double upperBound = e.getInvoice().getPrice().getPrice() * (1.0 + f);
                double lowerBound = e.getInvoice().getPrice().getPrice() * (1.0 - f);
                if (!(totalCost >= lowerBound) || !(totalCost <= upperBound)) {
                    approved = false;
                }
                if (approved) {
                    for (TWMOrderComplete o : e.getOrders()) {
                        o.getOrder().setOrderPricingState(OrderPricingStateE.CHECKED);
                    }
                }
                if (e.getInvoice().getAcceptAnyway().booleanValue() || e.getInvoice().getState() == TWMInvoiceStateE.CANCELLED) continue;
                if (approved) {
                    e.getInvoice().setState(TWMInvoiceStateE.ACCEPT);
                    continue;
                }
                if (e.getOrders().isEmpty()) {
                    e.getInvoice().setState(TWMInvoiceStateE.NO_ORDER);
                } else {
                    e.getInvoice().setState(TWMInvoiceStateE.VALUE_DIFFERENCE);
                }
                supplierApproved = false;
            }
            if (supplierApproved) {
                s.setState(TWMSupplierStateE.COMPLETED);
                continue;
            }
            s.setState(TWMSupplierStateE.FAILED);
        }
    }
}

