/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.utils.ImportInvoiceDataPopupInsert;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDFileChooserPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.BasicLogComplete_;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ThreeWayMatchAccess;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ImportDetailsPanel
extends DefaultDetailsPanel<ThreeWayMatchLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDFileChooserPanel> fileChooser;
    private TextButton importButton;
    private TextButton clearButton;
    private TextButton revalidateStates;
    private TitledItem<TextLabel> creationUser;
    private TitledItem<TextLabel> creationDate;
    private TitledItem<TextLabel> latestUpdateUser;
    private TitledItem<TextLabel> latestUpdateDate;
    private TextLabel importantFileThings;

    public ImportDetailsPanel(RowEditor<ThreeWayMatchLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.getFirstCapitalLetter((String)Words.IMPORT));
        this.setCustomLayouter(new Layout());
        this.fileChooser = new TitledItem<RDFileChooserPanel>(new RDFileChooserPanel(provider, false), Words.getFirstCapitalLetter((String)Words.FILE), TitledItem.TitledItemOrientation.NORTH);
        this.importButton = new TextButton(Words.getFirstCapitalLetter((String)Words.IMPORT));
        this.clearButton = new TextButton(Words.getFirstCapitalLetter((String)Words.CLEAR));
        this.creationUser = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.getFirstCapitalLetter((String)Words.CREATION_USER), TitledItem.TitledItemOrientation.NORTH);
        this.creationDate = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.getFirstCapitalLetter((String)Words.CREATION_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.latestUpdateUser = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.getFirstCapitalLetter((String)Words.LATEST_UPDATE_USER), TitledItem.TitledItemOrientation.NORTH);
        this.latestUpdateDate = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.getFirstCapitalLetter((String)Words.LATEST_UPDATE_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.revalidateStates = new TextButton(Words.REVALIDATE_STATE);
        this.importantFileThings = new TextLabel(Words.ENSURE_IMPORT_FILE_HAS_NO_HEADERS);
        this.importButton.addButtonListener(this);
        this.clearButton.addButtonListener(this);
        this.revalidateStates.addButtonListener(this);
        this.addToView(this.fileChooser);
        this.addToView(this.importButton);
        this.addToView(this.clearButton);
        this.addToView(this.revalidateStates);
        this.addToView(this.creationUser);
        this.addToView(this.creationDate);
        this.addToView(this.latestUpdateUser);
        this.addToView(this.latestUpdateDate);
        this.addToView(this.importantFileThings);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.importButton.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.fileChooser);
        CheckedListAdder.addToList(focusList, this.importButton);
        CheckedListAdder.addToList(focusList, this.clearButton);
        CheckedListAdder.addToList(focusList, this.revalidateStates);
        return focusList;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = isEnabled && this.editor.getModel().isAddRow();
        boolean c = false;
        if (this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state).getValue() != null) {
            boolean bl = c = this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state).getValue() == TWMModificationStateE.DRAFT;
        }
        if (c) {
            c = c && this.provider.isWritable(ThreeWayMatchAccess.CAN_IMPORT);
        }
        this.fileChooser.setEnabled(c);
        this.importButton.setEnabled(c);
        this.clearButton.setEnabled(b);
        this.creationUser.setEnabled(b);
        this.creationDate.setEnabled(b);
        this.importantFileThings.setEnabled(b);
        this.latestUpdateUser.setEnabled(b);
        this.latestUpdateDate.setEnabled(b);
        this.revalidateStates.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.fileChooser.kill();
        this.fileChooser = null;
        this.importButton.kill();
        this.importButton = null;
        this.clearButton.kill();
        this.clearButton = null;
        this.creationUser.kill();
        this.creationUser = null;
        this.creationDate.kill();
        this.creationDate = null;
        this.latestUpdateUser.kill();
        this.latestUpdateUser = null;
        this.latestUpdateDate.kill();
        this.latestUpdateDate = null;
        this.revalidateStates.kill();
        this.revalidateStates = null;
        this.importantFileThings.kill();
        this.importantFileThings = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.fileChooser.getElement().setNode(node.getChildNamed(ThreeWayMatchComplete_.uploadedFile));
        this.creationUser.getElement().setNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.log, BasicLogComplete_.createUser}));
        this.creationDate.getElement().setNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.log, BasicLogComplete_.created}));
        this.latestUpdateUser.getElement().setNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.log, BasicLogComplete_.updateUser}));
        this.latestUpdateDate.getElement().setNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.log, BasicLogComplete_.updated}));
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.importButton) {
            PegasusFileComplete ref;
            if (this.editor.getModel().isAddRow()) {
                this.clearImports();
            }
            if ((ref = (PegasusFileComplete)this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.uploadedFile).getValue()) != null && (ref.getUri() != null || ref.getLocalFile() != null)) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.IMPORT_DATA);
                popUp.enableOKButton(false);
                popUp.enableCancelButton(false);
                popUp.setView(new ImportInvoiceDataPopupInsert((Node<PegasusFileComplete>)this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.uploadedFile), (Node<ThreeWayMatchComplete>)this.editor.getModel().getNode()));
                popUp.showPopUpWithinScreenMiddle(450, 250, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs != null) {
                            // empty if block
                        }
                    }
                }, source, PopupType.NORMAL);
            } else {
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_FILE_SELECTED)}), Words.UNABLE_TO_IMPORT_INVOICE_DATA, (Component)this);
            }
        } else if (source == this.clearButton) {
            this.clearImports();
        } else if (source == this.revalidateStates) {
            this.revalidateItemStates();
        }
    }

    private void revalidateItemStates() {
        this.editor.getModel().getNode().commit(ThreeWayMatchComplete.class);
        ThreeWayMatchComplete twm = (ThreeWayMatchComplete)this.editor.getModel().getNode().getValue(ThreeWayMatchComplete.class);
        ThreeWayMatchToolkit.updateTWMStates(twm);
        this.editor.getModel().getNode().removeExistingValues();
        this.editor.getModel().getNode().setValue((Object)twm, 0L);
        this.editor.getModel().getNode().updateNode();
    }

    private void clearImports() {
        Node n;
        Iterator it = this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.invoices).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.invoices).removeChild(n, 0L);
        }
        it = this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.suppliers).removeChild(n, 0L);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ImportDetailsPanel.this.fileChooser.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.verticalBorder);
            ImportDetailsPanel.this.fileChooser.setSize((int)((double)parent.getWidth() - (ImportDetailsPanel.this.revalidateStates.getPreferredSize().getWidth() + (double)(3 * ImportDetailsPanel.this.horizontalBorder))), (int)ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            ImportDetailsPanel.this.importantFileThings.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.fileChooser.getY() + ImportDetailsPanel.this.fileChooser.getHeight() + ImportDetailsPanel.this.inner_verticalBorder / 2);
            ImportDetailsPanel.this.importantFileThings.setSize(ImportDetailsPanel.this.fileChooser.getWidth(), (int)ImportDetailsPanel.this.importantFileThings.getPreferredSize().getHeight());
            ImportDetailsPanel.this.importButton.setLocation(ImportDetailsPanel.this.fileChooser.getX() + ImportDetailsPanel.this.fileChooser.getWidth() + ImportDetailsPanel.this.horizontalBorder, (int)((double)(ImportDetailsPanel.this.fileChooser.getY() + ImportDetailsPanel.this.fileChooser.getHeight()) - ImportDetailsPanel.this.importButton.getPreferredSize().getHeight()));
            ImportDetailsPanel.this.importButton.setSize(ImportDetailsPanel.this.importButton.getPreferredSize());
            ImportDetailsPanel.this.clearButton.setLocation(ImportDetailsPanel.this.importButton.getX(), ImportDetailsPanel.this.importButton.getY() + ImportDetailsPanel.this.importButton.getHeight() + ImportDetailsPanel.this.inner_verticalBorder);
            ImportDetailsPanel.this.clearButton.setSize(ImportDetailsPanel.this.importButton.getSize());
            ImportDetailsPanel.this.revalidateStates.setLocation(ImportDetailsPanel.this.importButton.getX(), ImportDetailsPanel.this.clearButton.getY() + ImportDetailsPanel.this.clearButton.getHeight() + ImportDetailsPanel.this.verticalBorder * 2);
            ImportDetailsPanel.this.revalidateStates.setSize(ImportDetailsPanel.this.revalidateStates.getPreferredSize());
            int w2tl = (parent.getWidth() - 3 * ImportDetailsPanel.this.horizontalBorder) / 2;
            ImportDetailsPanel.this.creationUser.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.clearButton.getX() + ImportDetailsPanel.this.clearButton.getHeight() + ImportDetailsPanel.this.verticalBorder);
            ImportDetailsPanel.this.creationUser.setSize(w2tl, (int)ImportDetailsPanel.this.creationUser.getPreferredSize().getHeight());
            ImportDetailsPanel.this.creationDate.setLocation(ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.creationUser.getY() + ImportDetailsPanel.this.creationUser.getHeight() + ImportDetailsPanel.this.verticalBorder);
            ImportDetailsPanel.this.creationDate.setSize(w2tl, (int)ImportDetailsPanel.this.creationDate.getPreferredSize().getHeight());
            ImportDetailsPanel.this.latestUpdateUser.setLocation(ImportDetailsPanel.this.creationUser.getX() + ImportDetailsPanel.this.creationUser.getWidth() + ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.creationUser.getY());
            ImportDetailsPanel.this.latestUpdateUser.setSize(w2tl, (int)ImportDetailsPanel.this.latestUpdateUser.getPreferredSize().getHeight());
            ImportDetailsPanel.this.latestUpdateDate.setLocation(ImportDetailsPanel.this.creationDate.getX() + ImportDetailsPanel.this.creationDate.getWidth() + ImportDetailsPanel.this.horizontalBorder, ImportDetailsPanel.this.creationDate.getY());
            ImportDetailsPanel.this.latestUpdateDate.setSize(w2tl, (int)ImportDetailsPanel.this.latestUpdateDate.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            h += ImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.clearButton.getPreferredSize().getHeight());
            h += ImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.creationUser.getPreferredSize().getHeight());
            h += ImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ImportDetailsPanel.this.creationDate.getPreferredSize().getHeight());
            return new Dimension(0, h += ImportDetailsPanel.this.verticalBorder);
        }
    }
}

