/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.InternationalizedDateConverter;
import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.utils.SupplierSwitchingPopupInsert;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorFiveWithCheckRenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ThreeWayMatchAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceReviewStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ImportedInvoicesDetailsPanel
extends DefaultDetailsPanel<ThreeWayMatchLight>
implements SearchTextFieldListener,
NodeListener,
SearchTextField2Listener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> stateFilter;
    private TitledItem<ComboBox> reviewStateFilter;
    private TitledItem<SearchTextField> searchField;
    private TitledPeriodEditor period;
    private TitledItem<SearchTextField2> supplierSearch;
    private TextButton reset;
    private AtomicInteger searchRequestCount;
    private Object currentStateFilter;
    private Object currentReviewStateFilter;
    private String currentSearchString;
    private PeriodComplete currentSearchPeriod;
    private SupplierLight currentSupplier;
    private ViewNode resultNode = new ViewNode("");
    private Table2 table;
    private boolean resetingSearch;

    public ImportedInvoicesDetailsPanel(RowEditor<ThreeWayMatchLight> editor, RDProvider provider) {
        super(editor, provider);
        this.searchRequestCount = new AtomicInteger(0);
        this.setTitleText(Words.IMPORTED_INVOICES);
        this.setCustomLayouter(new Layout());
        this.stateFilter = new TitledItem<ComboBox>(new ComboBox(), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.stateFilter.getElement().addItem(Words.ALL);
        this.stateFilter.getElement().addItem(TWMInvoiceStateE.ACCEPT);
        this.stateFilter.getElement().addItem(TWMInvoiceStateE.NO_ORDER);
        this.stateFilter.getElement().addItem(TWMInvoiceStateE.NO_SUPPLIER_MATCHED);
        this.stateFilter.getElement().addItem(TWMInvoiceStateE.VALUE_DIFFERENCE);
        this.stateFilter.getElement().addItem(TWMInvoiceStateE.CANCELLED);
        this.stateFilter.getElement().addItem(Words.ACCEPTED_ANYWAY);
        this.reviewStateFilter = new TitledItem<ComboBox>(new ComboBox(), Words.REVIEW_STATE, TitledItem.TitledItemOrientation.NORTH);
        this.reviewStateFilter.getElement().addItem(Words.ALL);
        this.reviewStateFilter.getElement().addItem(TWMInvoiceReviewStateE.NONE);
        this.reviewStateFilter.getElement().addItem(TWMInvoiceReviewStateE.CHECKED);
        this.reviewStateFilter.getElement().addItem(TWMInvoiceReviewStateE.UNCHECKED);
        this.searchField = new TitledItem<SearchTextField>(new SearchTextField(), Words.DOC_NAME_ETC, TitledItem.TitledItemOrientation.NORTH);
        PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)n, true, null);
        this.supplierSearch = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, new DTOProxyNode()), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.reset = new TextButton(Words.RESET);
        this.stateFilter.getElement().addItemListener(this);
        this.reviewStateFilter.getElement().addItemListener(this);
        this.reset.addButtonListener(this);
        this.searchField.getElement().addSearchTextFieldListener(this);
        this.period.getStartDateChooser().getNode().addNodeListener((NodeListener)this);
        this.period.getEndDateChooser().getNode().addNodeListener((NodeListener)this);
        this.supplierSearch.getElement().addSearchTextFieldListener(this);
        this.table = new Table2(false, "", false, false);
        this.table.setProvider(provider);
        this.table.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.state5 + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.DOCUMENT_NUMBER, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        tw = TableColumnInfo.dateColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DOCUMENT_DATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.DESCRIPTION, null, null, null, "", 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, null, null, null, "", tw + 13, tw + 13, tw + 13));
        columns.add(new TableColumnInfo(Words.NET + Words.DATE, null, null, null, "", tw + 28, tw + 28, tw + 28));
        columns.add(new TableColumnInfo(Words.REFERENCE, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.SUPPLIER_REF, null, null, null, "", TableColumnInfo.periodColumnWidth + 15, TableColumnInfo.periodColumnWidth + 15, TableColumnInfo.periodColumnWidth + 15));
        columns.add(new TableColumnInfo(Words.CATIT_SUPPLIER, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        tw = 2 * this.table.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.CHANGE_SUPPLIER, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.REVIEW_STATE, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.CANCELED, null, null, null, "", tw, tw, tw));
        tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) * 2;
        columns.add(new TableColumnInfo(Words.ACCEPTED_ANYWAY, null, null, null, "", tw, tw, tw));
        tw = 2 * this.table.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo(Words.DELETE_ITEM, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(10)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(11)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(12)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(13)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(14)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(15)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model, Table2RowPanel.TableControlsType.ONE)));
        this.table.getModel().setNode((Node)this.resultNode);
        this.addToView(this.stateFilter);
        this.addToView(this.reviewStateFilter);
        this.addToView(this.searchField);
        this.addToView(this.period);
        this.addToView(this.supplierSearch);
        this.addToView(this.reset);
        this.addToView(this.table);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.stateFilter.getFocusComponents();
        CheckedListAdder.addToList(a, this.reviewStateFilter);
        CheckedListAdder.addToList(a, this.searchField);
        CheckedListAdder.addToList(a, this.supplierSearch);
        CheckedListAdder.addToList(a, this.period);
        CheckedListAdder.addToList(a, this.reset);
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.stateFilter.setEnabled(isEnabled);
        this.reviewStateFilter.setEnabled(isEnabled);
        this.searchField.setEnabled(isEnabled);
        this.supplierSearch.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.reset.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        if (isEnabled) {
            boolean b = false;
            if (this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state) != null) {
                b = this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state).getValue() == TWMModificationStateE.ACCEPTED;
            }
            this.table.setEditable(!b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.period.getStartDateChooser().getNode().addNodeListener((NodeListener)this);
        this.period.getEndDateChooser().getNode().addNodeListener((NodeListener)this);
        this.stateFilter.kill();
        this.reviewStateFilter.kill();
        this.searchField.kill();
        this.supplierSearch.kill();
        this.period.kill();
        this.reset.kill();
        this.table.kill();
        this.stateFilter = null;
        this.reviewStateFilter = null;
        this.searchField = null;
        this.supplierSearch = null;
        this.period = null;
        this.reset = null;
        this.table = null;
    }

    @Override
    public void setNode(Node<?> node) {
        Date startDate = (Date)node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.startDate}).getValue();
        Date endDate = (Date)node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.endDate}).getValue();
        this.period.getStartDateChooser().getNode().setValue((Object)startDate, 0L);
        this.period.getEndDateChooser().getNode().setValue((Object)endDate, 0L);
        this.resetSearch();
    }

    public Table2 getTable() {
        return this.table;
    }

    private void doSearch() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.invoices).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node in = (Node)it.next();
                    boolean match = true;
                    boolean stringMatch = true;
                    boolean periodMatch = true;
                    boolean stateMatch = true;
                    boolean supplierMatch = true;
                    if (ImportedInvoicesDetailsPanel.this.currentSearchString != null && !ImportedInvoicesDetailsPanel.this.currentSearchString.isEmpty()) {
                        boolean foundS = false;
                        if (((TWMInvoiceImportComplete)in.getValue()).getDocumentNumber() != null && ((TWMInvoiceImportComplete)in.getValue()).getDocumentNumber().contains(ImportedInvoicesDetailsPanel.this.currentSearchString)) {
                            foundS = true;
                        }
                        if (!foundS && ((TWMInvoiceImportComplete)in.getValue()).getName() != null && ((TWMInvoiceImportComplete)in.getValue()).getName().contains(ImportedInvoicesDetailsPanel.this.currentSearchString)) {
                            foundS = true;
                        }
                        if (!foundS && ((TWMInvoiceImportComplete)in.getValue()).getDescription() != null && ((TWMInvoiceImportComplete)in.getValue()).getDescription().contains(ImportedInvoicesDetailsPanel.this.currentSearchString)) {
                            foundS = true;
                        }
                        if (!foundS && ((TWMInvoiceImportComplete)in.getValue()).getReference() != null && ((TWMInvoiceImportComplete)in.getValue()).getReference().contains(ImportedInvoicesDetailsPanel.this.currentSearchString)) {
                            foundS = true;
                        }
                        if (!foundS && ((TWMInvoiceImportComplete)in.getValue()).getSapSupplier() != null && ((TWMInvoiceImportComplete)in.getValue()).getSapSupplier().contains(ImportedInvoicesDetailsPanel.this.currentSearchString)) {
                            foundS = true;
                        }
                        stringMatch = foundS;
                    }
                    if (ImportedInvoicesDetailsPanel.this.currentSearchPeriod != null && ImportedInvoicesDetailsPanel.this.currentSearchPeriod.getStartDate() != null && ImportedInvoicesDetailsPanel.this.currentSearchPeriod.getEndDate() != null) {
                        boolean foundP = false;
                        if (((TWMInvoiceImportComplete)in.getValue()).getCreationDate() == null || ImportedInvoicesDetailsPanel.this.currentSearchPeriod == null || CalendarUtil.isBetween((Date)((TWMInvoiceImportComplete)in.getValue()).getCreationDate(), (PeriodComplete)ImportedInvoicesDetailsPanel.this.currentSearchPeriod)) {
                            foundP = true;
                        }
                        if (((TWMInvoiceImportComplete)in.getValue()).getDocumentDate() == null || ImportedInvoicesDetailsPanel.this.currentSearchPeriod == null || CalendarUtil.isBetween((Date)((TWMInvoiceImportComplete)in.getValue()).getDocumentDate(), (PeriodComplete)ImportedInvoicesDetailsPanel.this.currentSearchPeriod)) {
                            foundP = true;
                        }
                        if (((TWMInvoiceImportComplete)in.getValue()).getNettoDate() == null || ImportedInvoicesDetailsPanel.this.currentSearchPeriod == null || CalendarUtil.isBetween((Date)((TWMInvoiceImportComplete)in.getValue()).getNettoDate(), (PeriodComplete)ImportedInvoicesDetailsPanel.this.currentSearchPeriod)) {
                            foundP = true;
                        }
                        periodMatch = foundP;
                    }
                    if (ImportedInvoicesDetailsPanel.this.currentStateFilter != null) {
                        if (ImportedInvoicesDetailsPanel.this.currentStateFilter instanceof TWMInvoiceStateE) {
                            if (!((TWMInvoiceStateE)in.getChildNamed(TWMInvoiceImportComplete_.state).getValue()).equals(ImportedInvoicesDetailsPanel.this.currentStateFilter)) {
                                stateMatch = false;
                            }
                        } else if (ImportedInvoicesDetailsPanel.this.currentStateFilter instanceof String && ImportedInvoicesDetailsPanel.this.currentStateFilter.equals(Words.ACCEPTED_ANYWAY) && !((Boolean)in.getChildNamed(TWMInvoiceImportComplete_.acceptAnyway).getValue()).booleanValue()) {
                            stateMatch = false;
                        }
                    }
                    if (ImportedInvoicesDetailsPanel.this.currentReviewStateFilter != null && ImportedInvoicesDetailsPanel.this.currentReviewStateFilter instanceof TWMInvoiceReviewStateE && !((TWMInvoiceReviewStateE)in.getChildNamed(TWMInvoiceImportComplete_.reviewState).getValue()).equals(ImportedInvoicesDetailsPanel.this.currentReviewStateFilter)) {
                        stateMatch = false;
                    }
                    if (ImportedInvoicesDetailsPanel.this.currentSupplier != null) {
                        Node<TWMSupplierComplete> s = ThreeWayMatchToolkit.getSupplier4Invoice((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), (Node<TWMInvoiceImportComplete>)in);
                        if (s == null) {
                            supplierMatch = false;
                        } else if (!((TWMSupplierComplete)s.getValue()).getSupplier().equals((Object)ImportedInvoicesDetailsPanel.this.currentSupplier)) {
                            supplierMatch = false;
                        }
                    }
                    boolean bl = match = stateMatch && stringMatch && periodMatch && supplierMatch;
                    if (match) {
                        if (ImportedInvoicesDetailsPanel.this.table.getModel().getNode().contains(in)) continue;
                        ImportedInvoicesDetailsPanel.this.table.getModel().getNode().addChild(in, 0L);
                        continue;
                    }
                    if (!ImportedInvoicesDetailsPanel.this.table.getModel().getNode().contains(in)) continue;
                    ImportedInvoicesDetailsPanel.this.table.getModel().getNode().removeChild(in, 0L);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        int i = ImportedInvoicesDetailsPanel.this.searchRequestCount.decrementAndGet();
                        if (i > 0) {
                            ImportedInvoicesDetailsPanel.this.searchRequestCount.decrementAndGet();
                            ImportedInvoicesDetailsPanel.this.search();
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void search() {
        if (this.resetingSearch) {
            return;
        }
        if (this.searchRequestCount.get() == 0) {
            this.searchRequestCount.incrementAndGet();
            this.doSearch();
        } else if (this.searchRequestCount.get() == 1) {
            this.searchRequestCount.incrementAndGet();
        }
    }

    private void resetSearch() {
        this.currentStateFilter = null;
        this.currentSearchPeriod = null;
        this.currentSearchString = null;
        this.currentSupplier = null;
        this.currentReviewStateFilter = null;
        this.resetingSearch = true;
        this.searchField.getElement().setText("");
        this.supplierSearch.getElement().getNode().setValue(null, 0L);
        this.stateFilter.getElement().setSelectedItem(Words.ALL);
        this.reviewStateFilter.getElement().setSelectedItem(Words.ALL);
        this.resetingSearch = false;
        this.search();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.reset) {
            this.resetSearch();
        }
    }

    @Override
    public void textChanged(String nText, SearchTextField source) {
        this.currentSearchString = nText;
        this.search();
    }

    public void valueChanged(Node<?> node) {
        Date s = (Date)node.getValue();
        Date e = (Date)node.getValue();
        this.currentSearchPeriod = new PeriodComplete(s, e);
        this.search();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
        this.currentSupplier = (SupplierLight)n.getValue();
        this.search();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.stateFilter.getElement()) {
                this.currentStateFilter = e.getItem();
            } else if (e.getSource() == this.reviewStateFilter.getElement()) {
                this.currentReviewStateFilter = e.getItem();
            }
            this.search();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private StateIndicatorFiveWithCheckRenderer<TWMInvoiceStateE> state;
        private TextLabel docNumber;
        private TextLabel docDate;
        private TextLabel name;
        private TextLabel description;
        private TextLabel creationDate;
        private TextLabel nettoDate;
        private TextLabel reference;
        private TextLabel sapReference;
        private TextLabel catitSupplier;
        private QuantityRenderer costs;
        private EditButton editButton;
        private CheckBox cancel;
        private CheckBox acceptAnyway;
        private RemarkButton remark;
        private DeleteButton delete;
        private Node<TWMSupplierComplete> sn;
        private ComboBox reviewState;
        private RemarkButton reviewComment;

        public TableRowImpl(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            this.setSelectable(true);
            this.sn = ThreeWayMatchToolkit.getSupplier4Invoice((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), (Node<TWMInvoiceImportComplete>)m.getNode());
            this.state = new StateIndicatorFiveWithCheckRenderer(m.getNode().getChildNamed(TWMInvoiceImportComplete_.state), (Node<Boolean>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.acceptAnyway));
            this.docNumber = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.documentNumber));
            this.docDate = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.documentDate), ConverterRegistry.getConverter(InternationalizedDateConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.name));
            this.description = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.description));
            this.creationDate = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.creationDate), ConverterRegistry.getConverter(InternationalizedDateConverter.class));
            this.nettoDate = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.nettoDate), ConverterRegistry.getConverter(InternationalizedDateConverter.class));
            this.reference = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.reference));
            this.sapReference = new TextLabel(m.getNode().getChildNamed(TWMInvoiceImportComplete_.sapSupplier), ConverterRegistry.getConverter(StringConverter.class));
            this.catitSupplier = new TextLabel(this.sn != null ? this.sn.getChildNamed(TWMSupplierComplete_.supplier) : null, ConverterRegistry.getConverter(SupplierConverter.class));
            this.catitSupplier.setNodeBased(true);
            this.costs = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.price), (Converter<?, ?>)ConverterRegistry.getConverter(PriceConverter3.class));
            this.editButton = new EditButton();
            this.editButton.addButtonListener(this);
            this.cancel = new CheckBox();
            this.cancel.addButtonListener(this);
            this.acceptAnyway = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.acceptAnyway));
            this.acceptAnyway.addButtonListener(this);
            this.remark = new RemarkButton(true);
            this.remark.setNode((Node<String>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.acceptAnywayRemark));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.reviewState = ComboBoxFactory.getNodeTWMInvoiceReviewStateComboBox((Node<TWMInvoiceReviewStateE>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.reviewState));
            this.reviewComment = new RemarkButton((Node<String>)m.getNode().getChildNamed(TWMInvoiceImportComplete_.reviewComment));
            this.setLayout(new Layout());
            this.add(this.state);
            this.add(this.docNumber);
            this.add(this.docDate);
            this.add(this.name);
            this.add(this.description);
            this.add(this.creationDate);
            this.add(this.nettoDate);
            this.add(this.reference);
            this.add(this.sapReference);
            this.add(this.catitSupplier);
            this.add(this.costs);
            this.add(this.editButton);
            this.add(this.cancel);
            this.add(this.acceptAnyway);
            this.add(this.remark);
            this.add(this.delete);
            this.add(this.reviewComment);
            this.add(this.reviewState);
            if (m.getNode().getChildNamed(TWMInvoiceImportComplete_.state).getValue() == TWMInvoiceStateE.CANCELLED) {
                this.cancel.setChecked(true);
            }
            m.getNode().getChildNamed(TWMInvoiceImportComplete_.state).addNodeListener((NodeListener)this);
            this.setEnabled(this.isEnabled());
        }

        public Node<TWMEntryComplete> getEntryForInvoice(TWMInvoiceImportComplete i) {
            if (this.sn != null) {
                Iterator it = this.sn.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node e = (Node)it.next();
                    if (!((TWMInvoiceImportComplete)e.getChildNamed(TWMEntryComplete_.invoice).getValue()).equals((Object)i)) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.editButton.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.documentNumber).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.documentDate).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.name).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.description).getValue();
                }
                case 5: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.creationDate).getValue();
                }
                case 6: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.nettoDate).getValue();
                }
                case 7: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.reference).getValue();
                }
                case 8: {
                    return this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.sapSupplier).getValue();
                }
                case 9: {
                    return this.catitSupplier.getText();
                }
                case 10: {
                    return this.model.getNode().getChildNamed(new DtoField[]{TWMInvoiceImportComplete_.price, PriceComplete_.price}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean isAccepted = this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).getValue() == TWMInvoiceStateE.ACCEPT;
            boolean isCancelled = this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).getValue() == TWMInvoiceStateE.CANCELLED;
            boolean b = isEnabled && !isAccepted && !isCancelled;
            boolean canCancel = ImportedInvoicesDetailsPanel.this.provider.isWritable(ThreeWayMatchAccess.CANCEL_INVOICE);
            boolean canDelete = ImportedInvoicesDetailsPanel.this.provider.isWritable(ThreeWayMatchAccess.DELETE_INVOICE);
            this.state.setEnabled(b);
            this.docNumber.setEnabled(b);
            this.docDate.setEnabled(b);
            this.name.setEnabled(b);
            this.description.setEnabled(b);
            this.creationDate.setEnabled(b);
            this.nettoDate.setEnabled(b);
            this.reference.setEnabled(b);
            this.sapReference.setEnabled(b);
            this.catitSupplier.setEnabled(b);
            this.costs.setEnabled(b);
            this.editButton.setEnabled(b);
            this.cancel.setEnabled(isEnabled && canCancel);
            this.acceptAnyway.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            this.reviewComment.setEnabled(isEnabled);
            this.reviewState.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled && canDelete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).removeNodeListener((NodeListener)this);
            this.state.kill();
            this.state = null;
            this.docNumber.kill();
            this.docNumber = null;
            this.docDate.kill();
            this.docDate = null;
            this.name.kill();
            this.name = null;
            this.description.kill();
            this.description = null;
            this.creationDate.kill();
            this.creationDate = null;
            this.nettoDate.kill();
            this.nettoDate = null;
            this.reference.kill();
            this.reference = null;
            this.sapReference.kill();
            this.sapReference = null;
            this.catitSupplier.kill();
            this.catitSupplier = null;
            this.costs.kill();
            this.costs = null;
            this.editButton.kill();
            this.editButton = null;
            this.cancel.kill();
            this.cancel = null;
            this.acceptAnyway.kill();
            this.acceptAnyway = null;
            this.remark.kill();
            this.remark = null;
            this.delete.kill();
            this.delete = null;
            this.reviewComment.kill();
            this.reviewComment = null;
            this.reviewState.kill();
            this.reviewState = null;
        }

        private void changeSupplier(Node<SupplierLight> newSupplier) {
            if (this.sn != null) {
                Iterator it = this.sn.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node e = (Node)it.next();
                    if (!((TWMInvoiceImportComplete)e.getChildNamed(TWMEntryComplete_.invoice).getValue()).equals(this.model.getNode().getValue()) || this.sn == null) continue;
                    this.sn.getChildNamed(TWMSupplierComplete_.entries).removeChild(e, 0L);
                    this.sn = null;
                }
            }
            if (newSupplier != null && newSupplier.getValue() != null) {
                this.sn = ThreeWayMatchToolkit.getSupplier4Supplier((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), newSupplier);
                if (this.sn == null) {
                    TWMSupplierComplete twmSupplier = new TWMSupplierComplete();
                    twmSupplier.setClientOId(Long.valueOf(ADTO.getNextId()));
                    twmSupplier.setState(TWMSupplierStateE.FAILED);
                    twmSupplier.setSupplier((SupplierLight)newSupplier.getValue());
                    this.sn = INodeCreator.getDefaultImpl().getNode4DTO((Object)twmSupplier, true, false);
                    ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.suppliers).addChild(this.sn, 0L);
                }
                this.catitSupplier.setNode(this.sn.getChildNamed(TWMSupplierComplete_.supplier));
                TWMEntryComplete e = ThreeWayMatchToolkit.createNewTWMEntry((SupplierLight)this.sn.getChildNamed(TWMSupplierComplete_.supplier).getValue(), (TWMInvoiceImportComplete)this.model.getNode().getValue());
                Node ne = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false);
                this.sn.getChildNamed(TWMSupplierComplete_.entries).addChild(ne, 0L);
            } else {
                this.catitSupplier.setNode((Node)null);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.SWITCH_SUPPLIER);
                popUp.setView(new SupplierSwitchingPopupInsert(this.sn));
                popUp.showPopUp(x, y, 450, 100, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs != null) {
                            Node ns = (Node)xargs[0];
                            if (TableRowImpl.this.sn == null) {
                                TableRowImpl.this.sn = ThreeWayMatchToolkit.getSupplier4Supplier((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), (Node<SupplierLight>)ns);
                            }
                            if (TableRowImpl.this.sn != null && TableRowImpl.this.sn.getValue() != null) {
                                if (ns.getValue() != null && TableRowImpl.this.sn.getValue() != null) {
                                    if (!((SupplierLight)ns.getValue()).equals((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getSupplier())) {
                                        TableRowImpl.this.changeSupplier((Node<SupplierLight>)ns);
                                    } else {
                                        Node<TWMEntryComplete> entry = ThreeWayMatchToolkit.getEntryForInvoice((Node<TWMSupplierComplete>)TableRowImpl.this.sn, (Node<TWMInvoiceImportComplete>)TableRowImpl.this.model.getNode());
                                        if (entry == null) {
                                            TWMEntryComplete newEntry = ThreeWayMatchToolkit.createNewTWMEntry(((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getSupplier(), (TWMInvoiceImportComplete)TableRowImpl.this.model.getNode().getValue());
                                            ((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).addEntry(newEntry);
                                            Node entryNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)newEntry, true, false);
                                            TableRowImpl.this.sn.getChildNamed(TWMSupplierComplete_.entries).addChild(entryNode, 0L);
                                            Node node = TableRowImpl.this.sn;
                                            node.getChildNamed(TWMSupplierComplete_.volume).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume(), 0L);
                                            node.getChildNamed(new DtoField[]{TWMSupplierComplete_.volume, PriceComplete_.price}).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume().getPrice(), 0L);
                                            node.getChildNamed(new DtoField[]{TWMSupplierComplete_.volume, PriceComplete_.currency}).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume().getCurrency(), 0L);
                                        }
                                    }
                                    TableRowImpl.this.catitSupplier.setNode(TableRowImpl.this.sn.getChildNamed(TWMSupplierComplete_.supplier));
                                } else if (ns.getValue() != null || TableRowImpl.this.sn.getValue() != null) {
                                    if (ns.getValue() != null && TableRowImpl.this.sn.getValue() == null) {
                                        TableRowImpl.this.changeSupplier((Node<SupplierLight>)ns);
                                    } else if (ns.getValue() == null && TableRowImpl.this.sn.getValue() != null) {
                                        ThreeWayMatchToolkit.updateSupplierVolume((TWMSupplierComplete)TableRowImpl.this.sn.getValue());
                                        Node node = TableRowImpl.this.sn;
                                        node.getChildNamed(TWMSupplierComplete_.volume).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume(), 0L);
                                        node.getChildNamed(new DtoField[]{TWMSupplierComplete_.volume, PriceComplete_.price}).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume().getPrice(), 0L);
                                        node.getChildNamed(new DtoField[]{TWMSupplierComplete_.volume, PriceComplete_.currency}).setValue((Object)((TWMSupplierComplete)TableRowImpl.this.sn.getValue()).getVolume().getCurrency(), 0L);
                                        TableRowImpl.this.changeSupplier((Node<SupplierLight>)null);
                                    } else {
                                        TableRowImpl.this.catitSupplier.setNode((Node)null);
                                    }
                                }
                            } else {
                                TableRowImpl.this.changeSupplier((Node<SupplierLight>)ns);
                            }
                        }
                    }
                }, source, PopupType.NORMAL);
            } else if (source == this.acceptAnyway) {
                if (this.acceptAnyway.isChecked()) {
                    InnerPopupFactory.showRemarkPopup(source, x, y, this, this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.acceptAnywayRemark));
                } else {
                    this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).setValue((Object)TWMInvoiceStateE.NO_SUPPLIER_MATCHED, 0L);
                    ThreeWayMatchToolkit.updateImportedInvoiceState((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), (Node<TWMInvoiceImportComplete>)this.model.getNode(), true, false, null);
                }
            } else if (source == this.cancel) {
                if (this.cancel.isChecked()) {
                    InnerPopupFactory.showDesicionPopup(Words.CANCEL_CURRENT_SAP_INVOICE, Words.ARE_YOU_SURE_TO_CANCEL_TWM, this, new InnerPopUpListener2(){

                        @Override
                        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                            if (xargs == null) {
                                TableRowImpl.this.cancel.setChecked(false);
                            } else {
                                TableRowImpl.this.cancelCurrentInvoice();
                            }
                        }
                    }, -1, -1);
                } else {
                    PeriodComplete p = new PeriodComplete();
                    p.setStartDate((Date)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.startDate}).getValue());
                    p.setEndDate((Date)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.endDate}).getValue());
                    this.uncancelCurrentInvoice(p);
                }
            } else if (source == this.delete) {
                InnerPopupFactory.showDesicionPopup(Words.REMOVE_CURRENT_SAP_INVOICE, Words.ARE_YOU_SURE_TO_REMOVE_SAP_INVOICE, this, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs != null) {
                            ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.invoices).removeChild(TableRowImpl.this.model.getNode(), 0L);
                            TableRowImpl.this.model.getParentModel().getNode().removeChild(TableRowImpl.this.model.getNode(), 0L);
                            Iterator it = ImportedInvoicesDetailsPanel.this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
                            while (it.hasNext()) {
                                Node n = (Node)it.next();
                                Iterator it2 = n.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
                                while (it2.hasNext()) {
                                    Node nn = (Node)it2.next();
                                    if (!((TWMInvoiceImportComplete)nn.getChildNamed(TWMEntryComplete_.invoice).getValue()).equals(TableRowImpl.this.model.getNode().getValue())) continue;
                                    n.getChildNamed(TWMSupplierComplete_.entries).removeChild(nn, 0L);
                                }
                            }
                        }
                    }
                }, -1, -1);
            }
        }

        private void cancelCurrentInvoice() {
            this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).setValue((Object)TWMInvoiceStateE.CANCELLED, 0L);
            ThreeWayMatchToolkit.updateTWMSupplier(this.sn, true, false, null);
            this.sn.commit();
        }

        public void uncancelCurrentInvoice(PeriodComplete period) {
            this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).setValue((Object)TWMInvoiceStateE.NO_SUPPLIER_MATCHED, 0L);
            if (this.sn != null) {
                ThreeWayMatchToolkit.processSupplierEntry((TWMSupplierComplete)this.sn.getValue(), period);
                this.sn.updateNode();
                ThreeWayMatchToolkit.updateTWMSupplier(this.sn, true, false, null);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... args) {
            if (args != null) {
                this.remark.popUpClosed(source, args);
                this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).setValue((Object)TWMInvoiceStateE.ACCEPT, 0L);
            } else {
                this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.acceptAnyway).setValue((Object)false, 0L);
                this.model.getNode().getChildNamed(TWMInvoiceImportComplete_.state).setValue((Object)TWMInvoiceStateE.NO_SUPPLIER_MATCHED, 0L);
            }
            ThreeWayMatchToolkit.updateImportedInvoiceState((Node<ThreeWayMatchComplete>)ImportedInvoicesDetailsPanel.this.editor.getModel().getNode(), (Node<TWMInvoiceImportComplete>)this.model.getNode(), true, false, null);
        }

        public void valueChanged(Node<?> node) {
            if (node.getName().equals(TWMInvoiceImportComplete_.state.getFieldName())) {
                this.setEnabled(this.isEnabled());
                if (node.getValue() == TWMInvoiceStateE.CANCELLED) {
                    this.cancel.setChecked(true);
                } else {
                    this.cancel.setChecked(false);
                }
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.docNumber.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.docNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.docNumber.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.docNumber.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.docDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.docDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.docDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.docDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.description.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.description.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.description.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.description.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.creationDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.creationDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.creationDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.creationDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.nettoDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.nettoDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.nettoDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.nettoDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.reference.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reference.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reference.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.reference.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.sapReference.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sapReference.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sapReference.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sapReference.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.catitSupplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.catitSupplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.catitSupplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.catitSupplier.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(10);
                TableRowImpl.this.costs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costs.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(11);
                TableRowImpl.this.editButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editButton.setSize(TableRowImpl.this.editButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(12);
                TableRowImpl.this.reviewState.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reviewState.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reviewState.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.reviewComment.getPreferredSize().getWidth())), (int)TableRowImpl.this.reviewState.getPreferredSize().getHeight());
                TableRowImpl.this.reviewComment.setLocation(TableRowImpl.this.reviewState.getX() + TableRowImpl.this.reviewState.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reviewComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reviewComment.setSize(TableRowImpl.this.reviewComment.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(13);
                TableRowImpl.this.cancel.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cancel.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cancel.setSize(TableRowImpl.this.cancel.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(14);
                TableRowImpl.this.acceptAnyway.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.acceptAnyway.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.acceptAnyway.setSize(TableRowImpl.this.acceptAnyway.getPreferredSize());
                TableRowImpl.this.remark.setLocation(TableRowImpl.this.acceptAnyway.getX() + TableRowImpl.this.acceptAnyway.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(TableRowImpl.this.remark.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(15);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ImportedInvoicesDetailsPanel.this.stateFilter.setLocation(ImportedInvoicesDetailsPanel.this.horizontalBorder, ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.stateFilter.setSize(120, (int)ImportedInvoicesDetailsPanel.this.stateFilter.getPreferredSize().getHeight());
            ImportedInvoicesDetailsPanel.this.reviewStateFilter.setLocation(ImportedInvoicesDetailsPanel.this.stateFilter.getX() + ImportedInvoicesDetailsPanel.this.stateFilter.getWidth() + ImportedInvoicesDetailsPanel.this.horizontalBorder, ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.reviewStateFilter.setSize(180, (int)ImportedInvoicesDetailsPanel.this.reviewStateFilter.getPreferredSize().getHeight());
            ImportedInvoicesDetailsPanel.this.searchField.setLocation(ImportedInvoicesDetailsPanel.this.reviewStateFilter.getX() + ImportedInvoicesDetailsPanel.this.reviewStateFilter.getWidth() + ImportedInvoicesDetailsPanel.this.horizontalBorder, ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.searchField.setSize(180, (int)ImportedInvoicesDetailsPanel.this.searchField.getPreferredSize().getHeight());
            ImportedInvoicesDetailsPanel.this.supplierSearch.setLocation(ImportedInvoicesDetailsPanel.this.searchField.getX() + ImportedInvoicesDetailsPanel.this.searchField.getWidth() + ImportedInvoicesDetailsPanel.this.horizontalBorder, ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.supplierSearch.setSize(180, (int)ImportedInvoicesDetailsPanel.this.supplierSearch.getPreferredSize().getHeight());
            ImportedInvoicesDetailsPanel.this.period.setLocation(ImportedInvoicesDetailsPanel.this.supplierSearch.getX() + ImportedInvoicesDetailsPanel.this.supplierSearch.getWidth() + ImportedInvoicesDetailsPanel.this.horizontalBorder, ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.period.setSize(ImportedInvoicesDetailsPanel.this.period.getPreferredSize());
            ImportedInvoicesDetailsPanel.this.reset.setLocation(ImportedInvoicesDetailsPanel.this.period.getX() + ImportedInvoicesDetailsPanel.this.period.getWidth() + ImportedInvoicesDetailsPanel.this.horizontalBorder, (int)((double)(ImportedInvoicesDetailsPanel.this.period.getY() + ImportedInvoicesDetailsPanel.this.period.getHeight()) - ImportedInvoicesDetailsPanel.this.reset.getPreferredSize().getHeight()));
            ImportedInvoicesDetailsPanel.this.reset.setSize(ImportedInvoicesDetailsPanel.this.reset.getPreferredSize());
            ImportedInvoicesDetailsPanel.this.table.setLocation(0, ImportedInvoicesDetailsPanel.this.reset.getY() + ImportedInvoicesDetailsPanel.this.reset.getHeight() + ImportedInvoicesDetailsPanel.this.verticalBorder);
            ImportedInvoicesDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - ImportedInvoicesDetailsPanel.this.table.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 350);
        }
    }
}

