/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.ThreeWayMatchStateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ThreeWayMatchAccess;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ThreeWayMatchLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledPeriodEditor period;
    private TitledPeriodEditor orderPeriod;
    private TitledDateTimePeriodChooser purchaseBounds;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDMultiLocationComboBox> locations;

    public SpecificationDetailsPanel(RowEditor<ThreeWayMatchLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), Words.getFirstCapitalLetter((String)Words.NO_NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.getFirstCapitalLetter((String)Words.NAME), TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledPeriodEditor(null, true, provider, ThreeWayMatchComplete_.period);
        this.orderPeriod = new TitledPeriodEditor(null, true, provider, ThreeWayMatchComplete_.orderSearchEndDate);
        this.orderPeriod.setTitleText(Words.ORDER_PERIOD_START, Words.END);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(null, ConverterRegistry.getConverter(ThreeWayMatchStateConverter.class)), Words.getFirstCapitalLetter((String)Words.STATE), TitledItem.TitledItemOrientation.NORTH);
        this.purchaseBounds = new TitledDateTimePeriodChooser(null, null);
        this.purchaseBounds.setTitleText(Words.PURCHASE_BOUNDS_START, Words.END);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.period);
        this.addToView(this.orderPeriod);
        this.addToView(this.state);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.purchaseBounds);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.name.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.orderPeriod);
        CheckedListAdder.addToList(focusList, this.purchaseBounds);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.locations);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && this.name.getElement().getText().trim().isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NAME_MUST_BE_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ONLY_ONE_LOCATION_MUST_BE_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = false;
        if (this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state) != null && this.editor.getModel().getNode().getChildNamed(ThreeWayMatchComplete_.state).getValue() != null) {
            b = this.editor.getModel().getNode().getValue() == TWMModificationStateE.ACCEPTED;
        }
        this.number.setEnabled(isEnabled && !b);
        this.name.setEnabled(isEnabled && !b);
        this.period.setEnabled(isEnabled && !b);
        this.orderPeriod.setEnabled(isEnabled && !b);
        this.purchaseBounds.setEnabled(isEnabled && !b);
        if (b) {
            b = !this.provider.isWritable(ThreeWayMatchAccess.CAN_REDRAFT_ACCEPTED);
        }
        this.state.setEnabled(isEnabled && !b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled && !b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.name.kill();
        this.name = null;
        this.period.kill();
        this.period = null;
        this.orderPeriod.kill();
        this.orderPeriod = null;
        this.purchaseBounds.kill();
        this.purchaseBounds = null;
        this.state.kill();
        this.state = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ThreeWayMatchComplete dto = (ThreeWayMatchComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.number.getElement().setNode(node.getChildNamed(ThreeWayMatchComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(ThreeWayMatchComplete_.name));
        this.period.setStartDateNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.startDate}));
        this.period.setEndDateNode(node.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.endDate}));
        this.orderPeriod.setStartDateNode(node.getChildNamed(ThreeWayMatchComplete_.orderSearchStartDate));
        this.orderPeriod.setEndDateNode(node.getChildNamed(ThreeWayMatchComplete_.orderSearchEndDate));
        this.purchaseBounds.setNode((Node<Timestamp>)node.getChildNamed(ThreeWayMatchComplete_.purchaseStartBounds), (Node<Timestamp>)node.getChildNamed(ThreeWayMatchComplete_.purchaseEndBounds));
        this.state.getElement().setNode(node.getChildNamed(ThreeWayMatchComplete_.state));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TWMModificationStateE.class));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(ThreeWayMatchComplete_.eligibleLocations));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w3tl = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) / 3;
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(w3tl, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.period.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.period.setSize(SpecificationDetailsPanel.this.period.getPreferredSize());
            SpecificationDetailsPanel.this.orderPeriod.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.period.getY() + SpecificationDetailsPanel.this.period.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.orderPeriod.setSize(SpecificationDetailsPanel.this.orderPeriod.getPreferredSize());
            SpecificationDetailsPanel.this.purchaseBounds.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.orderPeriod.getY() + SpecificationDetailsPanel.this.orderPeriod.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.purchaseBounds.setSize(SpecificationDetailsPanel.this.purchaseBounds.getPreferredSize());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.purchaseBounds.getY() + SpecificationDetailsPanel.this.purchaseBounds.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(200, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY());
                SpecificationDetailsPanel.this.locations.setSize(200, (int)SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.orderPeriod.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.purchaseBounds.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

