/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.details.utils;

import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.modules.threewaymatch.importer.SAPImporterLSGFC;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;

public class ImportInvoiceDataPopupInsert
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<PegasusFileComplete> node;
    private boolean errorWhileDownloadFile = false;
    private Node<ThreeWayMatchComplete> match;

    public ImportInvoiceDataPopupInsert(Node<PegasusFileComplete> node, final Node<ThreeWayMatchComplete> match) {
        this.node = node;
        this.match = match;
        this.setLayout(new Layout());
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PeriodComplete p = new PeriodComplete();
                p.setStartDate((Date)match.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.startDate}).getValue());
                p.setEndDate((Date)match.getChildNamed(new DtoField[]{ThreeWayMatchComplete_.period, PeriodComplete_.endDate}).getValue());
                ImportInvoiceDataPopupInsert.this.processData(p);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ImportInvoiceDataPopupInsert.this.processFinished(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        ImportInvoiceDataPopupInsert.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFinished(Node<?> node) {
        this.popup.hidePopUp(new Object[0]);
        if (node == null) {
            InnerPopupFactory.showMessageDialog("File successfully imported", this);
        } else if (node.getValue() instanceof ScreenValidationObject) {
            InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{(ScreenValidationObject)node.getValue()}), "Unable to import SAP Invoices", (Component)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processData(PeriodComplete period) throws Exception {
        if (((PegasusFileComplete)this.node.getValue()).getLocalFile() != null) {
            this.importFile(((PegasusFileComplete)this.node.getValue()).getLocalFile(), period);
            return;
        } else {
            if (((PegasusFileComplete)this.node.getValue()).getUri() == null) throw new IllegalStateException("No File selected");
            File f = FileTransferUtil.download((PegasusFileComplete)((PegasusFileComplete)this.node.getValue()), (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                public void statusChanged(File file, FileTransferState state) {
                    ImportInvoiceDataPopupInsert.this.showAnimation("Download File from Server (" + state.getRemaining() + "/" + state.getSize() + ")");
                }

                public void exceptionOccurred(Exception exception) {
                    ImportInvoiceDataPopupInsert.this.errorWhileDownloadFile = true;
                }
            }});
            if (!this.errorWhileDownloadFile) throw new IllegalStateException("Unable to download File from Server");
            ((PegasusFileComplete)this.node.getValue()).setLocalFile(f);
            this.importFile(f, period);
        }
    }

    private void importFile(File file, PeriodComplete period) throws Exception {
        this.showAnimation("Import Invoice Data");
        SAPImporterLSGFC importer = new SAPImporterLSGFC();
        List<TWMInvoiceImportComplete> importedRows = importer.getInvoices(file);
        this.showAnimation("Resolve Suppliers");
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        List<TWMSupplierComplete> suppliers = ThreeWayMatchToolkit.createSupplierMapping(importedRows, settings);
        this.showAnimation("Map Purchase Orders");
        ThreeWayMatchToolkit.resolveOrderNumbers(suppliers, period);
        for (TWMSupplierComplete sup : suppliers) {
            Iterator it = this.match.getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
            boolean found = false;
            while (it.hasNext()) {
                Node s = (Node)it.next();
                if (!((TWMSupplierComplete)s.getValue()).getSupplier().equals((Object)sup.getSupplier())) continue;
                found = true;
                for (TWMEntryComplete e : sup.getEntries()) {
                    Node en = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false);
                    s.getChildNamed(TWMSupplierComplete_.entries).addChild(en, 0L);
                }
            }
            if (found) continue;
            Node ns = INodeCreator.getDefaultImpl().getNode4DTO((Object)sup, true, false);
            this.match.getChildNamed(ThreeWayMatchComplete_.suppliers).addChild(ns, 0L);
        }
        for (TWMInvoiceImportComplete i : importedRows) {
            Node nr = INodeCreator.getDefaultImpl().getNode4DTO((Object)i, true, false);
            this.match.getChildNamed(ThreeWayMatchComplete_.invoices).addChild(nr, 0L);
            ThreeWayMatchToolkit.updateImportedInvoiceState(this.match, (Node<TWMInvoiceImportComplete>)nr, true, false, null);
        }
        this.match.commit(ThreeWayMatchComplete.class);
        ThreeWayMatchToolkit.updateTWMStates((ThreeWayMatchComplete)this.match.getValue());
        this.match.updateNode();
        this.processFinished(null);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            ImportInvoiceDataPopupInsert.this.layoutAnimation(parent);
        }
    }
}

