/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.details.utils;

import ch.icit.pegasus.client.converter.ArticleChargePriceConverter;
import ch.icit.pegasus.client.converter.BasicArticleWithConversionAddedConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DeltaQuantityConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.OrderInfoConverter;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.PriceMutationConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.InternationalizedDateConverter;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.UserAndDateTimeConverter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.EditChargePriceUnitExpiryPopup;
import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.modules.threewaymatch.details.utils.PurchasePositionPriceConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorFiveWithCheckRenderer;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorTwoRenderer;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.BlackTitle;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.DocumentScanButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.PurchaseOrderSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPricingStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete_;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMEntryComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceReviewStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMOrderComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMOrderComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMSupplierStateE;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchComplete_;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TWMMatchPanel
extends DefaultPanel
implements Nodable,
Table2RowSelectionListener,
NodeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private BlackTitle supplierTitle;
    private Table2 suppliers;
    private VerticalSeparator sep1;
    private BlackTitle purchaseTitle;
    private PageableTable2 purchase;
    private VerticalSeparator sep2;
    private BlackTitle invoiceTitle;
    private Table2 invoices;
    private BlackTitle orderDetailsTitle;
    private Table2 orderDetails;
    private TextButton addAllOrders;
    private BackgroundFadeSkin invoiced;
    private BackgroundFadeSkin checked;
    private BackgroundFadeSkin approved;
    private TextLabel invoicedText;
    private TextLabel invoicedSum;
    private TextLabel checkedText;
    private TextLabel realSum;
    private TextLabel differenceText;
    private TextLabel differenceSum;
    private SearchTextField orderSearch;
    private SearchComboBox orderSearchSupplierSelection;
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_STATE_INVERT = "state_invert";
    private static final String FILTER_DEPARTMENT = "department";
    private static final String FILTER_TIMING = "timing";
    protected static final String FILTER_SUPPLIER = "supplier";
    private RDProvider provider;
    private Node<ThreeWayMatchComplete> matchNode;
    private CurrencyVariantAccessor currencyAccessor;

    public TWMMatchPanel(RDProvider provider) {
        this.provider = provider;
        this.currencyAccessor = new CurrencyVariantAccessorImpl();
        this.setLayout(new Layout());
        this.createSupplierTable();
        this.createInvoiceTable();
        this.createOrderDetailsTable();
        this.invoiced = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.checked = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.approved = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.invoicedText = new TextLabel(Words.INVOICED_SUM);
        this.invoicedSum = new TextLabel(null, ConverterRegistry.getConverter(PriceConverter3.class));
        this.checkedText = new TextLabel(Words.REALCOST);
        this.realSum = new TextLabel(null, ConverterRegistry.getConverter(PriceConverter3.class));
        this.differenceText = new TextLabel(Words.DIFFERENCE);
        this.differenceSum = new TextLabel(null, ConverterRegistry.getConverter(PriceConverter3.class));
        this.invoicedText.setFont(AttributesConverter.getDefaultBoldFont());
        this.invoicedSum.setFont(AttributesConverter.getDefaultBoldFont());
        this.checkedText.setFont(AttributesConverter.getDefaultBoldFont());
        this.realSum.setFont(AttributesConverter.getDefaultBoldFont());
        this.differenceText.setFont(AttributesConverter.getDefaultBoldFont());
        this.differenceSum.setFont(AttributesConverter.getDefaultBoldFont());
        this.createPurchaseTable();
        this.sep1 = new VerticalSeparator();
        this.sep2 = new VerticalSeparator();
        this.add(this.supplierTitle);
        this.add(this.suppliers);
        this.add(this.invoiceTitle);
        this.add(this.invoices);
        this.add(this.orderDetailsTitle);
        this.add(this.orderDetails);
        this.add(this.invoicedText);
        this.add(this.invoicedSum);
        this.add(this.checkedText);
        this.add(this.realSum);
        this.add(this.differenceText);
        this.add(this.differenceSum);
        this.add(this.purchaseTitle);
        this.add(this.purchase);
        this.add(this.sep1);
        this.add(this.sep2);
    }

    private void createPurchaseTable() {
        this.purchaseTitle = new BlackTitle();
        this.purchaseTitle.setTitleText(Words.PURCHASE_SEARCH);
        this.purchase = new PageableTable2(){

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(PurchaseOrderSearchAlgorithm.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                PurchaseOrderSearchConfiguration ps = new PurchaseOrderSearchConfiguration();
                String t = TWMMatchPanel.this.orderSearch.getText();
                Integer no = null;
                try {
                    no = Integer.valueOf(t);
                }
                catch (NumberFormatException e) {
                    no = null;
                }
                ps.setNumber(no);
                SupplierLight supplier = (SupplierLight)TWMMatchPanel.this.orderSearchSupplierSelection.getNode().getValue();
                PeriodComplete p = ThreeWayMatchToolkit.createPeriod((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode);
                ps.setPeriod(p);
                ps.setSupplier(supplier);
                return ps;
            }

            @Override
            public void fillFilterChain() {
                TWMMatchPanel.this.orderSearch = this.getFilterChain().addSeachField(TWMMatchPanel.FILTER_DEPARTMENT, Words.ORDER_NO);
                TWMMatchPanel.this.orderSearchSupplierSelection = this.getFilterChain().addSupplierSearch(TWMMatchPanel.FILTER_SUPPLIER, Words.SUPPLIER);
                this.getFilterChain().setDefault_comboSearchFieldWidth(190);
            }
        };
        this.purchase.setProvider(this.provider);
        this.purchase.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columnsPurchase = new ArrayList<TableColumnInfo>();
        columnsPurchase.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 80, 80, 80));
        int tw = TableColumnInfo.dateColumnWidth + 2 * this.purchase.getCellPadding();
        columnsPurchase.add(new TableColumnInfo(Words.ORDER_DATE, null, null, null, "", tw, tw, tw));
        columnsPurchase.add(new TableColumnInfo(Words.PRICE, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.purchase.getCellPadding();
        columnsPurchase.add(new TableColumnInfo(Words.ADD_TO_INVOICE, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columnsPurchase.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columnsPurchase.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columnsPurchase.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columnsPurchase.get(3)).setxExpand(0.0);
        this.purchase.setModel(new Table2Model(columnsPurchase, model -> new OrderSearchRow(model, Table2RowPanel.TableControlsType.ONE)));
        this.addAllOrders = new TextButton(Words.ADD_ALL);
        this.addAllOrders.addButtonListener(this);
        this.purchase.addFooterButton(this.addAllOrders);
        this.purchase.getModel().setNode((Node)new ViewNode("OrderSearch"));
    }

    private void createOrderDetailsTable() {
        this.orderDetailsTitle = new BlackTitle();
        this.orderDetailsTitle.setTitleText(Words.ORDER);
        this.orderDetails = new Table2(false, "", false, false);
        this.orderDetails.setProvider(this.provider);
        this.orderDetails.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columnsOrderDetails = new ArrayList<TableColumnInfo>();
        columnsOrderDetails.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columnsOrderDetails.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 180, 180, 180));
        columnsOrderDetails.add(new TableColumnInfo(Words.ORDERED, null, null, null, "", TableColumnInfo.priceColumnWidth));
        columnsOrderDetails.add(new TableColumnInfo(Words.RECEIVE, null, null, null, "", TableColumnInfo.priceColumnWidth));
        columnsOrderDetails.add(new TableColumnInfo(Words.DAY_PRICE, null, null, null, "", TableColumnInfo.priceColumnWidth * 2));
        ((TableColumnInfo)columnsOrderDetails.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columnsOrderDetails.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columnsOrderDetails.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columnsOrderDetails.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columnsOrderDetails.get(4)).setxExpand(0.0);
        this.orderDetails.setModel(new Table2Model(columnsOrderDetails, model -> {
            if (model.getNode().getValue(PurchaseOrderPositionComplete.class) instanceof PurchaseOrderPositionComplete) {
                OrderDetailsTableRowImpl p = new OrderDetailsTableRowImpl(model);
                return p;
            }
            OrderDetailsTransactionsTableRowPanel p = new OrderDetailsTransactionsTableRowPanel(model);
            return p;
        }));
    }

    private void createSupplierTable() {
        this.supplierTitle = new BlackTitle();
        this.supplierTitle.setTitleText(Words.MATCHED_SUPPLIER);
        this.suppliers = new Table2(false, "", false, false);
        this.suppliers.setProvider(this.provider);
        this.suppliers.setUseWriteAccessRight(true);
        this.suppliers.setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int sw = TableColumnInfo.state2 + 2 * this.suppliers.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", sw, sw, sw));
        columns.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.VOLUME, null, null, null, "", 120, 120, 120));
        sw = RemarkButton.getPreferredWidth() + this.suppliers.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", sw, sw, sw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.suppliers.setModel(new Table2Model(columns, model -> new SupplierTableRowImpl(model)));
        this.suppliers.setProgress(1.0f);
        this.suppliers.getModel().addTableSelectionListener(this);
    }

    private void createInvoiceTable() {
        this.invoiceTitle = new BlackTitle();
        this.invoiceTitle.setTitleText(Words.MATCHED_IMPORTED_INVOICES);
        this.invoices = new Table2(false, "", false, false);
        this.invoices.setProvider(this.provider);
        this.invoices.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columnsInvoice = new ArrayList<TableColumnInfo>();
        int sw = TableColumnInfo.state5 + 2 * this.invoices.getCellPadding();
        columnsInvoice.add(new TableColumnInfo(Words.STATE, null, null, null, "", sw, sw, sw));
        columnsInvoice.add(new TableColumnInfo(Words.INVOICE, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columnsInvoice.add(new TableColumnInfo(Words.ORDER_NO, null, null, null, "", 120, 120, 120));
        columnsInvoice.add(new TableColumnInfo(Words.PRICE, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        sw = TableColumnInfo.priceColumnWidth + 2 * this.invoices.getCellPadding() + 20;
        columnsInvoice.add(new TableColumnInfo(Words.SUM, null, null, null, "", sw, sw, sw));
        columnsInvoice.add(new TableColumnInfo(Words.DIFF, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columnsInvoice.add(new TableColumnInfo(Words.REVIEW_STATE, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        columnsInvoice.add(new TableColumnInfo(Words.STATE, null, null, null, "", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.invoices.getCellPadding();
        columnsInvoice.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columnsInvoice.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columnsInvoice.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columnsInvoice.get(8)).setxExpand(0.0);
        this.invoices.setModel(new Table2Model(columnsInvoice, model -> {
            if (model.getNode().getValue() instanceof TWMEntryComplete) {
                InvoiceTableRowImpl p = new InvoiceTableRowImpl(model);
                p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
                return p;
            }
            if (model.getNode().getValue() instanceof TWMOrderComplete) {
                OrderTableRowImpl p = new OrderTableRowImpl(model);
                p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
                return p;
            }
            return null;
        }));
        this.invoices.getModel().addTableSelectionListener(this);
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.suppliers.setVisibleContainer(pane);
        this.invoices.setVisibleContainer(pane);
        this.purchase.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.matchNode != null) {
            this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchStartDate).removeNodeListener((NodeListener)this);
            this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchEndDate).removeNodeListener((NodeListener)this);
        }
        this.matchNode = node;
        this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchStartDate).addNodeListener((NodeListener)this);
        this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchEndDate).addNodeListener((NodeListener)this);
        this.suppliers.getModel().setNode(node.getChildNamed(ThreeWayMatchComplete_.suppliers));
        this.updateAddAllButtonState();
    }

    @Override
    public Node<?> getNode() {
        return this.matchNode;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.suppliers.setEnabled(isEnabled);
        this.invoices.setEnabled(isEnabled);
        this.purchase.setEnabled(isEnabled);
        if (isEnabled) {
            this.updateAddAllButtonState();
        } else {
            this.addAllOrders.setEnabled(isEnabled);
        }
    }

    private Node<TWMSupplierComplete> getSelectedSupplier() {
        return this.suppliers.getModel().getSelectedNode();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.matchNode != null) {
            this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchStartDate).removeNodeListener((NodeListener)this);
            this.matchNode.getChildNamed(ThreeWayMatchComplete_.orderSearchEndDate).removeNodeListener((NodeListener)this);
        }
        this.suppliers.kill();
        this.invoices.kill();
        this.purchase.kill();
        this.sep1.kill();
        this.sep2.kill();
        this.addAllOrders.kill();
        this.suppliers = null;
        this.invoices = null;
        this.purchase = null;
        this.sep1 = null;
        this.sep2 = null;
        this.addAllOrders = null;
    }

    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<PurchaseOrderLight> ordersWithCustomerOwnedArticle = new HashSet<PurchaseOrderLight>();
        Iterator it = this.matchNode.getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node supplierNode = (Node)it.next();
            Iterator it2 = supplierNode.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node entry = (Node)it2.next();
                Node ordersNode = entry.getChildNamed(TWMEntryComplete_.orders);
                Iterator it3 = ordersNode.getFailSafeChildIterator();
                while (it3.hasNext()) {
                    Node order = (Node)it3.next();
                    PurchaseOrderLight value = (PurchaseOrderLight)order.getChildNamed(TWMOrderComplete_.order).getValue();
                    if (!Boolean.TRUE.equals(value.getContainsCustomerOwnedArticle())) continue;
                    ordersWithCustomerOwnedArticle.add(value);
                }
            }
        }
        for (PurchaseOrderLight orderLight : ordersWithCustomerOwnedArticle) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Order " + orderLight.getNumber() + " contains Customer Owned Items"));
        }
        return validationObjects;
    }

    private void updateStatisticsFooter(Node<TWMSupplierComplete> node) {
        PriceComplete iSum = ThreeWayMatchToolkit.getInvoicedSum(node);
        PriceComplete rSum = ThreeWayMatchToolkit.getRealCostSum(node);
        PriceComplete aSum = new PriceComplete(iSum.getCurrency(), Double.valueOf(iSum.getPrice() - rSum.getPrice()));
        Node in = this.invoicedSum.getNode();
        if (in == null) {
            in = new ViewNode("Invoiced Sum");
            this.invoicedSum.setNode(in);
        }
        in.setValue((Object)iSum, 0L);
        Node rn = this.realSum.getNode();
        if (rn == null) {
            rn = new ViewNode("Real Sum");
            this.realSum.setNode(rn);
        }
        rn.setValue((Object)rSum, 0L);
        Node an = this.differenceSum.getNode();
        if (an == null) {
            an = new ViewNode("Approved Sum");
            this.differenceSum.setNode(an);
        }
        an.setValue((Object)aSum, 0L);
        this.invoicedSum.updateString();
        this.realSum.updateString();
        this.differenceSum.updateString();
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, final Table2RowPanel panel) {
        if (panel != null && panel.getModel() != null && panel.getModel().getParentModel() != null) {
            if (panel.getModel().getParentModel().getTable() == this.suppliers) {
                SupplierLight sup = (SupplierLight)panel.getModel().getNode().getChildNamed(TWMSupplierComplete_.supplier).getValue();
                this.invoices.getModel().setNode(panel.getModel().getNode().getChildNamed(TWMSupplierComplete_.entries));
                this.orderSearchSupplierSelection.getNode().setValue((Object)sup, 0L);
                this.purchase.getFilterChain().updateSearch();
                this.updateStatisticsFooter((Node<TWMSupplierComplete>)panel.getModel().getNode());
            } else if (panel.getModel().getParentModel().getTable() == this.invoices) {
                this.updateAddAllButtonState();
                if (panel.getModel().getNode().getChildNamed(TWMOrderComplete_.order) != null && panel.getModel().getNode().getChildNamed(TWMOrderComplete_.order).getValue(PurchaseOrderComplete.class) == null) {
                    this.setEnabled(false);
                    this.orderDetails.showLoadingAnimation("Load Order");
                    ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                        @Override
                        public Node<?> loadData() throws Exception {
                            TWMOrderComplete order = (TWMOrderComplete)panel.getModel().getNode().getValue();
                            PurchaseOrderComplete poC = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(order.getOrder().getId())).getValue();
                            panel.getModel().getNode().getChildNamed(TWMOrderComplete_.order).setValue((Object)poC, 0L);
                            return panel.getModel().getNode();
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    TWMMatchPanel.this.setEnabled(true);
                                    TWMMatchPanel.this.orderDetails.hideLoadingAnimation();
                                    TWMMatchPanel.this.setOrderNode((Node<TWMOrderComplete>)node);
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TWMMatchPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                } else {
                    this.setOrderNode((Node<TWMOrderComplete>)panel.getModel().getNode());
                }
            } else if (panel != null && panel.getModel().getNode().getValue() instanceof TWMInvoiceImportComplete) {
                this.selectInvoice((Node<TWMInvoiceImportComplete>)panel.getModel().getNode());
            }
        }
    }

    private void updateAddAllButtonState() {
        if (this.invoices.getModel().getSelectedNode() != null) {
            if (this.invoices.getModel().getSelectedNode().getChildNamed(TWMOrderComplete_.order) != null) {
                this.addAllOrders.setEnabled(false);
            } else {
                this.addAllOrders.setEnabled(true);
            }
        } else {
            this.addAllOrders.setEnabled(false);
        }
    }

    private void selectInvoice(Node<TWMInvoiceImportComplete> value) {
        for (Table2RowPanel p : this.suppliers.getRows()) {
            SupplierTableRowImpl st = (SupplierTableRowImpl)p;
            Iterator it2 = st.getModel().getNode().getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node entry = (Node)it2.next();
                if (!((TWMInvoiceImportComplete)entry.getChildNamed(TWMEntryComplete_.invoice).getValue()).equals(value.getValue())) continue;
                p.setSelected(3);
                this.suppliers.scrollTo(p);
                for (Table2RowPanel ip : this.invoices.getRows()) {
                    InvoiceTableRowImpl itr = (InvoiceTableRowImpl)ip;
                    if (!itr.getModel().getNode().getChildNamed(TWMEntryComplete_.invoice).getValue().equals(value.getValue())) continue;
                    itr.setSelected(3);
                    this.invoices.scrollTo(ip);
                    return;
                }
            }
        }
    }

    private void setOrderNode(Node<TWMOrderComplete> order) {
        if (order.getValue() instanceof TWMOrderComplete) {
            this.orderDetails.getModel().setNode(order.getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderComplete_.orderPositions}));
            this.orderDetailsTitle.setTitleText(Words.ORDER + " " + ((TWMOrderComplete)order.getValue()).getOrder().getNumber());
        } else {
            this.orderDetails.getModel().setNode(null);
            this.orderDetailsTitle.setTitleText(Words.ORDER + " no order selected");
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        int fadeH = this.invoiced.getImage(0).getHeight();
        int currentY = this.getHeight() - 1 * fadeH;
        this.invoiced.paint(g2, this.invoices.getX(), currentY, this.invoices.getWidth(), 11);
        currentY = this.getHeight() - 2 * fadeH;
        this.checked.paint(g2, this.invoices.getX(), currentY, this.invoices.getWidth(), 11);
        currentY = this.getHeight() - 3 * fadeH;
        this.approved.paint(g2, this.invoices.getX(), currentY, this.invoices.getWidth(), 11);
        this.paintChildren(g2);
    }

    public void valueChanged(Node<?> node) {
        this.purchase.getFilterChain().updateSearch();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.addAllOrders && this.invoices.getModel().getSelectedNode() != null) {
            this.purchase.showLoadingAnimation(Words.ADD_ORDERS);
            this.purchase.setEnabled(false);
            ThreadSafeExecutable r = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    Node entry = TWMMatchPanel.this.invoices.getModel().getSelectedNode();
                    SearchResultIterator sri = new SearchResultIterator(TWMMatchPanel.this.purchase.filterValueChanged(null, null));
                    HashSet<Node> supMap = new HashSet<Node>();
                    for (PurchaseOrderLight o : sri) {
                        if (o == null) continue;
                        Node supplier = TWMMatchPanel.this.suppliers.getModel().getSelectedNode();
                        boolean alreadyAttached = false;
                        Iterator it = supplier.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
                        while (it.hasNext()) {
                            Node s = (Node)it.next();
                            Iterator it2 = s.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
                            while (it2.hasNext()) {
                                Node e = (Node)it2.next();
                                if (!((TWMOrderComplete)e.getValue()).getOrder().equals((Object)o)) continue;
                                alreadyAttached = true;
                            }
                        }
                        if (!alreadyAttached) {
                            TWMOrderComplete oe = new TWMOrderComplete();
                            oe.setClientOId(Long.valueOf(ADTO.getNextId()));
                            oe.setOrder(o);
                            oe.setPrice(new PriceComplete(o.getRealCost()));
                            Node oen = INodeCreator.getDefaultImpl().getNode4DTO((Object)oe, true, false);
                            entry.getChildNamed(TWMEntryComplete_.orders).addChild(oen, 0L);
                        }
                        supMap.add(supplier);
                    }
                    for (Node s : supMap) {
                        ThreeWayMatchToolkit.updateTWMSupplier((Node<TWMSupplierComplete>)s, true, false, null);
                    }
                    TWMMatchPanel.this.matchNode.commitThis(ThreeWayMatchComplete.class);
                    ThreeWayMatchToolkit.updateTWMStates((ThreeWayMatchComplete)TWMMatchPanel.this.matchNode.getValue());
                    TWMMatchPanel.this.matchNode.updateNode();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            TWMMatchPanel.this.purchase.hideLoadingAnimation();
                            TWMMatchPanel.this.purchase.setEnabled(true);
                            TWMMatchPanel.this.updateStatisticsFooter((Node<TWMSupplierComplete>)TWMMatchPanel.this.suppliers.getModel().getSelectedNode());
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TWMMatchPanel.this);
                            TWMMatchPanel.this.purchase.hideLoadingAnimation();
                            TWMMatchPanel.this.purchase.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(r);
        }
    }

    private class OrderTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel customerOwned;
        private TextLabel orderNo;
        private TextLabel price;
        private InputComboBox take;
        private TextLabel dif;
        private DeleteButton delete;
        private TextLabel orderInfos;
        private ComboBox pricingState;

        public OrderTableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.orderInfos = new TextLabel(m.getNode().getChildNamed(TWMOrderComplete_.order), ConverterRegistry.getConverter(OrderInfoConverter.class));
            this.customerOwned = new TextLabel(Boolean.TRUE.equals(m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.customerOwnedOnly}).getValue()) ? "customer owned" : "");
            this.orderNo = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.price = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.realCost}), ConverterRegistry.getConverter(PriceConverter3.class));
            Node p = INodeCreator.getDefaultImpl().getNode4DTO((Object)new PriceComplete((PriceComplete)m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.realCost}).getValue()), false, false);
            this.dif = new TextLabel(p, ConverterRegistry.getConverter(PriceConverter3.class));
            this.take = new InputComboBox(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.take.setMaxKommaStellen(3);
            this.take.setNode(m.getNode().getChildNamed(TWMOrderComplete_.price));
            m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).addNodeListener((NodeListener)this);
            this.pricingState = ComboBoxFactory.getNodePurchaseOrderPricingStateComboBox((Node<OrderPricingStateE>)this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.orderPricingState}), false);
            this.model.getNode().getParent().getParent().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).addNodeListener((NodeListener)this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.updateDifPrice();
            this.add(this.customerOwned);
            this.add(this.orderInfos);
            this.add(this.orderNo);
            this.add(this.price);
            this.add(this.take);
            this.add(this.dif);
            this.add(this.pricingState);
            this.add(this.delete);
        }

        private void updateDifPrice() {
            Double td = (Double)this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).getValue();
            CurrencyComplete tc = (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).getValue();
            Double op = (Double)this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.realCost, PriceComplete_.price}).getValue();
            CurrencyComplete oc = (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.order, PurchaseOrderLight_.realCost, PriceComplete_.currency}).getValue();
            if (td == null) {
                td = 0.0;
            }
            if (op == null) {
                op = 0.0;
            }
            double nd = op - td;
            this.dif.getNode().getChildNamed(PriceComplete_.price).setValue((Object)nd, 0L);
            this.dif.getNode().getChildNamed(PriceComplete_.currency).setValue((Object)oc, 0L);
            this.dif.updateString();
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.take.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean b = isEnabled && (Boolean)this.model.getNode().getParent().getParent().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).getValue() == false;
            this.customerOwned.setEnabled(b);
            this.orderInfos.setEnabled(b);
            this.orderNo.setEnabled(b);
            this.price.setEnabled(b);
            this.take.setEnabled(b);
            this.delete.setEnabled(b);
            this.pricingState.setEnabled(isEnabled);
            this.dif.setEnabled(b);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getParent().getParent().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).removeNodeListener((NodeListener)this);
            this.customerOwned.kill();
            this.customerOwned = null;
            this.orderInfos.kill();
            this.orderInfos = null;
            this.orderNo.kill();
            this.orderNo = null;
            this.price.kill();
            this.price = null;
            this.take.kill();
            this.take = null;
            this.delete.kill();
            this.delete = null;
            this.pricingState.kill();
            this.pricingState = null;
            this.dif.kill();
            this.dif = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                Node parent = this.getModel().getNode().getParent().getParent();
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
                ThreeWayMatchToolkit.updateTWMEntry((Node<TWMEntryComplete>)parent, false, null);
            }
        }

        public void valueChanged(Node<?> node) {
            if (node.getName().equals(TWMInvoiceImportComplete_.state.getFieldName())) {
                this.setEnabled(this.isEnabled());
            } else {
                ThreeWayMatchToolkit.updateTWMEntry((Node<TWMEntryComplete>)this.model.getNode().getParent().getParent(), false, null);
                this.updateDifPrice();
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                OrderTableRowImpl.this.customerOwned.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.customerOwned.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.customerOwned.setSize(w - 2 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.customerOwned.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                OrderTableRowImpl.this.orderInfos.setLocation(currentX + 4 * OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.orderInfos.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.orderInfos.setSize(w - 5 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.orderInfos.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                OrderTableRowImpl.this.orderNo.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.orderNo.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.orderNo.setSize(w - 2 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.orderNo.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                OrderTableRowImpl.this.price.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.price.setSize(OrderTableRowImpl.this.price.getPreferredSize());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(4);
                OrderTableRowImpl.this.take.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.take.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.take.setSize(w - 2 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.take.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(5);
                OrderTableRowImpl.this.dif.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.dif.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.dif.setSize(w - 2 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.dif.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(6);
                OrderTableRowImpl.this.pricingState.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.pricingState.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.pricingState.setSize(w - 2 * OrderTableRowImpl.this.getCellPadding(), (int)OrderTableRowImpl.this.pricingState.getPreferredSize().getHeight());
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(7);
                currentX += w;
                w = OrderTableRowImpl.this.model.getParentModel().getColumnWidth(8);
                OrderTableRowImpl.this.setControlsX(currentX);
                OrderTableRowImpl.this.delete.setLocation(currentX + OrderTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderTableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                OrderTableRowImpl.this.delete.setSize(OrderTableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class OrderSearchRow
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel orderNo;
        private TextLabel orderDate;
        private TextLabel price;
        private InfoButton info;
        private AddButton config;

        public OrderSearchRow(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            boolean isAttached = this.ensureCosts((Node<PurchaseOrderLight>)this.model.getNode());
            this.orderNo = new TextLabel(m.getNode().getChildNamed(PurchaseOrderComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.orderDate = new TextLabel(m.getNode().getChildNamed(PurchaseOrderComplete_.orderDate), ConverterRegistry.getConverter(InternationalizedDateConverter.class));
            this.price = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.remainingCost), ConverterRegistry.getConverter(PriceConverter3.class));
            this.config = new AddButton();
            this.config.addButtonListener(this);
            this.info = new InfoButton();
            this.info.addButtonListener(this);
            this.setLayout(new Layout());
            this.ensureAttachedState(isAttached);
            this.add(this.orderNo);
            this.add(this.orderDate);
            this.add(this.price);
            this.add(this.info);
            this.add(this.config);
        }

        private void ensureAttachedState(Boolean isAttached) {
            if (isAttached == null) {
                isAttached = this.isAttached();
            }
            if (isAttached.booleanValue()) {
                this.orderNo.setForeground(Color.gray);
                this.orderDate.setForeground(Color.gray);
                this.price.setForeground(Color.gray);
                this.repaint(32L);
            }
        }

        private boolean ensureCosts(Node<PurchaseOrderLight> node) {
            boolean isAttached = this.isAttached();
            ThreeWayMatchToolkit.ensurePurchaseOrderRemainingCost((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode, node, isAttached, this);
            return isAttached;
        }

        private boolean isAttached() {
            if (this.model.getNode().getChildNamed(PurchaseOrderLight_.reviewState).getValue() != OrderReviewStateE.UNCHECKED) {
                return true;
            }
            Iterator it = TWMMatchPanel.this.matchNode.getChildNamed(ThreeWayMatchComplete_.suppliers).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node s = (Node)it.next();
                if (!((SupplierLight)s.getChildNamed(TWMSupplierComplete_.supplier).getValue()).equals(this.model.getNode().getChildNamed(TWMSupplierComplete_.supplier).getValue())) continue;
                Iterator it2 = s.getChildNamed(TWMSupplierComplete_.entries).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node e = (Node)it2.next();
                    Iterator it3 = e.getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
                    while (it3.hasNext()) {
                        Node o = (Node)it3.next();
                        if (!((PurchaseOrderLight)o.getChildNamed(TWMOrderComplete_.order).getValue()).equals(this.model.getNode().getValue())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(PurchaseOrderComplete_.number).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(PurchaseOrderComplete_.realCost).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.orderNo.setEnabled(isEnabled);
            this.orderDate.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.config.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.orderNo.kill();
            this.orderNo = null;
            this.orderDate.kill();
            this.orderDate = null;
            this.info.kill();
            this.info = null;
            this.price.kill();
            this.price = null;
            this.config.kill();
            this.config = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.config) {
                if (TWMMatchPanel.this.invoices.getModel().getSelectedNode() != null) {
                    if (TWMMatchPanel.this.invoices.getModel().getSelectedNode().getValue() instanceof TWMOrderComplete) {
                        TWMOrderComplete o = new TWMOrderComplete();
                        o.setClientOId(Long.valueOf(ADTO.getNextId()));
                        o.setOrder((PurchaseOrderLight)this.model.getNode().getValue());
                        o.setPrice(new PriceComplete(o.getOrder().getRealCost()));
                        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
                        TWMMatchPanel.this.invoices.getModel().getSelectedNode().getParent().getParent().getChildNamed(TWMEntryComplete_.orders).addChild((Node)new DTOProxyNode(n), 0L);
                    } else if (TWMMatchPanel.this.invoices.getModel().getSelectedNode().getValue() instanceof TWMEntryComplete) {
                        TWMOrderComplete o = new TWMOrderComplete();
                        o.setClientOId(Long.valueOf(ADTO.getNextId()));
                        o.setOrder((PurchaseOrderLight)this.model.getNode().getValue());
                        o.setPrice(new PriceComplete(o.getOrder().getRealCost()));
                        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
                        TWMMatchPanel.this.invoices.getModel().getSelectedNode().getChildNamed(TWMEntryComplete_.orders).addChild((Node)new DTOProxyNode(n), 0L);
                    }
                    this.ensureAttachedState(this.ensureCosts((Node<PurchaseOrderLight>)this.model.getNode()));
                } else {
                    InnerPopupFactory.showMessageDialog("<b>No item selected</b><br/>Please select a Invoice or Order first", this);
                }
            } else if (source == this.info) {
                this.info.showMessage(this.info, ThreeWayMatchToolkit.getOrderInfoText((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode, (Node<PurchaseOrderLight>)this.model.getNode()), x, y);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderSearchRow.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = OrderSearchRow.this.model.getParentModel().getColumnWidth(0);
                OrderSearchRow.this.orderNo.setLocation(currentX + OrderSearchRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderSearchRow.this.orderNo.getPreferredSize().getHeight()) / 2.0));
                OrderSearchRow.this.orderNo.setSize(w - 2 * OrderSearchRow.this.getCellPadding(), (int)OrderSearchRow.this.orderNo.getPreferredSize().getHeight());
                currentX += w;
                w = OrderSearchRow.this.model.getParentModel().getColumnWidth(1);
                OrderSearchRow.this.orderDate.setLocation(currentX + OrderSearchRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderSearchRow.this.orderDate.getPreferredSize().getHeight()) / 2.0));
                OrderSearchRow.this.orderDate.setSize(w - 2 * OrderSearchRow.this.getCellPadding(), (int)OrderSearchRow.this.orderDate.getPreferredSize().getHeight());
                currentX += w;
                w = OrderSearchRow.this.model.getParentModel().getColumnWidth(2);
                OrderSearchRow.this.price.setLocation(currentX + OrderSearchRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderSearchRow.this.price.getPreferredSize().getHeight()) / 2.0));
                OrderSearchRow.this.price.setSize((int)((double)w - ((double)(2 * OrderSearchRow.this.getCellPadding() + OrderSearchRow.this.getInnerCellPadding()) + OrderSearchRow.this.info.getPreferredSize().getWidth())), (int)OrderSearchRow.this.price.getPreferredSize().getHeight());
                OrderSearchRow.this.info.setLocation(OrderSearchRow.this.price.getX() + OrderSearchRow.this.price.getWidth() + OrderSearchRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderSearchRow.this.info.getPreferredSize().getHeight()) / 2.0));
                OrderSearchRow.this.info.setSize(OrderSearchRow.this.info.getPreferredSize());
                currentX += w;
                w = OrderSearchRow.this.model.getParentModel().getColumnWidth(3);
                OrderSearchRow.this.setControlsX(currentX);
                OrderSearchRow.this.config.setLocation(currentX + OrderSearchRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderSearchRow.this.config.getPreferredSize().getHeight()) / 2.0));
                OrderSearchRow.this.config.setSize(OrderSearchRow.this.config.getPreferredSize());
            }
        }
    }

    private class OrderDetailsTableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private ExpandIcon expand;
        private TextLabel article;
        private TextLabel ordered;
        private TextLabel received;
        private TextLabel dayPrice;

        public OrderDetailsTableRowImpl(Table2RowModel m) {
            super(m);
            this.setExpanded(true);
            this.setLayoutInnerChildsSelf(true);
            this.no = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.sequenceNumber), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            this.expand = new ExpandIcon();
            this.expand.setExpanded(true);
            this.expand.addButtonListener(this);
            this.article = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.article), ConverterRegistry.getConverter(BasicArticleWithConversionAddedConverter.class));
            this.ordered = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.received = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.deliveredAmount), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.dayPrice = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchasePositionPriceConverter.class));
            this.setLayout(new Layout());
            m.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions).getAllChildAddEvents((NodeListener)this);
            this.add(this.no);
            this.add(this.expand);
            this.add(this.article);
            this.add(this.ordered);
            this.add(this.received);
            this.add(this.dayPrice);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.sequenceNumber).getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.no.setEnabled(isEnabled);
            this.expand.setEnabled(isEnabled);
            this.article.setEnabled(isEnabled);
            this.ordered.setEnabled(isEnabled);
            this.received.setEnabled(isEnabled);
            this.dayPrice.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.getModel().getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions).removeNodeListenerRecursively((NodeListener)this);
            this.no.kill();
            this.no = null;
            this.expand.kill();
            this.expand = null;
            this.article.kill();
            this.article = null;
            this.ordered.kill();
            this.ordered = null;
            this.received.kill();
            this.received = null;
            this.dayPrice.kill();
            this.dayPrice = null;
        }

        public void valueChanged(Node<?> node) {
        }

        public void childAdded(Node<?> source, Node<?> child) {
            this.addRow(child);
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            this.removeRow(this.getChild4Node(child));
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.expand) {
                this.setExpanded(this.expand.isExpanded(), true);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderDetailsTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = OrderDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                OrderDetailsTableRowImpl.this.no.setLocation(OrderDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTableRowImpl.this.no.setSize(OrderDetailsTableRowImpl.this.no.getPreferredSize());
                OrderDetailsTableRowImpl.this.expand.setLocation((int)((double)(currentX + w) - ((double)OrderDetailsTableRowImpl.this.getCellPadding() + OrderDetailsTableRowImpl.this.expand.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - OrderDetailsTableRowImpl.this.expand.getPreferredSize().getHeight()) / 2);
                OrderDetailsTableRowImpl.this.expand.setSize(OrderDetailsTableRowImpl.this.expand.getPreferredSize());
                currentX += w;
                w = OrderDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                OrderDetailsTableRowImpl.this.article.setLocation(currentX + OrderDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTableRowImpl.this.article.setSize(w - 2 * OrderDetailsTableRowImpl.this.getCellPadding(), (int)OrderDetailsTableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = OrderDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                OrderDetailsTableRowImpl.this.ordered.setLocation(currentX + OrderDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTableRowImpl.this.ordered.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTableRowImpl.this.ordered.setSize(w - 2 * OrderDetailsTableRowImpl.this.getCellPadding(), (int)OrderDetailsTableRowImpl.this.ordered.getPreferredSize().getHeight());
                currentX += w;
                w = OrderDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                OrderDetailsTableRowImpl.this.received.setLocation(currentX + OrderDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTableRowImpl.this.received.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTableRowImpl.this.received.setSize(w - 2 * OrderDetailsTableRowImpl.this.getCellPadding(), (int)OrderDetailsTableRowImpl.this.received.getPreferredSize().getHeight());
                currentX += w;
                w = OrderDetailsTableRowImpl.this.model.getParentModel().getColumnWidth(4);
                OrderDetailsTableRowImpl.this.dayPrice.setLocation(currentX + OrderDetailsTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTableRowImpl.this.dayPrice.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTableRowImpl.this.dayPrice.setSize(OrderDetailsTableRowImpl.this.dayPrice.getPreferredSize());
            }
        }
    }

    private class OrderDetailsTransactionsTableRowPanel
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel infos;
        private TextLabel received;
        private TextLabel dayPrice;
        private EditButton edit;
        private DocumentScanButton documents;

        public OrderDetailsTransactionsTableRowPanel(Table2RowModel m) {
            super(m);
            this.infos = new TextLabel(m.getNode(), ConverterRegistry.getConverter(UserAndDateTimeConverter.class));
            if (m.getNode().getValue() instanceof PurchaseOrderAcceptationComplete) {
                this.received = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderAcceptationComplete_.amount));
                this.dayPrice = new TextLabel(m.getNode().getChildNamed(PurchaseOrderAcceptationComplete_.charge), (Converter)new ArticleChargePriceConverter(ConverterRegistry.getConverter(PriceConverter3.class)));
                this.edit = new EditButton();
                this.edit.addButtonListener(this);
                this.documents = new DocumentScanButton();
                this.documents.addButtonListener((source, x, y) -> {
                    try {
                        Node group = null;
                        PurchaseOrderAcceptationComplete transaction = (PurchaseOrderAcceptationComplete)this.getModel().getNode().getValue();
                        Node position = this.getModel().getNode().getParent().getParent();
                        Node order = position.getParent().getParent();
                        PurchaseOrderComplete value = (PurchaseOrderComplete)order.getValue();
                        for (PurchaseOrderReceivingGroupComplete checkinGroup : value.getCheckinGroups()) {
                            if (!checkinGroup.getCheckins().contains(transaction)) continue;
                            group = INodeCreator.getDefaultImpl().getNode4DTO((Object)checkinGroup, true, false);
                        }
                        InnerPopupFactory.showScanDocumentPopup(this, (Node<DocumentScanComplete>)group.getChildNamed(PurchaseOrderReceivingGroupComplete_.documentScan), null, false, "Deliver Sheet");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            } else if (m.getNode().getValue() instanceof PurchaseOrderRejectionComplete) {
                this.received = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderRejectionComplete_.amount));
                this.dayPrice = new TextLabel(null, ConverterRegistry.getConverter(PriceConverter3.class));
                this.edit = new EditButton();
                this.edit.addButtonListener(this);
            } else if (m.getNode().getValue() instanceof PurchaseOrderPositionMutationComplete) {
                PurchaseOrderPositionMutationComplete mut = (PurchaseOrderPositionMutationComplete)m.getNode().getValue();
                this.dayPrice = new TextLabel(null, ConverterRegistry.getConverter(PriceConverter3.class));
                if (mut.getOldPriceUnit() != null && mut.getOldSupplierPrice() != null) {
                    this.received = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PriceMutationConverter.class));
                } else if (mut.getQuantity() != null && mut.getQuantity().getUnit() != null) {
                    this.received = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderPositionMutationComplete_.quantity), (Converter<?, ?>)ConverterRegistry.getConverter(DeltaQuantityConverter.class));
                }
            }
            this.setLayout(new Layout());
            this.add(this.infos);
            if (this.received != null) {
                this.add(this.received);
            }
            if (this.dayPrice != null) {
                this.add(this.dayPrice);
            }
            if (this.edit != null) {
                this.add(this.edit);
            }
            if (this.documents != null) {
                this.add(this.documents);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.infos.setEnabled(isEnabled);
            if (this.received != null) {
                this.received.setEnabled(isEnabled);
            }
            if (this.dayPrice != null) {
                this.dayPrice.setEnabled(isEnabled);
            }
            if (this.edit != null) {
                this.edit.setEnabled(isEnabled);
            }
            if (this.documents != null) {
                this.documents.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.infos.kill();
            if (this.received != null) {
                this.received.kill();
            }
            if (this.dayPrice != null) {
                this.dayPrice.kill();
            }
            if (this.edit != null) {
                this.edit.kill();
            }
            if (this.documents != null) {
                this.documents.kill();
            }
            this.infos = null;
            this.received = null;
            this.dayPrice = null;
            this.edit = null;
            this.documents = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.edit, true, true, "Edit Charge");
            popUp.setView(new EditChargePriceUnitExpiryPopup(this.model.getNode(), true));
            popUp.showPopUp(x, y, 250, 260, (source1, xargs) -> {
                if (xargs != null && this.dayPrice != null) {
                    this.dayPrice.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
            }, this.edit);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderDetailsTransactionsTableRowPanel.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = OrderDetailsTransactionsTableRowPanel.this.model.getParentModel().getColumnWidth(0);
                currentX += w;
                w = OrderDetailsTransactionsTableRowPanel.this.model.getParentModel().getColumnWidth(1);
                OrderDetailsTransactionsTableRowPanel.this.infos.setLocation(currentX + OrderDetailsTransactionsTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTransactionsTableRowPanel.this.infos.getPreferredSize().getHeight()) / 2.0));
                OrderDetailsTransactionsTableRowPanel.this.infos.setSize((w += OrderDetailsTransactionsTableRowPanel.this.model.getParentModel().getColumnWidth(2)) - 2 * OrderDetailsTransactionsTableRowPanel.this.getCellPadding(), (int)OrderDetailsTransactionsTableRowPanel.this.infos.getPreferredSize().getHeight());
                if (OrderDetailsTransactionsTableRowPanel.this.documents != null) {
                    OrderDetailsTransactionsTableRowPanel.this.documents.setLocation((int)((double)(currentX + w) - ((double)OrderDetailsTransactionsTableRowPanel.this.getCellPadding() + OrderDetailsTransactionsTableRowPanel.this.documents.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - OrderDetailsTransactionsTableRowPanel.this.documents.getPreferredSize().getHeight()) / 2.0));
                    OrderDetailsTransactionsTableRowPanel.this.documents.setSize(OrderDetailsTransactionsTableRowPanel.this.documents.getPreferredSize());
                }
                currentX += w;
                w = OrderDetailsTransactionsTableRowPanel.this.model.getParentModel().getColumnWidth(3);
                if (OrderDetailsTransactionsTableRowPanel.this.received != null) {
                    OrderDetailsTransactionsTableRowPanel.this.received.setLocation(currentX + OrderDetailsTransactionsTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTransactionsTableRowPanel.this.received.getPreferredSize().getHeight()) / 2.0));
                    OrderDetailsTransactionsTableRowPanel.this.received.setSize(w - 2 * OrderDetailsTransactionsTableRowPanel.this.getCellPadding(), (int)OrderDetailsTransactionsTableRowPanel.this.received.getPreferredSize().getHeight());
                }
                currentX += w;
                w = OrderDetailsTransactionsTableRowPanel.this.model.getParentModel().getColumnWidth(4);
                if (OrderDetailsTransactionsTableRowPanel.this.dayPrice != null) {
                    OrderDetailsTransactionsTableRowPanel.this.dayPrice.setLocation(currentX + OrderDetailsTransactionsTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderDetailsTransactionsTableRowPanel.this.dayPrice.getPreferredSize().getHeight()) / 2.0));
                    OrderDetailsTransactionsTableRowPanel.this.dayPrice.setSize(OrderDetailsTransactionsTableRowPanel.this.dayPrice.getPreferredSize());
                }
                if (OrderDetailsTransactionsTableRowPanel.this.edit != null) {
                    OrderDetailsTransactionsTableRowPanel.this.edit.setLocation((int)((double)(currentX + w) - (OrderDetailsTransactionsTableRowPanel.this.edit.getPreferredSize().getWidth() + (double)OrderDetailsTransactionsTableRowPanel.this.getCellPadding())), (int)((double)parent.getHeight() - OrderDetailsTransactionsTableRowPanel.this.edit.getPreferredSize().getHeight()) / 2);
                    OrderDetailsTransactionsTableRowPanel.this.edit.setSize(OrderDetailsTransactionsTableRowPanel.this.edit.getPreferredSize());
                }
            }
        }
    }

    private class InvoiceTableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private StateIndicatorFiveWithCheckRenderer<TWMInvoiceStateE> state;
        private TextLabel name;
        private TextLabel orderNo;
        private TextLabel price;
        private TextLabel sum;
        private TextLabel dif;
        private TitledItem<CheckBox> check;
        private RemarkButton remarkButton;
        private ComboBox reviewState;
        private RemarkButton reviewComment;

        public InvoiceTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayoutInnerChildsSelf(true);
            this.setExpanded(true);
            this.setSelectable(true);
            Node sn = m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state});
            this.state = new StateIndicatorFiveWithCheckRenderer(sn, (Node<Boolean>)m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.name}));
            this.orderNo = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.documentNumber}));
            this.price = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.price}), ConverterRegistry.getConverter(PriceConverter3.class));
            this.sum = new TextLabel(m.getNode().getChildNamed(TWMEntryComplete_.sum), ConverterRegistry.getConverter(PriceConverter3.class));
            this.dif = new TextLabel(m.getNode().getChildNamed(TWMEntryComplete_.dif), ConverterRegistry.getConverter(PriceConverter3.class));
            this.check = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway})), Words.OK, TitledItem.TitledItemOrientation.EAST);
            this.check.getElement().addButtonListener(this);
            this.remarkButton = new RemarkButton(true);
            this.remarkButton.setNode((Node<String>)m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnywayRemark}));
            this.reviewState = ComboBoxFactory.getNodeTWMInvoiceReviewStateComboBox((Node<TWMInvoiceReviewStateE>)m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.reviewState}));
            this.reviewComment = new RemarkButton((Node<String>)m.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.reviewComment}));
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).addNodeListener((NodeListener)this);
            this.setLayout(new Layout());
            m.getNode().getChildNamed(TWMEntryComplete_.orders).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(TWMEntryComplete_.orders).getAllChildAddEvents((NodeListener)this);
            this.add(this.state);
            this.add(this.name);
            this.add(this.orderNo);
            this.add(this.price);
            this.add(this.sum);
            this.add(this.dif);
            this.add(this.check);
            this.add(this.remarkButton);
            this.add(this.reviewComment);
            this.add(this.reviewState);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.state.getStringValue();
                }
                case 1: {
                    return this.name.getText();
                }
                case 2: {
                    return this.orderNo.getText();
                }
                case 3: {
                    return this.price.getNode().getValue();
                }
                case 4: {
                    return null;
                }
                case 5: {
                    return this.sum.getNode().getValue();
                }
                case 6: {
                    return this.dif.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean b = isEnabled && this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).getValue() != TWMInvoiceStateE.ACCEPT;
            this.state.setEnabled(b);
            this.name.setEnabled(b);
            this.orderNo.setEnabled(b);
            this.price.setEnabled(b);
            this.sum.setEnabled(b);
            this.dif.setEnabled(b);
            this.check.setEnabled(isEnabled);
            this.remarkButton.setEnabled(isEnabled);
            this.reviewComment.setEnabled(isEnabled);
            this.reviewState.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(TWMEntryComplete_.orders).removeNodeListenerRecursively((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).removeNodeListener((NodeListener)this);
            this.state.kill();
            this.state = null;
            this.name.kill();
            this.name = null;
            this.orderNo.kill();
            this.orderNo = null;
            this.price.kill();
            this.price = null;
            this.sum.kill();
            this.sum = null;
            this.dif.kill();
            this.dif = null;
            this.check.kill();
            this.check = null;
            this.remarkButton.kill();
            this.remarkButton = null;
            this.reviewComment.kill();
            this.reviewComment = null;
            this.reviewState.kill();
            this.reviewState = null;
        }

        private void updateSumAndDiff() throws Exception {
            double sum = 0.0;
            double dif = 0.0;
            double invoicePrice = (Double)this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.price, PriceComplete_.price}).getValue();
            CurrencyComplete invoiceCurrency = (CurrencyComplete)this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.price, PriceComplete_.currency}).getValue();
            TWMInvoiceImportComplete invoice = (TWMInvoiceImportComplete)this.model.getNode().getChildNamed(TWMEntryComplete_.invoice).getValue();
            CurrencyVariantComplete invoiceCurrencyVariant = (CurrencyVariantComplete)TWMMatchPanel.this.currencyAccessor.loadData((Object)invoiceCurrency, new Timestamp(invoice.getDocumentDate().getTime()));
            Iterator it = this.model.getNode().getChildNamed(TWMEntryComplete_.orders).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node o = (Node)it.next();
                double orderPrice = (Double)o.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).getValue();
                CurrencyComplete orderCurrency = (CurrencyComplete)o.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).getValue();
                CurrencyVariantComplete orderCurrencyVariant = (CurrencyVariantComplete)TWMMatchPanel.this.currencyAccessor.loadData((Object)orderCurrency, new Timestamp(((TWMOrderComplete)o.getValue()).getOrder().getOrderDate().getTime()));
                sum = !orderCurrencyVariant.getBase().equals((Object)invoiceCurrencyVariant.getBase()) ? (sum += orderPrice * orderCurrencyVariant.getExchangeRate()) : (sum += orderPrice);
                ThreeWayMatchToolkit.ensurePurchaseOrderRemainingCost((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode, (Node<PurchaseOrderLight>)o.getChildNamed(TWMOrderComplete_.order), true, this);
            }
            dif = invoicePrice - sum;
            Node sumNode = this.model.getNode().getChildNamed(TWMEntryComplete_.sum);
            Node difNode = this.model.getNode().getChildNamed(TWMEntryComplete_.dif);
            if (sumNode.getValue() == null) {
                sumNode.setValue((Object)new PriceComplete(), 0L);
            }
            if (difNode.getValue() == null) {
                difNode.setValue((Object)new PriceComplete(), 0L);
            }
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.price}).setValue((Object)sum, 0L);
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.sum, PriceComplete_.currency}).setValue((Object)invoiceCurrency, 0L);
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.price}).setValue((Object)dif, 0L);
            this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.dif, PriceComplete_.currency}).setValue((Object)invoiceCurrency, 0L);
            this.sum.updateString();
            this.dif.updateString();
        }

        public void revalidateState(boolean isSilent) {
            Node<TWMSupplierComplete> p = ThreeWayMatchToolkit.getSupplier4Invoice((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode, (Node<TWMInvoiceImportComplete>)this.model.getNode().getChildNamed(TWMEntryComplete_.invoice));
            if (p != null) {
                ThreeWayMatchToolkit.updateTWMSupplier(p, false, isSilent, this);
            }
        }

        public void valueChanged(Node<?> node) {
            if (node.getName().equals(TWMMatchPanel.FILTER_STATE)) {
                this.setEnabled(this.isEnabled());
            } else if (!node.getName().equals("orders")) {
                try {
                    this.updateSumAndDiff();
                    this.revalidateState(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
            this.addRow(child);
            child.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).addNodeListener((NodeListener)this);
            child.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).addNodeListener((NodeListener)this);
            try {
                this.updateSumAndDiff();
                this.revalidateState(true);
                TWMMatchPanel.this.invoices.revalidate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            this.removeRow(this.getChild4Node(child));
            child.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            child.getChildNamed(new DtoField[]{TWMOrderComplete_.price, PriceComplete_.currency}).removeNodeListener((NodeListener)this);
            Node sup = child.getChildNamed(TWMOrderComplete_.order);
            ThreeWayMatchToolkit.ensurePurchaseOrderRemainingCost((Node<ThreeWayMatchComplete>)TWMMatchPanel.this.matchNode, (Node<PurchaseOrderLight>)sup, false, this);
            OrderSearchRow p = (OrderSearchRow)TWMMatchPanel.this.purchase.getRowPanel4Node(sup);
            if (p != null) {
                p.ensureAttachedState(p.ensureCosts((Node<PurchaseOrderLight>)sup));
            }
            try {
                this.updateSumAndDiff();
                this.revalidateState(true);
                TWMMatchPanel.this.invoices.revalidate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.check.getElement()) {
                if (this.check.getElement().isChecked()) {
                    InnerPopupFactory.showRemarkPopup(source, x, y, this, this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnywayRemark}));
                } else {
                    this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).setValue((Object)TWMInvoiceStateE.NO_SUPPLIER_MATCHED, 0L);
                    ThreeWayMatchToolkit.updateTWMEntry((Node<TWMEntryComplete>)this.model.getNode(), false, null);
                    this.setEnabled(this.isEnabled());
                }
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs != null) {
                if (this.remarkButton != null) {
                    this.remarkButton.popUpClosed(source, xargs);
                    this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).setValue((Object)TWMInvoiceStateE.ACCEPT, 0L);
                }
            } else {
                this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}).setValue((Object)false, 0L);
                this.model.getNode().getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).setValue((Object)TWMInvoiceStateE.NO_SUPPLIER_MATCHED, 0L);
            }
            ThreeWayMatchToolkit.updateTWMEntry((Node<TWMEntryComplete>)this.model.getNode(), false, null);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                InvoiceTableRowImpl.this.state.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.state.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                InvoiceTableRowImpl.this.name.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.name.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                InvoiceTableRowImpl.this.orderNo.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.orderNo.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.orderNo.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.orderNo.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                InvoiceTableRowImpl.this.price.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.price.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(4);
                InvoiceTableRowImpl.this.sum.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.sum.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.sum.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.sum.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(5);
                InvoiceTableRowImpl.this.dif.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.dif.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.dif.setSize(w - 2 * InvoiceTableRowImpl.this.getCellPadding(), (int)InvoiceTableRowImpl.this.dif.getPreferredSize().getHeight());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(6);
                InvoiceTableRowImpl.this.reviewState.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.reviewState.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.reviewState.setSize((int)((double)w - ((double)(2 * InvoiceTableRowImpl.this.getCellPadding() + InvoiceTableRowImpl.this.getInnerCellPadding()) + InvoiceTableRowImpl.this.reviewComment.getPreferredSize().getWidth())), (int)InvoiceTableRowImpl.this.reviewState.getPreferredSize().getHeight());
                InvoiceTableRowImpl.this.reviewComment.setLocation(InvoiceTableRowImpl.this.reviewState.getX() + InvoiceTableRowImpl.this.reviewState.getWidth() + InvoiceTableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.reviewComment.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.reviewComment.setSize(InvoiceTableRowImpl.this.reviewComment.getPreferredSize());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(7);
                InvoiceTableRowImpl.this.check.setLocation(currentX + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.check.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.check.setSize(InvoiceTableRowImpl.this.check.getPreferredSize());
                InvoiceTableRowImpl.this.remarkButton.setLocation(InvoiceTableRowImpl.this.check.getX() + InvoiceTableRowImpl.this.check.getWidth() + InvoiceTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - InvoiceTableRowImpl.this.remarkButton.getPreferredSize().getHeight()) / 2.0));
                InvoiceTableRowImpl.this.remarkButton.setSize(InvoiceTableRowImpl.this.remarkButton.getPreferredSize());
                currentX += w;
                w = InvoiceTableRowImpl.this.model.getParentModel().getColumnWidth(8);
                InvoiceTableRowImpl.this.setControlsX(currentX);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, InvoiceTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class SupplierTableRowImpl
    extends Table2RowPanel
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private StateIndicatorTwoRenderer<TWMSupplierStateE> state;
        private TextLabel supplier;
        private QuantityRenderer volume;
        private RemarkButton remark;

        public SupplierTableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.state = new StateIndicatorTwoRenderer<Node>(m.getNode().getChildNamed(TWMSupplierComplete_.state));
            this.supplier = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMSupplierComplete_.supplier, SupplierLight_.name}));
            this.volume = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(TWMSupplierComplete_.volume), (Converter<?, ?>)ConverterRegistry.getConverter(PriceConverter3.class));
            this.remark = new RemarkButton((Node<String>)m.getNode().getChildNamed(TWMSupplierComplete_.comment));
            m.getNode().getChildNamed(TWMSupplierComplete_.entries).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(TWMSupplierComplete_.entries).getAllChildAddEvents((NodeListener)this);
            this.setLayout(new Layout());
            this.add(this.supplier);
            this.add(this.state);
            this.add(this.volume);
            this.add(this.remark);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.state.getNode().getValue();
                }
                case 1: {
                    return this.supplier.getText();
                }
                case 2: {
                    if (this.volume.getNode().getChildNamed(PriceComplete_.price).getValue() == null) {
                        return 0.0;
                    }
                    return this.volume.getNode().getChildNamed(PriceComplete_.price).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.supplier.setEnabled(isEnabled);
            this.volume.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.getModel().getNode().removeNodeListenerRecursively((NodeListener)this);
            this.state.kill();
            this.state = null;
            this.supplier.kill();
            this.supplier = null;
            this.volume.kill();
            this.volume = null;
            this.remark.kill();
            this.remark = null;
        }

        public void valueChanged(Node<?> node) {
            ThreeWayMatchToolkit.updateTWMSupplier((Node<TWMSupplierComplete>)this.model.getNode(), false, false, null);
        }

        public void childAdded(Node<?> source, Node<?> child) {
            child.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).addNodeListener((NodeListener)this);
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            child.getChildNamed(new DtoField[]{TWMEntryComplete_.invoice, TWMInvoiceImportComplete_.state}).removeNodeListener((NodeListener)this);
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                SupplierTableRowImpl.this.state.setLocation(SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.state.setSize(w - 2 * SupplierTableRowImpl.this.getCellPadding(), (int)SupplierTableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                SupplierTableRowImpl.this.supplier.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.supplier.setSize(w - 2 * SupplierTableRowImpl.this.getCellPadding(), (int)SupplierTableRowImpl.this.supplier.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                SupplierTableRowImpl.this.volume.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.volume.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.volume.setSize(w - 2 * SupplierTableRowImpl.this.getCellPadding(), (int)SupplierTableRowImpl.this.volume.getPreferredSize().getHeight());
                currentX += w;
                w = SupplierTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                SupplierTableRowImpl.this.remark.setLocation(currentX + SupplierTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - SupplierTableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                SupplierTableRowImpl.this.remark.setSize(w - 2 * SupplierTableRowImpl.this.getCellPadding(), (int)SupplierTableRowImpl.this.remark.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, SupplierTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int borderWidth = 20;
            TWMMatchPanel.this.supplierTitle.setLocation(0, 0);
            TWMMatchPanel.this.supplierTitle.setSize(300, (int)TWMMatchPanel.this.supplierTitle.getPreferredSize().getHeight());
            TWMMatchPanel.this.suppliers.setLocation(0, TWMMatchPanel.this.supplierTitle.getHeight());
            TWMMatchPanel.this.suppliers.setSize(300, parent.getHeight() - TWMMatchPanel.this.supplierTitle.getHeight());
            TWMMatchPanel.this.sep1.setLocation(TWMMatchPanel.this.suppliers.getWidth(), 0);
            TWMMatchPanel.this.sep1.setSize(borderWidth, parent.getHeight());
            int purchaseWidth = 350;
            TWMMatchPanel.this.purchaseTitle.setLocation(parent.getWidth() - purchaseWidth, 0);
            TWMMatchPanel.this.purchaseTitle.setSize(purchaseWidth, (int)TWMMatchPanel.this.purchaseTitle.getPreferredSize().getHeight());
            TWMMatchPanel.this.purchase.setLocation(parent.getWidth() - purchaseWidth, TWMMatchPanel.this.purchaseTitle.getHeight());
            TWMMatchPanel.this.purchase.setSize(purchaseWidth, parent.getHeight() - TWMMatchPanel.this.purchaseTitle.getHeight());
            TWMMatchPanel.this.sep2.setLocation(TWMMatchPanel.this.purchase.getX() - borderWidth, 0);
            TWMMatchPanel.this.sep2.setSize(borderWidth, parent.getHeight());
            int fadeH = TWMMatchPanel.this.invoiced.getImage(0).getHeight();
            int orderH = 3 * fadeH;
            orderH += 200;
            orderH = (int)((double)orderH + TWMMatchPanel.this.orderDetailsTitle.getPreferredSize().getHeight());
            TWMMatchPanel.this.invoiceTitle.setLocation(TWMMatchPanel.this.sep1.getX() + TWMMatchPanel.this.sep1.getWidth(), 0);
            TWMMatchPanel.this.invoiceTitle.setSize(parent.getWidth() - (TWMMatchPanel.this.suppliers.getWidth() + TWMMatchPanel.this.purchase.getWidth() + TWMMatchPanel.this.sep1.getWidth() + TWMMatchPanel.this.sep2.getWidth()), (int)TWMMatchPanel.this.invoiceTitle.getPreferredSize().getHeight());
            TWMMatchPanel.this.invoices.setLocation(TWMMatchPanel.this.invoiceTitle.getX(), TWMMatchPanel.this.invoiceTitle.getHeight());
            TWMMatchPanel.this.invoices.setSize(TWMMatchPanel.this.invoiceTitle.getWidth(), parent.getHeight() - (orderH + TWMMatchPanel.this.invoiceTitle.getHeight()));
            TWMMatchPanel.this.orderDetailsTitle.setLocation(TWMMatchPanel.this.invoiceTitle.getX(), TWMMatchPanel.this.invoices.getY() + TWMMatchPanel.this.invoices.getHeight());
            TWMMatchPanel.this.orderDetailsTitle.setSize(TWMMatchPanel.this.invoiceTitle.getWidth(), (int)TWMMatchPanel.this.orderDetailsTitle.getPreferredSize().getHeight());
            TWMMatchPanel.this.orderDetails.setLocation(TWMMatchPanel.this.orderDetailsTitle.getX(), TWMMatchPanel.this.orderDetailsTitle.getY() + TWMMatchPanel.this.orderDetailsTitle.getHeight());
            TWMMatchPanel.this.orderDetails.setSize(TWMMatchPanel.this.orderDetailsTitle.getWidth(), parent.getHeight() - (TWMMatchPanel.this.orderDetails.getY() + fadeH * 3));
            int tw = TWMMatchPanel.this.orderDetails.getModel().getColumnWidth(0) + TWMMatchPanel.this.orderDetails.getX();
            int w = TWMMatchPanel.this.invoices.getModel().getColumnWidth(0) + TWMMatchPanel.this.invoices.getX();
            w += TWMMatchPanel.this.invoices.getModel().getColumnWidth(1);
            int y = (int)((double)(parent.getHeight() - 3 * fadeH) + ((double)fadeH - TWMMatchPanel.this.invoicedText.getPreferredSize().getHeight()) / 2.0);
            TWMMatchPanel.this.invoicedText.setLocation(tw + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.invoicedText.setSize(TWMMatchPanel.this.invoicedText.getPreferredSize());
            TWMMatchPanel.this.invoicedSum.setLocation((w += TWMMatchPanel.this.invoices.getModel().getColumnWidth(2)) + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.invoicedSum.setSize(TWMMatchPanel.this.invoicedSum.getPreferredSize());
            y = (int)((double)(parent.getHeight() - 2 * fadeH) + ((double)fadeH - TWMMatchPanel.this.checkedText.getPreferredSize().getHeight()) / 2.0);
            TWMMatchPanel.this.checkedText.setLocation(tw + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.checkedText.setSize(TWMMatchPanel.this.checkedText.getPreferredSize());
            TWMMatchPanel.this.realSum.setLocation((w += TWMMatchPanel.this.invoices.getModel().getColumnWidth(3)) + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.realSum.setSize(TWMMatchPanel.this.realSum.getPreferredSize());
            y = (int)((double)(parent.getHeight() - fadeH) + ((double)fadeH - TWMMatchPanel.this.differenceText.getPreferredSize().getHeight()) / 2.0);
            TWMMatchPanel.this.differenceText.setLocation(tw + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.differenceText.setSize(TWMMatchPanel.this.differenceText.getPreferredSize());
            TWMMatchPanel.this.differenceSum.setLocation((w += TWMMatchPanel.this.invoices.getModel().getColumnWidth(4)) + TWMMatchPanel.this.invoices.getCellPadding(), y);
            TWMMatchPanel.this.differenceSum.setSize(TWMMatchPanel.this.differenceSum.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

