/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.tradegoods.TradeGoodsModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.AssociatedOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.OrderRemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.ProductsDetailsPanel2;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.TradeGoodsSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.TradeGoodsAccess;
import ch.icit.pegasus.server.core.dtos.search.TradeGoodsSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class TradeGoodsModule
extends ScreenTableView<TradeGoodsLight, TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_NONAME = "noname_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private static final String FILTER_STATE = "state";
    private String searchCriteria1 = null;
    private CustomerLight searchCriteria2 = null;
    private PeriodComplete searchCriteria3 = null;
    private ModificationStateE searchCriteria4;
    private TitledPeriodEditor periodEditor;

    public TradeGoodsModule() {
        super(TradeGoodsLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodEditor.kill();
        this.periodEditor = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return TradeGoodsAccess.MODULE_TRADE_GOODS;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.NUMBER.toString() + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NONAME, Words.NUMBER_OR_NAME, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodEditor.setCheckBoxEnabled();
        ComboBox b = ComboBoxFactory.getModificationStateComboBox(true);
        this.filterChain.addSelectionComboBox(b, 90, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<TradeGoodsLight, TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria3 = null;
            this.searchCriteria4 = null;
            this.periodEditor.setCheckBoxChecked(false);
        } else if (name == FILTER_NONAME) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.searchCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_PERIOD) {
            this.searchCriteria3 = new PeriodComplete(((TitledPeriodEditor)value).getStartDate(), ((TitledPeriodEditor)value).getEndDate());
        } else if (name == FILTER_STATE) {
            this.searchCriteria4 = value instanceof ModificationStateE ? (ModificationStateE)value : null;
        }
        TradeGoodsSearchConfiguration c = new TradeGoodsSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer((CustomerReference)this.searchCriteria2);
        c.setState(this.searchCriteria4);
        try {
            int i = Integer.valueOf(this.searchCriteria1);
            c.setNumber(Integer.valueOf(i));
        }
        catch (NumberFormatException e) {
            c.setName(this.searchCriteria1);
        }
        c.setPeriod(this.searchCriteria3);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<TradeGoodsLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(TradeGoodsSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<TradeGoodsLight> model) {
        return false;
    }

    @Override
    public boolean isDeletable(RowModel<TradeGoodsLight> model) {
        return super.isDeletable(model) && ((TradeGoodsLight)model.getNode().getValue()).getState() == ModificationStateE.DRAFT && ((TradeGoodsLight)model.getNode().getValue()).getIsInvoiced() == false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<TradeGoodsLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<TradeGoodsLight> rowEditor = new MessageProvidedRowEditor<TradeGoodsLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (rowEditor.getModel().isAddRow()) {
                TemplateDetailsPanel p1 = new TemplateDetailsPanel((RowEditor)rowEditor, p);
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                SpecificationDetailsPanel p2 = new SpecificationDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                AssociatedOrderDetailsPanel p3 = new AssociatedOrderDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                c1.add((Component)p2, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c1.add((Component)p3, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                ProductsDetailsPanel2 p4 = new ProductsDetailsPanel2((RowEditor<TradeGoodsLight>)rowEditor, p);
                OrderRemarkDetailsPanel p5 = new OrderRemarkDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                rowEditor.add(p1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.add(p4, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.add(p5, (Object)new TableLayoutConstraint(0, 3, 1.0, 1.0));
                rowEditor.addToFocusQueue(p1);
                rowEditor.addToFocusQueue(p2);
                rowEditor.addToFocusQueue(p3);
                rowEditor.addToFocusQueue(p4);
                rowEditor.addToFocusQueue(p5);
            } else {
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                SpecificationDetailsPanel p2 = new SpecificationDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                AssociatedOrderDetailsPanel p3 = new AssociatedOrderDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                c1.add((Component)p2, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c1.add((Component)p3, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                ProductsDetailsPanel2 p4 = new ProductsDetailsPanel2((RowEditor<TradeGoodsLight>)rowEditor, p);
                OrderRemarkDetailsPanel p5 = new OrderRemarkDetailsPanel((RowEditor<TradeGoodsLight>)rowEditor, p);
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(p4, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.add(p5, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
                rowEditor.addToFocusQueue(p2);
                rowEditor.addToFocusQueue(p3);
                rowEditor.addToFocusQueue(p4);
                rowEditor.addToFocusQueue(p5);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new TradeGoodsModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.NUMBER, TradeGoodsLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo("", "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.STATE, TradeGoodsLight_.state, TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.NAME, TradeGoodsLight_.sellName, 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.CUSTOMER, TradeGoodsLight_.customer, 80, 80, 80));
        columns.add(new TableColumnInfo(Words.DATE, "", (Class)DateConverter.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.DATE, TradeGoodsLight_.sellDate, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth));
        columns.add(new TableColumnInfo(Words.COST, "", (Class)PriceConverter1.class, (Enum<?>)TradeGoodsSearchConfiguration.TRADE_GOODS_COLUMN.COST, TradeGoodsLight_.estimatedCost, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        return columns;
    }
}

