/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tradegoods.TradeGoodsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import java.sql.Date;

public class TradeGoodsModuleDataHandler
extends DefaultDataHandler<TradeGoodsLight, TradeGoodsComplete> {
    public TradeGoodsModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Trade Goods");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TradeGoodsLight l = (TradeGoodsLight)node.getValue(TradeGoodsLight.class);
                TradeGoodsComplete c = (TradeGoodsComplete)((TradeGoodsServiceManager)ServiceManagerRegistry.getService(TradeGoodsServiceManager.class)).getComplete(l).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<TradeGoodsLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TradeGoodsComplete d = (TradeGoodsComplete)node.getValue(TradeGoodsComplete.class);
                TradeGoodsComplete dto = (TradeGoodsComplete)((TradeGoodsServiceManager)ServiceManagerRegistry.getService(TradeGoodsServiceManager.class)).updateTradeGoods(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<TradeGoodsComplete> createEmptyNode() {
        TradeGoodsComplete d = new TradeGoodsComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setState(ModificationStateE.DRAFT);
        d.setSellDate(new Date(System.currentTimeMillis()));
        d.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<TradeGoodsComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TradeGoodsComplete d = (TradeGoodsComplete)node.getValue(TradeGoodsComplete.class);
                if (d.getEligibleLocations().isEmpty()) {
                    d.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                TradeGoodsComplete dto = (TradeGoodsComplete)((TradeGoodsServiceManager)ServiceManagerRegistry.getService(TradeGoodsServiceManager.class)).createTradeGoods(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TradeGoodsModuleDataHandler.this.setCurrentLoadMaximum(3);
                TradeGoodsModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                TradeGoodsModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                TradeGoodsModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return TradeGoodsModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<TradeGoodsComplete> resetData(Node<TradeGoodsComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Class<TradeGoodsComplete> getCommittingClass() {
        return TradeGoodsComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<TradeGoodsLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

