/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods.details;

import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.utils.PriceLoader;
import ch.icit.pegasus.client.gui.modules.tradegoods.details.utils.TotalCostConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultFootablePanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ProductInfoButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodProductComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodProductComplete_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProductsDetailsPanel2
extends StateDependantTableDetailsPanel<TradeGoodsLight> {
    private static final long serialVersionUID = -4552350129677539999L;
    private PriceLoader loader;
    private FootablePanel footerPanel;
    private BackgroundFadeSkin fade;
    private ReloadablePriceView costs;

    public ProductsDetailsPanel2(RowEditor<TradeGoodsLight> editor, RDProvider provider) {
        super(editor, provider, true, true, false, true);
        this.setTitleText(Words.PRODUCTS);
        this.setOverridePrefHeight(350);
        this.loader = new PriceLoader();
        this.fade = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.costs = new ReloadablePriceView((LoadingGroup)this.loader, TotalCostConverter.class);
        this.costs.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        this.costs.setNode(null);
        this.costs.setProgress(1.0f);
        this.setCalculation();
        this.loader.setTotalCost(this.costs);
        this.footerPanel = new DefaultFootablePanel(){
            private static final long serialVersionUID = 1258195029006829737L;

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                DrawToolkit.setAlphaComposite(g2, this.getFader());
                ProductsDetailsPanel2.this.fade.paint(g2, 0, this.getHeight() - ProductsDetailsPanel2.this.fade.getImage(11).getHeight(), this.getWidth(), 11);
                this.paintChildren(g2);
            }
        };
        this.footerPanel.setLayout(new Layout());
        this.footerPanel.setProgress(1.0f);
        this.footerPanel.add(this.costs);
        this.table.setUseWriteAccessRight(true);
        this.table.setFooterPanel(this.footerPanel);
    }

    public boolean isDeletable() {
        return this.provider.isDeletable(TradeGoodsComplete_.tradeGoodProducts);
    }

    public boolean isOrderChangable() {
        return this.provider.isOrderChangable(TradeGoodsComplete_.tradeGoodProducts.getFieldName());
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return TradeGoodsLight_.state;
    }

    private void setCalculation() {
        this.costs.setRunnable(new CalculationRunnable(){

            @Override
            public void run() {
                PriceComplete c = null;
                if (ProductsDetailsPanel2.this.costs.getNode() == null) {
                    return;
                }
                c = ProductsDetailsPanel2.this.costs.getNode().getValue() != null ? (PriceComplete)ProductsDetailsPanel2.this.costs.getNode().getValue() : new PriceComplete();
                if (c.getCurrency() == null) {
                    c.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                }
                if (c.getPrice() == null) {
                    c.setPrice(Double.valueOf(0.0));
                }
                double p = 0.0;
                Iterator it = ProductsDetailsPanel2.this.editor.getModel().getNode().getChildNamed(TradeGoodsComplete_.tradeGoodProducts).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node e = (Node)it.next();
                    if (e.getChildNamed(TradeGoodProductComplete_.cost) == null || e.getChildNamed(new DtoField[]{TradeGoodProductComplete_.cost, PriceComplete_.price}) == null || e.getChildNamed(new DtoField[]{TradeGoodProductComplete_.cost, PriceComplete_.price}).getValue() == null) continue;
                    p += ((Double)e.getChildNamed(new DtoField[]{TradeGoodProductComplete_.cost, PriceComplete_.price}).getValue()).doubleValue();
                }
                c.setPrice(Double.valueOf(p));
                ProductsDetailsPanel2.this.costs.getNode().setValue((Object)c, 0L);
                ProductsDetailsPanel2.this.costs.getNode().updateNode();
            }

            @Override
            public boolean isAlive() {
                return !ProductsDetailsPanel2.this.costs.isKilled();
            }
        });
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(TradeGoodsComplete_.tradeGoodProducts));
        this.loader.updateMe(this.costs);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.SALES, null, null, null, "", 150, 150, 150));
        int tw = TableColumnInfo.getSortableColumnWidth(this.table);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
        table.setUseWriteAccessRight(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        if (this.editor.getModel().getNode().getChildNamed(TradeGoodsComplete_.customer).getValue() == null) {
            InnerPopupFactory.showErrorDialog(Words.PLEASE_SELECT_CUSTOMER_BEFORE_ADD_PRODUCTS, (Component)source);
            return;
        }
        TradeGoodProductComplete p = new TradeGoodProductComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setSequenceNumber(Integer.valueOf(this.table.getRowCount() + 1));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl r = (TableRowImpl)p;
            List<ScreenValidationObject> b = r.validateRow();
            validationObjects.addAll(b);
        }
        return validationObjects;
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model, this.isOrderChangable(), this.isDeletable());
        return p;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, ProductsDetailsPanel2.this.fade.getImage(0).getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductsDetailsPanel2.this.costs.setLocation(parent.getWidth() - 200, (int)((double)parent.getHeight() - ProductsDetailsPanel2.this.costs.getPreferredSize().getHeight()) / 2);
            ProductsDetailsPanel2.this.costs.setSize(200, (int)ProductsDetailsPanel2.this.costs.getPreferredSize().getHeight());
        }
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements TextFieldListener {
        private static final long serialVersionUID = 1L;
        private final TextLabel no;
        private final SearchTextField2<ProductComplete> product;
        private final ArticleProductInfoButton infoButton;
        private final TextField amount;
        private final TextLabel st;
        private final ReloadablePriceView cost;

        public TableRowImpl(Table2RowModel m, boolean isOrderChangable, boolean isDeletable) {
            super(m, isOrderChangable, isDeletable);
            this.setSortAttributeName(TradeGoodProductComplete_.sequenceNumber);
            this.setStartEndOffset(1, 0);
            this.no = new TextLabel(m.getNode().getChildNamed(TradeGoodProductComplete_.sequenceNumber));
            this.product = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(TradeGoodProductComplete_.product));
            Object[] o = new Object[3];
            o[2] = ProductsDetailsPanel2.this.editor.getModel().getNode().getChildNamed(TradeGoodsComplete_.customer);
            this.product.setAdditionalSearchField(o);
            this.infoButton = new ProductInfoButton(m.getNode().getChildNamed(TradeGoodProductComplete_.product), null, ProductToolkit.getAllTypes());
            this.amount = new TextField(null, TextFieldType.INT);
            this.amount.setNode(m.getNode().getChildNamed(TradeGoodProductComplete_.quantity));
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            this.st = new TextLabel(s.getPieceUnit().getShortName());
            this.amount.addTextFieldListener(this);
            this.cost = new ReloadablePriceView((LoadingGroup)ProductsDetailsPanel2.this.loader, ConverterRegistry.getConverter(PriceConverter1.class));
            this.cost.setNode(m.getNode().getChildNamed(TradeGoodProductComplete_.cost));
            this.setCalculation();
            ProductsDetailsPanel2.this.loader.addProduct(this.cost);
            this.setLayout(new InnerLayout());
            ProductsDetailsPanel2.this.loader.updateMe(this.cost);
            this.add(this.no);
            this.add(this.product);
            this.add(this.infoButton);
            this.add(this.amount);
            this.add(this.st);
            this.add(this.cost);
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(TradeGoodProductComplete_.product).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_PRODUCT_IS_SET_ON_ROW, (Object[])new Object[]{ProductsDetailsPanel2.this.table.getRowIndex(this) + 1})));
            }
            return validationObjects;
        }

        private void setCalculation() {
            this.cost.setRunnable(new CalculationRunnable(){

                @Override
                public void run() {
                    PriceComplete c = null;
                    if (TableRowImpl.this.cost.getNode().getValue() != null) {
                        c = (PriceComplete)TableRowImpl.this.cost.getNode().getValue();
                    } else {
                        c = new PriceComplete();
                        TableRowImpl.this.cost.getNode().setValue((Object)c, 0L);
                    }
                    if (c.getCurrency() == null) {
                        c.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                    }
                    if (c.getPrice() == null) {
                        c.setPrice(Double.valueOf(0.0));
                    }
                    if (TableRowImpl.this.model.getNode().getChildNamed(TradeGoodProductComplete_.quantity).getValue() == null) {
                        TableRowImpl.this.model.getNode().getChildNamed(TradeGoodProductComplete_.quantity).setValue((Object)0, 0L);
                    }
                    Integer st = (Integer)TableRowImpl.this.model.getNode().getChildNamed(TradeGoodProductComplete_.quantity).getValue();
                    ProductComplete l = (ProductComplete)TableRowImpl.this.model.getNode().getChildNamed(TradeGoodProductComplete_.product).getValue();
                    if (l != null) {
                        PriceComplete productPrice = ProductPriceCalculationToolkit.getProductPrice((ProductVariantLight)l.getCurrentVariant(), (CustomerLight)((CustomerLight)ProductsDetailsPanel2.this.editor.getModel().getNode().getChildNamed(TradeGoodsComplete_.customer).getValue()));
                        if (productPrice != null) {
                            c.setPrice(productPrice.getPrice());
                        } else {
                            c.setPrice(Double.valueOf(0.0));
                        }
                        if (c.getPrice() == null) {
                            c.setPrice(Double.valueOf(0.0));
                        }
                        c.setPrice(Double.valueOf(c.getPrice() * (double)st.intValue()));
                        TableRowImpl.this.cost.getNode().getChildNamed(PriceComplete_.price).setValue((Object)c.getPrice(), 0L);
                        TableRowImpl.this.cost.getNode().setValue((Object)c, 0L);
                        TableRowImpl.this.cost.getNode().updateNode();
                    }
                }

                @Override
                public boolean isAlive() {
                    return !TableRowImpl.this.isKilled();
                }
            });
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.product.kill();
            this.infoButton.kill();
            this.amount.kill();
            this.st.kill();
            this.cost.kill();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.product);
            CheckedListAdder.addToList(focusList, this.amount);
            List<Component> b = super.getFocusComponents();
            if (b != null) {
                focusList.addAll(b);
            }
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.product.requestFocusInWindowNow();
        }

        @Override
        public boolean isRowValid() {
            if (this.product.isItemSelected()) {
                return true;
            }
            this.product.setInvalid();
            return false;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.no.setEnabled(isEnabled);
            this.product.setEnabled(isEnabled);
            this.infoButton.setEnabled(this.model.getParentModel().getTable().isEnabled());
            this.amount.setEnabled(isEnabled);
            this.st.setEnabled(isEnabled);
            this.cost.setEnabled(isEnabled);
        }

        @Override
        public void valueChanged(AbstractTextField field) {
            ProductsDetailsPanel2.this.loader.updateMe(this.cost);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.no.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.product.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.product.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.product.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.product.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.product.getX() + TableRowImpl.this.product.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.st.getPreferredSize().getHeight())), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                TableRowImpl.this.st.setLocation(TableRowImpl.this.amount.getX() + TableRowImpl.this.amount.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.st.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.st.setSize(TableRowImpl.this.st.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.cost.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cost.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cost.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cost.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

