/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalutationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.FilterAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightsE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DefaultFilterDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.util.Tuple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class UserAdminModuleDataHandler
extends DefaultDataHandler<UserReference, UserComplete> {
    public UserAdminModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<UserReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserComplete d = (UserComplete)node.getValue(UserComplete.class);
                boolean isCurrent = false;
                if (((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser() != null && ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().equals((Object)d)) {
                    isCurrent = true;
                }
                if (d.getContact() == null) {
                    d.setContact(new ContactComplete());
                }
                Node pwd3 = node.getChildNamed(DtoFieldConstants.pwd3);
                Node locationAccessRight = node.getChildNamed(DtoFieldConstants.currentLocation);
                if (locationAccessRight != null) {
                    locationAccessRight.commitThis(LocationAccessRightComplete.class);
                    LocationAccessRightComplete cl = (LocationAccessRightComplete)locationAccessRight.getValue(LocationAccessRightComplete.class);
                    if (cl != null) {
                        HashSet<ModuleDefinitionComplete> defs = new HashSet<ModuleDefinitionComplete>();
                        Iterator it = cl.getModules().iterator();
                        while (it.hasNext()) {
                            ModuleAccessRightComplete r = (ModuleAccessRightComplete)it.next();
                            if (!defs.contains(r.getModule())) {
                                defs.add(r.getModule());
                            } else {
                                it.remove();
                            }
                            HashSet<DataRightDefinitionComplete> accessFields = new HashSet<DataRightDefinitionComplete>();
                            Iterator it2 = r.getAccessRights().iterator();
                            while (it2.hasNext()) {
                                DataAccessRightComplete af = (DataAccessRightComplete)it2.next();
                                if (!accessFields.contains(af.getDataAccessRight())) {
                                    accessFields.add(af.getDataAccessRight());
                                    continue;
                                }
                                it2.remove();
                            }
                            HashSet<Tuple> dataFields = new HashSet<Tuple>();
                            Iterator it3 = r.getFieldAccessRights().iterator();
                            while (it3.hasNext()) {
                                DataFieldAccessRightComplete df = (DataFieldAccessRightComplete)it3.next();
                                if (!dataFields.contains(new Tuple((Object)df.getField(), (Object)df.getAccessRight()))) {
                                    dataFields.add(new Tuple((Object)df.getField(), (Object)df.getAccessRight()));
                                    continue;
                                }
                                it3.remove();
                            }
                            Iterator it4 = r.getSubModules().iterator();
                            HashSet<SubModuleDefinitionComplete> subModules = new HashSet<SubModuleDefinitionComplete>();
                            while (it4.hasNext()) {
                                SubModuleAccessRightComplete sm = (SubModuleAccessRightComplete)it4.next();
                                if (!subModules.contains(sm.getModule())) {
                                    subModules.add(sm.getModule());
                                    continue;
                                }
                                it4.remove();
                            }
                        }
                        LocationAccessRightComplete locationAccessRightComplete = (LocationAccessRightComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).saveUserRights(cl).getValue();
                    }
                }
                d = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).update((UserReference)d).getValue();
                if (isCurrent) {
                    ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).setCurrentUser(d);
                }
                if (d != null) {
                    node.removeExistingValues();
                    node.setValue((Object)d, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected LocationAccessRightComplete mergeRights(LocationAccessRightComplete source, LocationAccessRightComplete destination) {
        HashSet<String> usedModules = new HashSet<String>();
        for (ModuleAccessRightComplete m : source.getModules()) {
            ModuleAccessRightComplete om = this.getAccessRight(m, destination.getModules());
            if (om == null) {
                om = new ModuleAccessRightComplete();
                om.setModule(m.getModule());
                om.setClientOId(Long.valueOf(ADTO.getNextId()));
                destination.getModules().add(om);
            }
            this.mergeAccessRights(m.getAccessRights(), om);
            this.mergeAccessFields(m.getFieldAccessRights(), om);
            this.mergeFilter(m.getFilters(), om);
            this.mergeSubModule(m.getSubModules(), om);
            this.mergePreferredSubModule(m.getPreferredSubModule(), om);
            usedModules.add(m.getModule().getInvokingName());
        }
        return destination;
    }

    private void mergePreferredSubModule(SubModuleAccessRightComplete preferredSubModule, ModuleAccessRightComplete om) {
        if (preferredSubModule == null) {
            return;
        }
        for (SubModuleAccessRightComplete s : om.getSubModules()) {
            if (!preferredSubModule.equals((Object)s)) continue;
            om.setPreferredSubModule(s);
            return;
        }
    }

    private void mergeSubModule(List<SubModuleAccessRightComplete> subModules, ModuleAccessRightComplete om) {
        HashSet<String> usedSubModules = new HashSet<String>();
        for (SubModuleAccessRightComplete s : subModules) {
            SubModuleAccessRightComplete os = this.getSubModule(s, om.getSubModules());
            if (os == null) {
                os = new SubModuleAccessRightComplete();
                os.setClientOId(Long.valueOf(ADTO.getNextId()));
                os.setModule(s.getModule());
                om.getSubModules().add(os);
            }
            usedSubModules.add(s.getModule().getInvokingName());
        }
        Iterator it = om.getSubModules().iterator();
        while (it.hasNext()) {
            SubModuleAccessRightComplete s;
            s = (SubModuleAccessRightComplete)it.next();
            if (usedSubModules.contains(s.getModule().getInvokingName())) continue;
            it.remove();
        }
    }

    private SubModuleAccessRightComplete getSubModule(SubModuleAccessRightComplete s, List<SubModuleAccessRightComplete> subModules) {
        for (SubModuleAccessRightComplete r : subModules) {
            if (!r.getModule().getInvokingName().equals(s.getModule().getInvokingName())) continue;
            return r;
        }
        return null;
    }

    private void mergeFilter(List<FilterAccessRightComplete> filters, ModuleAccessRightComplete om) {
        HashSet<DefaultFilterDefinitionComplete> usedSubModules = new HashSet<DefaultFilterDefinitionComplete>();
        for (FilterAccessRightComplete far : filters) {
            FilterAccessRightComplete of = this.getFilter(far, om.getFilters());
            if (of == null) {
                of = new FilterAccessRightComplete();
                of.setClientOId(Long.valueOf(ADTO.getNextId()));
                of.setFilter(far.getFilter());
                om.getFilters().add(of);
            }
            usedSubModules.add(far.getFilter());
        }
        Iterator it = om.getFilters().iterator();
        while (it.hasNext()) {
            FilterAccessRightComplete s = (FilterAccessRightComplete)it.next();
            if (usedSubModules.contains(s.getFilter())) continue;
            it.remove();
        }
    }

    private FilterAccessRightComplete getFilter(FilterAccessRightComplete far, List<FilterAccessRightComplete> filters) {
        for (FilterAccessRightComplete fa : filters) {
            if (!fa.getFilter().equals((Object)far.getFilter())) continue;
            return fa;
        }
        return null;
    }

    private void mergeAccessFields(List<DataFieldAccessRightComplete> fieldAccessRights, ModuleAccessRightComplete om) {
        HashSet<Tuple> usedSubModules = new HashSet<Tuple>();
        for (DataFieldAccessRightComplete far : fieldAccessRights) {
            DataFieldAccessRightComplete of = this.getAccessField(far, om.getFieldAccessRights());
            if (of == null) {
                of = new DataFieldAccessRightComplete();
                of.setClientOId(Long.valueOf(ADTO.getNextId()));
                of.setField(far.getField());
                om.getFieldAccessRights().add(of);
            }
            of.setAccessRight(far.getAccessRight());
            usedSubModules.add(new Tuple((Object)far.getField().getName(), (Object)far.getAccessRight()));
        }
        Iterator it = om.getFieldAccessRights().iterator();
        while (it.hasNext()) {
            DataFieldAccessRightComplete s = (DataFieldAccessRightComplete)it.next();
            if (usedSubModules.contains(new Tuple((Object)s.getField().getName(), (Object)s.getAccessRight()))) continue;
            it.remove();
        }
    }

    private DataFieldAccessRightComplete getAccessField(DataFieldAccessRightComplete far, List<DataFieldAccessRightComplete> fieldAccessRights) {
        for (DataFieldAccessRightComplete f : fieldAccessRights) {
            if (!f.getField().getName().equals(far.getField().getName())) continue;
            return f;
        }
        return null;
    }

    private void mergeAccessRights(List<DataAccessRightComplete> accessRights, ModuleAccessRightComplete om) {
        HashSet<DataRightsE> usedSubModules = new HashSet<DataRightsE>();
        for (DataAccessRightComplete dataRight : accessRights) {
            DataAccessRightComplete or = this.getAccessRight(dataRight, om.getAccessRights());
            if (or != null) continue;
            or = new DataAccessRightComplete();
            or.setClientOId(Long.valueOf(ADTO.getNextId()));
            or.setDataAccessRight(dataRight.getDataAccessRight());
            om.getAccessRights().add(or);
            usedSubModules.add(dataRight.getDataAccessRight().getAccessRight());
        }
        Iterator it = om.getAccessRights().iterator();
        while (it.hasNext()) {
            DataAccessRightComplete s = (DataAccessRightComplete)it.next();
            if (usedSubModules.contains(s.getDataAccessRight().getAccessRight())) continue;
            it.remove();
        }
    }

    private DataAccessRightComplete getAccessRight(DataAccessRightComplete dataRight, List<DataAccessRightComplete> accessRights) {
        for (DataAccessRightComplete ar : accessRights) {
            boolean ba = ar.getDataAccessRight().getAccessRight().equals((Object)dataRight.getDataAccessRight().getAccessRight());
            if (!ba) continue;
            return ar;
        }
        return null;
    }

    private ModuleAccessRightComplete getAccessRight(ModuleAccessRightComplete source, List<ModuleAccessRightComplete> modules) {
        for (ModuleAccessRightComplete m : modules) {
            if (!m.getModule().getInvokingName().equals(source.getModule().getInvokingName())) continue;
            return m;
        }
        return null;
    }

    @Override
    public Node<UserComplete> createEmptyNode() {
        UserComplete d = new UserComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setContact(new ContactComplete());
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<UserComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserComplete d = (UserComplete)node.getValue();
                String pwd = (String)node.getChildNamed(DtoFieldConstants.pwd1).getValue();
                if (Boolean.TRUE.equals(d.getIsUserRole())) {
                    pwd = "";
                }
                UserComplete dto = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).create(d, pwd).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserAdminModuleDataHandler.this.setCurrentLoadMaximum(5);
                UserAdminModuleDataHandler.this.showNextMessage(progressListener);
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getAllRegisteredModulesCached();
                UserAdminModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                UserAdminModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SalutationComplete.class);
                UserAdminModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                UserAdminModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return UserAdminModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh User");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UserLight l = (UserLight)node.getValue(UserLight.class);
                UserComplete c = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUser(new UserReference(l.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<UserComplete> resetData(Node<UserComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Class<UserComplete> getCommittingClass() {
        return UserComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<UserReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

