/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details;

import ch.icit.pegasus.client.comparators.ModuleDefinitionComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.useradmin.details.StoreRightsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.DataRightDefinition;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.FieldsDefinition;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.SmartDefinition;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextButton;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModuleRightsDetailsPanel
extends DefaultDetailsPanel<UserLight>
implements Table2RowSelectionListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final StoreRightsDetailsPanel storeRightsDetailsPanel;
    private Table2 modules;
    private SmartDefinition smarts;
    private FieldsDefinition fields;
    private DataRightDefinition dataRights;
    private RDTextButton selectAll;
    private boolean isAddAll;
    private LoadingAnimation animation;
    private boolean isNodeSet;
    private Node<LocationAccessRightComplete> node;

    public ModuleRightsDetailsPanel(RowEditor<UserLight> editor, StoreRightsDetailsPanel storeRightsDetailsPanel, RDProvider provider) {
        super(editor, provider);
        this.storeRightsDetailsPanel = storeRightsDetailsPanel;
        this.setTitleText(Words.MODULE_ACCESS_RIGHTS);
        this.selectAll = new RDTextButton(provider);
        this.selectAll.setOverrideName(UserComplete_.modules);
        this.selectAll.setNode(null);
        this.selectAll.addButtonListener(this);
        this.ensureButtonType();
        this.modules = new Table2(false, "", false, false, "");
        this.modules.setProvider(provider);
        this.modules.setOverrideName(UserComplete_.modules);
        this.modules.setUseWriteAccessRight(true);
        this.smarts = new SmartDefinition(provider);
        this.fields = new FieldsDefinition(provider);
        this.dataRights = new DataRightDefinition(provider);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.MODULE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.ACCESS, null, null, null, "", 65, 65, 65));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.modules.setModel(new Table2Model(columns, model -> new TableRowImpl(model, Table2RowPanel.TableControlsType.ONE)));
        this.modules.getModel().addTableSelectionListener(this);
        this.modules.setComparator(ComparatorRegistry.getComparator(ModuleDefinitionComparator.class));
        this.setCustomLayouter(new Layout());
        this.addToView(this.modules);
        this.addToView(this.smarts);
        this.addToView(this.fields);
        this.addToView(this.dataRights);
        this.addToView(this.selectAll);
    }

    protected void showAnimation(String text) {
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation(text);
    }

    protected void hideAnimation() {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.modules.getFocusComponents();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.modules.requestFocusInWindowNow();
    }

    private void ensureButtonType() {
        if (this.isChecked()) {
            if (this.selectAll != null) {
                this.selectAll.setText(Words.DESELECT_ALL);
            }
            this.isAddAll = false;
        } else {
            if (this.selectAll != null) {
                this.selectAll.setText(Words.SELECT_ALL);
            }
            this.isAddAll = true;
        }
    }

    private boolean isChecked() {
        if (this.fields != null && !this.fields.isEmpty()) {
            return this.fields.isChecked();
        }
        if (this.smarts != null && !this.smarts.isEmpty()) {
            return this.smarts.isChecked();
        }
        if (this.dataRights != null && !this.dataRights.isEmpty()) {
            return this.dataRights.isChecked();
        }
        return false;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.selectAll.getEditor()) {
            if (this.isAddAll) {
                if (this.fields != null) {
                    this.fields.selectAll();
                }
                if (this.smarts != null) {
                    this.smarts.selectAll();
                }
                if (this.dataRights != null) {
                    this.dataRights.selectAll();
                }
                this.ensureButtonType();
            } else {
                if (this.fields != null) {
                    this.fields.deselectAll();
                }
                if (this.smarts != null) {
                    this.smarts.deselectAll();
                }
                if (this.dataRights != null) {
                    this.dataRights.deselectAll();
                }
                this.ensureButtonType();
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean enabled = this.modules.getModel().getSelectedNode() != null;
        this.smarts.setEnabled(isEnabled & enabled);
        this.fields.setEnabled(isEnabled & enabled);
        this.dataRights.setEnabled(isEnabled & enabled);
        this.modules.setEnabled(isEnabled);
        this.selectAll.setEnabled(isEnabled & this.isNodeSet & enabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.smarts.kill();
        this.fields.kill();
        this.dataRights.kill();
        this.modules.kill();
        this.selectAll.kill();
        this.smarts = null;
        this.fields = null;
        this.dataRights = null;
        this.modules = null;
        this.selectAll = null;
    }

    private void updateNode(Node<LocationAccessRightComplete> node) {
        Node n;
        this.node = node;
        if (this.storeRightsDetailsPanel != null) {
            this.storeRightsDetailsPanel.updateNode(node);
        }
        if ((n = this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.currentLocation)) != null) {
            this.editor.getModel().getNode().removeChild(n, 0L);
        }
        if (this.node != null) {
            this.node.setName(DtoFieldConstants.currentLocation);
            this.editor.getModel().getNode().addChild(this.node, 0L);
        }
        if (this.modules != null && this.modules.getModel() != null) {
            this.modules.getModel().selectRow(null, false, false, 3);
            this.modules.getModel().setNode(NodeToolkit.getAffixList(ModuleDefinitionComplete.class));
        }
        this.ensureButtonType();
    }

    private Node<ModuleAccessRightComplete> getAccessObject(Object object) {
        Iterator it = this.node.getChildNamed(LocationAccessRightComplete_.modules).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!((ModuleDefinitionComplete)n.getChildNamed(ModuleAccessRightComplete_.module).getValue()).equals(object)) continue;
            return n;
        }
        return null;
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel == null) {
            return;
        }
        Node n = panel.getModel().getNode();
        TableRowImpl pp = (TableRowImpl)panel;
        Node<ModuleAccessRightComplete> accessNode = this.getAccessObject(n.getValue());
        this.smarts.setMasterNode(accessNode);
        this.dataRights.setMasterNode(accessNode);
        this.fields.setMasterNode(accessNode);
        this.editor.revalidate();
        this.isNodeSet = true;
        this.setEnabled(this.isNodeSet);
        this.ensureButtonType();
    }

    public void saveCurrentLocation(final UserComplete user, final LocationComplete l) {
        this.node.commit(LocationAccessRightComplete.class);
        LocationAccessRightComplete location = (LocationAccessRightComplete)this.node.getValue(LocationAccessRightComplete.class);
        if (location.getModules().isEmpty()) {
            InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_MODULE_RIGHT_FOR_CURRENT_LOCATION)}), Words.UNABLE_TO_SAVE_LOCATION, (Component)this);
            this.loadNewLocation(user, l);
        } else {
            this.showAnimation(Words.SAVE_LOCATION_ACCESS_RIGHTS);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ModuleRightsDetailsPanel.this.node.commit();
                    LocationAccessRightComplete r = (LocationAccessRightComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).saveUserRights((LocationAccessRightComplete)ModuleRightsDetailsPanel.this.node.getValue()).getValue();
                    ModuleRightsDetailsPanel.this.node.removeExistingValues();
                    ModuleRightsDetailsPanel.this.node.setValue((Object)r, 0L);
                    ModuleRightsDetailsPanel.this.node.updateNode();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (user != null && l != null) {
                                ModuleRightsDetailsPanel.this.loadNewLocation(user, l);
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                            ModuleRightsDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public void loadNewLocation(final UserComplete user, final LocationComplete l) {
        this.showAnimation(Words.LOAD_LOCATION_ACCESS_RIGHTS);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                LocationAccessRightComplete r = (LocationAccessRightComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUserRights((UserReference)user, l, false).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return ModuleRightsDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void loadLocationRights(final UserComplete user, final LocationComplete l) {
        this.setEnabled(false);
        if (this.node != null) {
            InnerPopupFactory.showDesicionPopup(Words.SAVE_RIGHTS_FOR_CURRENT_LOCATION, Words.SAVE_ACCESS_RIGHTS_FOR_CURRENT_LOCATION_FIRST, this, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        ModuleRightsDetailsPanel.this.loadNewLocation(user, l);
                    } else {
                        ModuleRightsDetailsPanel.this.saveCurrentLocation(user, l);
                    }
                }
            }, -1, -1);
        } else {
            this.loadNewLocation(user, l);
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.updateNode(node);
        this.hideAnimation();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.hideAnimation();
        this.setEnabled(true);
        this.editor.errorOccurred(exception);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel moduleName;
        private CheckBox access;
        private boolean isEditable;

        public TableRowImpl(Table2RowModel m, Table2RowPanel.TableControlsType controlsType) {
            super(m);
            this.isEditable = true;
            this.setUseControlSkin(controlsType);
            this.setSelectable(true);
            this.moduleName = new TextLabel((String)m.getNode().getChildNamed(ModuleDefinitionComplete_.displayName).getValue());
            this.access = new CheckBox();
            this.access.addButtonListener(this);
            this.isEditable = ModuleRightsDetailsPanel.this.modules.isWritable();
            this.ensureSelectionState();
            this.setLayout(new Layout());
            this.setEnabled(true);
            this.add(this.moduleName);
            this.add(this.access);
        }

        private void ensureSelectionState() {
            Iterator it = ModuleRightsDetailsPanel.this.node.getChildNamed(LocationAccessRightComplete_.modules).getFailSafeChildIterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node n = (Node)it.next();
                if (!((ModuleAccessRightComplete)n.getValue()).getModule().equals(this.model.getNode().getValue())) continue;
                found = true;
                this.access.setChecked(true);
            }
            if (!found) {
                this.access.setChecked(false);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.access) {
                if (this.access.isChecked()) {
                    ModuleAccessRightComplete a = new ModuleAccessRightComplete();
                    a.setClientOId(Long.valueOf(ADTO.getNextId()));
                    a.setModule((ModuleDefinitionComplete)this.model.getNode().getValue());
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, true, false);
                    ModuleRightsDetailsPanel.this.node.getChildNamed(LocationAccessRightComplete_.modules).addChild(n, System.currentTimeMillis());
                    if (this.isSelected == 3) {
                        ModuleRightsDetailsPanel.this.tableRowSelected(this.model.getParentModel().getTable(), this);
                    }
                } else {
                    Iterator it = ModuleRightsDetailsPanel.this.node.getChildNamed(LocationAccessRightComplete_.modules).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (!((ModuleAccessRightComplete)n.getValue()).getModule().equals(this.model.getNode().getValue())) continue;
                        ModuleRightsDetailsPanel.this.node.getChildNamed(LocationAccessRightComplete_.modules).removeChild(n, System.currentTimeMillis());
                    }
                    if (this.isSelected == 3) {
                        ModuleRightsDetailsPanel.this.tableRowSelected(this.getModel().getParentModel().getTable(), this);
                    }
                }
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.moduleName.kill();
            this.access.kill();
            this.moduleName = null;
            this.access = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.access.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.moduleName.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.moduleName.setEnabled(isEnabled);
            this.access.setEnabled(isEnabled & this.isEditable);
        }

        public boolean isChecked() {
            return this.access.isChecked();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.moduleName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.moduleName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.moduleName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.moduleName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.access.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.access.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.access.setSize(TableRowImpl.this.access.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 500;
            int b = (int)((double)ModuleRightsDetailsPanel.this.verticalBorder + ModuleRightsDetailsPanel.this.smarts.getPreferredSize().getHeight() + 23.0 + (double)ModuleRightsDetailsPanel.this.verticalBorder + ModuleRightsDetailsPanel.this.dataRights.getPreferredSize().getHeight() + 23.0 + (double)ModuleRightsDetailsPanel.this.verticalBorder + ModuleRightsDetailsPanel.this.fields.getPreferredSize().getHeight() + 23.0 + (double)ModuleRightsDetailsPanel.this.verticalBorder + ModuleRightsDetailsPanel.this.selectAll.getPreferredSize().getHeight() + (double)ModuleRightsDetailsPanel.this.verticalBorder);
            if (b > h) {
                h = b;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ModuleRightsDetailsPanel.this.animation != null) {
                ModuleRightsDetailsPanel.this.animation.setLocation((int)((double)parent.getWidth() - ModuleRightsDetailsPanel.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ModuleRightsDetailsPanel.this.animation.getPreferredSize().getHeight()) / 2);
                ModuleRightsDetailsPanel.this.animation.setSize(ModuleRightsDetailsPanel.this.animation.getPreferredSize());
            }
            ModuleRightsDetailsPanel.this.modules.setLocation(0, 0);
            ModuleRightsDetailsPanel.this.modules.setSize(200, parent.getHeight());
            ModuleRightsDetailsPanel.this.smarts.setLocation(200 + ModuleRightsDetailsPanel.this.horizontalBorder, ModuleRightsDetailsPanel.this.verticalBorder);
            ModuleRightsDetailsPanel.this.smarts.setSize(parent.getWidth() - (2 * ModuleRightsDetailsPanel.this.horizontalBorder + 200), (int)ModuleRightsDetailsPanel.this.smarts.getPreferredSize().getHeight() + 23);
            ModuleRightsDetailsPanel.this.dataRights.setLocation(200 + ModuleRightsDetailsPanel.this.horizontalBorder, ModuleRightsDetailsPanel.this.smarts.getY() + ModuleRightsDetailsPanel.this.smarts.getHeight() + ModuleRightsDetailsPanel.this.verticalBorder);
            ModuleRightsDetailsPanel.this.dataRights.setSize(parent.getWidth() - (2 * ModuleRightsDetailsPanel.this.horizontalBorder + 200), (int)ModuleRightsDetailsPanel.this.dataRights.getPreferredSize().getHeight() + 23);
            ModuleRightsDetailsPanel.this.fields.setLocation(200 + ModuleRightsDetailsPanel.this.horizontalBorder, ModuleRightsDetailsPanel.this.dataRights.getY() + ModuleRightsDetailsPanel.this.dataRights.getHeight() + ModuleRightsDetailsPanel.this.verticalBorder);
            ModuleRightsDetailsPanel.this.fields.setSize(parent.getWidth() - (2 * ModuleRightsDetailsPanel.this.horizontalBorder + 200), (int)ModuleRightsDetailsPanel.this.fields.getPreferredSize().getHeight() + 23);
            ModuleRightsDetailsPanel.this.selectAll.setLocation((int)((double)(ModuleRightsDetailsPanel.this.fields.getX() + ModuleRightsDetailsPanel.this.fields.getWidth()) - ModuleRightsDetailsPanel.this.selectAll.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - (ModuleRightsDetailsPanel.this.selectAll.getPreferredSize().getHeight() + (double)ModuleRightsDetailsPanel.this.verticalBorder)));
            ModuleRightsDetailsPanel.this.selectAll.setSize(ModuleRightsDetailsPanel.this.selectAll.getPreferredSize());
        }
    }
}

