/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details.utils;

import ch.icit.pegasus.client.comparators.FieldAccessComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.useradmin.details.utils.RightsEditPopup;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldRightsE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldsDefinition
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Node<?> userNode;

    public FieldsDefinition(RDProvider provider) {
        super(false, "", true, true, "Field Access");
        this.setProvider(provider);
        this.setOverrideName("modules");
        this.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("FIELD", null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + CheckBox.getPreferredWidth() + 15;
        columns.add(new TableColumnInfo("EDIT", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setComparator(ComparatorRegistry.getComparator(FieldAccessComparator.class));
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setMasterNode(Node<?> node) {
        this.userNode = node;
        if (node == null) {
            this.getModel().setNode(null);
        } else {
            this.getModel().setNode(node.getChildNamed(new DtoField[]{ModuleAccessRightComplete_.module, ModuleDefinitionComplete_.fieldRights}));
        }
    }

    private void ensureRight(boolean isCheck, DataFieldRightsE currentRightE, Node currentRight, Node currentField, DataFieldDefinitionComplete d) {
        if (isCheck) {
            DataFieldAccessRightComplete r = new DataFieldAccessRightComplete();
            r.setClientOId(Long.valueOf(ADTO.getNextId()));
            r.setAccessRight(currentRightE);
            r.setField(d);
            currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)r, true, false), System.currentTimeMillis());
        } else {
            Iterator it = currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!n.getChildNamed(DataFieldAccessRightComplete_.field).getValue().equals(d) || !n.getChildNamed(DataFieldAccessRightComplete_.accessRight).getValue().equals(currentRightE)) continue;
                currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).removeChild(n, System.currentTimeMillis());
            }
        }
    }

    private boolean hasRight(DataFieldRightsE currentRightE, Node currentRight, Node currentField, DataFieldDefinitionComplete d) {
        Iterator it = currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!n.getChildNamed(DataFieldAccessRightComplete_.field).getValue().equals(d) || !n.getChildNamed(DataFieldAccessRightComplete_.accessRight).getValue().equals(currentRightE)) continue;
            return true;
        }
        return false;
    }

    public void selectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(true);
        }
    }

    public void deselectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(false);
        }
    }

    public boolean isChecked() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.isChecked()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private Component right;
        private int inset;
        private boolean isList;
        private boolean isEditable;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isEditable = true;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.name = new TextLabel(m.getNode().getChildNamed(DataFieldDefinitionComplete_.name));
            this.isEditable = FieldsDefinition.this.isWritable();
            DataFieldDefinitionComplete f = (DataFieldDefinitionComplete)m.getNode().getValue();
            if (f.getIsList().booleanValue()) {
                this.isList = true;
                this.right = new EditButton();
                ((EditButton)this.right).addButtonListener(this);
            } else {
                this.right = new CheckBox();
                ((CheckBox)this.right).addButtonListener(this);
                this.ensureSelectionState();
            }
            this.setLayout(new Layout());
            this.setExpanded(true);
            this.setEnabled(true);
            this.add(this.name);
            this.add(this.right);
            this.setLayoutInnerChildsSelf(true);
            Iterator it = m.getNode().getChildNamed(DataFieldDefinitionComplete_.subElements).getChilds();
            while (it.hasNext()) {
                Node nn = (Node)it.next();
                this.addRow(nn);
            }
        }

        private void ensureSelectionState() {
            Iterator it = FieldsDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getFailSafeChildIterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node n = (Node)it.next();
                if (!((DataFieldAccessRightComplete)n.getValue()).getField().equals(this.model.getNode().getValue())) continue;
                found = true;
                ((CheckBox)this.right).setChecked(true);
            }
            if (!found) {
                ((CheckBox)this.right).setChecked(false);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.right) {
                if (this.isList) {
                    InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                    popUp.setAttributes(source, false, false, "Edit List Access Rights");
                    popUp.setView(new RightsEditPopup(FieldsDefinition.this.userNode, this.model.getNode()));
                    popUp.showPopUp(x, y, -1, -1, this, source, PopupType.NORMAL);
                } else if (((CheckBox)this.right).isChecked()) {
                    DataFieldAccessRightComplete a = new DataFieldAccessRightComplete();
                    a.setClientOId(Long.valueOf(ADTO.getNextId()));
                    a.setAccessRight(DataFieldRightsE.WRITE);
                    a.setField((DataFieldDefinitionComplete)this.model.getNode().getValue());
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, true, false);
                    FieldsDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).addChild(n, System.currentTimeMillis());
                } else {
                    Iterator it = FieldsDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (!((DataFieldAccessRightComplete)n.getValue()).getField().equals(this.model.getNode().getValue())) continue;
                        FieldsDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).removeChild(n, System.currentTimeMillis());
                    }
                }
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            if (this.right instanceof CheckBox) {
                return ((CheckBox)this.right).getFocusComponents();
            }
            if (this.right instanceof EditButton) {
                return ((EditButton)this.right).getFocusComponents();
            }
            return null;
        }

        @Override
        public void applyInset() {
            this.inset = 23;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    if (!(this.right instanceof CheckBox)) break;
                    return ((CheckBox)this.right).isChecked();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.right.setEnabled(isEnabled & this.isEditable);
            for (Table2RowPanel p : this.getChildren()) {
                p.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.name != null) {
                this.name.kill();
            }
            if (this.right != null && this.right instanceof Killable) {
                ((Killable)((Object)this.right)).kill();
            }
            this.name = null;
            this.right = null;
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        }

        public void selectRow(boolean b) {
            if (this.right instanceof CheckBox) {
                ((CheckBox)this.right).setChecked(b);
                this.buttonPressed((Button)this.right, 0, 0);
            } else {
                boolean isCheck = b;
                Node currentRight = FieldsDefinition.this.userNode;
                Node currentField = this.model.getNode();
                DataFieldDefinitionComplete d = (DataFieldDefinitionComplete)currentField.getValue();
                FieldsDefinition.this.ensureRight(isCheck, DataFieldRightsE.ADD, currentRight, currentField, d);
                FieldsDefinition.this.ensureRight(isCheck, DataFieldRightsE.CHANGEORDER, currentRight, currentField, d);
                FieldsDefinition.this.ensureRight(isCheck, DataFieldRightsE.REMOVE, currentRight, currentField, d);
                FieldsDefinition.this.ensureRight(isCheck, DataFieldRightsE.WRITE, currentRight, currentField, d);
                for (Table2RowPanel p : this.children) {
                    TableRowImpl pp = (TableRowImpl)p;
                    pp.selectRow(b);
                }
            }
        }

        public boolean isChecked() {
            DataFieldDefinitionComplete d;
            Node currentField;
            if (this.right instanceof CheckBox) {
                return ((CheckBox)this.right).isChecked();
            }
            Node currentRight = FieldsDefinition.this.userNode;
            if (!FieldsDefinition.this.hasRight(DataFieldRightsE.ADD, currentRight, currentField = this.model.getNode(), d = (DataFieldDefinitionComplete)currentField.getValue())) {
                return false;
            }
            if (!FieldsDefinition.this.hasRight(DataFieldRightsE.CHANGEORDER, currentRight, currentField, d)) {
                return false;
            }
            if (!FieldsDefinition.this.hasRight(DataFieldRightsE.REMOVE, currentRight, currentField, d)) {
                return false;
            }
            return FieldsDefinition.this.hasRight(DataFieldRightsE.WRITE, currentRight, currentField, d);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.name.setLocation(TableRowImpl.this.getCellPadding() + TableRowImpl.this.inset, (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.inset), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.right.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.right.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.right.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.right.getPreferredSize().getHeight());
            }
        }
    }
}

