/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details.utils;

import ch.icit.pegasus.client.converter.SmartAccessRightConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.OrderingsUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SmartDefinition
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Node userNode;

    public SmartDefinition(RDProvider provider) {
        super(false, "", true, true, "Sub Module Access");
        this.setProvider(provider);
        this.setOverrideName("modules");
        this.setUseWriteAccessRight(true);
        this.setComparator((Comparator)this.getSubmoduleComparator());
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("RIGHT", null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo(Words.PREFERRED_SUBMODULE, null, null, null, "", 75, 75, 75));
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private Ordering<TableRowImpl> getSubmoduleComparator() {
        List<SubModuleTypeE> submoduleTypeOrder = OrderingsUtil.getExplicitList();
        Ordering order2 = Ordering.natural().onResultOf((Function)new Function<TableRowImpl, String>(){

            public String apply(TableRowImpl foo) {
                SubModuleDefinitionComplete u1 = (SubModuleDefinitionComplete)foo.getModel().getNode().getValue();
                return u1.getDisplayName();
            }
        });
        Ordering order = Ordering.explicit(submoduleTypeOrder).onResultOf((Function)new Function<TableRowImpl, SubModuleTypeE>(){

            public SubModuleTypeE apply(TableRowImpl foo) {
                SubModuleDefinitionComplete u1 = (SubModuleDefinitionComplete)foo.getModel().getNode().getValue();
                return u1.getType();
            }
        });
        return order.compound((Comparator)order2);
    }

    public void setMasterNode(Node<?> node) {
        this.userNode = node;
        if (node == null) {
            this.getModel().setNode(null);
        } else {
            HashSet<String> subNames = new HashSet<String>();
            Iterator it = node.getChildNamed(new DtoField[]{ModuleAccessRightComplete_.module, ModuleDefinitionComplete_.subModules}).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node m = (Node)it.next();
                if (subNames.contains(((SubModuleDefinitionComplete)m.getValue()).getInvokingName())) {
                    node.getChildNamed(new DtoField[]{ModuleAccessRightComplete_.module, ModuleDefinitionComplete_.subModules}).removeChild(m, 0L);
                    continue;
                }
                subNames.add(((SubModuleDefinitionComplete)m.getValue()).getInvokingName());
            }
            this.getModel().setNode(node.getChildNamed(new DtoField[]{ModuleAccessRightComplete_.module, ModuleDefinitionComplete_.subModules}));
        }
    }

    public void selectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(true);
        }
    }

    public void deselectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(false);
        }
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean isChecked() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.isChecked()) continue;
            return false;
        }
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private CheckBox right;
        private RadioButton preferredSubModule;
        private boolean isEditable;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isEditable = true;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(SmartAccessRightConverter.class));
            this.right = new CheckBox();
            this.preferredSubModule = new RadioButton();
            this.preferredSubModule.addButtonListener(this);
            this.isEditable = SmartDefinition.this.isWritable();
            this.right.addButtonListener(this);
            this.setLayout(new Layout());
            this.ensureSelectionState();
            this.setEnabled(true);
            this.add(this.name);
            this.add(this.preferredSubModule);
            this.add(this.right);
        }

        private void ensureSelectionState() {
            Iterator it = SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).getFailSafeChildIterator();
            Node pref = SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.preferredSubModule);
            boolean found = false;
            while (it.hasNext() && !found) {
                Node n = (Node)it.next();
                if (!((SubModuleAccessRightComplete)n.getValue()).getModule().getInvokingName().equals(((SubModuleDefinitionComplete)this.model.getNode().getValue()).getInvokingName())) continue;
                found = true;
                this.right.setChecked(true);
                if (!((SubModuleAccessRightComplete)n.getValue()).equals(pref.getValue())) continue;
                this.preferredSubModule.setChecked(true);
            }
            if (!found) {
                this.right.setChecked(false);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.right) {
                if (this.right.isChecked()) {
                    SubModuleAccessRightComplete a = new SubModuleAccessRightComplete();
                    a.setClientOId(Long.valueOf(ADTO.getNextId()));
                    a.setModule((SubModuleDefinitionComplete)this.model.getNode().getValue());
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, true, false);
                    SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).addChild(n, System.currentTimeMillis());
                } else {
                    Iterator it = SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (!((SubModuleAccessRightComplete)n.getValue()).getModule().equals(this.model.getNode().getValue())) continue;
                        SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).removeChild(n, System.currentTimeMillis());
                    }
                }
                this.setEnabled(this.isEnabled());
            } else if (source == this.preferredSubModule) {
                Iterator it = SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (!((SubModuleDefinitionComplete)n.getChildNamed(SubModuleAccessRightComplete_.module).getValue()).equals(this.getModel().getNode().getValue())) continue;
                    if (this.preferredSubModule.isChecked()) {
                        Iterator it2 = SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.subModules).getFailSafeChildIterator();
                        while (it2.hasNext()) {
                            Node n2 = (Node)it2.next();
                            if (!((SubModuleAccessRightComplete)n2.getValue()).getModule().equals(this.model.getNode().getValue())) continue;
                            SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.preferredSubModule).setValue(n2.getValue(), 0L);
                        }
                        continue;
                    }
                    SmartDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.preferredSubModule).setValue(null, 0L);
                }
                this.deselectOtherPreferredSubModules();
            }
        }

        private void deselectOtherPreferredSubModules() {
            for (Table2RowPanel p : SmartDefinition.this.getRows()) {
                TableRowImpl r = (TableRowImpl)p;
                if (r == this) continue;
                r.preferredSubModule.setChecked(false);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.right.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.right.setEnabled(isEnabled && this.isEditable);
            boolean isNormalSubModule = false;
            if (this.model.getNode().getChildNamed(SubModuleDefinitionComplete_.type).getValue() == SubModuleTypeE.ACTION || this.model.getNode().getChildNamed(SubModuleDefinitionComplete_.type).getValue() == SubModuleTypeE.TOOL || this.model.getNode().getChildNamed(SubModuleDefinitionComplete_.type).getValue() == SubModuleTypeE.EXPORT || this.model.getNode().getChildNamed(SubModuleDefinitionComplete_.type).getValue() == SubModuleTypeE.INFO || this.model.getNode().getChildNamed(SubModuleDefinitionComplete_.type).getValue() == SubModuleTypeE.PRINT) {
                isNormalSubModule = true;
            }
            this.preferredSubModule.setEnabled(isEnabled && this.isEditable && this.right.isChecked() && isNormalSubModule);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.right.kill();
            this.preferredSubModule.kill();
            this.name = null;
            this.right = null;
            this.preferredSubModule = null;
        }

        public void selectRow(boolean b) {
            this.right.setChecked(b);
            this.buttonPressed(this.right, 0, 0);
        }

        public boolean isChecked() {
            return this.right.isChecked();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.name.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.preferredSubModule.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.preferredSubModule.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.preferredSubModule.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.preferredSubModule.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.right.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.right.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.right.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.right.getPreferredSize().getHeight());
            }
        }
    }
}

