/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.weeklyplan;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.RestaurantConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.weeklyplan.WeeklyPlanModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.weeklyplan.details.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.weeklyplan.details.LabelProductionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.weeklyplan.details.LoadDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.weeklyplan.details.WeeklyPlanDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.WeeklyPlanSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.WeeklyPlanAccess;
import ch.icit.pegasus.server.core.dtos.search.WeeklyPlanSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class WeeklyPlanModule
extends ScreenTableView<WeeklyPlanLight, WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    public final String FILTER_PERIOD = "period";
    public final String FILTER_CUSTOMER = "customer";
    public final String FILTER_DEPARTMENT = "department";
    private PeriodComplete period;
    private CustomerLight customer;
    private CostCenterComplete department;
    private ComboBox departments;

    public WeeklyPlanModule() {
        super(WeeklyPlanLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return WeeklyPlanAccess.MODULE_WEEKLY_PLAN;
    }

    @Override
    public boolean isDeletable(RowModel<WeeklyPlanLight> model) {
        return true;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        return c;
    }

    @Override
    public void kill() {
        this.departments.kill();
        this.departments = null;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addCustomerSearchField("customer");
        this.departments = new ComboBox(null, null, ConverterRegistry.getConverter(DepartmentConverter.class), true);
        this.filterChain.addSelectionComboBox(this.departments, "department", Words.DEPARTMENT, Words.ALL);
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection("period", new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), Words.DATE, false);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<WeeklyPlanLight, WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.period = null;
            this.department = null;
            this.customer = null;
        } else if (name != null) {
            if (name.equals("period")) {
                this.period = ((TitledPeriodEditor)value).getPeriod();
            }
            if (name.equals("customer")) {
                this.customer = value instanceof CustomerLight ? (CustomerLight)value : (value instanceof Node ? (((Node)value).getValue() instanceof CustomerLight ? (CustomerLight)((Node)value).getValue() : null) : null);
            }
            if (name.equals("department")) {
                this.department = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (((Node)value).getValue() instanceof CostCenterComplete ? (CostCenterComplete)((Node)value).getValue() : null) : null);
            }
        }
        WeeklyPlanSearchConfiguration c = new WeeklyPlanSearchConfiguration();
        c.setCustomer(this.customer);
        c.setDepartment(this.department);
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.period);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.departments.refreshPossibleValues(ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.PRODUCTION));
        this.departments.addItem(Words.ALL);
        this.departments.setSelectedItem(Words.ALL);
    }

    @Override
    public SearchAlgorithm<WeeklyPlanLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(WeeklyPlanSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<WeeklyPlanLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<WeeklyPlanLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<WeeklyPlanLight> rowEditor = new MessageProvidedRowEditor<WeeklyPlanLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            ConfigurationDetailsPanel c1 = new ConfigurationDetailsPanel((RowEditor<WeeklyPlanLight>)rowEditor, p);
            WeeklyPlanDetailsPanel c5 = new WeeklyPlanDetailsPanel((RowEditor<WeeklyPlanLight>)rowEditor, p);
            LoadDataDetailsPanel c4 = null;
            if (!model.isAddRow()) {
                c4 = new LoadDataDetailsPanel(rowEditor, p, c5);
            }
            LabelProductionDetailsPanel c6 = new LabelProductionDetailsPanel((RowEditor<WeeklyPlanLight>)rowEditor, p);
            int index = 0;
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
            if (c4 != null) {
                rowEditor.add(c4, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
            }
            rowEditor.add(c5, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
            rowEditor.add(c6, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
            rowEditor.addToFocusQueue(c1);
            if (c4 != null) {
                rowEditor.addToFocusQueue(c4);
            }
            rowEditor.addToFocusQueue(c5);
            rowEditor.addToFocusQueue(c6);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new WeeklyPlanModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.WEEK, "", (Class)StringConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.WEEK, WeeklyPlanLight_.calendarWeek, TableColumnInfo.numberColumnWithExpandWidth + 35));
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.STATE, WeeklyPlanLight_.planState, TableColumnInfo.state3));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.NAME, WeeklyPlanLight_.name, TableColumnInfo.periodColumnWidth, Integer.MAX_VALUE, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.PERIOD, WeeklyPlanLight_.period, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.CUSTOMER, WeeklyPlanLight_.customer, TableColumnInfo.customerCodeWidth * 2));
        columns.add(new TableColumnInfo(Words.DEPARMENT, "", (Class)DepartmentConverter.class, (Enum<?>)WeeklyPlanSearchConfiguration.WEEKLY_PLAN_COLUMN.DEPARTMENT, WeeklyPlanLight_.department, TableColumnInfo.departmentWidth * 2));
        columns.add(new TableColumnInfo(Words.RESTAURANT, "", (Class)RestaurantConverter.class, null, WeeklyPlanLight_.restaurant, TableColumnInfo.departmentWidth * 2));
        return columns;
    }
}

