/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.yourbarmate.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.yourbarmate.YourBarMateOrderImportComplete_;
import ch.icit.pegasus.server.core.dtos.yourbarmate.YourBarMateOrderImportLight;
import ch.icit.pegasus.server.core.dtos.yourbarmate.YourBarMateOrderPositionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class OrderDetailsPanel
extends TableDetailsPanel<YourBarMateOrderImportLight> {
    private static final long serialVersionUID = 1L;

    public OrderDetailsPanel(RowEditor<YourBarMateOrderImportLight> editor, RDProvider provider) {
        super(editor, provider, editor.getModel().isAddRow());
        this.setTitleText(Words.PRODUCT);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Remote ID", null, null, null, "", 40));
        columns.add(new TableColumnInfo("Remote Name", null, null, null, "", 40));
        columns.add(new TableColumnInfo("Resolved Product", null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.QUALITY, null, null, null, "", 120));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.6);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        YourBarMateOrderPositionComplete orderImport = (YourBarMateOrderPositionComplete)model.getNode().getValue();
        String name = "";
        if (orderImport.getResolvedProduct() != null) {
            name = orderImport.getResolvedProduct().getNumber() + " - " + orderImport.getResolvedProduct().getCurrentVariant().getName();
        }
        row.addLayoutComponent(new TextLabel(orderImport.getRemoteId()), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(orderImport.getRemoteName()), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(name), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(orderImport.getProductCount() + "x "), DefaultTable2RowPanelLayout.LayoutType.FIX);
        row.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        return row;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(YourBarMateOrderImportComplete_.items));
    }
}

