/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.SubModuleProvider;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.modules.ScreenToolkit;
import ch.icit.pegasus.client.gui.screentemplates.ScreenLoader;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.smartaccess.AnalysisDoubleSmartScreenButton;
import ch.icit.pegasus.client.gui.table.smartaccess.AnalysisSmartScreenPopupButton;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.AnalaysisSmartScreenAccessPopupInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.OrderingsUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TitledScreenInsert<T extends IUniversal>
extends ScreenInsert<T>
implements RemoteLoader,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private TextLabel title;
    protected MainFrame frame;
    private AnalysisDoubleSmartScreenButton<T> smartButton1;
    private Button smartButton2;
    private ScreenLoader<T> screenLoader;
    private InnerPopUp2 popUp;
    private List<SubModuleAccessRightComplete> smartScreens;

    public TitledScreenInsert() {
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.title = new TextLabel();
        ScreenToolkit.configureScreenTitle(this.title);
        this.title.setText(this.getScreenTitle());
        this.smartScreens = new ArrayList<SubModuleAccessRightComplete>();
        this.screenLoader = new ScreenLoader<T>(){

            @Override
            public InnerPopUp2 getPopup() {
                return TitledScreenInsert.this.popUp;
            }

            @Override
            public RowModel<T> getModel() {
                return null;
            }

            @Override
            public MainFrame getMainFrame() {
                return TitledScreenInsert.this.frame;
            }

            @Override
            public ConnectionToOutside<T, ?> getConnectionToOutside() {
                return null;
            }

            @Override
            public void clearPopup() {
            }
        };
        this.add(this.title);
    }

    public void updateTitle() {
        this.title.setText(this.getScreenTitle());
    }

    public ModuleAccessRightComplete getCurrentAccessRight(AccessDefinitionComplete accessDef) {
        return HUDToolkit.getCurrentAccessRight(accessDef, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    public SubModuleAccessRightComplete getAccessRightForSubModule(String name) {
        return HUDToolkit.getAccessRightForSubModule(name, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    public abstract String getScreenTitle();

    public void setMainFrame(MainFrame frame) {
        this.frame = frame;
    }

    public MainFrame getMainFrame() {
        return this.frame;
    }

    public TextLabel getTitle() {
        return this.title;
    }

    public int layoutTitle(Container parent) {
        this.title.setLocation(0, (int)((double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle")).intValue() - this.title.getPreferredSize().getHeight()));
        this.title.setSize(this.title.getPreferredSize());
        if (this.getSmartButton2() != null) {
            this.getSmartButton2().setLocation(parent.getWidth() - this.getSmartButton2().getPreferredSize().width, (int)((double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle")).intValue() - this.getSmartButton2().getPreferredSize().getHeight()));
            this.getSmartButton2().setSize(this.getSmartButton2().getPreferredSize());
            this.getSmartButton1().setLocation((int)((double)(parent.getWidth() - this.getSmartButton2().getPreferredSize().width) - this.getSmartButton1().getPreferredSize().getWidth() - 2.0), (int)((double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle")).intValue() - this.getSmartButton1().getPreferredSize().getHeight()));
            this.getSmartButton1().setSize(this.getSmartButton1().getPreferredSize());
        } else if (this.getSmartButton2() == null && this.getSmartButton1() != null) {
            this.getSmartButton1().setLocation((int)((double)parent.getWidth() - this.getSmartButton1().getPreferredSize().getWidth()), (int)((double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle")).intValue() - this.getSmartButton1().getPreferredSize().getHeight()));
            this.getSmartButton1().setSize(this.getSmartButton1().getPreferredSize());
        }
        return this.title.getY() + this.title.getHeight();
    }

    @Override
    public void screenSet() {
        if (this.frame != null) {
            this.frame.getTitleBar().setHUDButtonsEnabled(true, 19635);
            this.createAnalysisButtons();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.title != null) {
            this.title.setEnabled(isEnabled);
        }
        if (this.getSmartButton1() != null) {
            this.getSmartButton1().setEnabled(isEnabled);
        }
        if (this.getSmartButton2() != null) {
            this.getSmartButton2().setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.title.kill();
        this.title = null;
        this.frame = null;
        if (this.smartButton1 != null) {
            this.smartButton1.kill();
        }
        this.smartButton1 = null;
        if (this.smartButton2 != null) {
            this.smartButton2.kill();
        }
        this.smartButton2 = null;
        this.screenLoader = null;
        this.popUp = null;
        this.smartScreens.clear();
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.getSmartButton1()) {
            this.screenLoader.loadScreen(((SubModuleAccessRightComplete)this.getSmartButton1().getUserObject()).getModule(), x, y, this.frame, null);
        } else if (source == this.getSmartButton2()) {
            this.popUp = InnerPopUp2.getInnerPopUp();
            this.popUp.setAttributes(this.getSmartButton2(), false, false, "");
            this.popUp.setView(new AnalaysisSmartScreenAccessPopupInsert(this.smartScreens, this.frame, (ScreenLoader)this.screenLoader, null));
            this.popUp.showPopUp(0, this.getSmartButton2().getHeight(), 200, -1, null, this.getSmartButton2(), PopupType.SMARTACCES);
        }
    }

    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        return true;
    }

    private void createAnalysisButtons() {
        if (this instanceof SubModuleProvider && ScreenViewProvider.getCurrentScreenObject() != null) {
            ArrayList<SubModuleTypeE> acceptedTypes = new ArrayList<SubModuleTypeE>();
            acceptedTypes.add(SubModuleTypeE.ANALYSIS_EXPORT);
            acceptedTypes.add(SubModuleTypeE.ANALYSIS_PRINT);
            acceptedTypes.add(SubModuleTypeE.ANALYSIS_INFO);
            acceptedTypes.add(SubModuleTypeE.ANALYSIS_ACTION);
            acceptedTypes.add(SubModuleTypeE.ANALYSIS_EXPORT_SIMPLE);
            String currentName = HUDToolkit.getInvokerNameForTopScreenClass(ScreenViewProvider.getCurrentScreenClass());
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            for (ModuleAccessRightComplete r : user.getModules()) {
                if (!r.getModule().getInvokingName().equals(currentName)) continue;
                for (SubModuleAccessRightComplete rr : r.getSubModules()) {
                    String v;
                    if (!acceptedTypes.contains(rr.getModule().getType()) || !this.isAnalysisModuleAllowed(rr) || (v = AppModulesUtils.getSubModuleName(rr.getModule().getInvokingName(), rr.getModule().getDisplayName())) == null || v.isEmpty()) continue;
                    boolean found = false;
                    for (SubModuleAccessRightComplete rt : this.smartScreens) {
                        if (!rt.getModule().equals((Object)rr.getModule())) continue;
                        found = true;
                    }
                    if (found) continue;
                    this.smartScreens.add(rr);
                }
            }
            Collections.sort(this.smartScreens, OrderingsUtil.getSubModuleOrderingByType());
            if (this.smartScreens.size() > 0) {
                if (this.getSmartButton1() != null) {
                    this.getSmartButton1().kill();
                }
                if (this.getSmartButton2() != null) {
                    this.getSmartButton2().kill();
                }
                this.setSmartButton1(new AnalysisDoubleSmartScreenButton(HUDToolkit.getSmartScreenButtonIconClassForInvokerName(this.smartScreens.get(0).getModule().getInvokingName()), this.smartScreens.get(0).getModule().getDisplayName()));
                this.getSmartButton1().addButtonListener(this);
                this.getSmartButton1().setUserObject(this.smartScreens.get(0));
                this.add(this.getSmartButton1());
                this.setSmartButton2(new AnalysisSmartScreenPopupButton());
                this.getSmartButton2().addButtonListener(this);
                this.getSmartButton2().setToolTipText(Words.EXPAND_OPTIONS);
                this.add(this.getSmartButton2());
            }
        }
    }

    protected AnalysisDoubleSmartScreenButton<T> getSmartButton1() {
        return this.smartButton1;
    }

    protected void setSmartButton1(AnalysisDoubleSmartScreenButton<T> smartButton1) {
        this.smartButton1 = smartButton1;
    }

    protected Button getSmartButton2() {
        return this.smartButton2;
    }

    protected void setSmartButton2(Button smartButton2) {
        this.smartButton2 = smartButton2;
    }
}

