/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TableRowDateSorter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class AVariantDetailsPanelTabbed<T extends IDTO>
extends DefaultDetailsPanel<T>
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private TabbedItem<Table2> tables;
    protected Table2 productiveVariants;
    protected Table2 tenderVariants;
    protected Table2RowPanel selectedPanel;

    public AVariantDetailsPanelTabbed(RowEditor editor, RDProvider provider) {
        super(editor, provider, true, true);
        this.setTitleText(Words.VARIANTS);
        this.tables = new TabbedItem<Table2>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        this.productiveVariants = this.createVariantTable(true);
        this.tenderVariants = this.createVariantTable(false);
        boolean showTender = provider.isWritable("showTender");
        boolean useTender = Boolean.TRUE.equals(this.settings.getUseProductTenderScenario());
        if (showTender && useTender) {
            this.tables.addView(this.productiveVariants, new TabButton(Words.PRODUCTIVE));
            this.tables.addView(this.tenderVariants, new TabButton(Words.TENDER));
        } else {
            this.tables.addView(this.productiveVariants, new TabButton(Words.PRODUCTIVE));
            this.tables.removeHeaders();
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.tables);
    }

    public Table2 getProductivePanel() {
        return this.productiveVariants;
    }

    public Table2 getTenderPanel() {
        return this.tenderVariants;
    }

    public Table2 getSelectedPanel() {
        return this.tables.getSelectedView();
    }

    private Table2 createVariantTable(final boolean productive) {
        Table2 table = new Table2(false, "", false, false);
        table.setRequestFocusOnAdd(true);
        table.setComparator(ComparatorRegistry.getComparator(TableRowDateSorter.class));
        table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                AVariantDetailsPanelTabbed.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                AVariantDetailsPanelTabbed.this.editor.revalidate();
            }
        });
        Table2Model tModel = new Table2Model(this.getColumns(table), true){

            @Override
            public boolean checkIfIsToAdd(Node node) {
                Node tenderNode = AVariantDetailsPanelTabbed.this.getTenderNode(node);
                return tenderNode != null && (productive ? Boolean.FALSE.equals(tenderNode.getValue()) : Boolean.TRUE.equals(tenderNode.getValue()));
            }
        };
        tModel.setViewFactory(model -> {
            Table2RowPanel p = this.getTableRow(model, productive);
            p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            return p;
        });
        table.setModel(tModel);
        table.getModel().addTableSelectionListener(this);
        this.addToView(table);
        return table;
    }

    private Node getTenderNode(Node node) {
        return node.getChildNamed(ProductVariantLight_.tenderVariant);
    }

    public abstract List<TableColumnInfo> getColumns(Table2 var1);

    @Override
    public abstract List<ScreenValidationObject> validateParagraph();

    public abstract Table2RowPanel getTableRow(Table2RowModel var1, boolean var2);

    public abstract void reloadVariant(Node var1, Table2RowPanel var2);

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.tables);
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.tables.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.tables.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.tables.kill();
        this.tables = null;
    }

    public abstract boolean isVariantParent(Node<?> var1);

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        Node n = this.editor.getModel().getNode().getChildNamed(new String[]{"currentVariant"});
        if (this.tables != null) {
            this.setNodesToTables(this.productiveVariants, node, n, true, this.tables.getSelectedView() == this.productiveVariants);
            this.setNodesToTables(this.tenderVariants, node, n, false, this.tables.getSelectedView() == this.tenderVariants);
        }
    }

    private void setNodesToTables(Table2 usedTable, Node<?> variantParent, Node currentVariant, boolean productive, boolean select) {
        if (variantParent != null && this.isVariantParent(variantParent)) {
            this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getAllChildAddEventsFor(null, new String[0]);
            if (usedTable != null) {
                usedTable.getModel().setNode(this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}));
                if (currentVariant.getValue() == null) {
                    currentVariant = this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getChildAt(0);
                }
                if (select) {
                    for (Table2RowPanel i : usedTable.getRows()) {
                        if (!i.getModel().getNode().getValue().equals(currentVariant.getValue())) continue;
                        usedTable.getModel().selectRow(i, true, false, 3);
                    }
                }
                usedTable.updateOrder();
            }
        }
    }

    public abstract Class getCommittingClass(Node<?> var1);

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel == null) {
            return;
        }
        if (this.selectedPanel != null) {
            this.selectedPanel.getModel().getNode().commitThis(this.getCommittingClass(this.selectedPanel.getModel().getNode()));
        }
        this.selectedPanel = panel;
        Node n = panel.getModel().getNode();
        this.reloadVariant(n, panel);
    }

    public void updatePanels(Node<?> node, Table2RowPanel panel) {
        for (DetailsEditorParagraph p : this.editor.getParagraphs()) {
            if (p.equals(this)) continue;
            p.setNode(node);
        }
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 180);
        }

        @Override
        public void layoutContainer(Container parent) {
            AVariantDetailsPanelTabbed.this.tables.setLocation(0, 0);
            AVariantDetailsPanelTabbed.this.tables.setSize(parent.getWidth(), parent.getHeight() - 1);
        }
    }
}

