/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTemplateDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements SearchTextField2Listener,
ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    protected TitledItem<SearchTextField2> search;
    protected TextButton load;

    public AbstractTemplateDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider, true, true);
        this.setTitleText(Words.TEMPLATE);
        this.search = new TitledItem<SearchTextField2>(this.getSearchField(), this.getSearchFieldTitle(), TitledItem.TitledItemOrientation.NORTH);
        this.search.getElement().addSearchTextFieldListener(this);
        this.load = new TextButton(Words.COPY);
        this.load.addButtonListener(this);
        this.setEnabled(this.isEnabled());
        this.setCustomLayouter(new Layout());
        this.addToView(this.search);
        this.addToView(this.load);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.search.setEnabled(isEnabled);
        this.load.setEnabled(isEnabled && this.search.getElement().isItemSelected());
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.load) {
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(this.getLoadingText());
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    return AbstractTemplateDetailsPanel.this.getJob().loadData();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return AbstractTemplateDetailsPanel.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public T getSelectedData() {
        if (this.search.getElement().getNode() != null) {
            return (T)((IDTO)this.search.getElement().getNode().getValue());
        }
        return null;
    }

    public Node<T> getSelectedNode() {
        return this.search.getElement().getNode();
    }

    public abstract SearchTextField2 getSearchField();

    public abstract String getSearchFieldTitle();

    public abstract String getLoadingText();

    public abstract ThreadSafeExecutable getJob();

    public int layout(Container parent) {
        int w = 350;
        this.search.setLocation(this.horizontalBorder, this.verticalBorder);
        this.search.setSize(w, (int)this.search.getPreferredSize().getHeight());
        this.load.setLocation((int)((double)parent.getWidth() - (this.load.getPreferredSize().getWidth() + (double)this.horizontalBorder)), (int)((double)(this.search.getY() + this.search.getHeight()) - this.load.getPreferredSize().getHeight()));
        this.load.setSize(this.load.getPreferredSize());
        return this.search.getX() + this.search.getWidth();
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.search.kill();
        this.load.kill();
        this.search = null;
        this.load = null;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.search);
        CheckedListAdder.addToList(a, this.load);
        return a;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.setEnabled(this.isEnabled());
        this.fireFocusCycleChanged(this);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null) {
            if (this.getUpdateNodeBased()) {
                this.applyValueNodeBased((IDTO)node.getValue(this.getCommittingClass()));
            } else {
                this.applyDataValue((IDTO)node.getValue());
            }
        }
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    public Class<?> getCommittingClass() {
        return null;
    }

    public boolean getUpdateNodeBased() {
        return false;
    }

    public void applyValueNodeBased(T data) {
        Node fsNode = INodeCreator.getDefaultImpl().getNode4DTO(data, false, false);
        this.editor.getModel().setNode(fsNode);
        this.editor.setNode(fsNode);
    }

    public void applyDataValue(T data) {
        this.editor.getModel().getNode().removeExistingValues();
        this.editor.getModel().getNode().setValue(data, 0L);
        this.editor.getModel().getNode().updateNode();
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.search.getElement().getTextField().requestFocusInWindow();
    }

    @Override
    public void requestFocusInWindowNow() {
        this.search.requestFocusInWindowNow();
    }

    private static class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AbstractTemplateDetailsPanel p = (AbstractTemplateDetailsPanel)parent.getParent();
            p.layout(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            AbstractTemplateDetailsPanel p = (AbstractTemplateDetailsPanel)parent.getParent();
            int h = p.verticalBorder;
            h = (int)((double)h + p.search.getPreferredSize().getHeight());
            return new Dimension(0, h += p.verticalBorder);
        }
    }
}

