/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.gui.screentemplates.details.VariantBasedStateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class VariantBasedStateDependantTableDetailsPanel<VARIANT extends IDTO, BASE extends IDTO>
extends VariantBasedStateDependantDetailsPanel<VARIANT, BASE> {
    private static final long serialVersionUID = 1L;
    private int overridePrefHeight = -1;
    protected Table2 table;

    public VariantBasedStateDependantTableDetailsPanel(RowEditor<BASE> editor, RDProvider provider) {
        this(editor, provider, true);
    }

    public VariantBasedStateDependantTableDetailsPanel(RowEditor<BASE> editor, RDProvider provider, boolean withAddButton) {
        super(editor, provider);
        this.installTable(withAddButton);
    }

    public Table2Model createNewTableModel(List<TableColumnInfo> columns) {
        return new Table2Model(columns, true);
    }

    private void installTable(boolean withAddButton) {
        this.table = new Table2(withAddButton, Words.TABLE_ADD);
        this.table.setProvider(this.provider);
        List<TableColumnInfo> headers = this.getColumns();
        Table2Model tableModel = this.createNewTableModel(headers);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                VariantBasedStateDependantTableDetailsPanel.this.addButtonPressed(x, y, source);
            }

            @Override
            public void childRemoved() {
                VariantBasedStateDependantTableDetailsPanel.this.childRemoved();
            }
        });
        this.table.setModel(tableModel);
        tableModel.setViewFactory(model -> this.generateView(model, false));
        this.lafAttributeChanged("All attribues changed");
        this.configTable(this.table);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    public abstract List<TableColumnInfo> getColumns();

    public abstract void configTable(Table2 var1);

    public abstract void addButtonPressed(int var1, int var2, Button var3);

    public abstract void childRemoved();

    public abstract Table2RowPanel generateView(Table2RowModel var1, boolean var2);

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        super.setEnabled(isEnabled && isDraft);
        if (isEnabled) {
            if (isDraft) {
                this.table.setEnabled(isEnabled);
            } else {
                this.table.setLocked(isDraft);
            }
        } else {
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
    }

    public void setOverridePrefHeight(int overridePrefHeight) {
        this.overridePrefHeight = overridePrefHeight;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            VariantBasedStateDependantTableDetailsPanel.this.table.setLocation(0, 0);
            VariantBasedStateDependantTableDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(260, VariantBasedStateDependantTableDetailsPanel.this.overridePrefHeight != -1 ? VariantBasedStateDependantTableDetailsPanel.this.overridePrefHeight : (int)(VariantBasedStateDependantTableDetailsPanel.this.table.getPreferredSize().getHeight() + 2.0));
        }
    }
}

