/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.overview;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChain;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainListener;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanel;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanelListener;
import ch.icit.pegasus.client.gui.utils.panels.FrameIconBar;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.ScreenMessagePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class FilterChainScreenView<T extends ADTO, E extends Enum<E>>
extends TitledScreenInsert<T>
implements AttributeListener,
FilterChainListener,
RemoteLoader,
ConnectionToOutside<T, E>,
PaginationPanelListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    protected FilterChain filterChain;
    protected FrameIconBar otherTitleThing;
    protected int titleIconsConfiguration = 6545;
    protected int vertical_gap_to_title;
    protected int vertical_gap_to_screenTitle;
    protected int vertical_gap_to_chain_Title;
    protected int vertical_gap_to_filterChain;
    protected int vertical_gap_to_tableTitle;
    private boolean firstLoadingDone = false;
    protected Node<List<T>> node;
    protected LoadingAnimation loadingAnimation;
    protected E currentColumnAttribute;
    protected boolean isAsc;
    protected static final String sortedColumnAttName = "sortedColumn";
    private ASearchConfiguration<T, E> lastSearch;
    protected boolean isSynchronSearch = true;
    protected int numberOfShownResults = 10;
    protected SearchResult<?> currentResult;
    private ScreenMessagePanel screenMessage;
    protected boolean isInstalled = false;
    protected long loadingId;
    protected SearchAlgorithm<T> searchAlgorithm;
    protected boolean isLoadingData;
    protected boolean hasFilterChain;
    protected boolean isInit = true;
    protected boolean notYetLoaded = false;
    protected boolean dontSaveConfig;
    protected boolean errorIsShown;

    public FilterChainScreenView() {
        this(true);
    }

    public FilterChainScreenView(boolean withFilterChain) {
        this.hasFilterChain = withFilterChain;
        this.loadingId = System.currentTimeMillis();
        this.numberOfShownResults = AttributesConverter.getInteger4String(ApplicationSettingsLoader.getLoader().getAttribute("number_of_shown_results"));
    }

    public void setScreenName(String name) {
    }

    protected abstract ASearchConfiguration<? extends ADTO, ? extends Enum<?>> getEmptySortedSearchConfiguration();

    public ADTO reloadDTO(ADTO dto) {
        return dto;
    }

    public abstract FilterChainConfiguration getDefaultConfiguration();

    public void loadConfiguration() {
        this.isInit = true;
        if (this.filterChain != null) {
            FilterChainConfiguration c = FilterChainConfiguration.loadConfiguration(HUDToolkit.getInvokerNameForTopScreenClass(this.getClass().getName()), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
            if (c == null) {
                c = this.getDefaultConfiguration();
            }
            for (String[] e : c.getProperties()) {
                this.filterChain.updateElement(e[0], e[1]);
            }
        }
        this.notYetLoaded = false;
        this.isInit = false;
    }

    public FilterChainConfiguration getCurrentConfiguration() {
        FilterChainConfiguration f = this.filterChain.getCurrentConfiguration();
        return f;
    }

    public void saveConfiguration() {
        if (this.filterChain == null) {
            return;
        }
        String t = HUDToolkit.getInvokerNameForTopScreenClass(this.getClass().getName());
        FilterChainConfiguration.saveConfiguration(t, (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), this.getCurrentConfiguration(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    public Node getNode() {
        return this.node;
    }

    private void doSearch(final ASearchConfiguration<T, E> o, final Component source) {
        if (source instanceof SearchTextField) {
            ((SearchTextField)source).startAnimation();
        }
        this.setLoadData(true);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SearchResult res;
                ViewNode nn = FilterChainScreenView.this.searchAlgorithm.search(o);
                FilterChainScreenView.this.currentResult = res = (SearchResult)nn.getValue();
                if (!FilterChainScreenView.this.dontSaveConfig) {
                    FilterChainScreenView.this.saveConfiguration();
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (FilterChainScreenView.this.searchAlgorithm != null && node != null) {
                            if (FilterChainScreenView.this.lastSearch != null) {
                                ASearchConfiguration x = FilterChainScreenView.this.lastSearch;
                                FilterChainScreenView.this.lastSearch = null;
                                FilterChainScreenView.this.doSearch(x, source);
                                return;
                            }
                            if (node != null && node.getValue() != null && node.getValue() instanceof SearchResult) {
                                FilterChainScreenView.this.searchAlgorithm.mergeValues(FilterChainScreenView.this.node, ((SearchResult)node.getValue()).getResults());
                            }
                            if (!FilterChainScreenView.this.firstLoadingDone) {
                                FilterChainScreenView.this.firstLoadingDone = true;
                                FilterChainScreenView.this.hideAnimation();
                            }
                            if (source instanceof SearchTextField) {
                                ((SearchTextField)source).stopAnimation();
                            }
                            FilterChainScreenView.this.setLoadData(false);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        if (!FilterChainScreenView.this.errorIsShown) {
                            FilterChainScreenView.this.errorIsShown = true;
                            InnerPopUp2 pop = InnerPopupFactory.showErrorDialog((Exception)exception, (Component)FilterChainScreenView.this);
                            pop.setListener(FilterChainScreenView.this);
                        }
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureAnimation() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.errorIsShown = false;
    }

    protected void showScreenMessage(String msg) {
        if (this.screenMessage == null) {
            this.screenMessage = new ScreenMessagePanel(msg);
        } else {
            this.screenMessage.setText(msg);
        }
        this.add((Component)this.screenMessage, 0);
        this.screenMessage.fadeIn();
        this.validate();
    }

    public void setTitleComponent(FrameIconBar com) {
        this.otherTitleThing = com;
        this.add(this.otherTitleThing);
        this.otherTitleThing.fadeIn();
    }

    public FrameIconBar getTitleComponent() {
        return this.otherTitleThing;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.filterChain != null) {
            this.filterChain.kill();
            this.filterChain = null;
        }
        if (this.otherTitleThing != null) {
            this.otherTitleThing.kill();
            this.otherTitleThing = null;
        }
        if (this.screenMessage != null) {
            this.screenMessage.kill();
            this.screenMessage = null;
        }
        this.node = null;
        if (this.loadingAnimation != null) {
            this.loadingAnimation.kill();
        }
        this.loadingAnimation = null;
        this.currentColumnAttribute = null;
        this.lastSearch = null;
        this.currentResult = null;
        this.searchAlgorithm = null;
    }

    @Override
    public void setMainFrame(MainFrame mainFrame) {
        super.setMainFrame(mainFrame);
        if (!this.isInstalled) {
            this.isInstalled = true;
            this.install();
            this.addThings2Screen();
            this.setLoadingData(true);
            if (!(this instanceof RowSmartScreen)) {
                this.startDownload();
            }
        }
    }

    protected void startDownload() {
        this.ensureAnimation();
    }

    protected abstract void install();

    protected abstract void createFilterChain(long var1);

    @Override
    public void filterValueChanged(Object name, Object value, boolean isReset, Component source) {
        if (this.searchAlgorithm != null) {
            if (this.isSynchronSearch) {
                ASearchConfiguration<T, E> o = this.getSearchParameters(this.node, name, value, isReset, source);
                if (!this.isInit && !this.notYetLoaded) {
                    ViewNode nn = null;
                    ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                    try {
                        nn = this.searchAlgorithm.search(o);
                    }
                    catch (SearchException e) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getEmbeddedException().getMessage()));
                    }
                    catch (ClientServerCallException e) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                    }
                    if (nn != null) {
                        List retVAlue = null;
                        if (nn.getValue() instanceof SearchResult) {
                            retVAlue = ((SearchResult)nn.getValue()).getResults();
                        } else if (nn.getValue() instanceof List) {
                            retVAlue = (List)nn.getValue();
                        }
                        this.searchAlgorithm.mergeValues(this.node, retVAlue);
                    } else {
                        InnerPopupFactory.showErrorDialog(rets, "Enable to search", (Component)this);
                    }
                }
            } else {
                if (this.node == null) {
                    return;
                }
                ASearchConfiguration<T, E> o = this.getSearchParameters(this.node, name, value, isReset, source);
                if (!this.isInit && !this.notYetLoaded) {
                    if (ThreadSafeLoader.isOperationFinished()) {
                        this.lastSearch = null;
                        this.doSearch(o, source);
                    } else {
                        this.lastSearch = o;
                    }
                }
            }
        }
    }

    public SearchAlgorithm getSearchAlgorithm() {
        return this.searchAlgorithm;
    }

    public void setSearchAlgorithm(SearchAlgorithm searchAlgorithm) {
        this.searchAlgorithm = searchAlgorithm;
        if (this.notYetLoaded) {
            this.notYetLoaded = false;
            this.lastSearch = null;
        }
    }

    public abstract ASearchConfiguration<T, E> getSearchParameters(Node<?> var1, Object var2, Object var3, boolean var4, Component var5);

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.hasFilterChain) {
            this.filterChain.setEnabled(isEnabled);
        }
        if (this.otherTitleThing != null) {
            this.otherTitleThing.setEnabled(isEnabled);
        }
        this.getMainFrame().getTitleBar().setEnabled(isEnabled);
    }

    public void setLoadData(boolean isLoading) {
        if (isLoading) {
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 7735);
        } else {
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 7735);
        }
    }

    public void setLoadingData(boolean isLoadingData) {
        if (isLoadingData) {
            this.setEnabled(false);
            this.ensureAnimation();
            if (this.hasFilterChain) {
                this.filterChain.activateDataLoadingAnimation(null, null, null);
            }
        } else {
            this.hideAnimation();
            if (this.hasFilterChain) {
                this.filterChain.deactivateDataLoadingAnimation();
            }
        }
        this.isLoadingData = isLoadingData;
    }

    public boolean isLoadingData() {
        return this.isLoadingData;
    }

    @Override
    public void stopAnimationsImmediately() {
        this.hideAnimation();
        if (this.hasFilterChain) {
            this.filterChain.stopAnimationImmediately();
        }
    }

    public LoadingAnimation startAnimation(String t) {
        this.setEnabled(false);
        this.ensureAnimation();
        return this.loadingAnimation;
    }

    public void hideAnimation() {
        this.setEnabled(true);
        if (this.loadingAnimation != null) {
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation.stop();
            this.loadingAnimation = null;
        }
    }

    protected void addThings2Screen() {
        this.setLayout(new TableViewLayout());
        if (this.hasFilterChain) {
            this.filterChain = new FilterChain(this.getClass());
            this.filterChain.addFilterChainListener(this);
        }
        this.attributeChanged("All attributes changed");
        this.createFilterChain(this.loadingId);
        if (this.hasFilterChain) {
            this.add(this.filterChain);
        }
    }

    @Override
    public String getScreenTitle() {
        return this.getInvoker().getDisplayName();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            if (this.hasFilterChain) {
                this.filterChain.setSize(this.filterChain.getWidth(), AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_filter_chain_height")));
            }
            this.vertical_gap_to_chain_Title = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_chaintitle"));
            this.vertical_gap_to_filterChain = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_filter_chain"));
            this.vertical_gap_to_screenTitle = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_screentitle"));
            this.vertical_gap_to_tableTitle = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_tabletitle"));
            this.vertical_gap_to_title = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle"));
        }
        this.setSize(this.getWidth(), this.getHeight());
    }

    public abstract JComponent getContentComponent();

    @Override
    public void configureHUDButtons(boolean isEnabled) {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(isEnabled, this.titleIconsConfiguration);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.isInit = false;
        if (this.hasFilterChain) {
            this.filterChain.deactivateDataLoadingAnimation();
        }
        if (this.searchAlgorithm != null) {
            this.lastSearch = null;
            this.loadConfiguration();
            this.doSearch(this.getSearchParameters(null, null, null, false, null), this);
        } else {
            this.notYetLoaded = true;
            this.configureHUDButtons(true);
        }
    }

    public void redo() {
    }

    public void undo() {
    }

    public void commitSent() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void sortColumn(E att, boolean isAsc) {
        this.currentColumnAttribute = att;
        this.isAsc = isAsc;
        this.filterValueChanged(null, null, false, this.filterChain);
    }

    @Override
    public Object getValidationAttributes(RowPanel p) {
        return null;
    }

    @Override
    public void pageChanged(PaginationPanel source, int currentPage) {
        this.filterValueChanged(null, null, false, source);
    }

    public abstract AccessDefinitionComplete getInvoker();

    public void reloadData() {
        this.doSearch(this.getSearchParameters(null, null, null, false, null), this);
    }

    public void showMessage(List<ScreenValidationObject> res) {
        if (res != null && !res.isEmpty()) {
            InnerPopupFactory.showErrorDialog(res, "Unable to open all Flights, please review Flights:", (Component)this);
        }
    }

    @Override
    public Object getCurrentSearchConfig() {
        return this.getSearchParameters(null, null, null, false, this);
    }

    public class TableViewLayout
    extends DefaultLayout {
        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int currentY = 0;
            currentY = FilterChainScreenView.this.layoutTitle(parent);
            if (FilterChainScreenView.this.hasFilterChain) {
                FilterChainScreenView.this.filterChain.setLocation(0, currentY += FilterChainScreenView.this.vertical_gap_to_screenTitle);
                FilterChainScreenView.this.filterChain.setSize(w, FilterChainScreenView.this.filterChain.getHeight());
                currentY += FilterChainScreenView.this.filterChain.getHeight();
            } else if (FilterChainScreenView.this.otherTitleThing != null) {
                FilterChainScreenView.this.otherTitleThing.setLocation(0, currentY + 10);
                FilterChainScreenView.this.otherTitleThing.setSize(w, (int)FilterChainScreenView.this.otherTitleThing.getPreferredSize().getHeight());
                currentY += FilterChainScreenView.this.vertical_gap_to_screenTitle + FilterChainScreenView.this.otherTitleThing.getHeight();
            }
            int toolGap = 0;
            JComponent contentComponent = FilterChainScreenView.this.getContentComponent();
            contentComponent.setLocation(0, currentY += FilterChainScreenView.this.vertical_gap_to_filterChain);
            contentComponent.setSize(w, h - (contentComponent.getY() + toolGap));
            if (FilterChainScreenView.this.screenMessage != null) {
                FilterChainScreenView.this.screenMessage.setLocation(0, currentY);
                FilterChainScreenView.this.screenMessage.setSize(contentComponent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

