/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.overview;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.HiddenRowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

public class ScreenTableAddRow<T extends IUniversal>
extends HiddenRowPanel<T>
implements AttributeListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    protected TextLabel label;
    protected static int horizontal_icon_inset;
    protected static int horizontal_icon_text_gap;
    private boolean isEnabled = true;
    protected Skin3Field skin;
    protected Skin1Field iconSkin;

    public ScreenTableAddRow(String titlePrefix, boolean shouldDelegateMouseEvents) {
        super(shouldDelegateMouseEvents);
        this.setLayout(new AddRowLayout());
        this.label = new TextLabel(titlePrefix);
        this.skin = (Skin3Field)DefaultSkins.TableAddRowTexture.createDynamicSkin();
        this.attributeChanged("All attributes changed");
        this.lafAttributeChanged("All attribues changed");
        this.add(this.label);
    }

    public ScreenTableAddRow(String titlePrefix) {
        this(titlePrefix, true);
    }

    public ScreenTableAddRow(String titlePrefix, Skin1Field iconSkin) {
        this(titlePrefix);
        this.iconSkin = iconSkin;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void setDisabled(boolean b) {
        super.setDisabled(b);
        if (b) {
            this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color")));
        } else {
            this.label.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        }
    }

    private int getAddRowImageHeight() {
        return this.skin.getImageLeft(this.state).getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.getAddRowImageHeight();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Button.ButtonState s = this.state;
        if (this.isDisabled) {
            s = Button.ButtonState.DISABLED;
        }
        this.skin.paint(g2, 0, 0, this.getWidth(), s);
        this.iconSkin.paint(g2, horizontal_icon_inset, (this.skin.getImageLeft(this.state).getHeight() - this.iconSkin.getImage(this.state).getHeight()) / 2, this.state);
        this.paintChildren(g2);
        if (this.isExpanded() || this.isAnimating()) {
            this.paintFrame(g2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        this.label.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("table_add_row_font_size"), LafLoader.getLafLoader().getAttribute("table_add_row_font_type")));
    }

    @Override
    public Dimension getPreferredSize() {
        return ((AddRowLayout)this.getLayout()).preferredLayoutSize(this);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            horizontal_icon_inset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_add_row_horizontal_icon_inset"));
            horizontal_icon_text_gap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_add_row_horizontal_icon_text_gap"));
        }
    }

    private class AddRowLayout
    extends DefaultLayout {
        private AddRowLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = ScreenTableAddRow.this.skin.getImageMiddle(ScreenTableAddRow.this.state).getHeight();
            if (ScreenTableAddRow.this.label != null) {
                ScreenTableAddRow.this.label.setLocation(horizontal_icon_inset + ScreenTableAddRow.this.iconSkin.getImage(ScreenTableAddRow.this.state).getWidth() + horizontal_icon_text_gap, (int)((double)h - ScreenTableAddRow.this.label.getPreferredSize().getHeight()) / 2);
                ScreenTableAddRow.this.label.setSize(ScreenTableAddRow.this.label.getPreferredSize());
            }
            if (ScreenTableAddRow.this.rowContentPanel != null) {
                ScreenTableAddRow.this.rowContentPanel.setLocation(2, ScreenTableAddRow.this.model.getColapsedRowHeight(ScreenTableAddRow.this));
                ScreenTableAddRow.this.rowContentPanel.setSize(parent.getWidth() - 4, ScreenTableAddRow.this.rowContentPanel.getPreferredHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = ScreenTableAddRow.this.model.getColapsedRowHeight(ScreenTableAddRow.this);
            if (ScreenTableAddRow.this.rowContentPanel != null) {
                height += ScreenTableAddRow.this.rowContentPanel.getPreferredHeight();
            }
            return new Dimension(parent.getWidth() - 4, height);
        }
    }
}

