/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.overview.data;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.i18n.Words;

public abstract class DefaultDataHandler<T_REFERENCE extends ADTO, T_COMPLETE extends ADTO>
implements IDataHandler<T_REFERENCE, T_COMPLETE> {
    protected TableModel model;
    protected long loadingID;
    protected ScreenTableView tableView;
    private int currentMaximum;
    private int currentIndex = 1;

    public DefaultDataHandler(long id, ScreenTableView tableView) {
        this.loadingID = id;
        this.tableView = tableView;
    }

    protected void showMessage(ProgressListener listener, String msg) {
        if (listener != null) {
            listener.stateChanged(msg);
        }
    }

    protected void showMessage(ProgressListener listener, int current) {
        this.showMessage(listener, current, this.currentMaximum);
    }

    protected void showNextMessage(ProgressListener listener) {
        this.showMessage(listener, ++this.currentIndex, this.currentMaximum);
    }

    public void setCurrentLoadMaximum(int currentMaximum) {
        this.currentMaximum = currentMaximum;
        this.setCurrentIndex(0);
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    protected void showMessage(ProgressListener listener, int current, int max) {
        if (listener != null) {
            listener.stateChanged(Words.LOADING_ANIMATION_LOAD + " " + current + "/" + max + " " + Words.LOADING_ANIMATION_MODULES);
        }
    }

    @Override
    public long getLoadingID() {
        return this.loadingID;
    }

    public ScreenTableView getTableView() {
        return this.tableView;
    }

    public void setTableView(ScreenTableView tableView) {
        this.tableView = tableView;
    }

    @Override
    public boolean reloadDataBeforeOpening(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean reloadDataAfterClosing(Node<?> node, RemoteLoader listener, ProgressListener progressListener) {
        return this.reloadDataBeforeOpening((Node)node, listener, progressListener);
    }

    @Override
    public abstract void updateData(Node<T_REFERENCE> var1, RemoteLoader var2, ProgressListener var3);

    @Override
    public abstract void createNewData(Node<T_COMPLETE> var1, RemoteLoader var2, boolean var3, ProgressListener var4);

    @Override
    public abstract void loadMasterData(long var1, RemoteLoader var3, ProgressListener var4);

    @Override
    public abstract Node<T_COMPLETE> resetData(Node<T_COMPLETE> var1);

    @Override
    public void setModel(TableModel model) {
        this.model = model;
    }

    @Override
    public Node<T_COMPLETE> createEmptyNode() {
        return null;
    }
}

