/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.splitscreen;

import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public abstract class SplitScreenView<T extends IDTO>
extends TitledScreenInsert<T>
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected LoadingAnimation animation;
    protected TextLabel split1Title;
    protected TextLabel split2Title;
    protected SplitView split1;
    protected SplitView split2;
    private Node sNode1;
    private Node sIReadableNode;
    protected IDataHandler dataHandler;

    public SplitScreenView() {
        this.install();
        this.ensureAnimation("Load Module XX/XX");
    }

    public abstract AccessDefinitionComplete getInvoker();

    public ProgressListener getLoadingAnimation() {
        return this.animation;
    }

    public LoadingAnimation showAnimation(boolean b) {
        return this.showAnimation(b, "");
    }

    public LoadingAnimation showAnimation(boolean b, String remoteValidationText) {
        if (b) {
            this.setEnabled(false);
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 0);
            return this.ensureAnimation(remoteValidationText);
        }
        if (!this.isKilled()) {
            this.setEnabled(true);
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 6545);
        }
        this.hideAnimation();
        return null;
    }

    protected void install() {
        this.setOpaque(false);
        this.setLayout(new Layout());
    }

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    private LoadingAnimation ensureAnimation(String remoteValidationText) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(remoteValidationText);
            this.animation.fadeIn();
            this.animation.start();
            this.add((Component)this.animation, 0);
        }
        this.revalidate();
        return this.animation;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void loadingAnimationDone() {
        this.setEnabled(false);
        this.dataHandler.loadMasterData(0L, this, this.animation);
    }

    public Node getSplitView1List() {
        if (this.sNode1 == null) {
            this.sNode1 = new ListNode();
        }
        return this.sNode1;
    }

    public Node getSplitView2List() {
        if (this.sIReadableNode == null) {
            this.sIReadableNode = new ListNode();
        }
        return this.sIReadableNode;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.split1 != null) {
            this.split1.setEnabled(isEnabled);
            this.split2.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.split1.kill();
        this.split2.kill();
        this.split1 = null;
        this.split2 = null;
        this.split1Title.kill();
        this.split2Title.kill();
        this.split1Title = null;
        this.split2Title = null;
        this.sIReadableNode = null;
        this.sNode1 = null;
        this.dataHandler = null;
    }

    public IDataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        this.setEnabled(true);
        this.screenSet();
    }

    @Override
    public final String getScreenTitle() {
        return new AppModulesUtils().getModuleDisplayName(this.getInvoker());
    }

    public void resetView() {
        this.split1.resetData();
        this.split2.resetData();
    }

    public RDProvider createProvider() {
        return new RDProvider(this.getCurrentAccessRight(this.getInvoker()));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (SplitScreenView.this.animation != null) {
                SplitScreenView.this.animation.setLocation((int)(((double)parent.getWidth() - SplitScreenView.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - SplitScreenView.this.animation.getPreferredSize().getHeight()) / 2);
                SplitScreenView.this.animation.setSize(SplitScreenView.this.animation.getPreferredSize());
            }
            int currentY = 0;
            currentY = SplitScreenView.this.layoutTitle(parent);
            int h = parent.getHeight() - (currentY += 10);
            h -= 10;
            h /= 2;
            int ah = 0;
            int insert = 10;
            if (SplitScreenView.this.split1Title != null) {
                SplitScreenView.this.split1Title.setLocation(insert, currentY);
                SplitScreenView.this.split1Title.setSize(SplitScreenView.this.split1Title.getPreferredSize());
                currentY += SplitScreenView.this.split1Title.getHeight();
                ah = SplitScreenView.this.split1Title.getHeight();
            }
            SplitScreenView.this.split1.setLocation(0, currentY);
            SplitScreenView.this.split1.setSize(parent.getWidth(), h - ah);
            currentY = SplitScreenView.this.split1.getY() + SplitScreenView.this.split1.getHeight() + 10;
            ah = 0;
            if (SplitScreenView.this.split2Title != null) {
                SplitScreenView.this.split2Title.setLocation(insert, currentY);
                SplitScreenView.this.split2Title.setSize(SplitScreenView.this.split2Title.getPreferredSize());
                currentY += SplitScreenView.this.split2Title.getHeight();
                ah = SplitScreenView.this.split2Title.getHeight();
            }
            SplitScreenView.this.split2.setLocation(0, currentY);
            SplitScreenView.this.split2.setSize(parent.getWidth(), h - ah);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }
}

