/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.splitscreen;

import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public abstract class SplitScreenView3<T extends IDTO>
extends TitledScreenInsert<T>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected LoadingAnimation animation;
    protected TextLabel split1Title;
    protected TextLabel split2Title;
    protected TextLabel split3Title;
    protected CheckBox check1To3;
    protected TextLabel description1To3;
    protected CheckBox check2To3;
    protected TextLabel description2To3;
    protected SplitView split1;
    protected SplitView split2;
    protected SplitView split3;
    private Node sNode1;
    private Node sIReadableNode;
    private Node sNode3;
    private ArrowButton flightToProducts;
    private ArrowButton productToArticles;
    private ArrowButton flightToArticles;
    protected IDataHandler dataHandler;
    protected TablePanelAddSaveButton export;

    public SplitScreenView3() {
        this.install();
        this.ensureAnimation();
    }

    public abstract String getInvokingName();

    public ProgressListener getLoadingAnimation() {
        return this.animation;
    }

    public void showAnimation(boolean b) {
        if (b) {
            this.setEnabled(false);
            this.ensureAnimation();
            this.validate();
        } else {
            this.setEnabled(true);
            this.hideAnimation();
        }
    }

    protected void install() {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.export = new TablePanelAddSaveButton("Export");
        this.export.addButtonListener(this);
        this.flightToProducts = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right);
        this.flightToProducts.setToolTipText(this.getSplitText1());
        this.productToArticles = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Down);
        this.productToArticles.setToolTipText(this.getSplitText3());
        this.flightToArticles = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Down);
        this.flightToArticles.setToolTipText(this.getSplitText2());
        this.flightToProducts.addButtonListener(this);
        this.productToArticles.addButtonListener(this);
        this.flightToArticles.addButtonListener(this);
        this.add(this.export);
        this.add(this.flightToProducts);
        this.add(this.productToArticles);
        this.add(this.flightToArticles);
    }

    public abstract String getSplitText1();

    public abstract String getSplitText2();

    public abstract String getSplitText3();

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void escapeKeyPressed() {
    }

    private void ensureAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged("Load");
            this.animation.fadeIn();
            this.animation.start();
            this.add((Component)this.animation, 0);
        }
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void loadingAnimationDone() {
        this.setEnabled(false);
        this.dataHandler.loadMasterData(0L, this, this.animation);
    }

    @Override
    public void screenSet() {
        super.screenSet();
    }

    public Node getSplitView1List() {
        if (this.sNode1 == null) {
            this.sNode1 = new ListNode();
        }
        return this.sNode1;
    }

    public Node getSplitView2List() {
        if (this.sIReadableNode == null) {
            this.sIReadableNode = new ListNode();
        }
        return this.sIReadableNode;
    }

    public Node getSplitView3List() {
        if (this.sNode3 == null) {
            this.sNode3 = new ListNode();
        }
        return this.sNode3;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.split1 == null) {
            return;
        }
        this.split1.setEnabled(isEnabled);
        this.split2.setEnabled(isEnabled);
        this.split3.setEnabled(isEnabled);
        this.split1Title.setEnabled(isEnabled);
        this.split2Title.setEnabled(isEnabled);
        this.split3Title.setEnabled(isEnabled);
        this.flightToProducts.setEnabled(isEnabled);
        this.productToArticles.setEnabled(isEnabled);
        this.flightToArticles.setEnabled(isEnabled);
        this.export.setEnabled(isEnabled);
        if (this.check1To3 != null) {
            this.check1To3.setEnabled(isEnabled);
        }
        if (this.check2To3 != null) {
            this.check2To3.setEnabled(isEnabled);
        }
        if (this.description1To3 != null) {
            this.description1To3.setEnabled(isEnabled);
        }
        if (this.description2To3 != null) {
            this.description2To3.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
        this.split1.kill();
        this.split2.kill();
        this.split3.kill();
        this.split1Title.kill();
        this.split2Title.kill();
        this.split3Title.kill();
        this.flightToProducts.kill();
        this.productToArticles.kill();
        this.flightToArticles.kill();
        this.export.kill();
        this.flightToProducts = null;
        this.productToArticles = null;
        this.flightToArticles = null;
        this.split1Title = null;
        this.split2Title = null;
        this.split3Title = null;
        if (this.check1To3 != null) {
            this.check1To3.kill();
        }
        if (this.check2To3 != null) {
            this.check2To3.kill();
        }
        if (this.description1To3 != null) {
            this.description1To3.kill();
        }
        if (this.description2To3 != null) {
            this.description2To3.kill();
        }
        this.check1To3 = null;
        this.check2To3 = null;
        this.description1To3 = null;
        this.description2To3 = null;
        this.split1 = null;
        this.split2 = null;
        this.split3 = null;
        this.sNode1 = null;
        this.sIReadableNode = null;
        this.sNode3 = null;
        this.dataHandler = null;
        this.export = null;
    }

    public IDataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        this.setEnabled(true);
        if (this.getMainFrame() != null && this.getMainFrame().getTitleBar() != null) {
            this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 6545);
        }
    }

    public void resetView() {
        this.split1.resetData();
        this.split2.resetData();
        this.split3.resetData();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.flightToProducts) {
            this.processSplit1ToSlip2();
        } else if (source == this.productToArticles) {
            this.processSplit2ToSplit3();
        } else if (source == this.flightToArticles) {
            this.processSplit1ToSplit3();
        } else if (source == this.export) {
            this.exportData(x, y);
        } else {
            super.buttonPressed(source, x, y);
        }
    }

    public abstract List<ExcelRow> getRows() throws ClientRemoteException;

    public abstract void processSplit1ToSlip2();

    public abstract void processSplit2ToSplit3();

    public abstract void processSplit1ToSplit3();

    public abstract void exportData(int var1, int var2);

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX;
            int insert = 10;
            int currentY = SplitScreenView3.this.layoutTitle(parent);
            int h = parent.getHeight() - (currentY += insert);
            h -= insert;
            h = (int)((double)h - SplitScreenView3.this.productToArticles.getPreferredSize().getHeight());
            h -= insert;
            h = (int)((double)h - SplitScreenView3.this.split1Title.getPreferredSize().getHeight());
            h = (int)((double)h - SplitScreenView3.this.split3Title.getPreferredSize().getHeight());
            h -= insert;
            h -= insert;
            h -= insert;
            h = (int)((double)h - SplitScreenView3.this.export.getPreferredSize().getHeight());
            int aw = (int)(((double)parent.getWidth() - ((double)insert + SplitScreenView3.this.flightToProducts.getPreferredSize().getWidth() + (double)insert)) / 2.0);
            int ah = h / 2;
            SplitScreenView3.this.split1Title.setLocation(insert, currentY);
            SplitScreenView3.this.split1Title.setSize(SplitScreenView3.this.split1Title.getPreferredSize());
            SplitScreenView3.this.split1.setLocation(0, currentY += SplitScreenView3.this.split1Title.getHeight());
            SplitScreenView3.this.split1.setSize(aw, ah);
            SplitScreenView3.this.split2Title.setLocation((int)((double)(SplitScreenView3.this.split1.getX() + SplitScreenView3.this.split1.getWidth() + insert) + SplitScreenView3.this.flightToProducts.getPreferredSize().getWidth() + (double)(2 * insert)), currentY - SplitScreenView3.this.split1Title.getHeight());
            SplitScreenView3.this.split2Title.setSize(SplitScreenView3.this.split2Title.getPreferredSize());
            SplitScreenView3.this.flightToArticles.setLocation((int)((double)SplitScreenView3.this.split1.getX() + ((double)SplitScreenView3.this.split1.getWidth() - SplitScreenView3.this.flightToArticles.getPreferredSize().getWidth()) / 2.0), SplitScreenView3.this.split1.getY() + SplitScreenView3.this.split1.getHeight() + insert);
            SplitScreenView3.this.flightToArticles.setSize(SplitScreenView3.this.flightToArticles.getPreferredSize());
            if (SplitScreenView3.this.description1To3 != null) {
                currentX = SplitScreenView3.this.flightToArticles.getX() + SplitScreenView3.this.flightToArticles.getWidth() + insert;
                if (SplitScreenView3.this.check1To3 != null) {
                    SplitScreenView3.this.check1To3.setLocation(currentX, (int)((double)SplitScreenView3.this.flightToArticles.getY() + ((double)SplitScreenView3.this.flightToArticles.getHeight() - SplitScreenView3.this.check1To3.getPreferredSize().getHeight()) / 2.0));
                    SplitScreenView3.this.check1To3.setSize(SplitScreenView3.this.check1To3.getPreferredSize());
                    currentX = SplitScreenView3.this.check1To3.getX() + SplitScreenView3.this.check1To3.getWidth() + insert;
                }
                SplitScreenView3.this.description1To3.setLocation(currentX, (int)((double)SplitScreenView3.this.flightToArticles.getY() + ((double)SplitScreenView3.this.flightToArticles.getHeight() - SplitScreenView3.this.description1To3.getPreferredSize().getHeight()) / 2.0));
                SplitScreenView3.this.description1To3.setSize(SplitScreenView3.this.description1To3.getPreferredSize());
            }
            SplitScreenView3.this.flightToProducts.setLocation(SplitScreenView3.this.split1.getX() + SplitScreenView3.this.split1.getWidth() + insert, (int)((double)currentY + ((double)SplitScreenView3.this.split1.getHeight() - SplitScreenView3.this.flightToProducts.getPreferredSize().getHeight()) / 2.0));
            SplitScreenView3.this.flightToProducts.setSize(SplitScreenView3.this.flightToProducts.getPreferredSize());
            SplitScreenView3.this.split2.setLocation(SplitScreenView3.this.flightToProducts.getX() + SplitScreenView3.this.flightToProducts.getWidth() + insert, currentY);
            SplitScreenView3.this.split2.setSize(aw, ah);
            currentY += SplitScreenView3.this.split2.getHeight();
            SplitScreenView3.this.productToArticles.setLocation((int)((double)SplitScreenView3.this.split2.getX() + ((double)SplitScreenView3.this.split2.getWidth() - SplitScreenView3.this.productToArticles.getPreferredSize().getWidth()) / 2.0), currentY += insert);
            SplitScreenView3.this.productToArticles.setSize(SplitScreenView3.this.productToArticles.getPreferredSize());
            if (SplitScreenView3.this.description2To3 != null) {
                currentX = SplitScreenView3.this.productToArticles.getX() + SplitScreenView3.this.productToArticles.getWidth() + insert;
                if (SplitScreenView3.this.check2To3 != null) {
                    SplitScreenView3.this.check2To3.setLocation(currentX, (int)((double)SplitScreenView3.this.productToArticles.getY() + ((double)SplitScreenView3.this.productToArticles.getHeight() - SplitScreenView3.this.check2To3.getPreferredSize().getHeight()) / 2.0));
                    SplitScreenView3.this.check2To3.setSize(SplitScreenView3.this.check2To3.getPreferredSize());
                    currentX = SplitScreenView3.this.check2To3.getX() + SplitScreenView3.this.check2To3.getWidth() + insert;
                }
                SplitScreenView3.this.description2To3.setLocation(currentX, (int)((double)SplitScreenView3.this.productToArticles.getY() + ((double)SplitScreenView3.this.productToArticles.getHeight() - SplitScreenView3.this.description2To3.getPreferredSize().getHeight()) / 2.0));
                SplitScreenView3.this.description2To3.setSize(SplitScreenView3.this.description2To3.getPreferredSize());
            }
            currentY = (int)((double)currentY + SplitScreenView3.this.productToArticles.getPreferredSize().getHeight());
            SplitScreenView3.this.split3Title.setLocation(insert, currentY += insert);
            SplitScreenView3.this.split3Title.setSize(SplitScreenView3.this.split3Title.getPreferredSize());
            currentY = (int)((double)currentY + SplitScreenView3.this.split3Title.getPreferredSize().getHeight());
            SplitScreenView3.this.split3.setLocation(0, currentY);
            SplitScreenView3.this.split3.setSize(parent.getWidth(), ah);
            SplitScreenView3.this.export.setLocation(0, (int)((double)parent.getHeight() - SplitScreenView3.this.export.getPreferredSize().getHeight()));
            SplitScreenView3.this.export.setSize(SplitScreenView3.this.export.getPreferredSize());
            if (SplitScreenView3.this.animation != null) {
                SplitScreenView3.this.animation.setLocation((int)(((double)parent.getWidth() - SplitScreenView3.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - SplitScreenView3.this.animation.getPreferredSize().getHeight()) / 2);
                SplitScreenView3.this.animation.setSize(SplitScreenView3.this.animation.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }
}

