/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.toolbar;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.toolbar.ToolButton;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ScreenToolView
extends DefaultPanel {
    private static final long serialVersionUID = 1L;
    private List<TitledItem<ToolButton>> buttons = new ArrayList<TitledItem<ToolButton>>();
    private ScreenTableView overView;

    public ScreenToolView(ScreenTableView overview) {
        this.overView = overview;
        this.setLayout(new Layout());
    }

    public ScreenTableView getOverview() {
        return this.overView;
    }

    public void addToolButton(ToolButton button, String name) {
        TitledItem<ToolButton> b = new TitledItem<ToolButton>(button, name, TitledItem.TitledItemOrientation.SOUTH);
        b.setInnerGap(0);
        this.buttons.add(b);
        this.add(b);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (TitledItem<ToolButton> b : this.buttons) {
            a.addAll(b.getFocusComponents());
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        for (TitledItem<ToolButton> b : this.buttons) {
            b.setVisibleContainer(pane);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (TitledItem<ToolButton> b : this.buttons) {
            b.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (TitledItem<ToolButton> b : this.buttons) {
            this.remove(b);
            b.kill();
        }
        this.buttons.clear();
    }

    public ASearchConfiguration getSearchConfiguration() {
        return this.overView.getSearchParameters(null, null, false, false, null);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 70);
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            for (TitledItem b : ScreenToolView.this.buttons) {
                b.setLocation(currentX, 0);
                b.setSize(b.getPreferredSize());
                currentX += b.getWidth() + 15;
            }
        }
    }
}

