/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.article.allergens.approve;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.List;

public class ActionAllergensApproveComponent
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> node;
    private RowModel<BasicArticleLight> model;
    private TitledItem<TextLabel> approved;
    private TitledItem<TextLabel> lastApproved;
    private TitledItem<ScrollableTextArea> allergenApproveComment;
    private TitledItem<ComboBox> allergenApproveNow;

    public ActionAllergensApproveComponent(Node<BasicArticleLight> node, RowModel<BasicArticleLight> model) {
        this.node = node;
        this.model = model;
        this.setLayout(new Layout());
        this.showAnimation(Words.LOAD_DATA);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.approved != null) {
            this.approved.kill();
            this.lastApproved.kill();
            this.allergenApproveComment.kill();
            this.allergenApproveNow.kill();
        }
        this.approved = null;
        this.lastApproved = null;
        this.allergenApproveComment = null;
        this.allergenApproveNow = null;
    }

    public void loadData() {
        ThreadSafeLoader.run(new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight l = (BasicArticleLight)ActionAllergensApproveComponent.this.node.getValue(BasicArticleLight.class);
                BasicArticleComplete b = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(l.getId())).getValue();
                ActionAllergensApproveComponent.this.node.removeExistingValues();
                ActionAllergensApproveComponent.this.node.setValue((Object)b, 0L);
                ActionAllergensApproveComponent.this.node.updateNode();
                if (b.getRequestAllergenUpdateUser() != null) {
                    UserLight u = (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUserLight(b.getRequestAllergenUpdateUser()).getValue();
                    Node cn = ActionAllergensApproveComponent.this.node.getChildNamed(BasicArticleComplete_.requestAllergenUpdateUser);
                    cn.removeExistingValues();
                    cn.setValue((Object)u, 0L);
                }
                return null;
            }

            private void insertUI() {
                ActionAllergensApproveComponent.this.hideAnimation();
                ActionAllergensApproveComponent.this.approved = new TitledItem<TextLabel>(new TextLabel(ActionAllergensApproveComponent.this.node.getChildNamed(BasicArticleComplete_.allergensApproved), ConverterRegistry.getConverter(BooleanConverter.class)), Words.APPROVED, TitledItem.TitledItemOrientation.WEST);
                ActionAllergensApproveComponent.this.lastApproved = new TitledItem<TextLabel>(new TextLabel(ActionAllergensApproveComponent.this.node.getChildNamed(BasicArticleComplete_.lastAllergensApproved), ConverterRegistry.getConverter(DateTimeConverter.class)), Words.LAST_APPROVE, TitledItem.TitledItemOrientation.WEST);
                ActionAllergensApproveComponent.this.allergenApproveComment = new TitledItem<ScrollableTextArea>(new ScrollableTextArea((Node<String>)ActionAllergensApproveComponent.this.node.getChildNamed(BasicArticleComplete_.allergenApproveComment)), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
                ActionAllergensApproveComponent.this.allergenApproveComment.setIgnorePrefHeight(true);
                ActionAllergensApproveComponent.this.allergenApproveNow = new TitledItem<ComboBox>(ComboBoxFactory.getYesNoComboBox(false), Words.APPROVE_ALLERGEN, TitledItem.TitledItemOrientation.WEST);
                ((ComboBox)ActionAllergensApproveComponent.this.allergenApproveNow.getElement()).addItem("-");
                ((ComboBox)ActionAllergensApproveComponent.this.allergenApproveNow.getElement()).setSelectedItem("-");
                ActionAllergensApproveComponent.this.approved.fadeIn();
                ActionAllergensApproveComponent.this.lastApproved.fadeIn();
                ActionAllergensApproveComponent.this.allergenApproveComment.fadeIn();
                ActionAllergensApproveComponent.this.allergenApproveNow.fadeIn();
                ActionAllergensApproveComponent.this.add(ActionAllergensApproveComponent.this.approved);
                ActionAllergensApproveComponent.this.add(ActionAllergensApproveComponent.this.lastApproved);
                ActionAllergensApproveComponent.this.add(ActionAllergensApproveComponent.this.allergenApproveComment);
                ActionAllergensApproveComponent.this.add(ActionAllergensApproveComponent.this.allergenApproveNow);
                ActionAllergensApproveComponent.this.popup.revalidate();
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        this.insertUI();
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        });
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            this.approved.setVisible(false);
            this.lastApproved.setVisible(false);
            this.allergenApproveComment.setVisible(false);
            this.allergenApproveNow.setVisible(false);
            this.showAnimation(Words.SAVE_DATA);
            ThreadSafeLoader.run(this.getJob());
            this.popup.enableCancelButton(false);
            this.popup.enableOKButton(false);
        } else {
            super.enterPressed(isOK);
        }
    }

    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ActionAllergensApproveComponent.this.node.commitThis(BasicArticleComplete.class);
                BasicArticleComplete artC = (BasicArticleComplete)ActionAllergensApproveComponent.this.node.getValue(BasicArticleComplete.class);
                if (((ComboBox)ActionAllergensApproveComponent.this.allergenApproveNow.getElement()).getSelectedItem() != null) {
                    if (((ComboBox)ActionAllergensApproveComponent.this.allergenApproveNow.getElement()).getSelectedItem().equals(Words.YES)) {
                        artC.setAllergensApproved(Boolean.valueOf(true));
                        artC.setLastAllergensApproved(new Timestamp(System.currentTimeMillis()));
                        artC.setAllergenApproveState(AllergenDeclarationStateE.MANUALLY_APPROVED);
                    } else if (((ComboBox)ActionAllergensApproveComponent.this.allergenApproveNow.getElement()).getSelectedItem().equals(Words.NO_ANSWER)) {
                        artC.setAllergensApproved(Boolean.valueOf(false));
                        artC.setLastAllergensApproved(new Timestamp(System.currentTimeMillis()));
                        artC.setAllergenApproveState(AllergenDeclarationStateE.PROCESSING);
                    }
                }
                artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).approveAllergen(artC).getValue();
                ActionAllergensApproveComponent.this.node.removeExistingValues();
                ActionAllergensApproveComponent.this.node.setValue((Object)artC, 0L);
                ActionAllergensApproveComponent.this.node.updateNode();
                ActionAllergensApproveComponent.this.model.mergeNode(ActionAllergensApproveComponent.this.node, true);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionAllergensApproveComponent.this.popup.hideCancelButton();
                        ActionAllergensApproveComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionAllergensApproveComponent.this.popup.hideScheduled(300, Words.SUCCESSFUL);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ActionAllergensApproveComponent.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.allergenApproveNow != null ? this.allergenApproveNow.getElement().isInnerComponent(c) : false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ActionAllergensApproveComponent.this.border;
            if (ActionAllergensApproveComponent.this.approved != null) {
                currentY = (int)((double)currentY + (ActionAllergensApproveComponent.this.approved.getPreferredSize().getHeight() + (double)(ActionAllergensApproveComponent.this.border / 2)));
            }
            if (ActionAllergensApproveComponent.this.lastApproved != null) {
                currentY = (int)((double)currentY + (ActionAllergensApproveComponent.this.lastApproved.getPreferredSize().getHeight() + (double)ActionAllergensApproveComponent.this.border));
            }
            if (ActionAllergensApproveComponent.this.allergenApproveComment != null) {
                currentY += 100 + ActionAllergensApproveComponent.this.border;
            }
            if (ActionAllergensApproveComponent.this.allergenApproveNow != null) {
                currentY = (int)((double)currentY + (ActionAllergensApproveComponent.this.allergenApproveNow.getPreferredSize().getHeight() + (double)ActionAllergensApproveComponent.this.border));
            }
            return new Dimension(0, currentY);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionAllergensApproveComponent.this.layoutAnimation(parent);
            int currentY = ActionAllergensApproveComponent.this.border;
            if (ActionAllergensApproveComponent.this.approved != null) {
                ActionAllergensApproveComponent.this.approved.setLocation(ActionAllergensApproveComponent.this.border, currentY);
                ActionAllergensApproveComponent.this.approved.setSize(parent.getWidth() - 2 * ActionAllergensApproveComponent.this.border, (int)ActionAllergensApproveComponent.this.approved.getPreferredSize().getHeight());
                currentY = ActionAllergensApproveComponent.this.approved.getY() + ActionAllergensApproveComponent.this.approved.getHeight() + ActionAllergensApproveComponent.this.border / 2;
            }
            if (ActionAllergensApproveComponent.this.lastApproved != null) {
                ActionAllergensApproveComponent.this.lastApproved.setLocation(ActionAllergensApproveComponent.this.border, currentY);
                ActionAllergensApproveComponent.this.lastApproved.setSize(parent.getWidth() - 2 * ActionAllergensApproveComponent.this.border, (int)ActionAllergensApproveComponent.this.lastApproved.getPreferredSize().getHeight());
                currentY = ActionAllergensApproveComponent.this.lastApproved.getY() + ActionAllergensApproveComponent.this.lastApproved.getHeight() + ActionAllergensApproveComponent.this.border;
            }
            if (ActionAllergensApproveComponent.this.allergenApproveComment != null) {
                ActionAllergensApproveComponent.this.allergenApproveComment.setLocation(ActionAllergensApproveComponent.this.border, currentY);
                ActionAllergensApproveComponent.this.allergenApproveComment.setSize(parent.getWidth() - 2 * ActionAllergensApproveComponent.this.border, 100);
                currentY = ActionAllergensApproveComponent.this.allergenApproveComment.getY() + ActionAllergensApproveComponent.this.allergenApproveComment.getHeight() + ActionAllergensApproveComponent.this.border;
            }
            if (ActionAllergensApproveComponent.this.allergenApproveNow != null) {
                ActionAllergensApproveComponent.this.allergenApproveNow.setLocation(ActionAllergensApproveComponent.this.border, currentY);
                ActionAllergensApproveComponent.this.allergenApproveNow.setSize(parent.getWidth() - 2 * ActionAllergensApproveComponent.this.border, (int)ActionAllergensApproveComponent.this.allergenApproveNow.getPreferredSize().getHeight());
            }
        }
    }
}

