/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.article.update;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;

public class ActionUpdateArticlePriceComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel label;
    protected Node node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;
    private boolean emptyPositionShown;

    public ActionUpdateArticlePriceComponent(Node node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
        this.createComponents();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentModel != null) {
            this.currentModel.mergeNode(this.node, true);
        }
        super.remoteObjectLoaded(node);
    }

    protected void installPort() {
        this.label = new MultiLineTextLabel();
        this.label.setText(Words.ARE_YOU_SURE_TO_UPDATE_ARTICLE_STD_PRICES);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.label);
        this.emptyPositionShown = true;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        this.removeInheritedComponents();
        super.enterPressed(isOK);
    }

    public void setUser(UserReference u) {
        this.currentUser = u;
    }

    @Override
    public String getTitleString() {
        return Words.UPDATE;
    }

    @Override
    public String getTitleValue() {
        return (String)this.node.getChildNamed(BasicArticleLight_.name).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.currentModel != null) {
            this.currentModel.mergeNode(this.node, true);
        }
        this.label.setVisible(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticlePriceCalculationLight l = (ArticlePriceCalculationLight)ActionUpdateArticlePriceComponent.this.node.getValue(ArticlePriceCalculationLight.class);
                ArticlePriceCalculationComplete o = (ArticlePriceCalculationComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).writeArticleCalculationToArticle(new ArticlePriceCalculationReference(l.getId())).getValue();
                ActionUpdateArticlePriceComponent.this.node.removeExistingValues();
                ActionUpdateArticlePriceComponent.this.node.setValue((Object)o, 0L);
                ActionUpdateArticlePriceComponent.this.node.updateNode();
                return ActionUpdateArticlePriceComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionUpdateArticlePriceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return Words.UPDATE_ARTICLES;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionUpdateArticlePriceComponent.this.layoutInheritedComponents(parent);
            ActionUpdateArticlePriceComponent.this.label.setLocation(0, y);
            ActionUpdateArticlePriceComponent.this.label.setSize(parent.getWidth(), parent.getHeight() - y);
        }
    }
}

