/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.changenotification;

import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ActionCheckChangeNotificationComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private MultiLineTextLabel label;
    protected Node<ChangeNotificationReference> node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;
    protected boolean emptyPositionShown;

    public ActionCheckChangeNotificationComponent(Node<ChangeNotificationReference> node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    protected void installPort() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.label.setText(Words.MARK_AS_PROCESSED_BY_MANAGER);
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
        this.emptyPositionShown = true;
    }

    @Override
    public String getTitleString() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.currentModel.getView().revalidate();
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ChangeNotificationLight l = (ChangeNotificationLight)ActionCheckChangeNotificationComponent.this.node.getValue(ChangeNotificationLight.class);
                ChangeNotificationLight notificationLight = (ChangeNotificationLight)((ChangeNotificationServiceManager)ServiceManagerRegistry.getService(ChangeNotificationServiceManager.class)).markChangeNotificationAsProcessedByManager(new ChangeNotificationReference(l.getId())).getValue();
                ActionCheckChangeNotificationComponent.this.node.removeExistingValues();
                ActionCheckChangeNotificationComponent.this.node.setValue((Object)notificationLight, 0L);
                ActionCheckChangeNotificationComponent.this.node.updateNode();
                return ActionCheckChangeNotificationComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionCheckChangeNotificationComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.currentModel.getView().refreshCells();
    }

    @Override
    protected String getProgressText() {
        return Words.MARKED_AS_PROCESSED_BY_MANAGER;
    }

    @Override
    protected String getFinishedText() {
        return Words.MARKED_AS_PROCESSED_BY_MANAGER;
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionCheckChangeNotificationComponent.this.scrollPane.getWidth() - ActionCheckChangeNotificationComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionCheckChangeNotificationComponent.this.label.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCheckChangeNotificationComponent.this.label.setLocation(0, 0);
            ActionCheckChangeNotificationComponent.this.label.setSize(parent.getWidth(), (int)ActionCheckChangeNotificationComponent.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionCheckChangeNotificationComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionCheckChangeNotificationComponent.this.layoutInheritedComponents(parent);
            ActionCheckChangeNotificationComponent.this.scrollPane.setLocation(ActionCheckChangeNotificationComponent.this.border, ActionCheckChangeNotificationComponent.this.border);
            ActionCheckChangeNotificationComponent.this.scrollPane.setSize(parent.getWidth() - ActionCheckChangeNotificationComponent.this.border, parent.getHeight() - ActionCheckChangeNotificationComponent.this.border);
        }
    }
}

