/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.vector;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.FileChooserAnalysisItem;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class ActionValidateVectorSalesComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<FileChooserPanel> vectorFile;

    public ActionValidateVectorSalesComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        PegasusFileComplete pegasusFileComplete = new PegasusFileComplete();
        pegasusFileComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
        pegasusFileComplete.setCategory(FileCategoryE.REPORT);
        FileChooserPanel fileChooserPanel = new FileChooserPanel(false, Words.SELECT_SALES_FILE_FROM_VECTOR, "", false);
        this.vectorFile = new TitledItem<FileChooserPanel>(fileChooserPanel, "File", TitledItem.TitledItemOrientation.NORTH);
        TitledItem<FileChooserPanel> file = this.vectorFile;
        file.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)pegasusFileComplete, false, false));
        this.addOptionsItem(new FileChooserAnalysisItem(file, "file"));
    }

    @Override
    public String getTitleString() {
        return Words.VECTOR_DATA_VALIDATION;
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List references = this.loadItemReferences();
        Iterator it = references.iterator();
        while (it.hasNext()) {
            if (((FlightReference)it.next()).getId() != null) continue;
            it.remove();
        }
        PegasusFileComplete value = (PegasusFileComplete)this.vectorFile.getElement().getNode().getValue();
        try {
            value = FileTransferUtil.upload((PegasusFileComplete)value, (FileTransferListener[])new FileTransferListener[0]);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, "Unable to validate", (Component)this);
            e.printStackTrace();
            return null;
        }
        ASearchConfiguration fc = this.getSearchConfiguration();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).validateRimDataByVectorSales(new ListWrapper(references), (FlightSearchConfiguration)fc, value).getValue();
        return file;
    }
}

