/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.wagon.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonProductComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonProductComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WagonPanel
extends JPanelFadable {
    private Table2 wagonTable;
    private FlightComplete flight;
    private Node<List<FlightWagonComplete>> wagonNode;

    public WagonPanel() {
        this.createWagonTable();
    }

    public void setData(FlightComplete flight, Node<List<FlightWagonComplete>> wagonNode) {
        this.flight = flight;
        this.wagonNode = wagonNode;
        Iterator it = wagonNode.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            this.insertWagonData((Node<FlightWagonComplete>)next);
        }
    }

    private void insertWagonData(Node<FlightWagonComplete> wagon) {
        this.wagonTable.getModel().getNode().addChild(wagon, 0L);
        Iterator it2 = wagon.getChildNamed(FlightWagonComplete_.products).getFailSafeChildIterator();
        while (it2.hasNext()) {
            Node product = (Node)it2.next();
            this.wagonTable.getModel().getNode().addChild(product, 0L);
        }
    }

    private void createWagonTable() {
        this.wagonTable = new Table2(true, Words.TABLE_ADD);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("WAGON", "", null, null, "", 80, Integer.MAX_VALUE, 80));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3f);
        columns.add(new TableColumnInfo("PRODUCT", "", null, null, "", 80, Integer.MAX_VALUE, 80));
        ((TableColumnInfo)columns.get(1)).setxExpand(0.7f);
        columns.add(new TableColumnInfo("QUANTITY", "", null, null, "", 150, 150, 150));
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        int pf = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", "", null, null, "", pf += this.wagonTable.getCellPadding() * 2, pf, pf));
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        Table2Model tableModel = new Table2Model(columns, true);
        this.wagonTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                FlightWagonComplete wagon = new FlightWagonComplete();
                wagon.setFlight((FlightLight)WagonPanel.this.flight);
                wagon.setClientOId(Long.valueOf(ADTO.getNextId()));
                for (AdditionalOrderComplete additionalOrder : WagonPanel.this.flight.getAdditionalOrders()) {
                    FlightWagonProductComplete product = new FlightWagonProductComplete();
                    product.setProduct(additionalOrder.getProduct());
                    product.setQuantity(Integer.valueOf(0));
                    product.setClientOId(Long.valueOf(ADTO.getNextId()));
                    wagon.getProducts().add(product);
                }
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)wagon, true, false);
                WagonPanel.this.wagonNode.addChild(node, 0L);
                WagonPanel.this.insertWagonData((Node<FlightWagonComplete>)node);
            }

            @Override
            public void childRemoved() {
            }
        });
        tableModel.setViewFactory(model -> {
            WagonTableRow rowPanel = new WagonTableRow(model);
            rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            return rowPanel;
        });
        this.wagonTable.setModel(tableModel);
        this.wagonTable.setRequestFocusOnAdd(true);
        ViewNode viewNode = new ViewNode("WagonView");
        this.wagonTable.getModel().setNode((Node)viewNode);
        this.setLayout(new Layout());
        this.add(this.wagonTable);
    }

    private class WagonTableRow
    extends Table2RowPanel {
        private TextField wagonName;
        private TextLabel product;
        private TextField quantity;
        private TextField shelfCount;
        private DeleteButton delete;
        private boolean wagonMode;

        public WagonTableRow(Table2RowModel m) {
            super(m);
            if (m.getNode().getValue() instanceof FlightWagonProductComplete) {
                FlightWagonProductComplete wagon = (FlightWagonProductComplete)m.getNode().getValue();
                this.product = new TextLabel(wagon.getProduct().getCurrentVariant().getName());
                this.quantity = new TextField(m.getNode().getChildNamed(FlightWagonProductComplete_.quantity), TextFieldType.INT_NULLABLE);
                this.add(this.product);
                this.add(this.quantity);
            } else {
                this.wagonMode = true;
                this.wagonName = new TextField(this.model.getNode().getChildNamed(FlightWagonComplete_.wagonName));
                this.quantity = new TextField(m.getNode().getChildNamed(FlightWagonComplete_.weight), TextFieldType.NORMAL);
                this.shelfCount = new TextField(m.getNode().getChildNamed(FlightWagonComplete_.shelfCount), TextFieldType.INT);
                this.delete = new DeleteButton();
                this.delete.addButtonListener((source, x, y) -> {
                    Iterator it = this.model.getNode().getChildNamed(FlightWagonComplete_.products).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node product = (Node)it.next();
                        WagonPanel.this.wagonTable.getModel().getNode().removeChild(product, 0L);
                    }
                    WagonPanel.this.wagonNode.removeChild(this.model.getNode(), 0L);
                    WagonPanel.this.wagonTable.getModel().getNode().removeChild(this.model.getNode(), 0L);
                });
                this.add(this.wagonName);
                this.add(this.delete);
                this.add(this.shelfCount);
                this.add(this.quantity);
            }
            this.setLayout(new Layout());
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, WagonTableRow.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = WagonTableRow.this.model.getParentModel().getColumnWidth(0);
                if (WagonTableRow.this.wagonMode) {
                    WagonTableRow.this.wagonName.setLocation(WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.wagonName.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.wagonName.setSize(w - 2 * WagonPanel.this.wagonTable.getCellPadding(), (int)WagonTableRow.this.wagonName.getPreferredSize().getHeight());
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(1);
                    WagonTableRow.this.shelfCount.setLocation(currentX + WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.shelfCount.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.shelfCount.setSize(w - 2 * WagonPanel.this.wagonTable.getCellPadding(), (int)WagonTableRow.this.shelfCount.getPreferredSize().getHeight());
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(2);
                    WagonTableRow.this.quantity.setLocation(currentX + WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.quantity.setSize(w - 2 * WagonPanel.this.wagonTable.getCellPadding(), (int)WagonTableRow.this.quantity.getPreferredSize().getHeight());
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(3);
                    WagonTableRow.this.setControlsX(currentX);
                    WagonTableRow.this.delete.setLocation(currentX + WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.delete.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.delete.setSize(WagonTableRow.this.delete.getPreferredSize());
                } else {
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(1);
                    WagonTableRow.this.product.setLocation(currentX + WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.product.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.product.setSize(w - 2 * WagonPanel.this.wagonTable.getCellPadding(), (int)WagonTableRow.this.product.getPreferredSize().getHeight());
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(2);
                    WagonTableRow.this.quantity.setLocation(currentX + WagonPanel.this.wagonTable.getCellPadding(), (int)(((double)parent.getHeight() - WagonTableRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    WagonTableRow.this.quantity.setSize(w - 2 * WagonPanel.this.wagonTable.getCellPadding(), (int)WagonTableRow.this.quantity.getPreferredSize().getHeight());
                    currentX += w;
                    w = WagonTableRow.this.model.getParentModel().getColumnWidth(3);
                    WagonTableRow.this.setControlsX(currentX);
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            WagonPanel.this.wagonTable.setLocation(0, 0);
            WagonPanel.this.wagonTable.setSize(parent.getSize());
        }
    }
}

